# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # DataSourceReference is a reference to a DataSource resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the DataSourceReference.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/dataSourceReferences/\\{data_source_reference}
        # @!attribute [r] data_source
        #   @return [::String]
        #     Output only. The resource name of the DataSource.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/backupVaults/\\{backupVault}/dataSources/\\{dataSource}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataSourceReference was created.
        # @!attribute [r] data_source_backup_config_state
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigState]
        #     Output only. The backup configuration state of the DataSource.
        # @!attribute [r] data_source_backup_count
        #   @return [::Integer]
        #     Output only. Number of backups in the DataSource.
        # @!attribute [r] data_source_backup_config_info
        #   @return [::Google::Cloud::BackupDR::V1::DataSourceBackupConfigInfo]
        #     Output only. Information of backup configuration on the DataSource.
        # @!attribute [r] data_source_gcp_resource_info
        #   @return [::Google::Cloud::BackupDR::V1::DataSourceGcpResourceInfo]
        #     Output only. The GCP resource that the DataSource is associated with.
        # @!attribute [r] total_stored_bytes
        #   @return [::Integer]
        #     Output only. Total size of the storage used by all backup resources for the
        #     referenced datasource.
        class DataSourceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information of backup configuration on the DataSource.
        # @!attribute [r] last_backup_state
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigInfo::LastBackupState]
        #     Output only. The status of the last backup in this DataSource
        # @!attribute [r] last_successful_backup_consistency_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp of the last successful backup to this DataSource.
        class DataSourceBackupConfigInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The GCP resource that the DataSource is associated with.
        # @!attribute [r] gcp_resourcename
        #   @return [::String]
        #     Output only. The resource name of the GCP resource.
        #     Ex: projects/\\{project}/zones/\\{zone}/instances/\\{instance}
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. The type of the GCP resource.
        #     Ex: compute.googleapis.com/Instance
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. The location of the GCP resource.
        #     Ex: <region>/<zone>/"global"/"unspecified"
        # @!attribute [r] cloud_sql_instance_properties
        #   @return [::Google::Cloud::BackupDR::V1::CloudSqlInstanceDataSourceReferenceProperties]
        #     Output only. The properties of the Cloud SQL instance.
        class DataSourceGcpResourceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the GetDataSourceReference method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DataSourceReference to retrieve.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/dataSourceReferences/\\{data_source_reference}
        class GetDataSourceReferenceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the ListDataSourceReferences method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of DataSourceReferences to return. The service
        #     may return fewer than this value. If unspecified, at most 50
        #     DataSourceReferences will be returned. The maximum value is 100; values
        #     above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDataSourceReferences`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDataSourceReferences` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters the results listed in the
        #     response. The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering.
        #
        #     The following field and operator combinations are supported:
        #
        #     * data_source_gcp_resource_info.gcp_resourcename with `=`, `!=`
        #     * data_source_gcp_resource_info.type with `=`, `!=`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A comma-separated list of fields to order by, sorted in ascending
        #     order. Use "desc" after a field name for descending.
        #
        #     Supported fields:
        #
        #     * data_source
        #     * data_source_gcp_resource_info.gcp_resourcename
        class ListDataSourceReferencesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the ListDataSourceReferences method.
        # @!attribute [rw] data_source_references
        #   @return [::Array<::Google::Cloud::BackupDR::V1::DataSourceReference>]
        #     The DataSourceReferences from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDataSourceReferencesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the FetchDataSourceReferencesForResourceType method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Required. The type of the GCP resource.
        #     Ex: sql.googleapis.com/Instance
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of DataSourceReferences to return. The service
        #     may return fewer than this value. If unspecified, at most 50
        #     DataSourceReferences will be returned. The maximum value is 100; values
        #     above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous call of
        #     `FetchDataSourceReferencesForResourceType`.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `FetchDataSourceReferencesForResourceType` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters the results fetched in the
        #     response. The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. Supported
        #     fields:
        #     * data_source
        #     * data_source_gcp_resource_info.gcp_resourcename
        #     * data_source_backup_config_state
        #     * data_source_backup_count
        #     * data_source_backup_config_info.last_backup_state
        #     * data_source_gcp_resource_info.gcp_resourcename
        #     * data_source_gcp_resource_info.type
        #     * data_source_gcp_resource_info.location
        #     * data_source_gcp_resource_info.cloud_sql_instance_properties.instance_create_time
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A comma-separated list of fields to order by, sorted in ascending
        #     order. Use "desc" after a field name for descending.
        #
        #     Supported fields:
        #     * name
        class FetchDataSourceReferencesForResourceTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the FetchDataSourceReferencesForResourceType method.
        # @!attribute [rw] data_source_references
        #   @return [::Array<::Google::Cloud::BackupDR::V1::DataSourceReference>]
        #     The DataSourceReferences from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class FetchDataSourceReferencesForResourceTypeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
