# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # ComputeInstanceBackupProperties represents Compute Engine instance backup
        # properties.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional text description for the instances that are created from these
        #     properties.
        # @!attribute [rw] tags
        #   @return [::Google::Cloud::BackupDR::V1::Tags]
        #     A list of tags to apply to the instances that are created from these
        #     properties. The tags identify valid sources or targets for network
        #     firewalls. The setTags method can modify this list of tags. Each tag within
        #     the list must comply with RFC1035 (https://www.ietf.org/rfc/rfc1035.txt).
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     The machine type to use for instances that are created from these
        #     properties.
        # @!attribute [rw] can_ip_forward
        #   @return [::Boolean]
        #     Enables instances created based on these properties to send packets with
        #     source IP addresses other than their own and receive packets with
        #     destination IP addresses other than their own. If these instances will be
        #     used as an IP gateway or it will be set as the next-hop in a Route
        #     resource, specify `true`. If unsure, leave this set to `false`. See the
        #     https://cloud.google.com/vpc/docs/using-routes#canipforward
        #     documentation for more information.
        # @!attribute [rw] network_interface
        #   @return [::Array<::Google::Cloud::BackupDR::V1::NetworkInterface>]
        #     An array of network access configurations for this interface.
        # @!attribute [rw] disk
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AttachedDisk>]
        #     An array of disks that are associated with the instances that are created
        #     from these properties.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::BackupDR::V1::Metadata]
        #     The metadata key/value pairs to assign to instances that are created from
        #     these properties. These pairs can consist of custom metadata or predefined
        #     keys. See https://cloud.google.com/compute/docs/metadata/overview for more
        #     information.
        # @!attribute [rw] service_account
        #   @return [::Array<::Google::Cloud::BackupDR::V1::ServiceAccount>]
        #     A list of service accounts with specified scopes. Access tokens for these
        #     service accounts are available to the instances that are created from
        #     these properties. Use metadata queries to obtain the access tokens for
        #     these instances.
        # @!attribute [rw] scheduling
        #   @return [::Google::Cloud::BackupDR::V1::Scheduling]
        #     Specifies the scheduling options for the instances that are created from
        #     these properties.
        # @!attribute [rw] guest_accelerator
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AcceleratorConfig>]
        #     A list of guest accelerator cards' type and count to use for instances
        #     created from these properties.
        # @!attribute [rw] min_cpu_platform
        #   @return [::String]
        #     Minimum cpu/platform to be used by instances. The instance may be
        #     scheduled on the specified or newer cpu/platform. Applicable values are the
        #     friendly names of CPU platforms, such as
        #     `minCpuPlatform: Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`.
        #     For more information, read
        #     https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
        # @!attribute [rw] key_revocation_action_type
        #   @return [::Google::Cloud::BackupDR::V1::KeyRevocationActionType]
        #     KeyRevocationActionType of the instance. Supported options are "STOP" and
        #     "NONE". The default value is "NONE" if it is not specified.
        # @!attribute [rw] source_instance
        #   @return [::String]
        #     The source instance used to create this backup. This can be a partial or
        #     full URL to the resource. For example, the following are valid values:
        #       -https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
        #       -projects/project/zones/zone/instances/instance
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to apply to instances that are created from these properties.
        class ComputeInstanceBackupProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # ComputeInstanceRestoreProperties represents Compute Engine instance
        # properties to be overridden during restore.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the compute instance.
        # @!attribute [rw] advanced_machine_features
        #   @return [::Google::Cloud::BackupDR::V1::AdvancedMachineFeatures]
        #     Optional. Controls for advanced machine-related behavior features.
        # @!attribute [rw] can_ip_forward
        #   @return [::Boolean]
        #     Optional. Allows this instance to send and receive packets with
        #     non-matching destination or source IPs.
        # @!attribute [rw] confidential_instance_config
        #   @return [::Google::Cloud::BackupDR::V1::ConfidentialInstanceConfig]
        #     Optional. Controls Confidential compute options on the instance
        # @!attribute [rw] deletion_protection
        #   @return [::Boolean]
        #     Optional. Whether the resource should be protected against deletion.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. An optional description of this resource. Provide this property
        #     when you create the resource.
        # @!attribute [rw] disks
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AttachedDisk>]
        #     Optional. Array of disks associated with this instance. Persistent disks
        #     must be created before you can assign them. Source regional persistent
        #     disks will be restored with default replica zones if not specified.
        # @!attribute [rw] display_device
        #   @return [::Google::Cloud::BackupDR::V1::DisplayDevice]
        #     Optional. Enables display device for the instance.
        # @!attribute [rw] guest_accelerators
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AcceleratorConfig>]
        #     Optional. A list of the type and count of accelerator cards attached to the
        #     instance.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Optional. Specifies the hostname of the instance. The specified hostname
        #     must be RFC1035 compliant. If hostname is not specified, the default
        #     hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global
        #     DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal
        #     DNS.
        # @!attribute [rw] instance_encryption_key
        #   @return [::Google::Cloud::BackupDR::V1::CustomerEncryptionKey]
        #     Optional. Encrypts suspended data for an instance with a
        #     customer-managed encryption key.
        # @!attribute [rw] key_revocation_action_type
        #   @return [::Google::Cloud::BackupDR::V1::KeyRevocationActionType]
        #     Optional. KeyRevocationActionType of the instance.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels to apply to this instance.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Optional. Full or partial URL of the machine type resource to use for this
        #     instance.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::BackupDR::V1::Metadata]
        #     Optional. This includes custom metadata and predefined keys.
        # @!attribute [rw] min_cpu_platform
        #   @return [::String]
        #     Optional. Minimum CPU platform to use for this instance.
        # @!attribute [rw] network_interfaces
        #   @return [::Array<::Google::Cloud::BackupDR::V1::NetworkInterface>]
        #     Optional. An array of network configurations for this instance. These
        #     specify how interfaces are configured to interact with other network
        #     services, such as connecting to the internet. Multiple interfaces are
        #     supported per instance. Required to restore in different project or region.
        # @!attribute [rw] network_performance_config
        #   @return [::Google::Cloud::BackupDR::V1::NetworkPerformanceConfig]
        #     Optional. Configure network performance such as egress bandwidth tier.
        # @!attribute [rw] params
        #   @return [::Google::Cloud::BackupDR::V1::InstanceParams]
        #     Input only. Additional params passed with the request, but not persisted
        #     as part of resource payload.
        # @!attribute [rw] private_ipv6_google_access
        #   @return [::Google::Cloud::BackupDR::V1::ComputeInstanceRestoreProperties::InstancePrivateIpv6GoogleAccess]
        #     Optional. The private IPv6 google access type for the VM.
        #     If not specified, use INHERIT_FROM_SUBNETWORK as default.
        # @!attribute [rw] allocation_affinity
        #   @return [::Google::Cloud::BackupDR::V1::AllocationAffinity]
        #     Optional. Specifies the reservations that this instance can consume from.
        # @!attribute [rw] resource_policies
        #   @return [::Array<::String>]
        #     Optional. Resource policies applied to this instance.
        #     By default, no resource policies will be applied.
        # @!attribute [rw] scheduling
        #   @return [::Google::Cloud::BackupDR::V1::Scheduling]
        #     Optional. Sets the scheduling options for this instance.
        # @!attribute [rw] service_accounts
        #   @return [::Array<::Google::Cloud::BackupDR::V1::ServiceAccount>]
        #     Optional. A list of service accounts, with their specified scopes,
        #     authorized for this instance. Only one service account per VM instance is
        #     supported.
        # @!attribute [rw] tags
        #   @return [::Google::Cloud::BackupDR::V1::Tags]
        #     Optional. Tags to apply to this instance. Tags are used to identify valid
        #     sources or targets for network firewalls and are specified by the client
        #     during instance creation.
        class ComputeInstanceRestoreProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The private IPv6 google access type for the VMs.
          module InstancePrivateIpv6GoogleAccess
            # Default value. This value is unused.
            INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0

            # Each network interface inherits PrivateIpv6GoogleAccess from its
            # subnetwork.
            INHERIT_FROM_SUBNETWORK = 1

            # Outbound private IPv6 access from VMs in this subnet to Google services.
            # If specified, the subnetwork who is attached to the instance's default
            # network interface will be assigned an internal IPv6 prefix if it doesn't
            # have before.
            ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 2

            # Bidirectional private IPv6 access to/from Google services. If
            # specified, the subnetwork who is attached to the instance's default
            # network interface will be assigned an internal IPv6 prefix if it doesn't
            # have before.
            ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 3
          end
        end

        # ComputeInstanceTargetEnvironment represents Compute Engine target
        # environment to be used during restore.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. Target project for the Compute Engine instance.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. The zone of the Compute Engine instance.
        class ComputeInstanceTargetEnvironment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ComputeInstanceDataSourceProperties represents the properties of a
        # ComputeEngine resource that are stored in the DataSource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the compute instance backed up by the datasource.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the Compute Engine instance.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     The machine type of the instance.
        # @!attribute [rw] total_disk_count
        #   @return [::Integer]
        #     The total number of disks attached to the Instance.
        # @!attribute [rw] total_disk_size_gb
        #   @return [::Integer]
        #     The sum of all the disk sizes.
        class ComputeInstanceDataSourceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies options for controlling advanced machine features.
        # @!attribute [rw] enable_nested_virtualization
        #   @return [::Boolean]
        #     Optional. Whether to enable nested virtualization or not (default is
        #     false).
        # @!attribute [rw] threads_per_core
        #   @return [::Integer]
        #     Optional. The number of threads per physical core. To disable simultaneous
        #     multithreading (SMT) set this to 1. If unset, the maximum number
        #     of threads supported per core by the underlying processor is
        #     assumed.
        # @!attribute [rw] visible_core_count
        #   @return [::Integer]
        #     Optional. The number of physical cores to expose to an instance. Multiply
        #     by the number of threads per core to compute the total number of virtual
        #     CPUs to expose to the instance. If unset, the number of cores is
        #     inferred from the instance's nominal CPU count and the underlying
        #     platform's SMT width.
        # @!attribute [rw] enable_uefi_networking
        #   @return [::Boolean]
        #     Optional. Whether to enable UEFI networking for instance creation.
        class AdvancedMachineFeatures
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of Confidential Instance options.
        # @!attribute [rw] enable_confidential_compute
        #   @return [::Boolean]
        #     Optional. Defines whether the instance should have confidential compute
        #     enabled.
        class ConfidentialInstanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of Display Device options
        # @!attribute [rw] enable_display
        #   @return [::Boolean]
        #     Optional. Enables display for the Compute Engine VM
        class DisplayDevice
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A specification of the type and number of accelerator cards attached to the
        # instance.
        # @!attribute [rw] accelerator_type
        #   @return [::String]
        #     Optional. Full or partial URL of the accelerator type resource to attach to
        #     this instance.
        # @!attribute [rw] accelerator_count
        #   @return [::Integer]
        #     Optional. The number of the guest accelerator cards exposed to this
        #     instance.
        class AcceleratorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A customer-supplied encryption key.
        # @!attribute [rw] raw_key
        #   @return [::String]
        #     Optional. Specifies a 256-bit customer-supplied
        #     encryption key.
        #
        #     Note: The following fields are mutually exclusive: `raw_key`, `rsa_encrypted_key`, `kms_key_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rsa_encrypted_key
        #   @return [::String]
        #     Optional. RSA-wrapped 2048-bit
        #     customer-supplied encryption key to either encrypt or decrypt this
        #     resource.
        #
        #     Note: The following fields are mutually exclusive: `rsa_encrypted_key`, `raw_key`, `kms_key_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Optional. The name of the encryption key that is stored in Google Cloud
        #     KMS.
        #
        #     Note: The following fields are mutually exclusive: `kms_key_name`, `raw_key`, `rsa_encrypted_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] kms_key_service_account
        #   @return [::String]
        #     Optional. The service account being used for the encryption request for the
        #     given KMS key. If absent, the Compute Engine default service account is
        #     used.
        class CustomerEncryptionKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A key/value pair to be used for storing metadata.
        # @!attribute [rw] key
        #   @return [::String]
        #     Optional. Key for the metadata entry.
        # @!attribute [rw] value
        #   @return [::String]
        #     Optional. Value for the metadata entry. These are free-form strings, and
        #     only have meaning as interpreted by the image running in the instance. The
        #     only restriction placed on values is that their size must be less than
        #     or equal to 262144 bytes (256 KiB).
        class Entry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A metadata key/value entry.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::BackupDR::V1::Entry>]
        #     Optional. Array of key/value pairs. The total size of all keys and values
        #     must be less than 512 KB.
        class Metadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A network interface resource attached to an instance.
        # s
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. URL of the VPC network resource for this instance.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Optional. The URL of the Subnetwork resource for this instance.
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     Optional. An IPv4 internal IP address to assign to the instance for this
        #     network interface. If not specified by the user, an unused internal IP is
        #     assigned by the system.
        # @!attribute [rw] ipv6_address
        #   @return [::String]
        #     Optional. An IPv6 internal network address for this network interface. To
        #     use a static internal IP address, it must be unused and in the same region
        #     as the instance's zone. If not specified, Google Cloud will automatically
        #     assign an internal IPv6 address from the instance's subnetwork.
        # @!attribute [rw] internal_ipv6_prefix_length
        #   @return [::Integer]
        #     Optional. The prefix length of the primary internal IPv6 range.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. [Output Only] The name of the network interface, which is
        #     generated by the server.
        # @!attribute [rw] access_configs
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AccessConfig>]
        #     Optional. An array of configurations for this interface. Currently, only
        #     one access config,ONE_TO_ONE_NAT is supported. If there are no
        #     accessConfigs specified, then this instance will have
        #     no external internet access.
        # @!attribute [rw] ipv6_access_configs
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AccessConfig>]
        #     Optional. An array of IPv6 access configurations for this interface.
        #     Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there
        #     is no ipv6AccessConfig specified, then this instance will
        #     have no external IPv6 Internet access.
        # @!attribute [rw] alias_ip_ranges
        #   @return [::Array<::Google::Cloud::BackupDR::V1::AliasIpRange>]
        #     Optional. An array of alias IP ranges for this network interface.
        #     You can only specify this field for network interfaces in VPC networks.
        # @!attribute [rw] stack_type
        #   @return [::Google::Cloud::BackupDR::V1::NetworkInterface::StackType]
        #     The stack type for this network interface.
        # @!attribute [rw] ipv6_access_type
        #   @return [::Google::Cloud::BackupDR::V1::NetworkInterface::Ipv6AccessType]
        #     Optional. [Output Only] One of EXTERNAL, INTERNAL to indicate whether the
        #     IP can be accessed from the Internet. This field is always inherited from
        #     its subnetwork.
        # @!attribute [rw] queue_count
        #   @return [::Integer]
        #     Optional. The networking queue count that's specified by users for the
        #     network interface. Both Rx and Tx queues will be set to this number. It'll
        #     be empty if not specified by the users.
        # @!attribute [rw] nic_type
        #   @return [::Google::Cloud::BackupDR::V1::NetworkInterface::NicType]
        #     Optional. The type of vNIC to be used on this interface. This may be gVNIC
        #     or VirtioNet.
        # @!attribute [rw] network_attachment
        #   @return [::String]
        #     Optional. The URL of the network attachment that this interface should
        #     connect to in the following format:
        #     projects/\\{project_number}/regions/\\{region_name}/networkAttachments/\\{network_attachment_name}.
        class NetworkInterface
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Stack type for this network interface.
          module StackType
            # Default should be STACK_TYPE_UNSPECIFIED.
            STACK_TYPE_UNSPECIFIED = 0

            # The network interface will be assigned IPv4 address.
            IPV4_ONLY = 1

            # The network interface can have both IPv4 and IPv6 addresses.
            IPV4_IPV6 = 2
          end

          # IPv6 access type for this network interface.
          module Ipv6AccessType
            # IPv6 access type not set. Means this network interface hasn't been
            # turned on IPv6 yet.
            UNSPECIFIED_IPV6_ACCESS_TYPE = 0

            # This network interface can have internal IPv6.
            INTERNAL = 1

            # This network interface can have external IPv6.
            EXTERNAL = 2
          end

          # Nic type for this network interface.
          module NicType
            # Default should be NIC_TYPE_UNSPECIFIED.
            NIC_TYPE_UNSPECIFIED = 0

            # VIRTIO
            VIRTIO_NET = 1

            # GVNIC
            GVNIC = 2
          end
        end

        # Network performance configuration.
        # @!attribute [rw] total_egress_bandwidth_tier
        #   @return [::Google::Cloud::BackupDR::V1::NetworkPerformanceConfig::Tier]
        #     Optional. The tier of the total egress bandwidth.
        class NetworkPerformanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Network performance tier.
          module Tier
            # This value is unused.
            TIER_UNSPECIFIED = 0

            # Default network performance config.
            DEFAULT = 1

            # Tier 1 network performance config.
            TIER_1 = 2
          end
        end

        # An access configuration attached to an instance's network interface.
        # Only one access config per instance is supported.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::BackupDR::V1::AccessConfig::AccessType]
        #     Optional. In accessConfigs (IPv4), the
        #     default and only option is ONE_TO_ONE_NAT. In
        #     ipv6AccessConfigs, the default and only option is
        #     DIRECT_IPV6.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The name of this access configuration.
        # @!attribute [rw] external_ip
        #   @return [::String]
        #     Optional. The external IP address of this access configuration.
        # @!attribute [rw] external_ipv6
        #   @return [::String]
        #     Optional. The external IPv6 address of this access configuration.
        # @!attribute [rw] external_ipv6_prefix_length
        #   @return [::Integer]
        #     Optional. The prefix length of the external IPv6 range.
        # @!attribute [rw] set_public_ptr
        #   @return [::Boolean]
        #     Optional. Specifies whether a public DNS 'PTR' record should be created to
        #     map the external IP address of the instance to a DNS domain name.
        # @!attribute [rw] public_ptr_domain_name
        #   @return [::String]
        #     Optional. The DNS domain name for the public PTR record.
        # @!attribute [rw] network_tier
        #   @return [::Google::Cloud::BackupDR::V1::AccessConfig::NetworkTier]
        #     Optional. This signifies the networking tier used for configuring this
        #     access
        class AccessConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of configuration.
          module AccessType
            # Default value. This value is unused.
            ACCESS_TYPE_UNSPECIFIED = 0

            # ONE_TO_ONE_NAT
            ONE_TO_ONE_NAT = 1

            # Direct IPv6 access.
            DIRECT_IPV6 = 2
          end

          # Network tier property used by addresses, instances and forwarding rules.
          module NetworkTier
            # Default value. This value is unused.
            NETWORK_TIER_UNSPECIFIED = 0

            # High quality, Google-grade network tier, support for all networking
            # products.
            PREMIUM = 1

            # Public internet quality, only limited support for other networking
            # products.
            STANDARD = 2
          end
        end

        # An alias IP range attached to an instance's network interface.
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     Optional. The IP alias ranges to allocate for this interface.
        # @!attribute [rw] subnetwork_range_name
        #   @return [::String]
        #     Optional. The name of a subnetwork secondary IP range from which to
        #     allocate an IP alias range. If not specified, the primary range of the
        #     subnetwork is used.
        class AliasIpRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional instance params.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource manager tags to be bound to the instance.
        class InstanceParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specifies the reservations that this instance can consume from.
        # @!attribute [rw] consume_allocation_type
        #   @return [::Google::Cloud::BackupDR::V1::AllocationAffinity::Type]
        #     Optional. Specifies the type of reservation from which this instance can
        #     consume
        # @!attribute [rw] key
        #   @return [::String]
        #     Optional. Corresponds to the label key of a reservation resource.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     Optional. Corresponds to the label values of a reservation resource.
        class AllocationAffinity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates whether to consume from a reservation or not.
          module Type
            # Default value. This value is unused.
            TYPE_UNSPECIFIED = 0

            # Do not consume from any allocated capacity.
            NO_RESERVATION = 1

            # Consume any allocation available.
            ANY_RESERVATION = 2

            # Must consume from a specific reservation. Must specify key value fields
            # for specifying the reservations.
            SPECIFIC_RESERVATION = 3
          end
        end

        # Sets the scheduling options for an Instance.
        # @!attribute [rw] on_host_maintenance
        #   @return [::Google::Cloud::BackupDR::V1::Scheduling::OnHostMaintenance]
        #     Optional. Defines the maintenance behavior for this instance.
        # @!attribute [rw] automatic_restart
        #   @return [::Boolean]
        #     Optional. Specifies whether the instance should be automatically restarted
        #     if it is terminated by Compute Engine (not terminated by a user).
        # @!attribute [rw] preemptible
        #   @return [::Boolean]
        #     Optional. Defines whether the instance is preemptible.
        # @!attribute [rw] node_affinities
        #   @return [::Array<::Google::Cloud::BackupDR::V1::Scheduling::NodeAffinity>]
        #     Optional. A set of node affinity and anti-affinity configurations.
        #     Overrides reservationAffinity.
        # @!attribute [rw] min_node_cpus
        #   @return [::Integer]
        #     Optional. The minimum number of virtual CPUs this instance will consume
        #     when running on a sole-tenant node.
        # @!attribute [rw] provisioning_model
        #   @return [::Google::Cloud::BackupDR::V1::Scheduling::ProvisioningModel]
        #     Optional. Specifies the provisioning model of the instance.
        # @!attribute [rw] instance_termination_action
        #   @return [::Google::Cloud::BackupDR::V1::Scheduling::InstanceTerminationAction]
        #     Optional. Specifies the termination action for the instance.
        # @!attribute [rw] local_ssd_recovery_timeout
        #   @return [::Google::Cloud::BackupDR::V1::SchedulingDuration]
        #     Optional. Specifies the maximum amount of time a Local Ssd Vm should wait
        #     while recovery of the Local Ssd state is attempted. Its value should be in
        #     between 0 and 168 hours with hour granularity and the default value being 1
        #     hour.
        class Scheduling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Node Affinity: the configuration of desired nodes onto which this Instance
          # could be scheduled.
          # @!attribute [rw] key
          #   @return [::String]
          #     Optional. Corresponds to the label key of Node resource.
          # @!attribute [rw] operator
          #   @return [::Google::Cloud::BackupDR::V1::Scheduling::NodeAffinity::Operator]
          #     Optional. Defines the operation of node selection.
          # @!attribute [rw] values
          #   @return [::Array<::String>]
          #     Optional. Corresponds to the label values of Node resource.
          class NodeAffinity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the type of node selections.
            module Operator
              # Default value. This value is unused.
              OPERATOR_UNSPECIFIED = 0

              # Requires Compute Engine to seek for matched nodes.
              IN = 1

              # Requires Compute Engine to avoid certain nodes.
              NOT_IN = 2
            end
          end

          # Defines the maintenance behavior for this instance=
          module OnHostMaintenance
            # Default value. This value is unused.
            ON_HOST_MAINTENANCE_UNSPECIFIED = 0

            # Tells Compute Engine to terminate and (optionally) restart the instance
            # away from the maintenance activity.
            TERMINATE = 1

            # Default, Allows Compute Engine to automatically migrate instances
            # out of the way of maintenance events.
            MIGRATE = 1000
          end

          # Defines the provisioning model for an instance.
          module ProvisioningModel
            # Default value. This value is not used.
            PROVISIONING_MODEL_UNSPECIFIED = 0

            # Standard provisioning with user controlled runtime, no discounts.
            STANDARD = 1

            # Heavily discounted, no guaranteed runtime.
            SPOT = 2
          end

          # Defines the supported termination actions for an instance.
          module InstanceTerminationAction
            # Default value. This value is unused.
            INSTANCE_TERMINATION_ACTION_UNSPECIFIED = 0

            # Delete the VM.
            DELETE = 1

            # Stop the VM without storing in-memory content. default action.
            STOP = 2
          end
        end

        # A SchedulingDuration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # @!attribute [rw] seconds
        #   @return [::Integer]
        #     Optional. Span of time at a resolution of a second.
        # @!attribute [rw] nanos
        #   @return [::Integer]
        #     Optional. Span of time that's a fraction of a second at nanosecond
        #     resolution.
        class SchedulingDuration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A service account.
        # @!attribute [rw] email
        #   @return [::String]
        #     Optional. Email address of the service account.
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     Optional. The list of scopes to be made available for this service account.
        class ServiceAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of instance tags.
        # @!attribute [rw] items
        #   @return [::Array<::String>]
        #     Optional. An array of tags. Each tag must be 1-63 characters long, and
        #     comply with RFC1035.
        class Tags
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An instance-attached disk resource.
        # @!attribute [rw] initialize_params
        #   @return [::Google::Cloud::BackupDR::V1::AttachedDisk::InitializeParams]
        #     Optional. Specifies the parameters to initialize this disk.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     Optional. This is used as an identifier for the disks. This is the unique
        #     name has to provided to modify disk parameters like disk_name and
        #     replica_zones (in case of RePDs)
        # @!attribute [rw] kind
        #   @return [::String]
        #     Optional. Type of the resource.
        # @!attribute [rw] disk_type_deprecated
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::BackupDR::V1::AttachedDisk::DiskType]
        #     Specifies the type of the disk.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::BackupDR::V1::AttachedDisk::DiskMode]
        #     Optional. The mode in which to attach this disk.
        # @!attribute [rw] source
        #   @return [::String]
        #     Optional. Specifies a valid partial or full URL to an existing Persistent
        #     Disk resource.
        # @!attribute [rw] index
        #   @return [::Integer]
        #     Optional. A zero-based index to this disk, where 0 is reserved for the
        #     boot disk.
        # @!attribute [rw] boot
        #   @return [::Boolean]
        #     Optional. Indicates that this is a boot disk. The virtual machine will use
        #     the first partition of the disk for its root filesystem.
        # @!attribute [rw] auto_delete
        #   @return [::Boolean]
        #     Optional. Specifies whether the disk will be auto-deleted when the instance
        #     is deleted (but not when the disk is detached from the instance).
        # @!attribute [rw] license
        #   @return [::Array<::String>]
        #     Optional. Any valid publicly visible licenses.
        # @!attribute [rw] disk_interface
        #   @return [::Google::Cloud::BackupDR::V1::AttachedDisk::DiskInterface]
        #     Optional. Specifies the disk interface to use for attaching this disk.
        # @!attribute [rw] guest_os_feature
        #   @return [::Array<::Google::Cloud::BackupDR::V1::GuestOsFeature>]
        #     Optional. A list of features to enable on the guest operating system.
        #     Applicable only for bootable images.
        # @!attribute [rw] disk_encryption_key
        #   @return [::Google::Cloud::BackupDR::V1::CustomerEncryptionKey]
        #     Optional. Encrypts or decrypts a disk using a customer-supplied
        #     encryption key.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Optional. The size of the disk in GB.
        # @!attribute [r] saved_state
        #   @return [::Google::Cloud::BackupDR::V1::AttachedDisk::DiskSavedState]
        #     Optional. Output only. The state of the disk.
        # @!attribute [r] disk_type
        #   @return [::String]
        #     Optional. Output only. The URI of the disk type resource. For example:
        #     projects/project/zones/zone/diskTypes/pd-standard or pd-ssd
        # @!attribute [rw] type
        #   @return [::Google::Cloud::BackupDR::V1::AttachedDisk::DiskType]
        #     Optional. Specifies the type of the disk.
        class AttachedDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the parameters to initialize this disk.
          # @!attribute [rw] disk_name
          #   @return [::String]
          #     Optional. Specifies the disk name. If not specified, the default is to
          #     use the name of the instance.
          # @!attribute [rw] replica_zones
          #   @return [::Array<::String>]
          #     Optional. URL of the zone where the disk should be created.
          #     Required for each regional disk associated with the instance.
          class InitializeParams
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # List of the Disk Types.
          module DiskType
            # Default value, which is unused.
            DISK_TYPE_UNSPECIFIED = 0

            # A scratch disk type.
            SCRATCH = 1

            # A persistent disk type.
            PERSISTENT = 2
          end

          # List of the Disk Modes.
          module DiskMode
            # Default value, which is unused.
            DISK_MODE_UNSPECIFIED = 0

            # Attaches this disk in read-write mode. Only one
            # virtual machine at a time can be attached to a disk in read-write mode.
            READ_WRITE = 1

            # Attaches this disk in read-only mode. Multiple virtual machines can use
            # a disk in read-only mode at a time.
            READ_ONLY = 2

            # The disk is locked for administrative reasons. Nobody else
            # can use the disk. This mode is used (for example) when taking
            # a snapshot of a disk to prevent mounting the disk while it is
            # being snapshotted.
            LOCKED = 3
          end

          # List of the Disk Interfaces.
          module DiskInterface
            # Default value, which is unused.
            DISK_INTERFACE_UNSPECIFIED = 0

            # SCSI Disk Interface.
            SCSI = 1

            # NVME Disk Interface.
            NVME = 2

            # NVDIMM Disk Interface.
            NVDIMM = 3

            # ISCSI Disk Interface.
            ISCSI = 4
          end

          # List of the states of the Disk.
          module DiskSavedState
            # Default Disk state has not been preserved.
            DISK_SAVED_STATE_UNSPECIFIED = 0

            # Disk state has been preserved.
            PRESERVED = 1
          end
        end

        # Feature type of the Guest OS.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::BackupDR::V1::GuestOsFeature::FeatureType]
        #     The ID of a supported feature.
        class GuestOsFeature
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List of the Feature Types.
          module FeatureType
            # Default value, which is unused.
            FEATURE_TYPE_UNSPECIFIED = 0

            # VIRTIO_SCSI_MULTIQUEUE feature type.
            VIRTIO_SCSI_MULTIQUEUE = 1

            # WINDOWS feature type.
            WINDOWS = 2

            # MULTI_IP_SUBNET feature type.
            MULTI_IP_SUBNET = 3

            # UEFI_COMPATIBLE feature type.
            UEFI_COMPATIBLE = 4

            # SECURE_BOOT feature type.
            SECURE_BOOT = 5

            # GVNIC feature type.
            GVNIC = 6

            # SEV_CAPABLE feature type.
            SEV_CAPABLE = 7

            # BARE_METAL_LINUX_COMPATIBLE feature type.
            BARE_METAL_LINUX_COMPATIBLE = 8

            # SUSPEND_RESUME_COMPATIBLE feature type.
            SUSPEND_RESUME_COMPATIBLE = 9

            # SEV_LIVE_MIGRATABLE feature type.
            SEV_LIVE_MIGRATABLE = 10

            # SEV_SNP_CAPABLE feature type.
            SEV_SNP_CAPABLE = 11

            # TDX_CAPABLE feature type.
            TDX_CAPABLE = 12

            # IDPF feature type.
            IDPF = 13

            # SEV_LIVE_MIGRATABLE_V2 feature type.
            SEV_LIVE_MIGRATABLE_V2 = 14
          end
        end

        # Specifies whether the virtual machine instance will be shut down on key
        # revocation. It is currently used in instance, instance properties and GMI
        # protos
        module KeyRevocationActionType
          # Default value. This value is unused.
          KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 0

          # Indicates user chose no operation.
          NONE = 1

          # Indicates user chose to opt for VM shutdown on key revocation.
          STOP = 2
        end
      end
    end
  end
end
