# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # DiskTargetEnvironment represents the target environment for the disk.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. Target project for the disk.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. Target zone for the disk.
        class DiskTargetEnvironment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RegionDiskTargetEnvironment represents the target environment for the disk.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. Target project for the disk.
        # @!attribute [rw] region
        #   @return [::String]
        #     Required. Target region for the disk.
        # @!attribute [rw] replica_zones
        #   @return [::Array<::String>]
        #     Required. Target URLs of the replica zones for the disk.
        class RegionDiskTargetEnvironment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DiskRestoreProperties represents the properties of a Disk restore.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the disk.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. An optional description of this resource. Provide this property
        #     when you create the resource.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     Required. The size of the disk in GB.
        # @!attribute [rw] licenses
        #   @return [::Array<::String>]
        #     Optional. A list of publicly available licenses that are applicable to this
        #     backup. This is applicable if the original image had licenses attached,
        #     e.g. Windows image
        # @!attribute [rw] guest_os_feature
        #   @return [::Array<::Google::Cloud::BackupDR::V1::GuestOsFeature>]
        #     Optional. A list of features to enable in the guest operating system. This
        #     is applicable only for bootable images.
        # @!attribute [rw] disk_encryption_key
        #   @return [::Google::Cloud::BackupDR::V1::CustomerEncryptionKey]
        #     Optional. Encrypts the disk using a
        #     customer-supplied encryption key or a customer-managed encryption key.
        # @!attribute [rw] physical_block_size_bytes
        #   @return [::Integer]
        #     Optional. Physical block size of the persistent disk, in bytes.
        #     If not present in a request, a default value is used.
        #     Currently, the supported size is 4096.
        # @!attribute [rw] provisioned_iops
        #   @return [::Integer]
        #     Optional. Indicates how many IOPS to provision for the disk. This sets the
        #     number of I/O operations per second that the disk can handle.
        # @!attribute [rw] provisioned_throughput
        #   @return [::Integer]
        #     Optional. Indicates how much throughput to provision for the disk. This
        #     sets the number of throughput MB per second that the disk can handle.
        # @!attribute [rw] enable_confidential_compute
        #   @return [::Boolean]
        #     Optional. Indicates whether this disk is using confidential compute mode.
        #     Encryption with a Cloud KMS key is required to enable this option.
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     Optional. The storage pool in which the new disk is created. You can
        #     provide this as a partial or full URL to the resource.
        # @!attribute [rw] access_mode
        #   @return [::Google::Cloud::BackupDR::V1::DiskRestoreProperties::AccessMode]
        #     Optional. The access mode of the disk.
        # @!attribute [rw] architecture
        #   @return [::Google::Cloud::BackupDR::V1::DiskRestoreProperties::Architecture]
        #     Optional. The architecture of the source disk. Valid values are
        #     ARM64 or X86_64.
        # @!attribute [rw] resource_policy
        #   @return [::Array<::String>]
        #     Optional. Resource policies applied to this disk.
        # @!attribute [rw] type
        #   @return [::String]
        #     Required. URL of the disk type resource describing which disk type to use
        #     to create the disk.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels to apply to this disk. These can be modified later using
        #     <code>setLabels</code> method. Label values can be empty.
        # @!attribute [rw] resource_manager_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource manager tags to be bound to the disk.
        class DiskRestoreProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceManagerTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The supported access modes of the disk.
          module AccessMode
            # The default AccessMode, means the disk can be attached to single instance
            # in RW mode.
            READ_WRITE_SINGLE = 0

            # The AccessMode means the disk can be attached to multiple instances in RW
            # mode.
            READ_WRITE_MANY = 1

            # The AccessMode means the disk can be attached to multiple instances in RO
            # mode.
            READ_ONLY_MANY = 2
          end

          # Architecture of the source disk.
          module Architecture
            # Default value. This value is unused.
            ARCHITECTURE_UNSPECIFIED = 0

            # Disks with architecture X86_64
            X86_64 = 1

            # Disks with architecture ARM64
            ARM64 = 2
          end
        end

        # DiskBackupProperties represents the properties of a Disk backup.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the source disk.
        # @!attribute [rw] licenses
        #   @return [::Array<::String>]
        #     A list of publicly available licenses that are applicable to this backup.
        #     This is applicable if the original image had licenses attached, e.g.
        #     Windows image.
        # @!attribute [rw] guest_os_feature
        #   @return [::Array<::Google::Cloud::BackupDR::V1::GuestOsFeature>]
        #     A list of guest OS features that are applicable to this backup.
        # @!attribute [rw] architecture
        #   @return [::Google::Cloud::BackupDR::V1::DiskBackupProperties::Architecture]
        #     The architecture of the source disk. Valid values are
        #     ARM64 or X86_64.
        # @!attribute [rw] type
        #   @return [::String]
        #     The URL of the type of the disk.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     Size(in GB) of the source disk.
        # @!attribute [rw] region
        #   @return [::String]
        #     Region and zone are mutually exclusive fields.
        #     The URL of the region of the source disk.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The URL of the Zone where the source disk.
        # @!attribute [rw] replica_zones
        #   @return [::Array<::String>]
        #     The URL of the Zones where the source disk should be replicated.
        # @!attribute [rw] source_disk
        #   @return [::String]
        #     The source disk used to create this backup.
        class DiskBackupProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Architecture of the source disk.
          module Architecture
            # Default value. This value is unused.
            ARCHITECTURE_UNSPECIFIED = 0

            # Disks with architecture X86_64
            X86_64 = 1

            # Disks with architecture ARM64
            ARM64 = 2
          end
        end

        # DiskDataSourceProperties represents the properties of a
        # Disk resource that are stored in the DataSource.
        # .
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the disk backed up by the datasource.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the disk.
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of the disk.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     The size of the disk in GB.
        class DiskDataSourceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
