# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # CloudSqlInstanceDataSourceProperties represents the properties of a
        # Cloud SQL resource that are stored in the DataSource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the Cloud SQL instance backed up by the datasource.
        #     Format:
        #     projects/\\{project}/instances/\\{instance}
        # @!attribute [r] database_installed_version
        #   @return [::String]
        #     Output only. The installed database version of the Cloud SQL instance.
        # @!attribute [r] instance_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The instance creation timestamp.
        # @!attribute [r] instance_tier
        #   @return [::String]
        #     Output only. The tier (or machine type) for this instance. Example:
        #     `db-custom-1-3840`
        class CloudSqlInstanceDataSourceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloudSqlInstanceBackupProperties represents Cloud SQL Instance
        # Backup properties.
        # @!attribute [r] database_installed_version
        #   @return [::String]
        #     Output only. The installed database version of the Cloud SQL instance
        #     when the backup was taken.
        # @!attribute [r] final_backup
        #   @return [::Boolean]
        #     Output only. Whether the backup is a final backup.
        # @!attribute [r] source_instance
        #   @return [::String]
        #     Output only. The source instance of the backup.
        #     Format:
        #     projects/\\{project}/instances/\\{instance}
        # @!attribute [r] instance_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The instance creation timestamp.
        # @!attribute [r] instance_tier
        #   @return [::String]
        #     Output only. The tier (or machine type) for this instance. Example:
        #     `db-custom-1-3840`
        # @!attribute [r] instance_delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The instance delete timestamp.
        class CloudSqlInstanceBackupProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloudSqlInstanceDataSourceReferenceProperties represents the properties of a
        # Cloud SQL resource that are stored in the DataSourceReference.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the Cloud SQL instance backed up by the datasource.
        #     Format:
        #     projects/\\{project}/instances/\\{instance}
        # @!attribute [r] database_installed_version
        #   @return [::String]
        #     Output only. The installed database version of the Cloud SQL instance.
        # @!attribute [r] instance_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The instance creation timestamp.
        # @!attribute [r] instance_tier
        #   @return [::String]
        #     Output only. The tier (or machine type) for this instance. Example:
        #     `db-custom-1-3840`
        class CloudSqlInstanceDataSourceReferenceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloudSqlInstanceInitializationConfig contains the configuration for
        # initializing a Cloud SQL instance.
        # @!attribute [rw] edition
        #   @return [::Google::Cloud::BackupDR::V1::CloudSqlInstanceInitializationConfig::Edition]
        #     Required. The edition of the Cloud SQL instance.
        class CloudSqlInstanceInitializationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The edition of the Cloud SQL instance. For details, see
          # https://cloud.google.com/sql/docs/editions-intro.
          module Edition
            # Unspecified edition.
            EDITION_UNSPECIFIED = 0

            # Enterprise edition.
            ENTERPRISE = 1

            # Enterprise Plus edition.
            ENTERPRISE_PLUS = 2
          end
        end

        # Cloud SQL instance's BPA properties.
        # @!attribute [r] instance_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was created.
        class CloudSqlInstanceBackupPlanAssociationProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
