# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # Message describing a BackupVault object.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Name of the backup vault to create. It must have
        #     the
        #     format`"projects/{project}/locations/{location}/backupVaults/{backupvault}"`.
        #     `{backupvault}` cannot be changed after creation. It must be between 3-63
        #     characters long and must be unique within the project and location.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the BackupVault instance (2048 characters or
        #     less).
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource labels to represent user provided metadata.
        #     No labels currently defined:
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was updated.
        # @!attribute [rw] backup_minimum_enforced_retention_duration
        #   @return [::Google::Protobuf::Duration]
        #     Required. The default and minimum enforced retention for each backup within
        #     the backup vault.  The enforced retention for each backup can be extended.
        # @!attribute [rw] backup_retention_inheritance
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault::BackupRetentionInheritance]
        #     Optional. Setting for how a backup's enforced retention end time is
        #     inherited.
        # @!attribute [r] deletable
        #   @return [::Boolean]
        #     Output only. Set to true when there are no backups nested under this
        #     resource.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Server specified ETag for the backup vault resource to
        #     prevent simultaneous updates from overwiting each other.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault::State]
        #     Output only. The BackupVault resource instance state.
        # @!attribute [rw] effective_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Time after which the BackupVault resource is locked.
        # @!attribute [r] backup_count
        #   @return [::Integer]
        #     Output only. The number of backups in this backup vault.
        # @!attribute [r] service_account
        #   @return [::String]
        #     Output only. Service account used by the BackupVault Service for this
        #     BackupVault.  The user should grant this account permissions in their
        #     workload project to enable the service to run backups and restores there.
        # @!attribute [r] total_stored_bytes
        #   @return [::Integer]
        #     Output only. Total size of the storage used by all backup resources.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Immutable after resource creation until resource deletion.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. See https://google.aip.dev/128#annotations
        #     Stores small amounts of arbitrary data.
        # @!attribute [rw] access_restriction
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault::AccessRestriction]
        #     Optional. Note: This field is added for future use case and will not be
        #     supported in the current release.
        #
        #     Access restriction for the backup vault.
        #     Default value is WITHIN_ORGANIZATION if not provided during creation.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault::EncryptionConfig]
        #     Optional. The encryption config of the backup vault.
        class BackupVault
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message describing the EncryptionConfig of backup vault.
          # This determines how data within the vault is encrypted at rest.
          # @!attribute [rw] kms_key_name
          #   @return [::String]
          #     Optional. The Cloud KMS key name to encrypt backups in this backup vault.
          #     Must be in the same region as the vault. Some workload backups like
          #     compute disk backups may use their inherited source key instead. Format:
          #     projects/\\{project}/locations/\\{location}/keyRings/\\{ring}/cryptoKeys/\\{key}
          class EncryptionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # How a backup's enforced retention end time is inherited.
          module BackupRetentionInheritance
            # Inheritance behavior not set. This will default to
            # `INHERIT_VAULT_RETENTION`.
            BACKUP_RETENTION_INHERITANCE_UNSPECIFIED = 0

            # The enforced retention end time of a backup will be inherited from the
            # backup vault's `backup_minimum_enforced_retention_duration` field.
            #
            # This is the default behavior.
            INHERIT_VAULT_RETENTION = 1

            # The enforced retention end time of a backup will always match the expire
            # time of the backup.
            #
            # If this is set, the backup's enforced retention end time will be set to
            # match the expire time during creation of the backup. When updating, the
            # ERET and expire time must be updated together and have the same value.
            # Invalid update requests will be rejected by the server.
            MATCH_BACKUP_EXPIRE_TIME = 2
          end

          # Holds the state of the backup vault resource.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The backup vault is being created.
            CREATING = 1

            # The backup vault has been created and is fully usable.
            ACTIVE = 2

            # The backup vault is being deleted.
            DELETING = 3

            # The backup vault is experiencing an issue and might be unusable.
            ERROR = 4

            # The backup vault is being updated.
            UPDATING = 5
          end

          # Holds the access restriction for the backup vault.
          module AccessRestriction
            # Access restriction not set. If user does not provide any value or pass
            # this value, it will be changed to WITHIN_ORGANIZATION.
            ACCESS_RESTRICTION_UNSPECIFIED = 0

            # Access to or from resources outside your current project will be denied.
            WITHIN_PROJECT = 1

            # Access to or from resources outside your current organization will be
            # denied.
            WITHIN_ORGANIZATION = 2

            # No access restriction.
            UNRESTRICTED = 3

            # Access to or from resources outside your current organization will be
            # denied except for backup appliance.
            WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA = 4
          end
        end

        # Message describing a DataSource object.
        # Datasource object used to represent Datasource details for both admin and
        # basic view.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Name of the datasource to create.
        #     It must have the
        #     format`"projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}"`.
        #     `{datasource}` cannot be changed after creation. It must be between 3-63
        #     characters long and must be unique within the backup vault.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BackupDR::V1::DataSource::State]
        #     Output only. The DataSource resource instance state.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource labels to represent user provided metadata.
        #     No labels currently defined:
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was updated.
        # @!attribute [rw] backup_count
        #   @return [::Integer]
        #     Number of backups in the data source.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Server specified ETag for the ManagementServer resource to prevent
        #     simultaneous updates from overwiting each other.
        # @!attribute [rw] total_stored_bytes
        #   @return [::Integer]
        #     The number of bytes (metadata and data) stored in this datasource.
        # @!attribute [r] config_state
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigState]
        #     Output only. The backup configuration state.
        # @!attribute [r] backup_config_info
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigInfo]
        #     Output only. Details of how the resource is configured for backup.
        # @!attribute [rw] data_source_gcp_resource
        #   @return [::Google::Cloud::BackupDR::V1::DataSourceGcpResource]
        #     The backed up resource is a Google Cloud resource.
        #     The word 'DataSource' was included in the names to indicate that this is
        #     the representation of the Google Cloud resource used within the
        #     DataSource object.
        #
        #     Note: The following fields are mutually exclusive: `data_source_gcp_resource`, `data_source_backup_appliance_application`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_source_backup_appliance_application
        #   @return [::Google::Cloud::BackupDR::V1::DataSourceBackupApplianceApplication]
        #     The backed up resource is a backup appliance application.
        #
        #     Note: The following fields are mutually exclusive: `data_source_backup_appliance_application`, `data_source_gcp_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] backup_blocked_by_vault_access_restriction
        #   @return [::Boolean]
        #     Output only. This field is set to true if the backup is blocked by vault
        #     access restriction.
        class DataSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Holds the state of the data source resource.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The data source is being created.
            CREATING = 1

            # The data source has been created and is fully usable.
            ACTIVE = 2

            # The data source is being deleted.
            DELETING = 3

            # The data source is experiencing an issue and might be unusable.
            ERROR = 4
          end
        end

        # BackupConfigInfo has information about how the resource is configured
        # for Backup and about the most recent backup to this vault.
        # @!attribute [r] last_backup_state
        #   @return [::Google::Cloud::BackupDR::V1::BackupConfigInfo::LastBackupState]
        #     Output only. The status of the last backup to this BackupVault
        # @!attribute [r] last_successful_backup_consistency_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. If the last backup were successful, this field has the
        #     consistency date.
        # @!attribute [r] last_backup_error
        #   @return [::Google::Rpc::Status]
        #     Output only. If the last backup failed, this field has the error message.
        # @!attribute [rw] gcp_backup_config
        #   @return [::Google::Cloud::BackupDR::V1::GcpBackupConfig]
        #     Configuration for a Google Cloud resource.
        #
        #     Note: The following fields are mutually exclusive: `gcp_backup_config`, `backup_appliance_backup_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] backup_appliance_backup_config
        #   @return [::Google::Cloud::BackupDR::V1::BackupApplianceBackupConfig]
        #     Configuration for an application backed up by a Backup Appliance.
        #
        #     Note: The following fields are mutually exclusive: `backup_appliance_backup_config`, `gcp_backup_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BackupConfigInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # LastBackupstate tracks whether the last backup was not yet started,
          # successful, failed, or could not be run because of the lack of permissions.
          module LastBackupState
            # Status not set.
            LAST_BACKUP_STATE_UNSPECIFIED = 0

            # The first backup has not yet completed
            FIRST_BACKUP_PENDING = 1

            # The most recent backup was successful
            SUCCEEDED = 2

            # The most recent backup failed
            FAILED = 3

            # The most recent backup could not be run/failed because of the lack of
            # permissions
            PERMISSION_DENIED = 4
          end
        end

        # GcpBackupConfig captures the Backup configuration details for Google Cloud
        # resources. All Google Cloud resources regardless of type are protected with
        # backup plan associations.
        # @!attribute [rw] backup_plan
        #   @return [::String]
        #     The name of the backup plan.
        # @!attribute [rw] backup_plan_description
        #   @return [::String]
        #     The description of the backup plan.
        # @!attribute [rw] backup_plan_association
        #   @return [::String]
        #     The name of the backup plan association.
        # @!attribute [rw] backup_plan_rules
        #   @return [::Array<::String>]
        #     The names of the backup plan rules which point to this backupvault
        # @!attribute [rw] backup_plan_revision_name
        #   @return [::String]
        #     The name of the backup plan revision.
        # @!attribute [rw] backup_plan_revision_id
        #   @return [::String]
        #     The user friendly id of the backup plan revision.
        #     E.g. v0, v1 etc.
        class GcpBackupConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupApplianceBackupConfig captures the backup configuration for
        # applications that are protected by Backup Appliances.
        # @!attribute [rw] backup_appliance_name
        #   @return [::String]
        #     The name of the backup appliance.
        # @!attribute [rw] backup_appliance_id
        #   @return [::Integer]
        #     The ID of the backup appliance.
        # @!attribute [rw] sla_id
        #   @return [::Integer]
        #     The ID of the SLA of this application.
        # @!attribute [rw] application_name
        #   @return [::String]
        #     The name of the application.
        # @!attribute [rw] host_name
        #   @return [::String]
        #     The name of the host where the application is running.
        # @!attribute [rw] slt_name
        #   @return [::String]
        #     The name of the SLT associated with the application.
        # @!attribute [rw] slp_name
        #   @return [::String]
        #     The name of the SLP associated with the application.
        class BackupApplianceBackupConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DataSourceGcpResource is used for protected resources that are Google Cloud
        # Resources. This name is easeier to understand than GcpResourceDataSource or
        # GcpDataSourceResource
        # @!attribute [r] gcp_resourcename
        #   @return [::String]
        #     Output only. Full resource pathname URL of the source Google Cloud
        #     resource.
        # @!attribute [rw] location
        #   @return [::String]
        #     Location of the resource: <region>/<zone>/"global"/"unspecified".
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of the Google Cloud resource. Use the Unified Resource Type,
        #     eg. compute.googleapis.com/Instance.
        # @!attribute [rw] compute_instance_datasource_properties
        #   @return [::Google::Cloud::BackupDR::V1::ComputeInstanceDataSourceProperties]
        #     ComputeInstanceDataSourceProperties has a subset of Compute Instance
        #     properties that are useful at the Datasource level.
        #
        #     Note: The following fields are mutually exclusive: `compute_instance_datasource_properties`, `cloud_sql_instance_datasource_properties`, `disk_datasource_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] cloud_sql_instance_datasource_properties
        #   @return [::Google::Cloud::BackupDR::V1::CloudSqlInstanceDataSourceProperties]
        #     Output only. CloudSqlInstanceDataSourceProperties has a subset of Cloud
        #     SQL Instance properties that are useful at the Datasource level.
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_instance_datasource_properties`, `compute_instance_datasource_properties`, `disk_datasource_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disk_datasource_properties
        #   @return [::Google::Cloud::BackupDR::V1::DiskDataSourceProperties]
        #     DiskDataSourceProperties has a subset of Disk properties that are useful
        #     at the Datasource level.
        #
        #     Note: The following fields are mutually exclusive: `disk_datasource_properties`, `compute_instance_datasource_properties`, `cloud_sql_instance_datasource_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DataSourceGcpResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupApplianceApplication describes a Source Resource when it is an
        # application backed up by a BackupAppliance.
        # @!attribute [rw] application_name
        #   @return [::String]
        #     The name of the Application as known to the Backup Appliance.
        # @!attribute [rw] backup_appliance
        #   @return [::String]
        #     Appliance name.
        # @!attribute [rw] appliance_id
        #   @return [::Integer]
        #     Appliance Id of the Backup Appliance.
        # @!attribute [rw] type
        #   @return [::String]
        #     The type of the application. e.g. VMBackup
        # @!attribute [rw] application_id
        #   @return [::Integer]
        #     The appid field of the application within the Backup Appliance.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Hostname of the host where the application is running.
        # @!attribute [rw] host_id
        #   @return [::Integer]
        #     Hostid of the application host.
        class DataSourceBackupApplianceApplication
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ServiceLockInfo represents the details of a lock taken by the service on a
        # Backup resource.
        # @!attribute [r] operation
        #   @return [::String]
        #     Output only. The name of the operation that created this lock.
        #     The lock will automatically be released when the operation completes.
        class ServiceLockInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupApplianceLockInfo contains metadata about the backupappliance that
        # created the lock.
        # @!attribute [rw] backup_appliance_id
        #   @return [::Integer]
        #     Required. The ID of the backup/recovery appliance that created this lock.
        # @!attribute [rw] backup_appliance_name
        #   @return [::String]
        #     Required. The name of the backup/recovery appliance that created this lock.
        # @!attribute [rw] lock_reason
        #   @return [::String]
        #     Required. The reason for the lock: e.g. MOUNT/RESTORE/BACKUP/etc.  The
        #     value of this string is only meaningful to the client and it is not
        #     interpreted by the BackupVault service.
        # @!attribute [rw] job_name
        #   @return [::String]
        #     The job name on the backup/recovery appliance that created this lock.
        #
        #     Note: The following fields are mutually exclusive: `job_name`, `backup_image`, `sla_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] backup_image
        #   @return [::String]
        #     The image name that depends on this Backup.
        #
        #     Note: The following fields are mutually exclusive: `backup_image`, `job_name`, `sla_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sla_id
        #   @return [::Integer]
        #     The SLA on the backup/recovery appliance that owns the lock.
        #
        #     Note: The following fields are mutually exclusive: `sla_id`, `job_name`, `backup_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BackupApplianceLockInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupLock represents a single lock on a Backup resource.  An unexpired
        # lock on a Backup prevents the Backup from being deleted.
        # @!attribute [rw] lock_until_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Required. The time after which this lock is not considered valid and will
        #     no longer protect the Backup from deletion.
        # @!attribute [rw] backup_appliance_lock_info
        #   @return [::Google::Cloud::BackupDR::V1::BackupApplianceLockInfo]
        #     If the client is a backup and recovery appliance, this
        #     contains metadata about why the lock exists.
        #
        #     Note: The following fields are mutually exclusive: `backup_appliance_lock_info`, `service_lock_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] service_lock_info
        #   @return [::Google::Cloud::BackupDR::V1::ServiceLockInfo]
        #     Output only. Contains metadata about the lock exist for Google Cloud
        #     native backups.
        #
        #     Note: The following fields are mutually exclusive: `service_lock_info`, `backup_appliance_lock_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BackupLock
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing a Backup object.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Name of the backup to create. It must have the
        #     format`"projects/<project>/locations/<location>/backupVaults/<backupvault>/dataSources/{datasource}/backups/{backup}"`.
        #     `{backup}` cannot be changed after creation. It must be between 3-63
        #     characters long and must be unique within the datasource.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. The description of the Backup instance (2048 characters or
        #     less).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource labels to represent user provided metadata.
        #     No labels currently defined.
        # @!attribute [rw] enforced_retention_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The backup can not be deleted before this time.
        # @!attribute [r] backup_retention_inheritance
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault::BackupRetentionInheritance]
        #     Output only. Setting for how the enforced retention end time is inherited.
        #     This value is copied from this backup's BackupVault.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. When this backup is automatically expired.
        # @!attribute [r] consistency_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The point in time when this backup was captured from the
        #     source.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Server specified ETag to prevent updates from overwriting each
        #     other.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BackupDR::V1::Backup::State]
        #     Output only. The Backup resource instance state.
        # @!attribute [r] service_locks
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupLock>]
        #     Output only. The list of BackupLocks taken by the service to prevent the
        #     deletion of the backup.
        # @!attribute [rw] backup_appliance_locks
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupLock>]
        #     Optional. The list of BackupLocks taken by the accessor Backup Appliance.
        # @!attribute [r] compute_instance_backup_properties
        #   @return [::Google::Cloud::BackupDR::V1::ComputeInstanceBackupProperties]
        #     Output only. Compute Engine specific backup properties.
        #
        #     Note: The following fields are mutually exclusive: `compute_instance_backup_properties`, `cloud_sql_instance_backup_properties`, `backup_appliance_backup_properties`, `disk_backup_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] cloud_sql_instance_backup_properties
        #   @return [::Google::Cloud::BackupDR::V1::CloudSqlInstanceBackupProperties]
        #     Output only. Cloud SQL specific backup properties.
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_instance_backup_properties`, `compute_instance_backup_properties`, `backup_appliance_backup_properties`, `disk_backup_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] backup_appliance_backup_properties
        #   @return [::Google::Cloud::BackupDR::V1::BackupApplianceBackupProperties]
        #     Output only. Backup Appliance specific backup properties.
        #
        #     Note: The following fields are mutually exclusive: `backup_appliance_backup_properties`, `compute_instance_backup_properties`, `cloud_sql_instance_backup_properties`, `disk_backup_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] disk_backup_properties
        #   @return [::Google::Cloud::BackupDR::V1::DiskBackupProperties]
        #     Output only. Disk specific backup properties.
        #
        #     Note: The following fields are mutually exclusive: `disk_backup_properties`, `compute_instance_backup_properties`, `cloud_sql_instance_backup_properties`, `backup_appliance_backup_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] backup_type
        #   @return [::Google::Cloud::BackupDR::V1::Backup::BackupType]
        #     Output only. Type of the backup, unspecified, scheduled or ondemand.
        # @!attribute [r] gcp_backup_plan_info
        #   @return [::Google::Cloud::BackupDR::V1::Backup::GCPBackupPlanInfo]
        #     Output only. Configuration for a Google Cloud resource.
        # @!attribute [r] resource_size_bytes
        #   @return [::Integer]
        #     Output only. source resource size in bytes at the time of the backup.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Optional. Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Optional. Output only. Reserved for future use.
        # @!attribute [r] gcp_resource
        #   @return [::Google::Cloud::BackupDR::V1::BackupGcpResource]
        #     Output only. Unique identifier of the GCP resource that is being backed
        #     up.
        # @!attribute [r] kms_key_versions
        #   @return [::Array<::String>]
        #     Optional. Output only. The list of KMS key versions used to encrypt the
        #     backup.
        class Backup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # GCPBackupPlanInfo captures the plan configuration details of Google Cloud
          # resources at the time of backup.
          # @!attribute [rw] backup_plan
          #   @return [::String]
          #     Resource name of backup plan by which workload is protected at the time
          #     of the backup.
          #     Format:
          #     projects/\\{project}/locations/\\{location}/backupPlans/\\{backupPlanId}
          # @!attribute [rw] backup_plan_rule_id
          #   @return [::String]
          #     The rule id of the backup plan which triggered this backup in case of
          #     scheduled backup or used for
          # @!attribute [rw] backup_plan_revision_name
          #   @return [::String]
          #     Resource name of the backup plan revision which triggered this backup in
          #     case of scheduled backup or used for on demand backup.
          #     Format:
          #     projects/\\{project}/locations/\\{location}/backupPlans/\\{backupPlanId}/revisions/\\{revisionId}
          # @!attribute [rw] backup_plan_revision_id
          #   @return [::String]
          #     The user friendly id of the backup plan revision which triggered this
          #     backup in case of scheduled backup or used for on demand backup.
          class GCPBackupPlanInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Holds the state of the backup resource.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The backup is being created.
            CREATING = 1

            # The backup has been created and is fully usable.
            ACTIVE = 2

            # The backup is being deleted.
            DELETING = 3

            # The backup is experiencing an issue and might be unusable.
            ERROR = 4

            # The backup is being uploaded.
            UPLOADING = 5
          end

          # Type of the backup, scheduled or ondemand.
          module BackupType
            # Backup type is unspecified.
            BACKUP_TYPE_UNSPECIFIED = 0

            # Scheduled backup.
            SCHEDULED = 1

            # On demand backup.
            ON_DEMAND = 2

            # Operational backup.
            ON_DEMAND_OPERATIONAL = 3
          end
        end

        # Message for creating a BackupVault.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] backup_vault_id
        #   @return [::String]
        #     Required. ID of the requesting object
        #     If auto-generating ID server-side, remove this field and
        #     backup_vault_id from the method_signature of Create RPC
        # @!attribute [rw] backup_vault
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is 'false'.
        class CreateBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing backupvault stores.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve backupvault stores
        #     information, in the format 'projects/\\{project_id}/locations/\\{location}'. In
        #     Cloud Backup and DR, locations map to Google Cloud regions, for example
        #     **us-central1**.
        #     To retrieve backupvault stores for all locations, use "-" for the
        #     '\\{location}' value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::BackupDR::V1::BackupVaultView]
        #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
        #     Vault.
        class ListBackupVaultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing BackupVaults.
        # @!attribute [rw] backup_vaults
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupVault>]
        #     The list of BackupVault instances in the project for the specified
        #     location.
        #
        #     If the '\\{location}' value in the request is "-", the response contains a
        #     list of instances from all locations. In case any location is unreachable,
        #     the response will only return backup vaults in reachable locations and
        #     the 'unreachable' field will be populated with a list of unreachable
        #     locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupVaultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for fetching usable BackupVaults.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve backupvault stores
        #     information, in the format 'projects/\\{project_id}/locations/\\{location}'. In
        #     Cloud Backup and DR, locations map to Google Cloud regions, for example
        #     **us-central1**.
        #     To retrieve backupvault stores for all locations, use "-" for the
        #     '\\{location}' value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class FetchUsableBackupVaultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for fetching usable BackupVaults.
        # @!attribute [rw] backup_vaults
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupVault>]
        #     The list of BackupVault instances in the project for the specified
        #     location.
        #
        #     If the '\\{location}' value in the request is "-", the response contains a
        #     list of instances from all locations. In case any location is unreachable,
        #     the response will only return backup vaults in reachable locations and
        #     the 'unreachable' field will be populated with a list of unreachable
        #     locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class FetchUsableBackupVaultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the FetchBackupsForResourceType method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Datasources are the parent resource for the backups.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/backupVaults/\\{backupVaultId}/dataSources/\\{datasourceId}
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Required. The type of the GCP resource.
        #     Ex: sqladmin.googleapis.com/Instance
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of Backups to return. The service may
        #     return fewer than this value. If unspecified, at most 50
        #     Backups will be returned. The maximum value is 100; values
        #     above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous call of
        #     `FetchBackupsForResourceType`.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `FetchBackupsForResourceType` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters the results fetched in the
        #     response. The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. Supported
        #     fields:
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A comma-separated list of fields to order by, sorted in ascending
        #     order. Use "desc" after a field name for descending.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::BackupDR::V1::BackupView]
        #     Optional. This parameter is used to specify the view of the backup.
        #     If not specified, the default view is BASIC.
        class FetchBackupsForResourceTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the FetchBackupsForResourceType method.
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::BackupDR::V1::Backup>]
        #     The Backups from the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class FetchBackupsForResourceTypeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a BackupVault.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the backupvault store resource name, in the format
        #     'projects/\\{project_id}/locations/\\{location}/backupVaults/\\{resource_name}'
        # @!attribute [rw] view
        #   @return [::Google::Cloud::BackupDR::V1::BackupVaultView]
        #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
        #     Vault
        class GetBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a BackupVault.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     BackupVault resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then the request will fail.
        # @!attribute [rw] backup_vault
        #   @return [::Google::Cloud::BackupDR::V1::BackupVault]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is 'false'.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, will not check plan duration against backup vault
        #     enforcement duration.
        # @!attribute [rw] force_update_access_restriction
        #   @return [::Boolean]
        #     Optional. If set to true, we will force update access restriction even if
        #     some non compliant data sources are present. The default is 'false'.
        class UpdateBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a BackupVault.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any data source from this backup vault will also
        #     be deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The current etag of the backup vault.
        #     If an etag is provided and does not match the current etag of the
        #     connection, deletion will be blocked.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is 'false'.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If true and the BackupVault is not found, the request will
        #     succeed but no action will be taken.
        # @!attribute [rw] ignore_backup_plan_references
        #   @return [::Boolean]
        #     Optional. If set to true, backupvault deletion will proceed even if there
        #     are backup plans referencing the backupvault. The default is 'false'.
        class DeleteBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing DataSources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve data
        #     sources information, in the format
        #     'projects/\\{project_id}/locations/\\{location}'. In Cloud Backup and DR,
        #     locations map to Google Cloud regions, for example **us-central1**.
        #     To retrieve data sources for all locations, use "-" for the
        #     '\\{location}' value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListDataSourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing DataSources.
        # @!attribute [rw] data_sources
        #   @return [::Array<::Google::Cloud::BackupDR::V1::DataSource>]
        #     The list of DataSource instances in the project for the specified
        #     location.
        #
        #     If the '\\{location}' value in the request is "-", the response contains a
        #     list of instances from all locations. In case any location is unreachable,
        #     the response will only return data sources in reachable locations
        #     and the 'unreachable' field will be populated with a list of unreachable
        #     locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDataSourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a DataSource instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the data source resource name, in the format
        #     'projects/\\{project_id}/locations/\\{location}/backupVaults/\\{resource_name}/dataSource/\\{resource_name}'
        class GetDataSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a data source instance.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     DataSource resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then the request will fail.
        # @!attribute [rw] data_source
        #   @return [::Google::Cloud::BackupDR::V1::DataSource]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. Enable upsert.
        class UpdateDataSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing Backups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve backup
        #     information, in the format
        #     'projects/\\{project_id}/locations/\\{location}'. In Cloud Backup and DR,
        #     locations map to Google Cloud regions, for example **us-central1**.
        #     To retrieve data sources for all locations, use "-" for the
        #     '\\{location}' value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::BackupDR::V1::BackupView]
        #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
        #     resource.
        class ListBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing Backups.
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::BackupDR::V1::Backup>]
        #     The list of Backup instances in the project for the specified
        #     location.
        #
        #     If the '\\{location}' value in the request is "-", the response contains a
        #     list of instances from all locations. In case any location is unreachable,
        #     the response will only return data sources in reachable locations
        #     and the 'unreachable' field will be populated with a list of unreachable
        #     locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a Backup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the data source resource name, in the format
        #     'projects/\\{project_id}/locations/\\{location}/backupVaults/\\{backupVault}/dataSources/\\{datasource}/backups/\\{backup}'
        # @!attribute [rw] view
        #   @return [::Google::Cloud::BackupDR::V1::BackupView]
        #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
        #     resource.
        class GetBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a Backup.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Backup resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then the request will fail.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::BackupDR::V1::Backup]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Backup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for restoring from a Backup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Backup instance, in the format
        #     'projects/*/locations/*/backupVaults/*/dataSources/*/backups/'.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] compute_instance_target_environment
        #   @return [::Google::Cloud::BackupDR::V1::ComputeInstanceTargetEnvironment]
        #     Compute Engine target environment to be used during restore.
        #
        #     Note: The following fields are mutually exclusive: `compute_instance_target_environment`, `disk_target_environment`, `region_disk_target_environment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disk_target_environment
        #   @return [::Google::Cloud::BackupDR::V1::DiskTargetEnvironment]
        #     Disk target environment to be used during restore.
        #
        #     Note: The following fields are mutually exclusive: `disk_target_environment`, `compute_instance_target_environment`, `region_disk_target_environment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] region_disk_target_environment
        #   @return [::Google::Cloud::BackupDR::V1::RegionDiskTargetEnvironment]
        #     Region disk target environment to be used during restore.
        #
        #     Note: The following fields are mutually exclusive: `region_disk_target_environment`, `compute_instance_target_environment`, `disk_target_environment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] compute_instance_restore_properties
        #   @return [::Google::Cloud::BackupDR::V1::ComputeInstanceRestoreProperties]
        #     Compute Engine instance properties to be overridden during restore.
        #
        #     Note: The following fields are mutually exclusive: `compute_instance_restore_properties`, `disk_restore_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disk_restore_properties
        #   @return [::Google::Cloud::BackupDR::V1::DiskRestoreProperties]
        #     Disk properties to be overridden during restore.
        #
        #     Note: The following fields are mutually exclusive: `disk_restore_properties`, `compute_instance_restore_properties`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] clear_overrides_field_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. A field mask used to clear server-side default values
        #     for fields within the `instance_properties` oneof.
        #
        #     When a field in this mask is cleared, the server will not apply its
        #     default logic (like inheriting a value from the source) for that field.
        #
        #     The most common current use case is clearing default encryption keys.
        #
        #     Examples of field mask paths:
        #     - Compute Instance Disks:
        #     `compute_instance_restore_properties.disks.*.disk_encryption_key`
        #     - Single Disk: `disk_restore_properties.disk_encryption_key`
        class RestoreBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for restoring from a Backup.
        # @!attribute [rw] target_resource
        #   @return [::Google::Cloud::BackupDR::V1::TargetResource]
        #     Details of the target resource created/modified as part of restore.
        class RestoreBackupResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of the target resource created/modified as part of restore.
        # @!attribute [rw] gcp_resource
        #   @return [::Google::Cloud::BackupDR::V1::GcpResource]
        #     Details of the native Google Cloud resource created as part of restore.
        class TargetResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Minimum details to identify a Google Cloud resource
        # @!attribute [rw] gcp_resourcename
        #   @return [::String]
        #     Name of the Google Cloud resource.
        # @!attribute [rw] location
        #   @return [::String]
        #     Location of the resource: <region>/<zone>/"global"/"unspecified".
        # @!attribute [rw] type
        #   @return [::String]
        #     Type of the resource. Use the Unified Resource Type,
        #     eg. compute.googleapis.com/Instance.
        class GcpResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Minimum details to identify a Google Cloud resource for a backup.
        # @!attribute [rw] gcp_resourcename
        #   @return [::String]
        #     Name of the Google Cloud resource.
        # @!attribute [rw] location
        #   @return [::String]
        #     Location of the resource: <region>/<zone>/"global"/"unspecified".
        # @!attribute [rw] type
        #   @return [::String]
        #     Type of the resource. Use the Unified Resource Type,
        #     eg. compute.googleapis.com/Instance.
        class BackupGcpResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Backup configuration state. Is the resource configured for backup?
        module BackupConfigState
          # The possible states of backup configuration.
          # Status not set.
          BACKUP_CONFIG_STATE_UNSPECIFIED = 0

          # The data source is actively protected (i.e. there is a
          # BackupPlanAssociation or Appliance SLA pointing to it)
          ACTIVE = 1

          # The data source is no longer protected (but may have backups under it)
          PASSIVE = 2
        end

        # BackupView contains enum options for Partial and Full view.
        module BackupView
          # If the value is not set, the default 'FULL' view is used.
          BACKUP_VIEW_UNSPECIFIED = 0

          # Includes basic data about the Backup, but not the full contents.
          BACKUP_VIEW_BASIC = 1

          # Includes all data about the Backup.
          # This is the default value (for both ListBackups and GetBackup).
          BACKUP_VIEW_FULL = 2
        end

        # BackupVaultView contains enum options for Partial and Full view.
        module BackupVaultView
          # If the value is not set, the default 'FULL' view is used.
          BACKUP_VAULT_VIEW_UNSPECIFIED = 0

          # Includes basic data about the Backup Vault, but not the full contents.
          BACKUP_VAULT_VIEW_BASIC = 1

          # Includes all data about the Backup Vault.
          # This is the default value (for both ListBackupVaults and GetBackupVault).
          BACKUP_VAULT_VIEW_FULL = 2
        end
      end
    end
  end
end
