# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        # A `BackupPlan` specifies some common fields, such as `description` as well
        # as one or more `BackupRule` messages. Each `BackupRule` has a retention
        # policy and defines a schedule by which the system is to perform backup
        # workloads.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the `BackupPlan`.
        #
        #     Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the `BackupPlan` resource.
        #
        #     The description allows for additional details about `BackupPlan` and its
        #     use cases to be provided. An example description is the following:  "This
        #     is a backup plan that performs a daily backup at 6pm and retains data for 3
        #     months". The description must be at most 2048 characters.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. This collection of key/value pairs allows for custom labels to be
        #     supplied by the user.  Example, \\{"tag": "Weekly"}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the `BackupPlan` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the `BackupPlan` was last updated.
        # @!attribute [rw] backup_rules
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupRule>]
        #     Required. The backup rules for this `BackupPlan`. There must be at least
        #     one `BackupRule` message.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BackupDR::V1::BackupPlan::State]
        #     Output only. The `State` for the `BackupPlan`.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Required. The resource type to which the `BackupPlan` will be applied.
        #     Examples include, "compute.googleapis.com/Instance",
        #     "sqladmin.googleapis.com/Instance", "alloydb.googleapis.com/Cluster",
        #     "compute.googleapis.com/Disk".
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. `etag` is returned from the service in the response. As a user of
        #     the service, you may provide an etag value in this field to prevent stale
        #     resources.
        # @!attribute [rw] backup_vault
        #   @return [::String]
        #     Required. Resource name of backup vault which will be used as storage
        #     location for backups. Format:
        #     projects/\\{project}/locations/\\{location}/backupVaults/\\{backupvault}
        # @!attribute [r] backup_vault_service_account
        #   @return [::String]
        #     Output only. The Google Cloud Platform Service Account to be used by the
        #     BackupVault for taking backups. Specify the email address of the Backup
        #     Vault Service Account.
        # @!attribute [rw] log_retention_days
        #   @return [::Integer]
        #     Optional. Applicable only for CloudSQL resource_type.
        #
        #     Configures how long logs will be stored. It is defined in “days”. This
        #     value should be greater than or equal to minimum enforced log retention
        #     duration of the backup vault.
        # @!attribute [r] supported_resource_types
        #   @return [::Array<::String>]
        #     Output only. All resource types to which backupPlan can be applied.
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. The user friendly revision ID of the `BackupPlanRevision`.
        #
        #     Example: v0, v1, v2, etc.
        # @!attribute [r] revision_name
        #   @return [::String]
        #     Output only. The resource id of the `BackupPlanRevision`.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision_id}`
        class BackupPlan
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `State` enumerates the possible states for a `BackupPlan`.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The resource is being created.
            CREATING = 1

            # The resource has been created and is fully usable.
            ACTIVE = 2

            # The resource is being deleted.
            DELETING = 3

            # The resource has been created but is not usable.
            INACTIVE = 4

            # The resource is being updated.
            UPDATING = 5
          end
        end

        # `BackupRule` binds the backup schedule to a retention policy.
        # @!attribute [rw] rule_id
        #   @return [::String]
        #     Required. Immutable. The unique id of this `BackupRule`. The `rule_id` is
        #     unique per `BackupPlan`.The `rule_id` must start with a lowercase letter
        #     followed by up to 62 lowercase letters, numbers, or hyphens. Pattern,
        #     /[a-z][a-z0-9-]\\{,62}/.
        # @!attribute [rw] backup_retention_days
        #   @return [::Integer]
        #     Required. Configures the duration for which backup data will be kept. It is
        #     defined in “days”. The value should be greater than or equal to minimum
        #     enforced retention of the backup vault.
        #
        #     Minimum value is 1 and maximum value is 36159 for custom retention
        #     on-demand backup.
        #     Minimum and maximum values are workload specific for all other rules.
        # @!attribute [rw] standard_schedule
        #   @return [::Google::Cloud::BackupDR::V1::StandardSchedule]
        #     Optional. Defines a schedule that runs within the confines of a defined
        #     window of time.
        class BackupRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `StandardSchedule` defines a schedule that run within the confines of a
        # defined window of days. We can define recurrence type for schedule as
        # HOURLY, DAILY, WEEKLY, MONTHLY or YEARLY.
        # @!attribute [rw] recurrence_type
        #   @return [::Google::Cloud::BackupDR::V1::StandardSchedule::RecurrenceType]
        #     Required. Specifies the `RecurrenceType` for the schedule.
        # @!attribute [rw] hourly_frequency
        #   @return [::Integer]
        #     Optional. Specifies frequency for hourly backups. A hourly frequency of 2
        #     means jobs will run every 2 hours from start time till end time defined.
        #
        #     This is required for `recurrence_type`, `HOURLY` and is not applicable
        #     otherwise. A validation error will occur if a value is supplied and
        #     `recurrence_type` is not `HOURLY`.
        #
        #     Value of hourly frequency should be between 4 and 23.
        #
        #     Reason for limit : We found that there is bandwidth limitation of 3GB/S for
        #     GMI while taking a backup and 5GB/S while doing a restore. Given the amount
        #     of parallel backups and restore we are targeting, this will potentially
        #     take the backup time to mins and hours (in worst case scenario).
        # @!attribute [rw] days_of_week
        #   @return [::Array<::Google::Type::DayOfWeek>]
        #     Optional. Specifies days of week like, MONDAY or TUESDAY, on which jobs
        #     will run.
        #
        #     This is required for `recurrence_type`, `WEEKLY` and is not applicable
        #     otherwise. A validation error will occur if a value is supplied and
        #     `recurrence_type` is not `WEEKLY`.
        # @!attribute [rw] days_of_month
        #   @return [::Array<::Integer>]
        #     Optional. Specifies days of months like 1, 5, or 14 on which jobs will run.
        #
        #     Values for `days_of_month` are only applicable for `recurrence_type`,
        #     `MONTHLY` and `YEARLY`. A validation error will occur if other values are
        #     supplied.
        # @!attribute [rw] week_day_of_month
        #   @return [::Google::Cloud::BackupDR::V1::WeekDayOfMonth]
        #     Optional. Specifies a week day of the month like, FIRST SUNDAY or LAST
        #     MONDAY, on which jobs will run. This will be specified by two fields in
        #     `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
        #     e.g. `LAST`.
        #
        #     This field is only applicable for `recurrence_type`, `MONTHLY` and
        #     `YEARLY`. A validation error will occur if other values are supplied.
        # @!attribute [rw] months
        #   @return [::Array<::Google::Type::Month>]
        #     Optional. Specifies the months of year, like `FEBRUARY` and/or `MAY`, on
        #     which jobs will run.
        #
        #     This field is only applicable when `recurrence_type` is `YEARLY`. A
        #     validation error will occur if other values are supplied.
        # @!attribute [rw] backup_window
        #   @return [::Google::Cloud::BackupDR::V1::BackupWindow]
        #     Required. A BackupWindow defines the window of day during which backup jobs
        #     will run. Jobs are queued at the beginning of the window and will be marked
        #     as `NOT_RUN` if they do not start by the end of the window.
        #
        #     Note: running jobs will not be cancelled at the end of the window.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Required. The time zone to be used when interpreting the schedule.
        #     The value of this field must be a time zone name from the IANA tz database.
        #     See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
        #     list of valid timezone names. For e.g., Europe/Paris.
        class StandardSchedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # `RecurrenceTypes` enumerates the applicable periodicity for the schedule.
          module RecurrenceType
            # recurrence type not set
            RECURRENCE_TYPE_UNSPECIFIED = 0

            # The `BackupRule` is to be applied hourly.
            HOURLY = 1

            # The `BackupRule` is to be applied daily.
            DAILY = 2

            # The `BackupRule` is to be applied weekly.
            WEEKLY = 3

            # The `BackupRule` is to be applied monthly.
            MONTHLY = 4

            # The `BackupRule` is to be applied yearly.
            YEARLY = 5
          end
        end

        # `BackupWindow` defines a window of the day during which backup jobs will run.
        # @!attribute [rw] start_hour_of_day
        #   @return [::Integer]
        #     Required. The hour of day (0-23) when the window starts for e.g. if value
        #     of start hour of day is 6 that mean backup window start at 6:00.
        # @!attribute [rw] end_hour_of_day
        #   @return [::Integer]
        #     Required. The hour of day (1-24) when the window end for e.g. if value of
        #     end hour of day is 10 that mean backup window end time is 10:00.
        #
        #     End hour of day should be greater than start hour of day.
        #     0 <= start_hour_of_day < end_hour_of_day <= 24
        #
        #     End hour of day is not include in backup window that mean if
        #     end_hour_of_day= 10 jobs should start before 10:00.
        class BackupWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `WeekDayOfMonth` defines the week day of the month on which the backups will
        # run. The message combines a `WeekOfMonth` and `DayOfWeek` to produce values
        # like `FIRST`/`MONDAY` or `LAST`/`FRIDAY`.
        # @!attribute [rw] week_of_month
        #   @return [::Google::Cloud::BackupDR::V1::WeekDayOfMonth::WeekOfMonth]
        #     Required. Specifies the week of the month.
        # @!attribute [rw] day_of_week
        #   @return [::Google::Type::DayOfWeek]
        #     Required. Specifies the day of the week.
        class WeekDayOfMonth
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # `WeekOfMonth` enumerates possible weeks in the month, e.g. the first,
          # third, or last week of the month.
          module WeekOfMonth
            # The zero value. Do not use.
            WEEK_OF_MONTH_UNSPECIFIED = 0

            # The first week of the month.
            FIRST = 1

            # The second week of the month.
            SECOND = 2

            # The third week of the month.
            THIRD = 3

            # The fourth  week of the month.
            FOURTH = 4

            # The last  week of the month.
            LAST = 5
          end
        end

        # The request message for creating a `BackupPlan`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The `BackupPlan` project and location in the format
        #     `projects/{project}/locations/{location}`. In Cloud BackupDR locations
        #     map to GCP regions, for example **us-central1**.
        # @!attribute [rw] backup_plan_id
        #   @return [::String]
        #     Required. The name of the `BackupPlan` to create. The name must be unique
        #     for the specified project and location.The name must start with a lowercase
        #     letter followed by up to 62 lowercase letters, numbers, or hyphens.
        #     Pattern, /[a-z][a-z0-9-]\\{,62}/.
        # @!attribute [rw] backup_plan
        #   @return [::Google::Cloud::BackupDR::V1::BackupPlan]
        #     Required. The `BackupPlan` resource object to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for getting a list `BackupPlan`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve `BackupPlans`
        #     information. Format: `projects/{project}/locations/{location}`. In Cloud
        #     BackupDR, locations map to GCP regions, for e.g. **us-central1**. To
        #     retrieve backup plans for all locations, use "-" for the
        #     `{location}` value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `BackupPlans` to return in a single
        #     response. If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
        #     received from a previous `ListBackupPlans` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListBackupPlans` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Field match expression used to filter the results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field by which to sort the results.
        class ListBackupPlansRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for getting a list of `BackupPlan`.
        # @!attribute [rw] backup_plans
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupPlan>]
        #     The list of `BackupPlans` in the project for the specified
        #     location.
        #
        #     If the `{location}` value in the request is "-", the response contains a
        #     list of resources from all locations. In case any location is unreachable,
        #     the response will only return backup plans in reachable locations and
        #     the 'unreachable' field will be populated with a list of unreachable
        #     locations.
        #     BackupPlan
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::BackupDR::V1::ListBackupPlansRequest#page_token page_token} in
        #     a subsequent `ListBackupPlans` call to retrieve the next page of results.
        #     If this field is omitted or empty, then there are no more results to
        #     return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupPlansResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for getting a `BackupPlan`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the `BackupPlan` to retrieve.
        #
        #     Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
        class GetBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for deleting a `BackupPlan`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the `BackupPlan` to delete.
        #
        #     Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a backup plan.
        # @!attribute [rw] backup_plan
        #   @return [::Google::Cloud::BackupDR::V1::BackupPlan]
        #     Required. The resource being updated
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        #     Field mask is used to specify the fields to be overwritten in the
        #     BackupPlan resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then the request will fail.
        #     Currently, these fields are supported in update: description, schedules,
        #     retention period, adding and removing Backup Rules.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateBackupPlanRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `BackupPlanRevision` represents a snapshot of a `BackupPlan` at a point in
        # time.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the `BackupPlanRevision`.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision}`
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. The user friendly revision ID of the `BackupPlanRevision`.
        #
        #     Example: v0, v1, v2, etc.
        # @!attribute [r] state
        #   @return [::Google::Cloud::BackupDR::V1::BackupPlanRevision::State]
        #     Output only. Resource State
        # @!attribute [rw] backup_plan_snapshot
        #   @return [::Google::Cloud::BackupDR::V1::BackupPlan]
        #     The Backup Plan being encompassed by this revision.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp that the revision was created.
        class BackupPlanRevision
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The state of the `BackupPlanRevision`.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The resource is being created.
            CREATING = 1

            # The resource has been created and is fully usable.
            ACTIVE = 2

            # The resource is being deleted.
            DELETING = 3

            # The resource has been created but is not usable.
            INACTIVE = 4
          end
        end

        # The request message for getting a `BackupPlanRevision`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the `BackupPlanRevision` to retrieve.
        #
        #     Format:
        #     `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision}`
        class GetBackupPlanRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for getting a list of `BackupPlanRevision`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve
        #     `BackupPlanRevisions` information. Format:
        #     `projects/{project}/locations/{location}/backupPlans/{backup_plan}`. In
        #     Cloud BackupDR, locations map to GCP regions, for e.g. **us-central1**.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `BackupPlans` to return in a single
        #     response. If not specified, a default value will be chosen by the service.
        #     Note that the response may include a partial list and a caller should
        #     only rely on the response's
        #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
        #     to determine if there are more instances left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The value of
        #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
        #     received from a previous `ListBackupPlans` call.
        #     Provide this to retrieve the subsequent page in a multi-page list of
        #     results. When paginating, all other parameters provided to
        #     `ListBackupPlans` must match the call that provided the page token.
        class ListBackupPlanRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for getting a list of `BackupPlanRevision`.
        # @!attribute [rw] backup_plan_revisions
        #   @return [::Array<::Google::Cloud::BackupDR::V1::BackupPlanRevision>]
        #     The list of `BackupPlanRevisions` in the project for the specified
        #     location.
        #
        #     If the `{location}` value in the request is "-", the response contains a
        #     list of resources from all locations. In case any location is unreachable,
        #     the response will only return backup plans in reachable locations and
        #     the 'unreachable' field will be populated with a list of unreachable
        #     locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which may be sent as
        #     {::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest#page_token page_token}
        #     in a subsequent `ListBackupPlanRevisions` call to retrieve the next page of
        #     results. If this field is omitted or empty, then there are no more results
        #     to return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupPlanRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
