# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module BackupDR
      module V1
        module BackupDR
          # Path helper methods for the BackupDR API.
          module Paths
            ##
            # Create a fully-qualified Backup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}/backups/{backup}`
            #
            # @param project [String]
            # @param location [String]
            # @param backupvault [String]
            # @param datasource [String]
            # @param backup [String]
            #
            # @return [::String]
            def backup_path project:, location:, backupvault:, datasource:, backup:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "backupvault cannot contain /" if backupvault.to_s.include? "/"
              raise ::ArgumentError, "datasource cannot contain /" if datasource.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupVaults/#{backupvault}/dataSources/#{datasource}/backups/#{backup}"
            end

            ##
            # Create a fully-qualified BackupPlan resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_plan [String]
            #
            # @return [::String]
            def backup_plan_path project:, location:, backup_plan:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupPlans/#{backup_plan}"
            end

            ##
            # Create a fully-qualified BackupPlanAssociation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupPlanAssociations/{backup_plan_association}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_plan_association [String]
            #
            # @return [::String]
            def backup_plan_association_path project:, location:, backup_plan_association:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupPlanAssociations/#{backup_plan_association}"
            end

            ##
            # Create a fully-qualified BackupPlanRevision resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_plan [String]
            # @param revision [String]
            #
            # @return [::String]
            def backup_plan_revision_path project:, location:, backup_plan:, revision:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "backup_plan cannot contain /" if backup_plan.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupPlans/#{backup_plan}/revisions/#{revision}"
            end

            ##
            # Create a fully-qualified BackupVault resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupVaults/{backupvault}`
            #
            # @param project [String]
            # @param location [String]
            # @param backupvault [String]
            #
            # @return [::String]
            def backup_vault_path project:, location:, backupvault:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupVaults/#{backupvault}"
            end

            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{ring}/cryptoKeys/{key}`
            #
            # @param project [String]
            # @param location [String]
            # @param ring [String]
            # @param key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, ring:, key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "ring cannot contain /" if ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{ring}/cryptoKeys/#{key}"
            end

            ##
            # Create a fully-qualified CryptoKeyVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            # @param crypto_key_version [String]
            #
            # @return [::String]
            def crypto_key_version_path project:, location:, key_ring:, crypto_key:, crypto_key_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"
              raise ::ArgumentError, "crypto_key cannot contain /" if crypto_key.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}/cryptoKeyVersions/#{crypto_key_version}"
            end

            ##
            # Create a fully-qualified DataSource resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}`
            #
            # @param project [String]
            # @param location [String]
            # @param backupvault [String]
            # @param datasource [String]
            #
            # @return [::String]
            def data_source_path project:, location:, backupvault:, datasource:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "backupvault cannot contain /" if backupvault.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupVaults/#{backupvault}/dataSources/#{datasource}"
            end

            ##
            # Create a fully-qualified DataSourceReference resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/dataSourceReferences/{data_source_reference}`
            #
            # @param project [String]
            # @param location [String]
            # @param data_source_reference [String]
            #
            # @return [::String]
            def data_source_reference_path project:, location:, data_source_reference:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/dataSourceReferences/#{data_source_reference}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}`
            #
            # @param project [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified ManagementServer resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/managementServers/{managementserver}`
            #
            # @param project [String]
            # @param location [String]
            # @param managementserver [String]
            #
            # @return [::String]
            def management_server_path project:, location:, managementserver:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/managementServers/#{managementserver}"
            end

            ##
            # Create a fully-qualified StoragePool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/zones/{zone}/storagePools/{storage_pool}`
            #
            # @param project [String]
            # @param zone [String]
            # @param storage_pool [String]
            #
            # @return [::String]
            def storage_pool_path project:, zone:, storage_pool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/zones/#{zone}/storagePools/#{storage_pool}"
            end

            extend self
          end
        end
      end
    end
  end
end
