# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/backupdr/v1/backupdr_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module BackupDR
      module V1
        module BackupDR
          ##
          # Client for the BackupDR service.
          #
          # The BackupDR Service
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "backupdr.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :backup_dr_stub

            ##
            # Configure the BackupDR Client class.
            #
            # See {::Google::Cloud::BackupDR::V1::BackupDR::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all BackupDR clients
            #   ::Google::Cloud::BackupDR::V1::BackupDR::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "BackupDR", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_management_servers.timeout = 60.0
                default_config.rpcs.list_management_servers.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_management_server.timeout = 60.0
                default_config.rpcs.get_management_server.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_management_server.timeout = 60.0

                default_config.rpcs.delete_management_server.timeout = 60.0

                default_config.rpcs.create_backup_vault.timeout = 60.0
                default_config.rpcs.create_backup_vault.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_backup_vaults.timeout = 60.0
                default_config.rpcs.list_backup_vaults.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_usable_backup_vaults.timeout = 60.0
                default_config.rpcs.fetch_usable_backup_vaults.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup_vault.timeout = 60.0
                default_config.rpcs.get_backup_vault.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_backup_vault.timeout = 60.0

                default_config.rpcs.delete_backup_vault.timeout = 60.0
                default_config.rpcs.delete_backup_vault.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_data_sources.timeout = 60.0
                default_config.rpcs.list_data_sources.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_data_source.timeout = 60.0
                default_config.rpcs.get_data_source.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_data_source.timeout = 60.0

                default_config.rpcs.list_backups.timeout = 60.0
                default_config.rpcs.list_backups.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup.timeout = 60.0
                default_config.rpcs.get_backup.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_backup.timeout = 60.0

                default_config.rpcs.restore_backup.timeout = 60.0

                default_config.rpcs.initialize_service.timeout = 60.0
                default_config.rpcs.initialize_service.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the BackupDR Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::BackupDR::V1::BackupDR::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @backup_dr_stub.universe_domain
            end

            ##
            # Create a new BackupDR client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the BackupDR client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/backupdr/v1/backupdr_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @backup_dr_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::BackupDR::V1::BackupDR::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @backup_dr_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @backup_dr_stub.endpoint
                config.universe_domain = @backup_dr_stub.universe_domain
                config.logger = @backup_dr_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @backup_dr_stub.endpoint
                config.universe_domain = @backup_dr_stub.universe_domain
                config.logger = @backup_dr_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::BackupDR::V1::BackupDR::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @backup_dr_stub.logger
            end

            # Service calls

            ##
            # Lists ManagementServers in a given project and location.
            #
            # @overload list_management_servers(request, options = nil)
            #   Pass arguments to `list_management_servers` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListManagementServersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListManagementServersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_management_servers(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_management_servers` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve management servers
            #     information, in the format 'projects/\\{project_id}/locations/\\{location}'. In
            #     Cloud BackupDR, locations map to Google Cloud regions, for example
            #     **us-central1**. To retrieve management servers for all locations, use "-"
            #     for the
            #     '\\{location}' value.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::ManagementServer>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::ManagementServer>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListManagementServersRequest.new
            #
            #   # Call the list_management_servers method.
            #   result = client.list_management_servers request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::ManagementServer.
            #     p item
            #   end
            #
            def list_management_servers request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListManagementServersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_management_servers.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_management_servers.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_management_servers.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_management_servers, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_management_servers, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ManagementServer.
            #
            # @overload get_management_server(request, options = nil)
            #   Pass arguments to `get_management_server` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetManagementServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetManagementServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_management_server(name: nil)
            #   Pass arguments to `get_management_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the management server resource name, in the format
            #     'projects/\\{project_id}/locations/\\{location}/managementServers/\\{resource_name}'
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::ManagementServer]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::ManagementServer]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetManagementServerRequest.new
            #
            #   # Call the get_management_server method.
            #   result = client.get_management_server request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::ManagementServer.
            #   p result
            #
            def get_management_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetManagementServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_management_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_management_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_management_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_management_server, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ManagementServer in a given project and location.
            #
            # @overload create_management_server(request, options = nil)
            #   Pass arguments to `create_management_server` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::CreateManagementServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::CreateManagementServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_management_server(parent: nil, management_server_id: nil, management_server: nil, request_id: nil)
            #   Pass arguments to `create_management_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The management server project and location in the format
            #     'projects/\\{project_id}/locations/\\{location}'. In Cloud Backup and DR
            #     locations map to Google Cloud regions, for example **us-central1**.
            #   @param management_server_id [::String]
            #     Required. The name of the management server to create. The name must be
            #     unique for the specified project and location.
            #   @param management_server [::Google::Cloud::BackupDR::V1::ManagementServer, ::Hash]
            #     Required. A [management server
            #     resource][google.cloud.backupdr.v1.ManagementServer]
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::CreateManagementServerRequest.new
            #
            #   # Call the create_management_server method.
            #   result = client.create_management_server request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_management_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::CreateManagementServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_management_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_management_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_management_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :create_management_server, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ManagementServer.
            #
            # @overload delete_management_server(request, options = nil)
            #   Pass arguments to `delete_management_server` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_management_server(name: nil, request_id: nil)
            #   Pass arguments to `delete_management_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::DeleteManagementServerRequest.new
            #
            #   # Call the delete_management_server method.
            #   result = client.delete_management_server request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_management_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::DeleteManagementServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_management_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_management_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_management_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :delete_management_server, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new BackupVault in a given project and location.
            #
            # @overload create_backup_vault(request, options = nil)
            #   Pass arguments to `create_backup_vault` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup_vault(parent: nil, backup_vault_id: nil, backup_vault: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `create_backup_vault` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param backup_vault_id [::String]
            #     Required. ID of the requesting object
            #     If auto-generating ID server-side, remove this field and
            #     backup_vault_id from the method_signature of Create RPC
            #   @param backup_vault [::Google::Cloud::BackupDR::V1::BackupVault, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is 'false'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::CreateBackupVaultRequest.new
            #
            #   # Call the create_backup_vault method.
            #   result = client.create_backup_vault request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup_vault request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::CreateBackupVaultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup_vault.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup_vault.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup_vault.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :create_backup_vault, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupVaults in a given project and location.
            #
            # @overload list_backup_vaults(request, options = nil)
            #   Pass arguments to `list_backup_vaults` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_vaults(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
            #   Pass arguments to `list_backup_vaults` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve backupvault stores
            #     information, in the format 'projects/\\{project_id}/locations/\\{location}'. In
            #     Cloud Backup and DR, locations map to Google Cloud regions, for example
            #     **us-central1**.
            #     To retrieve backupvault stores for all locations, use "-" for the
            #     '\\{location}' value.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #   @param view [::Google::Cloud::BackupDR::V1::BackupVaultView]
            #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
            #     Vault.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupVault>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupVault>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListBackupVaultsRequest.new
            #
            #   # Call the list_backup_vaults method.
            #   result = client.list_backup_vaults request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::BackupVault.
            #     p item
            #   end
            #
            def list_backup_vaults request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListBackupVaultsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_vaults.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_vaults.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_vaults.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_backup_vaults, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_backup_vaults, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # FetchUsableBackupVaults lists usable BackupVaults in a given project and
            # location. Usable BackupVault are the ones that user has
            # backupdr.backupVaults.get permission.
            #
            # @overload fetch_usable_backup_vaults(request, options = nil)
            #   Pass arguments to `fetch_usable_backup_vaults` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_usable_backup_vaults(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `fetch_usable_backup_vaults` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve backupvault stores
            #     information, in the format 'projects/\\{project_id}/locations/\\{location}'. In
            #     Cloud Backup and DR, locations map to Google Cloud regions, for example
            #     **us-central1**.
            #     To retrieve backupvault stores for all locations, use "-" for the
            #     '\\{location}' value.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupVault>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupVault>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest.new
            #
            #   # Call the fetch_usable_backup_vaults method.
            #   result = client.fetch_usable_backup_vaults request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::BackupVault.
            #     p item
            #   end
            #
            def fetch_usable_backup_vaults request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::FetchUsableBackupVaultsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_usable_backup_vaults.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_usable_backup_vaults.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_usable_backup_vaults.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :fetch_usable_backup_vaults, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :fetch_usable_backup_vaults, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a BackupVault.
            #
            # @overload get_backup_vault(request, options = nil)
            #   Pass arguments to `get_backup_vault` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetBackupVaultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetBackupVaultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_vault(name: nil, view: nil)
            #   Pass arguments to `get_backup_vault` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the backupvault store resource name, in the format
            #     'projects/\\{project_id}/locations/\\{location}/backupVaults/\\{resource_name}'
            #   @param view [::Google::Cloud::BackupDR::V1::BackupVaultView]
            #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
            #     Vault
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::BackupVault]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::BackupVault]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetBackupVaultRequest.new
            #
            #   # Call the get_backup_vault method.
            #   result = client.get_backup_vault request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::BackupVault.
            #   p result
            #
            def get_backup_vault request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetBackupVaultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_vault.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_vault.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_vault.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_backup_vault, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a BackupVault.
            #
            # @overload update_backup_vault(request, options = nil)
            #   Pass arguments to `update_backup_vault` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup_vault(update_mask: nil, backup_vault: nil, request_id: nil, validate_only: nil, force: nil, force_update_access_restriction: nil)
            #   Pass arguments to `update_backup_vault` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     BackupVault resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then the request will fail.
            #   @param backup_vault [::Google::Cloud::BackupDR::V1::BackupVault, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is 'false'.
            #   @param force [::Boolean]
            #     Optional. If set to true, will not check plan duration against backup vault
            #     enforcement duration.
            #   @param force_update_access_restriction [::Boolean]
            #     Optional. If set to true, we will force update access restriction even if
            #     some non compliant data sources are present. The default is 'false'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest.new
            #
            #   # Call the update_backup_vault method.
            #   result = client.update_backup_vault request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup_vault request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::UpdateBackupVaultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup_vault.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup_vault&.name
                header_params["backup_vault.name"] = request.backup_vault.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup_vault.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup_vault.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :update_backup_vault, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a BackupVault.
            #
            # @overload delete_backup_vault(request, options = nil)
            #   Pass arguments to `delete_backup_vault` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup_vault(name: nil, request_id: nil, force: nil, etag: nil, validate_only: nil, allow_missing: nil, ignore_backup_plan_references: nil)
            #   Pass arguments to `delete_backup_vault` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, any data source from this backup vault will also
            #     be deleted.
            #   @param etag [::String]
            #     The current etag of the backup vault.
            #     If an etag is provided and does not match the current etag of the
            #     connection, deletion will be blocked.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is 'false'.
            #   @param allow_missing [::Boolean]
            #     Optional. If true and the BackupVault is not found, the request will
            #     succeed but no action will be taken.
            #   @param ignore_backup_plan_references [::Boolean]
            #     Optional. If set to true, backupvault deletion will proceed even if there
            #     are backup plans referencing the backupvault. The default is 'false'.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest.new
            #
            #   # Call the delete_backup_vault method.
            #   result = client.delete_backup_vault request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup_vault request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::DeleteBackupVaultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup_vault.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup_vault.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup_vault.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :delete_backup_vault, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DataSources in a given project and location.
            #
            # @overload list_data_sources(request, options = nil)
            #   Pass arguments to `list_data_sources` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListDataSourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListDataSourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_sources(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_data_sources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve data
            #     sources information, in the format
            #     'projects/\\{project_id}/locations/\\{location}'. In Cloud Backup and DR,
            #     locations map to Google Cloud regions, for example **us-central1**.
            #     To retrieve data sources for all locations, use "-" for the
            #     '\\{location}' value.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::DataSource>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::DataSource>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListDataSourcesRequest.new
            #
            #   # Call the list_data_sources method.
            #   result = client.list_data_sources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::DataSource.
            #     p item
            #   end
            #
            def list_data_sources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListDataSourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_sources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_sources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_sources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_data_sources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_data_sources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a DataSource.
            #
            # @overload get_data_source(request, options = nil)
            #   Pass arguments to `get_data_source` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetDataSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetDataSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_source(name: nil)
            #   Pass arguments to `get_data_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the data source resource name, in the format
            #     'projects/\\{project_id}/locations/\\{location}/backupVaults/\\{resource_name}/dataSource/\\{resource_name}'
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::DataSource]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::DataSource]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetDataSourceRequest.new
            #
            #   # Call the get_data_source method.
            #   result = client.get_data_source request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::DataSource.
            #   p result
            #
            def get_data_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetDataSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_data_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a DataSource.
            #
            # @overload update_data_source(request, options = nil)
            #   Pass arguments to `update_data_source` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_source(update_mask: nil, data_source: nil, request_id: nil, allow_missing: nil)
            #   Pass arguments to `update_data_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     DataSource resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then the request will fail.
            #   @param data_source [::Google::Cloud::BackupDR::V1::DataSource, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param allow_missing [::Boolean]
            #     Optional. Enable upsert.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::UpdateDataSourceRequest.new
            #
            #   # Call the update_data_source method.
            #   result = client.update_data_source request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_data_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::UpdateDataSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_source&.name
                header_params["data_source.name"] = request.data_source.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :update_data_source, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Backups in a given project and location.
            #
            # @overload list_backups(request, options = nil)
            #   Pass arguments to `list_backups` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListBackupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListBackupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
            #   Pass arguments to `list_backups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve backup
            #     information, in the format
            #     'projects/\\{project_id}/locations/\\{location}'. In Cloud Backup and DR,
            #     locations map to Google Cloud regions, for example **us-central1**.
            #     To retrieve data sources for all locations, use "-" for the
            #     '\\{location}' value.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #   @param view [::Google::Cloud::BackupDR::V1::BackupView]
            #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
            #     resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::Backup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::Backup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListBackupsRequest.new
            #
            #   # Call the list_backups method.
            #   result = client.list_backups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::Backup.
            #     p item
            #   end
            #
            def list_backups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListBackupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_backups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_backups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch Backups for a given resource type.
            #
            # @overload fetch_backups_for_resource_type(request, options = nil)
            #   Pass arguments to `fetch_backups_for_resource_type` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_backups_for_resource_type(parent: nil, resource_type: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
            #   Pass arguments to `fetch_backups_for_resource_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Datasources are the parent resource for the backups.
            #     Format:
            #     projects/\\{project}/locations/\\{location}/backupVaults/\\{backupVaultId}/dataSources/\\{datasourceId}
            #   @param resource_type [::String]
            #     Required. The type of the GCP resource.
            #     Ex: sqladmin.googleapis.com/Instance
            #   @param page_size [::Integer]
            #     Optional. The maximum number of Backups to return. The service may
            #     return fewer than this value. If unspecified, at most 50
            #     Backups will be returned. The maximum value is 100; values
            #     above 100 will be coerced to 100.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous call of
            #     `FetchBackupsForResourceType`.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `FetchBackupsForResourceType` must match
            #     the call that provided the page token.
            #   @param filter [::String]
            #     Optional. A filter expression that filters the results fetched in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. Supported
            #     fields:
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields to order by, sorted in ascending
            #     order. Use "desc" after a field name for descending.
            #   @param view [::Google::Cloud::BackupDR::V1::BackupView]
            #     Optional. This parameter is used to specify the view of the backup.
            #     If not specified, the default view is BASIC.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::Backup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::Backup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest.new
            #
            #   # Call the fetch_backups_for_resource_type method.
            #   result = client.fetch_backups_for_resource_type request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::Backup.
            #     p item
            #   end
            #
            def fetch_backups_for_resource_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::FetchBackupsForResourceTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_backups_for_resource_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_backups_for_resource_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_backups_for_resource_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :fetch_backups_for_resource_type, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :fetch_backups_for_resource_type, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a Backup.
            #
            # @overload get_backup(request, options = nil)
            #   Pass arguments to `get_backup` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup(name: nil, view: nil)
            #   Pass arguments to `get_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the data source resource name, in the format
            #     'projects/\\{project_id}/locations/\\{location}/backupVaults/\\{backupVault}/dataSources/\\{datasource}/backups/\\{backup}'
            #   @param view [::Google::Cloud::BackupDR::V1::BackupView]
            #     Optional. Reserved for future use to provide a BASIC & FULL view of Backup
            #     resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::Backup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::Backup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetBackupRequest.new
            #
            #   # Call the get_backup method.
            #   result = client.get_backup request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::Backup.
            #   p result
            #
            def get_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_backup, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a Backup.
            #
            # @overload update_backup(request, options = nil)
            #   Pass arguments to `update_backup` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::UpdateBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::UpdateBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup(update_mask: nil, backup: nil, request_id: nil)
            #   Pass arguments to `update_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Backup resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then the request will fail.
            #   @param backup [::Google::Cloud::BackupDR::V1::Backup, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::UpdateBackupRequest.new
            #
            #   # Call the update_backup method.
            #   result = client.update_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::UpdateBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup&.name
                header_params["backup.name"] = request.backup.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :update_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Backup.
            #
            # @overload delete_backup(request, options = nil)
            #   Pass arguments to `delete_backup` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::DeleteBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::DeleteBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup(name: nil, request_id: nil)
            #   Pass arguments to `delete_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::DeleteBackupRequest.new
            #
            #   # Call the delete_backup method.
            #   result = client.delete_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::DeleteBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :delete_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Restore from a Backup
            #
            # @overload restore_backup(request, options = nil)
            #   Pass arguments to `restore_backup` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::RestoreBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::RestoreBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload restore_backup(name: nil, request_id: nil, compute_instance_target_environment: nil, disk_target_environment: nil, region_disk_target_environment: nil, compute_instance_restore_properties: nil, disk_restore_properties: nil, clear_overrides_field_mask: nil)
            #   Pass arguments to `restore_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Backup instance, in the format
            #     'projects/*/locations/*/backupVaults/*/dataSources/*/backups/'.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param compute_instance_target_environment [::Google::Cloud::BackupDR::V1::ComputeInstanceTargetEnvironment, ::Hash]
            #     Compute Engine target environment to be used during restore.
            #
            #     Note: The following parameters are mutually exclusive: `compute_instance_target_environment`, `disk_target_environment`, `region_disk_target_environment`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param disk_target_environment [::Google::Cloud::BackupDR::V1::DiskTargetEnvironment, ::Hash]
            #     Disk target environment to be used during restore.
            #
            #     Note: The following parameters are mutually exclusive: `disk_target_environment`, `compute_instance_target_environment`, `region_disk_target_environment`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param region_disk_target_environment [::Google::Cloud::BackupDR::V1::RegionDiskTargetEnvironment, ::Hash]
            #     Region disk target environment to be used during restore.
            #
            #     Note: The following parameters are mutually exclusive: `region_disk_target_environment`, `compute_instance_target_environment`, `disk_target_environment`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param compute_instance_restore_properties [::Google::Cloud::BackupDR::V1::ComputeInstanceRestoreProperties, ::Hash]
            #     Compute Engine instance properties to be overridden during restore.
            #
            #     Note: The following parameters are mutually exclusive: `compute_instance_restore_properties`, `disk_restore_properties`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param disk_restore_properties [::Google::Cloud::BackupDR::V1::DiskRestoreProperties, ::Hash]
            #     Disk properties to be overridden during restore.
            #
            #     Note: The following parameters are mutually exclusive: `disk_restore_properties`, `compute_instance_restore_properties`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param clear_overrides_field_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. A field mask used to clear server-side default values
            #     for fields within the `instance_properties` oneof.
            #
            #     When a field in this mask is cleared, the server will not apply its
            #     default logic (like inheriting a value from the source) for that field.
            #
            #     The most common current use case is clearing default encryption keys.
            #
            #     Examples of field mask paths:
            #     - Compute Instance Disks:
            #     `compute_instance_restore_properties.disks.*.disk_encryption_key`
            #     - Single Disk: `disk_restore_properties.disk_encryption_key`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::RestoreBackupRequest.new
            #
            #   # Call the restore_backup method.
            #   result = client.restore_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def restore_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::RestoreBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.restore_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.restore_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.restore_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :restore_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a BackupPlan
            #
            # @overload create_backup_plan(request, options = nil)
            #   Pass arguments to `create_backup_plan` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup_plan(parent: nil, backup_plan_id: nil, backup_plan: nil, request_id: nil)
            #   Pass arguments to `create_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The `BackupPlan` project and location in the format
            #     `projects/{project}/locations/{location}`. In Cloud BackupDR locations
            #     map to GCP regions, for example **us-central1**.
            #   @param backup_plan_id [::String]
            #     Required. The name of the `BackupPlan` to create. The name must be unique
            #     for the specified project and location.The name must start with a lowercase
            #     letter followed by up to 62 lowercase letters, numbers, or hyphens.
            #     Pattern, /[a-z][a-z0-9-]\\{,62}/.
            #   @param backup_plan [::Google::Cloud::BackupDR::V1::BackupPlan, ::Hash]
            #     Required. The `BackupPlan` resource object to create.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and t
            #     he request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::CreateBackupPlanRequest.new
            #
            #   # Call the create_backup_plan method.
            #   result = client.create_backup_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::CreateBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :create_backup_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a BackupPlan.
            #
            # @overload update_backup_plan(request, options = nil)
            #   Pass arguments to `update_backup_plan` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup_plan(backup_plan: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup_plan [::Google::Cloud::BackupDR::V1::BackupPlan, ::Hash]
            #     Required. The resource being updated
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The list of fields to update.
            #     Field mask is used to specify the fields to be overwritten in the
            #     BackupPlan resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then the request will fail.
            #     Currently, these fields are supported in update: description, schedules,
            #     retention period, adding and removing Backup Rules.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and t
            #     he request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest.new
            #
            #   # Call the update_backup_plan method.
            #   result = client.update_backup_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::UpdateBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup_plan&.name
                header_params["backup_plan.name"] = request.backup_plan.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :update_backup_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single BackupPlan.
            #
            # @overload get_backup_plan(request, options = nil)
            #   Pass arguments to `get_backup_plan` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_plan(name: nil)
            #   Pass arguments to `get_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the `BackupPlan` to retrieve.
            #
            #     Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::BackupPlan]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::BackupPlan]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetBackupPlanRequest.new
            #
            #   # Call the get_backup_plan method.
            #   result = client.get_backup_plan request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::BackupPlan.
            #   p result
            #
            def get_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_backup_plan, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupPlans in a given project and location.
            #
            # @overload list_backup_plans(request, options = nil)
            #   Pass arguments to `list_backup_plans` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListBackupPlansRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListBackupPlansRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_plans(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_backup_plans` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve `BackupPlans`
            #     information. Format: `projects/{project}/locations/{location}`. In Cloud
            #     BackupDR, locations map to GCP regions, for e.g. **us-central1**. To
            #     retrieve backup plans for all locations, use "-" for the
            #     `{location}` value.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of `BackupPlans` to return in a single
            #     response. If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
            #     received from a previous `ListBackupPlans` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListBackupPlans` must match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Field match expression used to filter the results.
            #   @param order_by [::String]
            #     Optional. Field by which to sort the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlan>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlan>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListBackupPlansRequest.new
            #
            #   # Call the list_backup_plans method.
            #   result = client.list_backup_plans request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::BackupPlan.
            #     p item
            #   end
            #
            def list_backup_plans request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListBackupPlansRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_plans.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_plans.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_plans.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_backup_plans, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_backup_plans, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single BackupPlan.
            #
            # @overload delete_backup_plan(request, options = nil)
            #   Pass arguments to `delete_backup_plan` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup_plan(name: nil, request_id: nil)
            #   Pass arguments to `delete_backup_plan` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the `BackupPlan` to delete.
            #
            #     Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest.new
            #
            #   # Call the delete_backup_plan method.
            #   result = client.delete_backup_plan request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup_plan request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::DeleteBackupPlanRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup_plan.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup_plan.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup_plan.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :delete_backup_plan, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single BackupPlanRevision.
            #
            # @overload get_backup_plan_revision(request, options = nil)
            #   Pass arguments to `get_backup_plan_revision` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_plan_revision(name: nil)
            #   Pass arguments to `get_backup_plan_revision` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the `BackupPlanRevision` to retrieve.
            #
            #     Format:
            #     `projects/{project}/locations/{location}/backupPlans/{backup_plan}/revisions/{revision}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::BackupPlanRevision]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::BackupPlanRevision]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest.new
            #
            #   # Call the get_backup_plan_revision method.
            #   result = client.get_backup_plan_revision request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::BackupPlanRevision.
            #   p result
            #
            def get_backup_plan_revision request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetBackupPlanRevisionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_plan_revision.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_plan_revision.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_plan_revision.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_backup_plan_revision, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupPlanRevisions in a given project and location.
            #
            # @overload list_backup_plan_revisions(request, options = nil)
            #   Pass arguments to `list_backup_plan_revisions` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_plan_revisions(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_backup_plan_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve
            #     `BackupPlanRevisions` information. Format:
            #     `projects/{project}/locations/{location}/backupPlans/{backup_plan}`. In
            #     Cloud BackupDR, locations map to GCP regions, for e.g. **us-central1**.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of `BackupPlans` to return in a single
            #     response. If not specified, a default value will be chosen by the service.
            #     Note that the response may include a partial list and a caller should
            #     only rely on the response's
            #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     Optional. The value of
            #     {::Google::Cloud::BackupDR::V1::ListBackupPlansResponse#next_page_token next_page_token}
            #     received from a previous `ListBackupPlans` call.
            #     Provide this to retrieve the subsequent page in a multi-page list of
            #     results. When paginating, all other parameters provided to
            #     `ListBackupPlans` must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlanRevision>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlanRevision>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest.new
            #
            #   # Call the list_backup_plan_revisions method.
            #   result = client.list_backup_plan_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::BackupPlanRevision.
            #     p item
            #   end
            #
            def list_backup_plan_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListBackupPlanRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_plan_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_plan_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_plan_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_backup_plan_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_backup_plan_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a BackupPlanAssociation
            #
            # @overload create_backup_plan_association(request, options = nil)
            #   Pass arguments to `create_backup_plan_association` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup_plan_association(parent: nil, backup_plan_association_id: nil, backup_plan_association: nil, request_id: nil)
            #   Pass arguments to `create_backup_plan_association` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The backup plan association project and location in the format
            #     `projects/{project_id}/locations/{location}`. In Cloud BackupDR locations
            #     map to GCP regions, for example **us-central1**.
            #   @param backup_plan_association_id [::String]
            #     Required. The name of the backup plan association to create. The name must
            #     be unique for the specified project and location.
            #   @param backup_plan_association [::Google::Cloud::BackupDR::V1::BackupPlanAssociation, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and t
            #     he request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest.new
            #
            #   # Call the create_backup_plan_association method.
            #   result = client.create_backup_plan_association request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup_plan_association request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::CreateBackupPlanAssociationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup_plan_association.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup_plan_association.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup_plan_association.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :create_backup_plan_association, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a BackupPlanAssociation.
            #
            # @overload update_backup_plan_association(request, options = nil)
            #   Pass arguments to `update_backup_plan_association` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup_plan_association(backup_plan_association: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_backup_plan_association` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup_plan_association [::Google::Cloud::BackupDR::V1::BackupPlanAssociation, ::Hash]
            #     Required. The resource being updated
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The list of fields to update.
            #     Field mask is used to specify the fields to be overwritten in the
            #     BackupPlanAssociation resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then the request will fail.
            #     Currently backup_plan_association.backup_plan is the only supported field.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and t
            #     he request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest.new
            #
            #   # Call the update_backup_plan_association method.
            #   result = client.update_backup_plan_association request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup_plan_association request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::UpdateBackupPlanAssociationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup_plan_association.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup_plan_association&.name
                header_params["backup_plan_association.name"] = request.backup_plan_association.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup_plan_association.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup_plan_association.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :update_backup_plan_association, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single BackupPlanAssociation.
            #
            # @overload get_backup_plan_association(request, options = nil)
            #   Pass arguments to `get_backup_plan_association` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup_plan_association(name: nil)
            #   Pass arguments to `get_backup_plan_association` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the backup plan association resource, in the format
            #     `projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::BackupPlanAssociation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::BackupPlanAssociation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest.new
            #
            #   # Call the get_backup_plan_association method.
            #   result = client.get_backup_plan_association request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::BackupPlanAssociation.
            #   p result
            #
            def get_backup_plan_association request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetBackupPlanAssociationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup_plan_association.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup_plan_association.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup_plan_association.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_backup_plan_association, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists BackupPlanAssociations in a given project and location.
            #
            # @overload list_backup_plan_associations(request, options = nil)
            #   Pass arguments to `list_backup_plan_associations` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backup_plan_associations(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_backup_plan_associations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve backup Plan
            #     Associations information, in the format
            #     `projects/{project_id}/locations/{location}`. In Cloud BackupDR, locations
            #     map to GCP regions, for example **us-central1**. To retrieve backup plan
            #     associations for all locations, use "-" for the
            #     `{location}` value.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlanAssociation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlanAssociation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest.new
            #
            #   # Call the list_backup_plan_associations method.
            #   result = client.list_backup_plan_associations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::BackupPlanAssociation.
            #     p item
            #   end
            #
            def list_backup_plan_associations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListBackupPlanAssociationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backup_plan_associations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backup_plan_associations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backup_plan_associations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_backup_plan_associations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_backup_plan_associations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List BackupPlanAssociations for a given resource type.
            #
            # @overload fetch_backup_plan_associations_for_resource_type(request, options = nil)
            #   Pass arguments to `fetch_backup_plan_associations_for_resource_type` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_backup_plan_associations_for_resource_type(parent: nil, resource_type: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `fetch_backup_plan_associations_for_resource_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #     Format: projects/\\{project}/locations/\\{location}
            #   @param resource_type [::String]
            #     Required. The type of the GCP resource.
            #     Ex: sql.googleapis.com/Instance
            #   @param page_size [::Integer]
            #     Optional. The maximum number of BackupPlanAssociations to return. The
            #     service may return fewer than this value. If unspecified, at most 50
            #     BackupPlanAssociations will be returned. The maximum value is 100; values
            #     above 100 will be coerced to 100.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous call of
            #     `FetchBackupPlanAssociationsForResourceType`.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `FetchBackupPlanAssociationsForResourceType` must match
            #     the call that provided the page token.
            #   @param filter [::String]
            #     Optional. A filter expression that filters the results fetched in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. Supported
            #     fields:
            #     * resource
            #     * backup_plan
            #     * state
            #     * data_source
            #     * cloud_sql_instance_backup_plan_association_properties.instance_create_time
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields to order by, sorted in ascending
            #     order. Use "desc" after a field name for descending.
            #
            #     Supported fields:
            #     * name
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlanAssociation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::BackupPlanAssociation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest.new
            #
            #   # Call the fetch_backup_plan_associations_for_resource_type method.
            #   result = client.fetch_backup_plan_associations_for_resource_type request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::BackupPlanAssociation.
            #     p item
            #   end
            #
            def fetch_backup_plan_associations_for_resource_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::FetchBackupPlanAssociationsForResourceTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_backup_plan_associations_for_resource_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_backup_plan_associations_for_resource_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_backup_plan_associations_for_resource_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :fetch_backup_plan_associations_for_resource_type, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :fetch_backup_plan_associations_for_resource_type, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single BackupPlanAssociation.
            #
            # @overload delete_backup_plan_association(request, options = nil)
            #   Pass arguments to `delete_backup_plan_association` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup_plan_association(name: nil, request_id: nil)
            #   Pass arguments to `delete_backup_plan_association` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the backup plan association resource, in the format
            #     `projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}`
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest.new
            #
            #   # Call the delete_backup_plan_association method.
            #   result = client.delete_backup_plan_association request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup_plan_association request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::DeleteBackupPlanAssociationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup_plan_association.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup_plan_association.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup_plan_association.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :delete_backup_plan_association, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Triggers a new Backup.
            #
            # @overload trigger_backup(request, options = nil)
            #   Pass arguments to `trigger_backup` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::TriggerBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::TriggerBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload trigger_backup(name: nil, rule_id: nil, request_id: nil)
            #   Pass arguments to `trigger_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the backup plan association resource, in the format
            #     `projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}`
            #   @param rule_id [::String]
            #     Required. backup rule_id for which a backup needs to be triggered.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::TriggerBackupRequest.new
            #
            #   # Call the trigger_backup method.
            #   result = client.trigger_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def trigger_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::TriggerBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.trigger_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.trigger_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.trigger_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :trigger_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single DataSourceReference.
            #
            # @overload get_data_source_reference(request, options = nil)
            #   Pass arguments to `get_data_source_reference` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_source_reference(name: nil)
            #   Pass arguments to `get_data_source_reference` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the DataSourceReference to retrieve.
            #     Format:
            #     projects/\\{project}/locations/\\{location}/dataSourceReferences/\\{data_source_reference}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BackupDR::V1::DataSourceReference]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BackupDR::V1::DataSourceReference]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest.new
            #
            #   # Call the get_data_source_reference method.
            #   result = client.get_data_source_reference request
            #
            #   # The returned object is of type Google::Cloud::BackupDR::V1::DataSourceReference.
            #   p result
            #
            def get_data_source_reference request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::GetDataSourceReferenceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_source_reference.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_source_reference.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_source_reference.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :get_data_source_reference, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DataSourceReferences for a given project and location.
            #
            # @overload list_data_source_references(request, options = nil)
            #   Pass arguments to `list_data_source_references` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_source_references(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_data_source_references` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #     Format: projects/\\{project}/locations/\\{location}
            #   @param page_size [::Integer]
            #     Optional. The maximum number of DataSourceReferences to return. The service
            #     may return fewer than this value. If unspecified, at most 50
            #     DataSourceReferences will be returned. The maximum value is 100; values
            #     above 100 will be coerced to 100.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `ListDataSourceReferences`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListDataSourceReferences` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     Optional. A filter expression that filters the results listed in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering.
            #
            #     The following field and operator combinations are supported:
            #
            #     * data_source_gcp_resource_info.gcp_resourcename with `=`, `!=`
            #     * data_source_gcp_resource_info.type with `=`, `!=`
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields to order by, sorted in ascending
            #     order. Use "desc" after a field name for descending.
            #
            #     Supported fields:
            #
            #     * data_source
            #     * data_source_gcp_resource_info.gcp_resourcename
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::DataSourceReference>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::DataSourceReference>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest.new
            #
            #   # Call the list_data_source_references method.
            #   result = client.list_data_source_references request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::DataSourceReference.
            #     p item
            #   end
            #
            def list_data_source_references request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::ListDataSourceReferencesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_source_references.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_source_references.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_source_references.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :list_data_source_references, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :list_data_source_references, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch DataSourceReferences for a given project, location and resource type.
            #
            # @overload fetch_data_source_references_for_resource_type(request, options = nil)
            #   Pass arguments to `fetch_data_source_references_for_resource_type` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_data_source_references_for_resource_type(parent: nil, resource_type: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `fetch_data_source_references_for_resource_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource name.
            #     Format: projects/\\{project}/locations/\\{location}
            #   @param resource_type [::String]
            #     Required. The type of the GCP resource.
            #     Ex: sql.googleapis.com/Instance
            #   @param page_size [::Integer]
            #     Optional. The maximum number of DataSourceReferences to return. The service
            #     may return fewer than this value. If unspecified, at most 50
            #     DataSourceReferences will be returned. The maximum value is 100; values
            #     above 100 will be coerced to 100.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous call of
            #     `FetchDataSourceReferencesForResourceType`.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `FetchDataSourceReferencesForResourceType` must match
            #     the call that provided the page token.
            #   @param filter [::String]
            #     Optional. A filter expression that filters the results fetched in the
            #     response. The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. Supported
            #     fields:
            #     * data_source
            #     * data_source_gcp_resource_info.gcp_resourcename
            #     * data_source_backup_config_state
            #     * data_source_backup_count
            #     * data_source_backup_config_info.last_backup_state
            #     * data_source_gcp_resource_info.gcp_resourcename
            #     * data_source_gcp_resource_info.type
            #     * data_source_gcp_resource_info.location
            #     * data_source_gcp_resource_info.cloud_sql_instance_properties.instance_create_time
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields to order by, sorted in ascending
            #     order. Use "desc" after a field name for descending.
            #
            #     Supported fields:
            #     * name
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::DataSourceReference>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BackupDR::V1::DataSourceReference>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest.new
            #
            #   # Call the fetch_data_source_references_for_resource_type method.
            #   result = client.fetch_data_source_references_for_resource_type request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BackupDR::V1::DataSourceReference.
            #     p item
            #   end
            #
            def fetch_data_source_references_for_resource_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::FetchDataSourceReferencesForResourceTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_data_source_references_for_resource_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_data_source_references_for_resource_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_data_source_references_for_resource_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :fetch_data_source_references_for_resource_type, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @backup_dr_stub, :fetch_data_source_references_for_resource_type, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Initializes the service related config for a project.
            #
            # @overload initialize_service(request, options = nil)
            #   Pass arguments to `initialize_service` via a request object, either of type
            #   {::Google::Cloud::BackupDR::V1::InitializeServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BackupDR::V1::InitializeServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload initialize_service(name: nil, resource_type: nil, request_id: nil, cloud_sql_instance_initialization_config: nil)
            #   Pass arguments to `initialize_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the serviceConfig used to initialize the
            #     service. Format:
            #     `projects/{project_id}/locations/{location}/serviceConfig`.
            #   @param resource_type [::String]
            #     Required. The resource type to which the default service config will be
            #     applied. Examples include, "compute.googleapis.com/Instance" and
            #     "storage.googleapis.com/Bucket".
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and t
            #     he request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param cloud_sql_instance_initialization_config [::Google::Cloud::BackupDR::V1::CloudSqlInstanceInitializationConfig, ::Hash]
            #     Optional. The configuration for initializing a Cloud SQL instance.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/backupdr/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BackupDR::V1::BackupDR::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BackupDR::V1::InitializeServiceRequest.new
            #
            #   # Call the initialize_service method.
            #   result = client.initialize_service request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def initialize_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BackupDR::V1::InitializeServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.initialize_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BackupDR::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.initialize_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.initialize_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @backup_dr_stub.call_rpc :initialize_service, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the BackupDR API.
            #
            # This class represents the configuration for BackupDR,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::BackupDR::V1::BackupDR::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_management_servers to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::BackupDR::V1::BackupDR::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_management_servers.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_management_servers.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::BackupDR::V1::BackupDR::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "backupdr.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the BackupDR API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_management_servers`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_management_servers
                ##
                # RPC-specific configuration for `get_management_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_management_server
                ##
                # RPC-specific configuration for `create_management_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_management_server
                ##
                # RPC-specific configuration for `delete_management_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_management_server
                ##
                # RPC-specific configuration for `create_backup_vault`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup_vault
                ##
                # RPC-specific configuration for `list_backup_vaults`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_vaults
                ##
                # RPC-specific configuration for `fetch_usable_backup_vaults`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_usable_backup_vaults
                ##
                # RPC-specific configuration for `get_backup_vault`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_vault
                ##
                # RPC-specific configuration for `update_backup_vault`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup_vault
                ##
                # RPC-specific configuration for `delete_backup_vault`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup_vault
                ##
                # RPC-specific configuration for `list_data_sources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_sources
                ##
                # RPC-specific configuration for `get_data_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_source
                ##
                # RPC-specific configuration for `update_data_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_source
                ##
                # RPC-specific configuration for `list_backups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backups
                ##
                # RPC-specific configuration for `fetch_backups_for_resource_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_backups_for_resource_type
                ##
                # RPC-specific configuration for `get_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup
                ##
                # RPC-specific configuration for `update_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup
                ##
                # RPC-specific configuration for `delete_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup
                ##
                # RPC-specific configuration for `restore_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :restore_backup
                ##
                # RPC-specific configuration for `create_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup_plan
                ##
                # RPC-specific configuration for `update_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup_plan
                ##
                # RPC-specific configuration for `get_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_plan
                ##
                # RPC-specific configuration for `list_backup_plans`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_plans
                ##
                # RPC-specific configuration for `delete_backup_plan`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup_plan
                ##
                # RPC-specific configuration for `get_backup_plan_revision`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_plan_revision
                ##
                # RPC-specific configuration for `list_backup_plan_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_plan_revisions
                ##
                # RPC-specific configuration for `create_backup_plan_association`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup_plan_association
                ##
                # RPC-specific configuration for `update_backup_plan_association`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup_plan_association
                ##
                # RPC-specific configuration for `get_backup_plan_association`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup_plan_association
                ##
                # RPC-specific configuration for `list_backup_plan_associations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backup_plan_associations
                ##
                # RPC-specific configuration for `fetch_backup_plan_associations_for_resource_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_backup_plan_associations_for_resource_type
                ##
                # RPC-specific configuration for `delete_backup_plan_association`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup_plan_association
                ##
                # RPC-specific configuration for `trigger_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :trigger_backup
                ##
                # RPC-specific configuration for `get_data_source_reference`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_source_reference
                ##
                # RPC-specific configuration for `list_data_source_references`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_source_references
                ##
                # RPC-specific configuration for `fetch_data_source_references_for_resource_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_data_source_references_for_resource_type
                ##
                # RPC-specific configuration for `initialize_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :initialize_service

                # @private
                def initialize parent_rpcs = nil
                  list_management_servers_config = parent_rpcs.list_management_servers if parent_rpcs.respond_to? :list_management_servers
                  @list_management_servers = ::Gapic::Config::Method.new list_management_servers_config
                  get_management_server_config = parent_rpcs.get_management_server if parent_rpcs.respond_to? :get_management_server
                  @get_management_server = ::Gapic::Config::Method.new get_management_server_config
                  create_management_server_config = parent_rpcs.create_management_server if parent_rpcs.respond_to? :create_management_server
                  @create_management_server = ::Gapic::Config::Method.new create_management_server_config
                  delete_management_server_config = parent_rpcs.delete_management_server if parent_rpcs.respond_to? :delete_management_server
                  @delete_management_server = ::Gapic::Config::Method.new delete_management_server_config
                  create_backup_vault_config = parent_rpcs.create_backup_vault if parent_rpcs.respond_to? :create_backup_vault
                  @create_backup_vault = ::Gapic::Config::Method.new create_backup_vault_config
                  list_backup_vaults_config = parent_rpcs.list_backup_vaults if parent_rpcs.respond_to? :list_backup_vaults
                  @list_backup_vaults = ::Gapic::Config::Method.new list_backup_vaults_config
                  fetch_usable_backup_vaults_config = parent_rpcs.fetch_usable_backup_vaults if parent_rpcs.respond_to? :fetch_usable_backup_vaults
                  @fetch_usable_backup_vaults = ::Gapic::Config::Method.new fetch_usable_backup_vaults_config
                  get_backup_vault_config = parent_rpcs.get_backup_vault if parent_rpcs.respond_to? :get_backup_vault
                  @get_backup_vault = ::Gapic::Config::Method.new get_backup_vault_config
                  update_backup_vault_config = parent_rpcs.update_backup_vault if parent_rpcs.respond_to? :update_backup_vault
                  @update_backup_vault = ::Gapic::Config::Method.new update_backup_vault_config
                  delete_backup_vault_config = parent_rpcs.delete_backup_vault if parent_rpcs.respond_to? :delete_backup_vault
                  @delete_backup_vault = ::Gapic::Config::Method.new delete_backup_vault_config
                  list_data_sources_config = parent_rpcs.list_data_sources if parent_rpcs.respond_to? :list_data_sources
                  @list_data_sources = ::Gapic::Config::Method.new list_data_sources_config
                  get_data_source_config = parent_rpcs.get_data_source if parent_rpcs.respond_to? :get_data_source
                  @get_data_source = ::Gapic::Config::Method.new get_data_source_config
                  update_data_source_config = parent_rpcs.update_data_source if parent_rpcs.respond_to? :update_data_source
                  @update_data_source = ::Gapic::Config::Method.new update_data_source_config
                  list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                  @list_backups = ::Gapic::Config::Method.new list_backups_config
                  fetch_backups_for_resource_type_config = parent_rpcs.fetch_backups_for_resource_type if parent_rpcs.respond_to? :fetch_backups_for_resource_type
                  @fetch_backups_for_resource_type = ::Gapic::Config::Method.new fetch_backups_for_resource_type_config
                  get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                  @get_backup = ::Gapic::Config::Method.new get_backup_config
                  update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                  @update_backup = ::Gapic::Config::Method.new update_backup_config
                  delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                  @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                  restore_backup_config = parent_rpcs.restore_backup if parent_rpcs.respond_to? :restore_backup
                  @restore_backup = ::Gapic::Config::Method.new restore_backup_config
                  create_backup_plan_config = parent_rpcs.create_backup_plan if parent_rpcs.respond_to? :create_backup_plan
                  @create_backup_plan = ::Gapic::Config::Method.new create_backup_plan_config
                  update_backup_plan_config = parent_rpcs.update_backup_plan if parent_rpcs.respond_to? :update_backup_plan
                  @update_backup_plan = ::Gapic::Config::Method.new update_backup_plan_config
                  get_backup_plan_config = parent_rpcs.get_backup_plan if parent_rpcs.respond_to? :get_backup_plan
                  @get_backup_plan = ::Gapic::Config::Method.new get_backup_plan_config
                  list_backup_plans_config = parent_rpcs.list_backup_plans if parent_rpcs.respond_to? :list_backup_plans
                  @list_backup_plans = ::Gapic::Config::Method.new list_backup_plans_config
                  delete_backup_plan_config = parent_rpcs.delete_backup_plan if parent_rpcs.respond_to? :delete_backup_plan
                  @delete_backup_plan = ::Gapic::Config::Method.new delete_backup_plan_config
                  get_backup_plan_revision_config = parent_rpcs.get_backup_plan_revision if parent_rpcs.respond_to? :get_backup_plan_revision
                  @get_backup_plan_revision = ::Gapic::Config::Method.new get_backup_plan_revision_config
                  list_backup_plan_revisions_config = parent_rpcs.list_backup_plan_revisions if parent_rpcs.respond_to? :list_backup_plan_revisions
                  @list_backup_plan_revisions = ::Gapic::Config::Method.new list_backup_plan_revisions_config
                  create_backup_plan_association_config = parent_rpcs.create_backup_plan_association if parent_rpcs.respond_to? :create_backup_plan_association
                  @create_backup_plan_association = ::Gapic::Config::Method.new create_backup_plan_association_config
                  update_backup_plan_association_config = parent_rpcs.update_backup_plan_association if parent_rpcs.respond_to? :update_backup_plan_association
                  @update_backup_plan_association = ::Gapic::Config::Method.new update_backup_plan_association_config
                  get_backup_plan_association_config = parent_rpcs.get_backup_plan_association if parent_rpcs.respond_to? :get_backup_plan_association
                  @get_backup_plan_association = ::Gapic::Config::Method.new get_backup_plan_association_config
                  list_backup_plan_associations_config = parent_rpcs.list_backup_plan_associations if parent_rpcs.respond_to? :list_backup_plan_associations
                  @list_backup_plan_associations = ::Gapic::Config::Method.new list_backup_plan_associations_config
                  fetch_backup_plan_associations_for_resource_type_config = parent_rpcs.fetch_backup_plan_associations_for_resource_type if parent_rpcs.respond_to? :fetch_backup_plan_associations_for_resource_type
                  @fetch_backup_plan_associations_for_resource_type = ::Gapic::Config::Method.new fetch_backup_plan_associations_for_resource_type_config
                  delete_backup_plan_association_config = parent_rpcs.delete_backup_plan_association if parent_rpcs.respond_to? :delete_backup_plan_association
                  @delete_backup_plan_association = ::Gapic::Config::Method.new delete_backup_plan_association_config
                  trigger_backup_config = parent_rpcs.trigger_backup if parent_rpcs.respond_to? :trigger_backup
                  @trigger_backup = ::Gapic::Config::Method.new trigger_backup_config
                  get_data_source_reference_config = parent_rpcs.get_data_source_reference if parent_rpcs.respond_to? :get_data_source_reference
                  @get_data_source_reference = ::Gapic::Config::Method.new get_data_source_reference_config
                  list_data_source_references_config = parent_rpcs.list_data_source_references if parent_rpcs.respond_to? :list_data_source_references
                  @list_data_source_references = ::Gapic::Config::Method.new list_data_source_references_config
                  fetch_data_source_references_for_resource_type_config = parent_rpcs.fetch_data_source_references_for_resource_type if parent_rpcs.respond_to? :fetch_data_source_references_for_resource_type
                  @fetch_data_source_references_for_resource_type = ::Gapic::Config::Method.new fetch_data_source_references_for_resource_type_config
                  initialize_service_config = parent_rpcs.initialize_service if parent_rpcs.respond_to? :initialize_service
                  @initialize_service = ::Gapic::Config::Method.new initialize_service_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
