# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AutoML
      module V1beta1
        # The data statistics of a series of values that share the same DataType.
        # @!attribute [rw] float64_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::Float64Stats]
        #     The statistics for FLOAT64 DataType.
        #
        #     Note: The following fields are mutually exclusive: `float64_stats`, `string_stats`, `timestamp_stats`, `array_stats`, `struct_stats`, `category_stats`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::StringStats]
        #     The statistics for STRING DataType.
        #
        #     Note: The following fields are mutually exclusive: `string_stats`, `float64_stats`, `timestamp_stats`, `array_stats`, `struct_stats`, `category_stats`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timestamp_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::TimestampStats]
        #     The statistics for TIMESTAMP DataType.
        #
        #     Note: The following fields are mutually exclusive: `timestamp_stats`, `float64_stats`, `string_stats`, `array_stats`, `struct_stats`, `category_stats`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] array_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::ArrayStats]
        #     The statistics for ARRAY DataType.
        #
        #     Note: The following fields are mutually exclusive: `array_stats`, `float64_stats`, `string_stats`, `timestamp_stats`, `struct_stats`, `category_stats`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] struct_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::StructStats]
        #     The statistics for STRUCT DataType.
        #
        #     Note: The following fields are mutually exclusive: `struct_stats`, `float64_stats`, `string_stats`, `timestamp_stats`, `array_stats`, `category_stats`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] category_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::CategoryStats]
        #     The statistics for CATEGORY DataType.
        #
        #     Note: The following fields are mutually exclusive: `category_stats`, `float64_stats`, `string_stats`, `timestamp_stats`, `array_stats`, `struct_stats`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] distinct_value_count
        #   @return [::Integer]
        #     The number of distinct values.
        # @!attribute [rw] null_value_count
        #   @return [::Integer]
        #     The number of values that are null.
        # @!attribute [rw] valid_value_count
        #   @return [::Integer]
        #     The number of values that are valid.
        class DataStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The data statistics of a series of FLOAT64 values.
        # @!attribute [rw] mean
        #   @return [::Float]
        #     The mean of the series.
        # @!attribute [rw] standard_deviation
        #   @return [::Float]
        #     The standard deviation of the series.
        # @!attribute [rw] quantiles
        #   @return [::Array<::Float>]
        #     Ordered from 0 to k k-quantile values of the data series of n values.
        #     The value at index i is, approximately, the i*n/k-th smallest value in the
        #     series; for i = 0 and i = k these are, respectively, the min and max
        #     values.
        # @!attribute [rw] histogram_buckets
        #   @return [::Array<::Google::Cloud::AutoML::V1beta1::Float64Stats::HistogramBucket>]
        #     Histogram buckets of the data series. Sorted by the min value of the
        #     bucket, ascendingly, and the number of the buckets is dynamically
        #     generated. The buckets are non-overlapping and completely cover whole
        #     FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
        #     the last one being `"Infinity"`.
        class Float64Stats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A bucket of a histogram.
          # @!attribute [rw] min
          #   @return [::Float]
          #     The minimum value of the bucket, inclusive.
          # @!attribute [rw] max
          #   @return [::Float]
          #     The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
          #     which case it's inclusive.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     The number of data values that are in the bucket, i.e. are between
          #     min and max values.
          class HistogramBucket
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The data statistics of a series of STRING values.
        # @!attribute [rw] top_unigram_stats
        #   @return [::Array<::Google::Cloud::AutoML::V1beta1::StringStats::UnigramStats>]
        #     The statistics of the top 20 unigrams, ordered by
        #     {::Google::Cloud::AutoML::V1beta1::StringStats::UnigramStats#count count}.
        class StringStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The statistics of a unigram.
          # @!attribute [rw] value
          #   @return [::String]
          #     The unigram.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     The number of occurrences of this unigram in the series.
          class UnigramStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The data statistics of a series of TIMESTAMP values.
        # @!attribute [rw] granular_stats
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AutoML::V1beta1::TimestampStats::GranularStats}]
        #     The string key is the pre-defined granularity. Currently supported:
        #     hour_of_day, day_of_week, month_of_year.
        #     Granularities finer that the granularity of timestamp data are not
        #     populated (e.g. if timestamps are at day granularity, then hour_of_day
        #     is not populated).
        class TimestampStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Stats split by a defined in context granularity.
          # @!attribute [rw] buckets
          #   @return [::Google::Protobuf::Map{::Integer => ::Integer}]
          #     A map from granularity key to example count for that key.
          #     E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
          class GranularStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::Integer]
            # @!attribute [rw] value
            #   @return [::Integer]
            class BucketsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AutoML::V1beta1::TimestampStats::GranularStats]
          class GranularStatsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The data statistics of a series of ARRAY values.
        # @!attribute [rw] member_stats
        #   @return [::Google::Cloud::AutoML::V1beta1::DataStats]
        #     Stats of all the values of all arrays, as if they were a single long
        #     series of data. The type depends on the element type of the array.
        class ArrayStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The data statistics of a series of STRUCT values.
        # @!attribute [rw] field_stats
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AutoML::V1beta1::DataStats}]
        #     Map from a field name of the struct to data stats aggregated over series
        #     of all data in that field across all the structs.
        class StructStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AutoML::V1beta1::DataStats]
          class FieldStatsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The data statistics of a series of CATEGORY values.
        # @!attribute [rw] top_category_stats
        #   @return [::Array<::Google::Cloud::AutoML::V1beta1::CategoryStats::SingleCategoryStats>]
        #     The statistics of the top 20 CATEGORY values, ordered by
        #
        #     {::Google::Cloud::AutoML::V1beta1::CategoryStats::SingleCategoryStats#count count}.
        class CategoryStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The statistics of a single CATEGORY value.
          # @!attribute [rw] value
          #   @return [::String]
          #     The CATEGORY value.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     The number of occurrences of this value in the series.
          class SingleCategoryStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A correlation statistics between two series of DataType values. The series
        # may have differing DataType-s, but within a single series the DataType must
        # be the same.
        # @!attribute [rw] cramers_v
        #   @return [::Float]
        #     The correlation value using the Cramer's V measure.
        class CorrelationStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
