# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/automl/v1beta1/version"

require "google/cloud/automl/v1beta1/automl/credentials"
require "google/cloud/automl/v1beta1/automl/paths"
require "google/cloud/automl/v1beta1/automl/rest/operations"
require "google/cloud/automl/v1beta1/automl/rest/client"

module Google
  module Cloud
    module AutoML
      module V1beta1
        ##
        # AutoML Server API.
        #
        # The resource names are assigned by the server.
        # The server never reuses names that it has created after the resources with
        # those names are deleted.
        #
        # An ID of a resource is the last element of the item's resource name. For
        # `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`, then
        # the id for the item is `{dataset_id}`.
        #
        # Currently the only supported `location_id` is "us-central1".
        #
        # On any input that is documented to expect a string parameter in
        # snake_case or kebab-case, either of those cases is accepted.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/automl/v1beta1/automl/rest"
        #     client = ::Google::Cloud::AutoML::V1beta1::AutoML::Rest::Client.new
        #
        module AutoML
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/automl/v1beta1/automl/rest/helpers" if ::File.file? helper_path
