# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/automl/v1/service_pb"
require "google/cloud/automl/v1/automl/rest"


class ::Google::Cloud::AutoML::V1::AutoML::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset = {}

    create_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_create_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dataset({ parent: parent, dataset: dataset }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dataset parent: parent, dataset: dataset do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dataset ::Google::Cloud::AutoML::V1::CreateDatasetRequest.new(parent: parent, dataset: dataset) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dataset({ parent: parent, dataset: dataset }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dataset(::Google::Cloud::AutoML::V1::CreateDatasetRequest.new(parent: parent, dataset: dataset), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dataset_client_stub.call_count
      end
    end
  end

  def test_get_dataset
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::Dataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_get_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dataset ::Google::Cloud::AutoML::V1::GetDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dataset(::Google::Cloud::AutoML::V1::GetDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dataset_client_stub.call_count
      end
    end
  end

  def test_list_datasets
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::ListDatasetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_datasets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_list_datasets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_datasets_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_datasets parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_datasets ::Google::Cloud::AutoML::V1::ListDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_datasets(::Google::Cloud::AutoML::V1::ListDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_datasets_client_stub.call_count
      end
    end
  end

  def test_update_dataset
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::Dataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dataset = {}
    update_mask = {}

    update_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_update_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dataset({ dataset: dataset, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dataset dataset: dataset, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dataset ::Google::Cloud::AutoML::V1::UpdateDatasetRequest.new(dataset: dataset, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dataset({ dataset: dataset, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dataset(::Google::Cloud::AutoML::V1::UpdateDatasetRequest.new(dataset: dataset, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dataset_client_stub.call_count
      end
    end
  end

  def test_delete_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_delete_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dataset ::Google::Cloud::AutoML::V1::DeleteDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dataset(::Google::Cloud::AutoML::V1::DeleteDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dataset_client_stub.call_count
      end
    end
  end

  def test_import_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    input_config = {}

    import_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_import_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_data_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_data({ name: name, input_config: input_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_data name: name, input_config: input_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_data ::Google::Cloud::AutoML::V1::ImportDataRequest.new(name: name, input_config: input_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_data({ name: name, input_config: input_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_data(::Google::Cloud::AutoML::V1::ImportDataRequest.new(name: name, input_config: input_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_data_client_stub.call_count
      end
    end
  end

  def test_export_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    output_config = {}

    export_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_export_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_data_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_data({ name: name, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_data name: name, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_data ::Google::Cloud::AutoML::V1::ExportDataRequest.new(name: name, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_data({ name: name, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_data(::Google::Cloud::AutoML::V1::ExportDataRequest.new(name: name, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_data_client_stub.call_count
      end
    end
  end

  def test_get_annotation_spec
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::AnnotationSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_annotation_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_get_annotation_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_annotation_spec_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_annotation_spec({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_annotation_spec name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_annotation_spec ::Google::Cloud::AutoML::V1::GetAnnotationSpecRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_annotation_spec({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_annotation_spec(::Google::Cloud::AutoML::V1::GetAnnotationSpecRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_annotation_spec_client_stub.call_count
      end
    end
  end

  def test_create_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model = {}

    create_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_create_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_model({ parent: parent, model: model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_model parent: parent, model: model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_model ::Google::Cloud::AutoML::V1::CreateModelRequest.new(parent: parent, model: model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_model({ parent: parent, model: model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_model(::Google::Cloud::AutoML::V1::CreateModelRequest.new(parent: parent, model: model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_model_client_stub.call_count
      end
    end
  end

  def test_get_model
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_get_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model ::Google::Cloud::AutoML::V1::GetModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model(::Google::Cloud::AutoML::V1::GetModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_client_stub.call_count
      end
    end
  end

  def test_list_models
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::ListModelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_models_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_list_models_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_models_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_models parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_models ::Google::Cloud::AutoML::V1::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_models(::Google::Cloud::AutoML::V1::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_models_client_stub.call_count
      end
    end
  end

  def test_delete_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_delete_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_model ::Google::Cloud::AutoML::V1::DeleteModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_model(::Google::Cloud::AutoML::V1::DeleteModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_model_client_stub.call_count
      end
    end
  end

  def test_update_model
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = {}
    update_mask = {}

    update_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_update_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_model({ model: model, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_model model: model, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_model ::Google::Cloud::AutoML::V1::UpdateModelRequest.new(model: model, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_model({ model: model, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_model(::Google::Cloud::AutoML::V1::UpdateModelRequest.new(model: model, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_model_client_stub.call_count
      end
    end
  end

  def test_deploy_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    image_object_detection_model_deployment_metadata = {}
    name = "hello world"

    deploy_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_deploy_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_model({ image_object_detection_model_deployment_metadata: image_object_detection_model_deployment_metadata, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_model image_object_detection_model_deployment_metadata: image_object_detection_model_deployment_metadata, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_model ::Google::Cloud::AutoML::V1::DeployModelRequest.new(image_object_detection_model_deployment_metadata: image_object_detection_model_deployment_metadata, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_model({ image_object_detection_model_deployment_metadata: image_object_detection_model_deployment_metadata, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_model(::Google::Cloud::AutoML::V1::DeployModelRequest.new(image_object_detection_model_deployment_metadata: image_object_detection_model_deployment_metadata, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_model_client_stub.call_count
      end
    end
  end

  def test_undeploy_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_undeploy_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undeploy_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undeploy_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undeploy_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undeploy_model ::Google::Cloud::AutoML::V1::UndeployModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undeploy_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undeploy_model(::Google::Cloud::AutoML::V1::UndeployModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undeploy_model_client_stub.call_count
      end
    end
  end

  def test_export_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    output_config = {}

    export_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_export_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_model_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_model({ name: name, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_model name: name, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_model ::Google::Cloud::AutoML::V1::ExportModelRequest.new(name: name, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_model({ name: name, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_model(::Google::Cloud::AutoML::V1::ExportModelRequest.new(name: name, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_model_client_stub.call_count
      end
    end
  end

  def test_get_model_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::ModelEvaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_get_model_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model_evaluation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model_evaluation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model_evaluation ::Google::Cloud::AutoML::V1::GetModelEvaluationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model_evaluation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model_evaluation(::Google::Cloud::AutoML::V1::GetModelEvaluationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_evaluation_client_stub.call_count
      end
    end
  end

  def test_list_model_evaluations
    # Create test objects.
    client_result = ::Google::Cloud::AutoML::V1::ListModelEvaluationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_model_evaluations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.stub :transcode_list_model_evaluations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_model_evaluations_client_stub do
        # Create client
        client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_model_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_model_evaluations parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_model_evaluations ::Google::Cloud::AutoML::V1::ListModelEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_model_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_model_evaluations(::Google::Cloud::AutoML::V1::ListModelEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_model_evaluations_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AutoML::V1::AutoML::Rest::Client::Configuration, config
  end
end
