# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AutoML
      module V1
        # A workspace for solving a single, particular machine learning (ML) problem.
        # A workspace contains examples that may be annotated.
        # @!attribute [rw] translation_dataset_metadata
        #   @return [::Google::Cloud::AutoML::V1::TranslationDatasetMetadata]
        #     Metadata for a dataset used for translation.
        #
        #     Note: The following fields are mutually exclusive: `translation_dataset_metadata`, `image_classification_dataset_metadata`, `text_classification_dataset_metadata`, `image_object_detection_dataset_metadata`, `text_extraction_dataset_metadata`, `text_sentiment_dataset_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_classification_dataset_metadata
        #   @return [::Google::Cloud::AutoML::V1::ImageClassificationDatasetMetadata]
        #     Metadata for a dataset used for image classification.
        #
        #     Note: The following fields are mutually exclusive: `image_classification_dataset_metadata`, `translation_dataset_metadata`, `text_classification_dataset_metadata`, `image_object_detection_dataset_metadata`, `text_extraction_dataset_metadata`, `text_sentiment_dataset_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_classification_dataset_metadata
        #   @return [::Google::Cloud::AutoML::V1::TextClassificationDatasetMetadata]
        #     Metadata for a dataset used for text classification.
        #
        #     Note: The following fields are mutually exclusive: `text_classification_dataset_metadata`, `translation_dataset_metadata`, `image_classification_dataset_metadata`, `image_object_detection_dataset_metadata`, `text_extraction_dataset_metadata`, `text_sentiment_dataset_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_object_detection_dataset_metadata
        #   @return [::Google::Cloud::AutoML::V1::ImageObjectDetectionDatasetMetadata]
        #     Metadata for a dataset used for image object detection.
        #
        #     Note: The following fields are mutually exclusive: `image_object_detection_dataset_metadata`, `translation_dataset_metadata`, `image_classification_dataset_metadata`, `text_classification_dataset_metadata`, `text_extraction_dataset_metadata`, `text_sentiment_dataset_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_extraction_dataset_metadata
        #   @return [::Google::Cloud::AutoML::V1::TextExtractionDatasetMetadata]
        #     Metadata for a dataset used for text extraction.
        #
        #     Note: The following fields are mutually exclusive: `text_extraction_dataset_metadata`, `translation_dataset_metadata`, `image_classification_dataset_metadata`, `text_classification_dataset_metadata`, `image_object_detection_dataset_metadata`, `text_sentiment_dataset_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_sentiment_dataset_metadata
        #   @return [::Google::Cloud::AutoML::V1::TextSentimentDatasetMetadata]
        #     Metadata for a dataset used for text sentiment.
        #
        #     Note: The following fields are mutually exclusive: `text_sentiment_dataset_metadata`, `translation_dataset_metadata`, `image_classification_dataset_metadata`, `text_classification_dataset_metadata`, `image_object_detection_dataset_metadata`, `text_extraction_dataset_metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Output only. The resource name of the dataset.
        #     Form: `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The name of the dataset to show in the interface. The name can be
        #     up to 32 characters long and can consist only of ASCII Latin letters A-Z
        #     and a-z, underscores
        #     (_), and ASCII digits 0-9.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of the dataset. The description can be up to
        #     25000 characters long.
        # @!attribute [rw] example_count
        #   @return [::Integer]
        #     Output only. The number of examples in the dataset.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this dataset was created.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Used to perform consistent read-modify-write updates. If not set, a blind
        #     "overwrite" update happens.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata to organize your dataset.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     Label values are optional. Label keys must start with a letter.
        #
        #     See https://goo.gl/xmQnxf for more information on and examples of labels.
        class Dataset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
