# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/automl/v1/service.proto for package 'Google.Cloud.AutoML.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/automl/v1/service_pb'

module Google
  module Cloud
    module AutoML
      module V1
        module AutoMl
          # AutoML Server API.
          #
          # The resource names are assigned by the server.
          # The server never reuses names that it has created after the resources with
          # those names are deleted.
          #
          # An ID of a resource is the last element of the item's resource name. For
          # `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`, then
          # the id for the item is `{dataset_id}`.
          #
          # Currently the only supported `location_id` is "us-central1".
          #
          # On any input that is documented to expect a string parameter in
          # snake_case or dash-case, either of those cases is accepted.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.automl.v1.AutoMl'

            # Creates a dataset.
            rpc :CreateDataset, ::Google::Cloud::AutoML::V1::CreateDatasetRequest, ::Google::Longrunning::Operation
            # Gets a dataset.
            rpc :GetDataset, ::Google::Cloud::AutoML::V1::GetDatasetRequest, ::Google::Cloud::AutoML::V1::Dataset
            # Lists datasets in a project.
            rpc :ListDatasets, ::Google::Cloud::AutoML::V1::ListDatasetsRequest, ::Google::Cloud::AutoML::V1::ListDatasetsResponse
            # Updates a dataset.
            rpc :UpdateDataset, ::Google::Cloud::AutoML::V1::UpdateDatasetRequest, ::Google::Cloud::AutoML::V1::Dataset
            # Deletes a dataset and all of its contents.
            # Returns empty response in the
            # [response][google.longrunning.Operation.response] field when it completes,
            # and `delete_details` in the
            # [metadata][google.longrunning.Operation.metadata] field.
            rpc :DeleteDataset, ::Google::Cloud::AutoML::V1::DeleteDatasetRequest, ::Google::Longrunning::Operation
            # Imports data into a dataset.
            # For Tables this method can only be called on an empty Dataset.
            #
            # For Tables:
            # *   A
            # [schema_inference_version][google.cloud.automl.v1.InputConfig.params]
            #     parameter must be explicitly set.
            # Returns an empty response in the
            # [response][google.longrunning.Operation.response] field when it completes.
            rpc :ImportData, ::Google::Cloud::AutoML::V1::ImportDataRequest, ::Google::Longrunning::Operation
            # Exports dataset's data to the provided output location.
            # Returns an empty response in the
            # [response][google.longrunning.Operation.response] field when it completes.
            rpc :ExportData, ::Google::Cloud::AutoML::V1::ExportDataRequest, ::Google::Longrunning::Operation
            # Gets an annotation spec.
            rpc :GetAnnotationSpec, ::Google::Cloud::AutoML::V1::GetAnnotationSpecRequest, ::Google::Cloud::AutoML::V1::AnnotationSpec
            # Creates a model.
            # Returns a Model in the [response][google.longrunning.Operation.response]
            # field when it completes.
            # When you create a model, several model evaluations are created for it:
            # a global evaluation, and one evaluation for each annotation spec.
            rpc :CreateModel, ::Google::Cloud::AutoML::V1::CreateModelRequest, ::Google::Longrunning::Operation
            # Gets a model.
            rpc :GetModel, ::Google::Cloud::AutoML::V1::GetModelRequest, ::Google::Cloud::AutoML::V1::Model
            # Lists models.
            rpc :ListModels, ::Google::Cloud::AutoML::V1::ListModelsRequest, ::Google::Cloud::AutoML::V1::ListModelsResponse
            # Deletes a model.
            # Returns `google.protobuf.Empty` in the
            # [response][google.longrunning.Operation.response] field when it completes,
            # and `delete_details` in the
            # [metadata][google.longrunning.Operation.metadata] field.
            rpc :DeleteModel, ::Google::Cloud::AutoML::V1::DeleteModelRequest, ::Google::Longrunning::Operation
            # Updates a model.
            rpc :UpdateModel, ::Google::Cloud::AutoML::V1::UpdateModelRequest, ::Google::Cloud::AutoML::V1::Model
            # Deploys a model. If a model is already deployed, deploying it with the
            # same parameters has no effect. Deploying with different parametrs
            # (as e.g. changing
            # [node_number][google.cloud.automl.v1p1beta.ImageObjectDetectionModelDeploymentMetadata.node_number])
            #  will reset the deployment state without pausing the model's availability.
            #
            # Only applicable for Text Classification, Image Object Detection , Tables, and Image Segmentation; all other domains manage
            # deployment automatically.
            #
            # Returns an empty response in the
            # [response][google.longrunning.Operation.response] field when it completes.
            rpc :DeployModel, ::Google::Cloud::AutoML::V1::DeployModelRequest, ::Google::Longrunning::Operation
            # Undeploys a model. If the model is not deployed this method has no effect.
            #
            # Only applicable for Text Classification, Image Object Detection and Tables;
            # all other domains manage deployment automatically.
            #
            # Returns an empty response in the
            # [response][google.longrunning.Operation.response] field when it completes.
            rpc :UndeployModel, ::Google::Cloud::AutoML::V1::UndeployModelRequest, ::Google::Longrunning::Operation
            # Exports a trained, "export-able", model to a user specified Google Cloud
            # Storage location. A model is considered export-able if and only if it has
            # an export format defined for it in
            # [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
            #
            # Returns an empty response in the
            # [response][google.longrunning.Operation.response] field when it completes.
            rpc :ExportModel, ::Google::Cloud::AutoML::V1::ExportModelRequest, ::Google::Longrunning::Operation
            # Gets a model evaluation.
            rpc :GetModelEvaluation, ::Google::Cloud::AutoML::V1::GetModelEvaluationRequest, ::Google::Cloud::AutoML::V1::ModelEvaluation
            # Lists model evaluations.
            rpc :ListModelEvaluations, ::Google::Cloud::AutoML::V1::ListModelEvaluationsRequest, ::Google::Cloud::AutoML::V1::ListModelEvaluationsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
