# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/automl/v1/service_pb"
require "google/cloud/automl/v1/automl/rest/service_stub"

module Google
  module Cloud
    module AutoML
      module V1
        module AutoML
          module Rest
            ##
            # REST client for the AutoMl service.
            #
            # AutoML Server API.
            #
            # The resource names are assigned by the server.
            # The server never reuses names that it has created after the resources with
            # those names are deleted.
            #
            # An ID of a resource is the last element of the item's resource name. For
            # `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`, then
            # the id for the item is `{dataset_id}`.
            #
            # Currently the only supported `location_id` is "us-central1".
            #
            # On any input that is documented to expect a string parameter in
            # snake_case or dash-case, either of those cases is accepted.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "automl.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :auto_ml_stub

              ##
              # Configure the AutoMl Client class.
              #
              # See {::Google::Cloud::AutoML::V1::AutoML::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AutoMl clients
              #   ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AutoML", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_dataset.timeout = 5.0

                  default_config.rpcs.get_dataset.timeout = 5.0
                  default_config.rpcs.get_dataset.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_datasets.timeout = 5.0
                  default_config.rpcs.list_datasets.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_dataset.timeout = 5.0

                  default_config.rpcs.delete_dataset.timeout = 5.0
                  default_config.rpcs.delete_dataset.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.import_data.timeout = 5.0

                  default_config.rpcs.export_data.timeout = 5.0

                  default_config.rpcs.get_annotation_spec.timeout = 5.0
                  default_config.rpcs.get_annotation_spec.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_model.timeout = 5.0

                  default_config.rpcs.get_model.timeout = 5.0
                  default_config.rpcs.get_model.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_models.timeout = 5.0
                  default_config.rpcs.list_models.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_model.timeout = 5.0
                  default_config.rpcs.delete_model.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_model.timeout = 5.0

                  default_config.rpcs.deploy_model.timeout = 5.0

                  default_config.rpcs.undeploy_model.timeout = 5.0

                  default_config.rpcs.export_model.timeout = 5.0

                  default_config.rpcs.get_model_evaluation.timeout = 5.0
                  default_config.rpcs.get_model_evaluation.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_model_evaluations.timeout = 5.0
                  default_config.rpcs.list_model_evaluations.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AutoMl Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AutoML::V1::AutoML::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @auto_ml_stub.universe_domain
              end

              ##
              # Create a new AutoMl REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AutoMl client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @auto_ml_stub = ::Google::Cloud::AutoML::V1::AutoML::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @auto_ml_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::AutoML::V1::AutoML::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @auto_ml_stub.logger
              end

              # Service calls

              ##
              # Creates a dataset.
              #
              # @overload create_dataset(request, options = nil)
              #   Pass arguments to `create_dataset` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::CreateDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::CreateDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_dataset(parent: nil, dataset: nil)
              #   Pass arguments to `create_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project to create the dataset for.
              #   @param dataset [::Google::Cloud::AutoML::V1::Dataset, ::Hash]
              #     Required. The dataset to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::CreateDatasetRequest.new
              #
              #   # Call the create_dataset method.
              #   result = client.create_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::CreateDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.create_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a dataset.
              #
              # @overload get_dataset(request, options = nil)
              #   Pass arguments to `get_dataset` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::GetDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::GetDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dataset(name: nil)
              #   Pass arguments to `get_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the dataset to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AutoML::V1::Dataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AutoML::V1::Dataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::GetDatasetRequest.new
              #
              #   # Call the get_dataset method.
              #   result = client.get_dataset request
              #
              #   # The returned object is of type Google::Cloud::AutoML::V1::Dataset.
              #   p result
              #
              def get_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::GetDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.get_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists datasets in a project.
              #
              # @overload list_datasets(request, options = nil)
              #   Pass arguments to `list_datasets` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::ListDatasetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::ListDatasetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_datasets(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_datasets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the project from which to list datasets.
              #   @param filter [::String]
              #     An expression for filtering the results of the request.
              #
              #       * `dataset_metadata` - for existence of the case (e.g.
              #                 `image_classification_dataset_metadata:*`). Some examples of using the filter are:
              #
              #       * `translation_dataset_metadata:*` --> The dataset has
              #                                              `translation_dataset_metadata`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer results than requested.
              #     If unspecified, server will pick a default size.
              #   @param page_token [::String]
              #     A token identifying a page of results for the server to return
              #     Typically obtained via
              #     {::Google::Cloud::AutoML::V1::ListDatasetsResponse#next_page_token ListDatasetsResponse.next_page_token} of the previous
              #     {::Google::Cloud::AutoML::V1::AutoML::Rest::Client#list_datasets AutoMl.ListDatasets} call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AutoML::V1::Dataset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AutoML::V1::Dataset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::ListDatasetsRequest.new
              #
              #   # Call the list_datasets method.
              #   result = client.list_datasets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AutoML::V1::Dataset.
              #     p item
              #   end
              #
              def list_datasets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::ListDatasetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_datasets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_datasets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_datasets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.list_datasets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @auto_ml_stub, :list_datasets, "datasets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a dataset.
              #
              # @overload update_dataset(request, options = nil)
              #   Pass arguments to `update_dataset` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::UpdateDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::UpdateDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_dataset(dataset: nil, update_mask: nil)
              #   Pass arguments to `update_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::Google::Cloud::AutoML::V1::Dataset, ::Hash]
              #     Required. The dataset which replaces the resource on the server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AutoML::V1::Dataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AutoML::V1::Dataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::UpdateDatasetRequest.new
              #
              #   # Call the update_dataset method.
              #   result = client.update_dataset request
              #
              #   # The returned object is of type Google::Cloud::AutoML::V1::Dataset.
              #   p result
              #
              def update_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::UpdateDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.update_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a dataset and all of its contents.
              # Returns empty response in the
              # {::Google::Longrunning::Operation#response response} field when it completes,
              # and `delete_details` in the
              # {::Google::Longrunning::Operation#metadata metadata} field.
              #
              # @overload delete_dataset(request, options = nil)
              #   Pass arguments to `delete_dataset` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::DeleteDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::DeleteDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_dataset(name: nil)
              #   Pass arguments to `delete_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the dataset to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::DeleteDatasetRequest.new
              #
              #   # Call the delete_dataset method.
              #   result = client.delete_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::DeleteDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.delete_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports data into a dataset.
              # For Tables this method can only be called on an empty Dataset.
              #
              # For Tables:
              # *   A
              # {::Google::Cloud::AutoML::V1::InputConfig#params schema_inference_version}
              #     parameter must be explicitly set.
              # Returns an empty response in the
              # {::Google::Longrunning::Operation#response response} field when it completes.
              #
              # @overload import_data(request, options = nil)
              #   Pass arguments to `import_data` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::ImportDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::ImportDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_data(name: nil, input_config: nil)
              #   Pass arguments to `import_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Dataset name. Dataset must already exist. All imported
              #     annotations and examples will be added.
              #   @param input_config [::Google::Cloud::AutoML::V1::InputConfig, ::Hash]
              #     Required. The desired input location and its domain specific semantics,
              #     if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::ImportDataRequest.new
              #
              #   # Call the import_data method.
              #   result = client.import_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::ImportDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.import_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports dataset's data to the provided output location.
              # Returns an empty response in the
              # {::Google::Longrunning::Operation#response response} field when it completes.
              #
              # @overload export_data(request, options = nil)
              #   Pass arguments to `export_data` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::ExportDataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::ExportDataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_data(name: nil, output_config: nil)
              #   Pass arguments to `export_data` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the dataset.
              #   @param output_config [::Google::Cloud::AutoML::V1::OutputConfig, ::Hash]
              #     Required. The desired output location.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::ExportDataRequest.new
              #
              #   # Call the export_data method.
              #   result = client.export_data request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_data request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::ExportDataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_data.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_data.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_data.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.export_data request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an annotation spec.
              #
              # @overload get_annotation_spec(request, options = nil)
              #   Pass arguments to `get_annotation_spec` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::GetAnnotationSpecRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::GetAnnotationSpecRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_annotation_spec(name: nil)
              #   Pass arguments to `get_annotation_spec` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the annotation spec to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AutoML::V1::AnnotationSpec]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AutoML::V1::AnnotationSpec]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::GetAnnotationSpecRequest.new
              #
              #   # Call the get_annotation_spec method.
              #   result = client.get_annotation_spec request
              #
              #   # The returned object is of type Google::Cloud::AutoML::V1::AnnotationSpec.
              #   p result
              #
              def get_annotation_spec request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::GetAnnotationSpecRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_annotation_spec.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_annotation_spec.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_annotation_spec.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.get_annotation_spec request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a model.
              # Returns a Model in the {::Google::Longrunning::Operation#response response}
              # field when it completes.
              # When you create a model, several model evaluations are created for it:
              # a global evaluation, and one evaluation for each annotation spec.
              #
              # @overload create_model(request, options = nil)
              #   Pass arguments to `create_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::CreateModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::CreateModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_model(parent: nil, model: nil)
              #   Pass arguments to `create_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the parent project where the model is being created.
              #   @param model [::Google::Cloud::AutoML::V1::Model, ::Hash]
              #     Required. The model to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::CreateModelRequest.new
              #
              #   # Call the create_model method.
              #   result = client.create_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::CreateModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.create_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a model.
              #
              # @overload get_model(request, options = nil)
              #   Pass arguments to `get_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::GetModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::GetModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_model(name: nil)
              #   Pass arguments to `get_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the model.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AutoML::V1::Model]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AutoML::V1::Model]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::GetModelRequest.new
              #
              #   # Call the get_model method.
              #   result = client.get_model request
              #
              #   # The returned object is of type Google::Cloud::AutoML::V1::Model.
              #   p result
              #
              def get_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::GetModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.get_model request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists models.
              #
              # @overload list_models(request, options = nil)
              #   Pass arguments to `list_models` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::ListModelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::ListModelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_models(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_models` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the project, from which to list the models.
              #   @param filter [::String]
              #     An expression for filtering the results of the request.
              #
              #       * `model_metadata` - for existence of the case (e.g.
              #                 `video_classification_model_metadata:*`).
              #       * `dataset_id` - for = or !=. Some examples of using the filter are:
              #
              #       * `image_classification_model_metadata:*` --> The model has
              #                                          `image_classification_model_metadata`.
              #       * `dataset_id=5` --> The model was created from a dataset with ID 5.
              #   @param page_size [::Integer]
              #     Requested page size.
              #   @param page_token [::String]
              #     A token identifying a page of results for the server to return
              #     Typically obtained via
              #     {::Google::Cloud::AutoML::V1::ListModelsResponse#next_page_token ListModelsResponse.next_page_token} of the previous
              #     {::Google::Cloud::AutoML::V1::AutoML::Rest::Client#list_models AutoMl.ListModels} call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AutoML::V1::Model>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AutoML::V1::Model>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::ListModelsRequest.new
              #
              #   # Call the list_models method.
              #   result = client.list_models request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AutoML::V1::Model.
              #     p item
              #   end
              #
              def list_models request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::ListModelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_models.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_models.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_models.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.list_models request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @auto_ml_stub, :list_models, "model", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a model.
              # Returns `google.protobuf.Empty` in the
              # {::Google::Longrunning::Operation#response response} field when it completes,
              # and `delete_details` in the
              # {::Google::Longrunning::Operation#metadata metadata} field.
              #
              # @overload delete_model(request, options = nil)
              #   Pass arguments to `delete_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::DeleteModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::DeleteModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_model(name: nil)
              #   Pass arguments to `delete_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the model being deleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::DeleteModelRequest.new
              #
              #   # Call the delete_model method.
              #   result = client.delete_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::DeleteModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.delete_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a model.
              #
              # @overload update_model(request, options = nil)
              #   Pass arguments to `update_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::UpdateModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::UpdateModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_model(model: nil, update_mask: nil)
              #   Pass arguments to `update_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param model [::Google::Cloud::AutoML::V1::Model, ::Hash]
              #     Required. The model which replaces the resource on the server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AutoML::V1::Model]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AutoML::V1::Model]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::UpdateModelRequest.new
              #
              #   # Call the update_model method.
              #   result = client.update_model request
              #
              #   # The returned object is of type Google::Cloud::AutoML::V1::Model.
              #   p result
              #
              def update_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::UpdateModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.update_model request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deploys a model. If a model is already deployed, deploying it with the
              # same parameters has no effect. Deploying with different parametrs
              # (as e.g. changing
              # [node_number][google.cloud.automl.v1p1beta.ImageObjectDetectionModelDeploymentMetadata.node_number])
              #  will reset the deployment state without pausing the model's availability.
              #
              # Only applicable for Text Classification, Image Object Detection , Tables, and Image Segmentation; all other domains manage
              # deployment automatically.
              #
              # Returns an empty response in the
              # {::Google::Longrunning::Operation#response response} field when it completes.
              #
              # @overload deploy_model(request, options = nil)
              #   Pass arguments to `deploy_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::DeployModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::DeployModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload deploy_model(image_object_detection_model_deployment_metadata: nil, image_classification_model_deployment_metadata: nil, name: nil)
              #   Pass arguments to `deploy_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param image_object_detection_model_deployment_metadata [::Google::Cloud::AutoML::V1::ImageObjectDetectionModelDeploymentMetadata, ::Hash]
              #     Model deployment metadata specific to Image Object Detection.
              #
              #     Note: The following parameters are mutually exclusive: `image_object_detection_model_deployment_metadata`, `image_classification_model_deployment_metadata`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param image_classification_model_deployment_metadata [::Google::Cloud::AutoML::V1::ImageClassificationModelDeploymentMetadata, ::Hash]
              #     Model deployment metadata specific to Image Classification.
              #
              #     Note: The following parameters are mutually exclusive: `image_classification_model_deployment_metadata`, `image_object_detection_model_deployment_metadata`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param name [::String]
              #     Required. Resource name of the model to deploy.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::DeployModelRequest.new
              #
              #   # Call the deploy_model method.
              #   result = client.deploy_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def deploy_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::DeployModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.deploy_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.deploy_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.deploy_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.deploy_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Undeploys a model. If the model is not deployed this method has no effect.
              #
              # Only applicable for Text Classification, Image Object Detection and Tables;
              # all other domains manage deployment automatically.
              #
              # Returns an empty response in the
              # {::Google::Longrunning::Operation#response response} field when it completes.
              #
              # @overload undeploy_model(request, options = nil)
              #   Pass arguments to `undeploy_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::UndeployModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::UndeployModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload undeploy_model(name: nil)
              #   Pass arguments to `undeploy_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the model to undeploy.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::UndeployModelRequest.new
              #
              #   # Call the undeploy_model method.
              #   result = client.undeploy_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def undeploy_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::UndeployModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.undeploy_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.undeploy_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.undeploy_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.undeploy_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports a trained, "export-able", model to a user specified Google Cloud
              # Storage location. A model is considered export-able if and only if it has
              # an export format defined for it in
              # {::Google::Cloud::AutoML::V1::ModelExportOutputConfig ModelExportOutputConfig}.
              #
              # Returns an empty response in the
              # {::Google::Longrunning::Operation#response response} field when it completes.
              #
              # @overload export_model(request, options = nil)
              #   Pass arguments to `export_model` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::ExportModelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::ExportModelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_model(name: nil, output_config: nil)
              #   Pass arguments to `export_model` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the model to export.
              #   @param output_config [::Google::Cloud::AutoML::V1::ModelExportOutputConfig, ::Hash]
              #     Required. The desired output location and configuration.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::ExportModelRequest.new
              #
              #   # Call the export_model method.
              #   result = client.export_model request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_model request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::ExportModelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_model.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_model.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_model.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.export_model request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a model evaluation.
              #
              # @overload get_model_evaluation(request, options = nil)
              #   Pass arguments to `get_model_evaluation` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::GetModelEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::GetModelEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_model_evaluation(name: nil)
              #   Pass arguments to `get_model_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the model evaluation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AutoML::V1::ModelEvaluation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AutoML::V1::ModelEvaluation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::GetModelEvaluationRequest.new
              #
              #   # Call the get_model_evaluation method.
              #   result = client.get_model_evaluation request
              #
              #   # The returned object is of type Google::Cloud::AutoML::V1::ModelEvaluation.
              #   p result
              #
              def get_model_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::GetModelEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_model_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_model_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_model_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.get_model_evaluation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists model evaluations.
              #
              # @overload list_model_evaluations(request, options = nil)
              #   Pass arguments to `list_model_evaluations` via a request object, either of type
              #   {::Google::Cloud::AutoML::V1::ListModelEvaluationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AutoML::V1::ListModelEvaluationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_model_evaluations(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_model_evaluations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the model to list the model evaluations for.
              #     If modelId is set as "-", this will list model evaluations from across all
              #     models of the parent location.
              #   @param filter [::String]
              #     Required. An expression for filtering the results of the request.
              #
              #       * `annotation_spec_id` - for =, !=  or existence. See example below for
              #                              the last.
              #
              #     Some examples of using the filter are:
              #
              #       * `annotation_spec_id!=4` --> The model evaluation was done for
              #                                 annotation spec with ID different than 4.
              #       * `NOT annotation_spec_id:*` --> The model evaluation was done for
              #                                    aggregate of all annotation specs.
              #   @param page_size [::Integer]
              #     Requested page size.
              #   @param page_token [::String]
              #     A token identifying a page of results for the server to return.
              #     Typically obtained via
              #     {::Google::Cloud::AutoML::V1::ListModelEvaluationsResponse#next_page_token ListModelEvaluationsResponse.next_page_token} of the previous
              #     {::Google::Cloud::AutoML::V1::AutoML::Rest::Client#list_model_evaluations AutoMl.ListModelEvaluations} call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AutoML::V1::ModelEvaluation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AutoML::V1::ModelEvaluation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/automl/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AutoML::V1::ListModelEvaluationsRequest.new
              #
              #   # Call the list_model_evaluations method.
              #   result = client.list_model_evaluations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AutoML::V1::ModelEvaluation.
              #     p item
              #   end
              #
              def list_model_evaluations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AutoML::V1::ListModelEvaluationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_model_evaluations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AutoML::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_model_evaluations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_model_evaluations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @auto_ml_stub.list_model_evaluations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @auto_ml_stub, :list_model_evaluations, "model_evaluation", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AutoMl REST API.
              #
              # This class represents the configuration for AutoMl REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AutoML::V1::AutoML::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_dataset to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_dataset.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_dataset.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "automl.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AutoMl API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dataset
                  ##
                  # RPC-specific configuration for `get_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dataset
                  ##
                  # RPC-specific configuration for `list_datasets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_datasets
                  ##
                  # RPC-specific configuration for `update_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dataset
                  ##
                  # RPC-specific configuration for `delete_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dataset
                  ##
                  # RPC-specific configuration for `import_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_data
                  ##
                  # RPC-specific configuration for `export_data`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_data
                  ##
                  # RPC-specific configuration for `get_annotation_spec`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_annotation_spec
                  ##
                  # RPC-specific configuration for `create_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_model
                  ##
                  # RPC-specific configuration for `get_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_model
                  ##
                  # RPC-specific configuration for `list_models`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_models
                  ##
                  # RPC-specific configuration for `delete_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_model
                  ##
                  # RPC-specific configuration for `update_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_model
                  ##
                  # RPC-specific configuration for `deploy_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :deploy_model
                  ##
                  # RPC-specific configuration for `undeploy_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undeploy_model
                  ##
                  # RPC-specific configuration for `export_model`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_model
                  ##
                  # RPC-specific configuration for `get_model_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_model_evaluation
                  ##
                  # RPC-specific configuration for `list_model_evaluations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_model_evaluations

                  # @private
                  def initialize parent_rpcs = nil
                    create_dataset_config = parent_rpcs.create_dataset if parent_rpcs.respond_to? :create_dataset
                    @create_dataset = ::Gapic::Config::Method.new create_dataset_config
                    get_dataset_config = parent_rpcs.get_dataset if parent_rpcs.respond_to? :get_dataset
                    @get_dataset = ::Gapic::Config::Method.new get_dataset_config
                    list_datasets_config = parent_rpcs.list_datasets if parent_rpcs.respond_to? :list_datasets
                    @list_datasets = ::Gapic::Config::Method.new list_datasets_config
                    update_dataset_config = parent_rpcs.update_dataset if parent_rpcs.respond_to? :update_dataset
                    @update_dataset = ::Gapic::Config::Method.new update_dataset_config
                    delete_dataset_config = parent_rpcs.delete_dataset if parent_rpcs.respond_to? :delete_dataset
                    @delete_dataset = ::Gapic::Config::Method.new delete_dataset_config
                    import_data_config = parent_rpcs.import_data if parent_rpcs.respond_to? :import_data
                    @import_data = ::Gapic::Config::Method.new import_data_config
                    export_data_config = parent_rpcs.export_data if parent_rpcs.respond_to? :export_data
                    @export_data = ::Gapic::Config::Method.new export_data_config
                    get_annotation_spec_config = parent_rpcs.get_annotation_spec if parent_rpcs.respond_to? :get_annotation_spec
                    @get_annotation_spec = ::Gapic::Config::Method.new get_annotation_spec_config
                    create_model_config = parent_rpcs.create_model if parent_rpcs.respond_to? :create_model
                    @create_model = ::Gapic::Config::Method.new create_model_config
                    get_model_config = parent_rpcs.get_model if parent_rpcs.respond_to? :get_model
                    @get_model = ::Gapic::Config::Method.new get_model_config
                    list_models_config = parent_rpcs.list_models if parent_rpcs.respond_to? :list_models
                    @list_models = ::Gapic::Config::Method.new list_models_config
                    delete_model_config = parent_rpcs.delete_model if parent_rpcs.respond_to? :delete_model
                    @delete_model = ::Gapic::Config::Method.new delete_model_config
                    update_model_config = parent_rpcs.update_model if parent_rpcs.respond_to? :update_model
                    @update_model = ::Gapic::Config::Method.new update_model_config
                    deploy_model_config = parent_rpcs.deploy_model if parent_rpcs.respond_to? :deploy_model
                    @deploy_model = ::Gapic::Config::Method.new deploy_model_config
                    undeploy_model_config = parent_rpcs.undeploy_model if parent_rpcs.respond_to? :undeploy_model
                    @undeploy_model = ::Gapic::Config::Method.new undeploy_model_config
                    export_model_config = parent_rpcs.export_model if parent_rpcs.respond_to? :export_model
                    @export_model = ::Gapic::Config::Method.new export_model_config
                    get_model_evaluation_config = parent_rpcs.get_model_evaluation if parent_rpcs.respond_to? :get_model_evaluation
                    @get_model_evaluation = ::Gapic::Config::Method.new get_model_evaluation_config
                    list_model_evaluations_config = parent_rpcs.list_model_evaluations if parent_rpcs.respond_to? :list_model_evaluations
                    @list_model_evaluations = ::Gapic::Config::Method.new list_model_evaluations_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
