# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/automl/v1/version"

require "google/cloud/automl/v1/automl/credentials"
require "google/cloud/automl/v1/automl/paths"
require "google/cloud/automl/v1/automl/operations"
require "google/cloud/automl/v1/automl/client"
require "google/cloud/automl/v1/automl/rest"

module Google
  module Cloud
    module AutoML
      module V1
        ##
        # AutoML Server API.
        #
        # The resource names are assigned by the server.
        # The server never reuses names that it has created after the resources with
        # those names are deleted.
        #
        # An ID of a resource is the last element of the item's resource name. For
        # `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`, then
        # the id for the item is `{dataset_id}`.
        #
        # Currently the only supported `location_id` is "us-central1".
        #
        # On any input that is documented to expect a string parameter in
        # snake_case or dash-case, either of those cases is accepted.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/automl/v1/automl"
        #     client = ::Google::Cloud::AutoML::V1::AutoML::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/automl/v1/automl/rest"
        #     client = ::Google::Cloud::AutoML::V1::AutoML::Rest::Client.new
        #
        module AutoML
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "automl", "helpers.rb"
require "google/cloud/automl/v1/automl/helpers" if ::File.file? helper_path
