# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/assuredworkloads/v1beta1/assuredworkloads_service_pb"
require "google/cloud/assured_workloads/v1beta1/assured_workloads_service/rest"


class ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_workload
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workload = {}
    external_id = "hello world"

    create_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::ServiceStub.stub :transcode_create_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workload({ parent: parent, workload: workload, external_id: external_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workload parent: parent, workload: workload, external_id: external_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workload ::Google::Cloud::AssuredWorkloads::V1beta1::CreateWorkloadRequest.new(parent: parent, workload: workload, external_id: external_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workload({ parent: parent, workload: workload, external_id: external_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workload(::Google::Cloud::AssuredWorkloads::V1beta1::CreateWorkloadRequest.new(parent: parent, workload: workload, external_id: external_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workload_client_stub.call_count
      end
    end
  end

  def test_restrict_allowed_resources
    # Create test objects.
    client_result = ::Google::Cloud::AssuredWorkloads::V1beta1::RestrictAllowedResourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    restriction_type = :RESTRICTION_TYPE_UNSPECIFIED

    restrict_allowed_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::ServiceStub.stub :transcode_restrict_allowed_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restrict_allowed_resources_client_stub do
        # Create client
        client = ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restrict_allowed_resources({ name: name, restriction_type: restriction_type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restrict_allowed_resources name: name, restriction_type: restriction_type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restrict_allowed_resources ::Google::Cloud::AssuredWorkloads::V1beta1::RestrictAllowedResourcesRequest.new(name: name, restriction_type: restriction_type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restrict_allowed_resources({ name: name, restriction_type: restriction_type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restrict_allowed_resources(::Google::Cloud::AssuredWorkloads::V1beta1::RestrictAllowedResourcesRequest.new(name: name, restriction_type: restriction_type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restrict_allowed_resources_client_stub.call_count
      end
    end
  end

  def test_delete_workload
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::ServiceStub.stub :transcode_delete_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workload({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workload name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workload ::Google::Cloud::AssuredWorkloads::V1beta1::DeleteWorkloadRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workload({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workload(::Google::Cloud::AssuredWorkloads::V1beta1::DeleteWorkloadRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workload_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AssuredWorkloads::V1beta1::AssuredWorkloadsService::Rest::Client::Configuration, config
  end
end
