# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/asset/v1/asset_service_pb"
require "google/cloud/asset/v1/asset_service/rest"


class ::Google::Cloud::Asset::V1::AssetService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_export_assets
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    read_time = {}
    asset_types = ["hello world"]
    content_type = :CONTENT_TYPE_UNSPECIFIED
    output_config = {}
    relationship_types = ["hello world"]

    export_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_export_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_assets_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_assets({ parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, output_config: output_config, relationship_types: relationship_types }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_assets parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, output_config: output_config, relationship_types: relationship_types do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_assets ::Google::Cloud::Asset::V1::ExportAssetsRequest.new(parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, output_config: output_config, relationship_types: relationship_types) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_assets({ parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, output_config: output_config, relationship_types: relationship_types }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_assets(::Google::Cloud::Asset::V1::ExportAssetsRequest.new(parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, output_config: output_config, relationship_types: relationship_types), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_assets_client_stub.call_count
      end
    end
  end

  def test_list_assets
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::ListAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    read_time = {}
    asset_types = ["hello world"]
    content_type = :CONTENT_TYPE_UNSPECIFIED
    page_size = 42
    page_token = "hello world"
    relationship_types = ["hello world"]

    list_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_list_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assets_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assets({ parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, page_size: page_size, page_token: page_token, relationship_types: relationship_types }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assets parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, page_size: page_size, page_token: page_token, relationship_types: relationship_types do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assets ::Google::Cloud::Asset::V1::ListAssetsRequest.new(parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, page_size: page_size, page_token: page_token, relationship_types: relationship_types) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assets({ parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, page_size: page_size, page_token: page_token, relationship_types: relationship_types }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assets(::Google::Cloud::Asset::V1::ListAssetsRequest.new(parent: parent, read_time: read_time, asset_types: asset_types, content_type: content_type, page_size: page_size, page_token: page_token, relationship_types: relationship_types), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assets_client_stub.call_count
      end
    end
  end

  def test_batch_get_assets_history
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::BatchGetAssetsHistoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    asset_names = ["hello world"]
    content_type = :CONTENT_TYPE_UNSPECIFIED
    read_time_window = {}
    relationship_types = ["hello world"]

    batch_get_assets_history_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_batch_get_assets_history_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_get_assets_history_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_get_assets_history({ parent: parent, asset_names: asset_names, content_type: content_type, read_time_window: read_time_window, relationship_types: relationship_types }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_get_assets_history parent: parent, asset_names: asset_names, content_type: content_type, read_time_window: read_time_window, relationship_types: relationship_types do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_get_assets_history ::Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest.new(parent: parent, asset_names: asset_names, content_type: content_type, read_time_window: read_time_window, relationship_types: relationship_types) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_get_assets_history({ parent: parent, asset_names: asset_names, content_type: content_type, read_time_window: read_time_window, relationship_types: relationship_types }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_get_assets_history(::Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest.new(parent: parent, asset_names: asset_names, content_type: content_type, read_time_window: read_time_window, relationship_types: relationship_types), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_get_assets_history_client_stub.call_count
      end
    end
  end

  def test_create_feed
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::Feed.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feed_id = "hello world"
    feed = {}

    create_feed_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_create_feed_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_feed_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_feed({ parent: parent, feed_id: feed_id, feed: feed }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_feed parent: parent, feed_id: feed_id, feed: feed do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_feed ::Google::Cloud::Asset::V1::CreateFeedRequest.new(parent: parent, feed_id: feed_id, feed: feed) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_feed({ parent: parent, feed_id: feed_id, feed: feed }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_feed(::Google::Cloud::Asset::V1::CreateFeedRequest.new(parent: parent, feed_id: feed_id, feed: feed), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_feed_client_stub.call_count
      end
    end
  end

  def test_get_feed
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::Feed.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feed_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_get_feed_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_feed_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_feed({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_feed name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_feed ::Google::Cloud::Asset::V1::GetFeedRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_feed({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_feed(::Google::Cloud::Asset::V1::GetFeedRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_feed_client_stub.call_count
      end
    end
  end

  def test_list_feeds
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::ListFeedsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_feeds_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_list_feeds_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_feeds_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_feeds({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_feeds parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_feeds ::Google::Cloud::Asset::V1::ListFeedsRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_feeds({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_feeds(::Google::Cloud::Asset::V1::ListFeedsRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_feeds_client_stub.call_count
      end
    end
  end

  def test_update_feed
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::Feed.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feed = {}
    update_mask = {}

    update_feed_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_update_feed_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_feed_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_feed({ feed: feed, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_feed feed: feed, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_feed ::Google::Cloud::Asset::V1::UpdateFeedRequest.new(feed: feed, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_feed({ feed: feed, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_feed(::Google::Cloud::Asset::V1::UpdateFeedRequest.new(feed: feed, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_feed_client_stub.call_count
      end
    end
  end

  def test_delete_feed
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_feed_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_delete_feed_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_feed_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_feed({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_feed name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_feed ::Google::Cloud::Asset::V1::DeleteFeedRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_feed({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_feed(::Google::Cloud::Asset::V1::DeleteFeedRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_feed_client_stub.call_count
      end
    end
  end

  def test_search_all_resources
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::SearchAllResourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = "hello world"
    query = "hello world"
    asset_types = ["hello world"]
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    search_all_resources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_search_all_resources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_all_resources_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_all_resources({ scope: scope, query: query, asset_types: asset_types, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_all_resources scope: scope, query: query, asset_types: asset_types, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_all_resources ::Google::Cloud::Asset::V1::SearchAllResourcesRequest.new(scope: scope, query: query, asset_types: asset_types, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_all_resources({ scope: scope, query: query, asset_types: asset_types, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_all_resources(::Google::Cloud::Asset::V1::SearchAllResourcesRequest.new(scope: scope, query: query, asset_types: asset_types, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_all_resources_client_stub.call_count
      end
    end
  end

  def test_search_all_iam_policies
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::SearchAllIamPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"
    asset_types = ["hello world"]
    order_by = "hello world"

    search_all_iam_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_search_all_iam_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_all_iam_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_all_iam_policies({ scope: scope, query: query, page_size: page_size, page_token: page_token, asset_types: asset_types, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_all_iam_policies scope: scope, query: query, page_size: page_size, page_token: page_token, asset_types: asset_types, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_all_iam_policies ::Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest.new(scope: scope, query: query, page_size: page_size, page_token: page_token, asset_types: asset_types, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_all_iam_policies({ scope: scope, query: query, page_size: page_size, page_token: page_token, asset_types: asset_types, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_all_iam_policies(::Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest.new(scope: scope, query: query, page_size: page_size, page_token: page_token, asset_types: asset_types, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_all_iam_policies_client_stub.call_count
      end
    end
  end

  def test_analyze_iam_policy
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    analysis_query = {}
    saved_analysis_query = "hello world"
    execution_timeout = {}

    analyze_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_analyze_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_iam_policy({ analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, execution_timeout: execution_timeout }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_iam_policy analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, execution_timeout: execution_timeout do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_iam_policy ::Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest.new(analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, execution_timeout: execution_timeout) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_iam_policy({ analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, execution_timeout: execution_timeout }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_iam_policy(::Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest.new(analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, execution_timeout: execution_timeout), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_iam_policy_client_stub.call_count
      end
    end
  end

  def test_analyze_iam_policy_longrunning
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    analysis_query = {}
    saved_analysis_query = "hello world"
    output_config = {}

    analyze_iam_policy_longrunning_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_analyze_iam_policy_longrunning_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_iam_policy_longrunning_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_iam_policy_longrunning({ analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_iam_policy_longrunning analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_iam_policy_longrunning ::Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest.new(analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_iam_policy_longrunning({ analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_iam_policy_longrunning(::Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest.new(analysis_query: analysis_query, saved_analysis_query: saved_analysis_query, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_iam_policy_longrunning_client_stub.call_count
      end
    end
  end

  def test_analyze_move
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::AnalyzeMoveResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    destination_parent = "hello world"
    view = :ANALYSIS_VIEW_UNSPECIFIED

    analyze_move_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_analyze_move_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_move_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_move({ resource: resource, destination_parent: destination_parent, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_move resource: resource, destination_parent: destination_parent, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_move ::Google::Cloud::Asset::V1::AnalyzeMoveRequest.new(resource: resource, destination_parent: destination_parent, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_move({ resource: resource, destination_parent: destination_parent, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_move(::Google::Cloud::Asset::V1::AnalyzeMoveRequest.new(resource: resource, destination_parent: destination_parent, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_move_client_stub.call_count
      end
    end
  end

  def test_query_assets
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::QueryAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    statement = "hello world"
    page_size = 42
    page_token = "hello world"
    timeout = {}
    read_time_window = {}
    output_config = {}

    query_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_query_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_assets_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_assets({ parent: parent, statement: statement, page_size: page_size, page_token: page_token, timeout: timeout, read_time_window: read_time_window, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_assets parent: parent, statement: statement, page_size: page_size, page_token: page_token, timeout: timeout, read_time_window: read_time_window, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_assets ::Google::Cloud::Asset::V1::QueryAssetsRequest.new(parent: parent, statement: statement, page_size: page_size, page_token: page_token, timeout: timeout, read_time_window: read_time_window, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_assets({ parent: parent, statement: statement, page_size: page_size, page_token: page_token, timeout: timeout, read_time_window: read_time_window, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_assets(::Google::Cloud::Asset::V1::QueryAssetsRequest.new(parent: parent, statement: statement, page_size: page_size, page_token: page_token, timeout: timeout, read_time_window: read_time_window, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_assets_client_stub.call_count
      end
    end
  end

  def test_create_saved_query
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::SavedQuery.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    saved_query = {}
    saved_query_id = "hello world"

    create_saved_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_create_saved_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_saved_query_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_saved_query({ parent: parent, saved_query: saved_query, saved_query_id: saved_query_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_saved_query parent: parent, saved_query: saved_query, saved_query_id: saved_query_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_saved_query ::Google::Cloud::Asset::V1::CreateSavedQueryRequest.new(parent: parent, saved_query: saved_query, saved_query_id: saved_query_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_saved_query({ parent: parent, saved_query: saved_query, saved_query_id: saved_query_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_saved_query(::Google::Cloud::Asset::V1::CreateSavedQueryRequest.new(parent: parent, saved_query: saved_query, saved_query_id: saved_query_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_saved_query_client_stub.call_count
      end
    end
  end

  def test_get_saved_query
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::SavedQuery.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_saved_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_get_saved_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_saved_query_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_saved_query({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_saved_query name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_saved_query ::Google::Cloud::Asset::V1::GetSavedQueryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_saved_query({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_saved_query(::Google::Cloud::Asset::V1::GetSavedQueryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_saved_query_client_stub.call_count
      end
    end
  end

  def test_list_saved_queries
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::ListSavedQueriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_saved_queries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_list_saved_queries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_saved_queries_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_saved_queries({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_saved_queries parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_saved_queries ::Google::Cloud::Asset::V1::ListSavedQueriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_saved_queries({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_saved_queries(::Google::Cloud::Asset::V1::ListSavedQueriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_saved_queries_client_stub.call_count
      end
    end
  end

  def test_update_saved_query
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::SavedQuery.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    saved_query = {}
    update_mask = {}

    update_saved_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_update_saved_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_saved_query_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_saved_query({ saved_query: saved_query, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_saved_query saved_query: saved_query, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_saved_query ::Google::Cloud::Asset::V1::UpdateSavedQueryRequest.new(saved_query: saved_query, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_saved_query({ saved_query: saved_query, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_saved_query(::Google::Cloud::Asset::V1::UpdateSavedQueryRequest.new(saved_query: saved_query, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_saved_query_client_stub.call_count
      end
    end
  end

  def test_delete_saved_query
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_saved_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_delete_saved_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_saved_query_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_saved_query({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_saved_query name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_saved_query ::Google::Cloud::Asset::V1::DeleteSavedQueryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_saved_query({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_saved_query(::Google::Cloud::Asset::V1::DeleteSavedQueryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_saved_query_client_stub.call_count
      end
    end
  end

  def test_batch_get_effective_iam_policies
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = "hello world"
    names = ["hello world"]

    batch_get_effective_iam_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_batch_get_effective_iam_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_get_effective_iam_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_get_effective_iam_policies({ scope: scope, names: names }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_get_effective_iam_policies scope: scope, names: names do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_get_effective_iam_policies ::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest.new(scope: scope, names: names) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_get_effective_iam_policies({ scope: scope, names: names }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_get_effective_iam_policies(::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest.new(scope: scope, names: names), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_get_effective_iam_policies_client_stub.call_count
      end
    end
  end

  def test_analyze_org_policies
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = "hello world"
    constraint = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    analyze_org_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_analyze_org_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_org_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_org_policies({ scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_org_policies scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_org_policies ::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest.new(scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_org_policies({ scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_org_policies(::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest.new(scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_org_policies_client_stub.call_count
      end
    end
  end

  def test_analyze_org_policy_governed_containers
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = "hello world"
    constraint = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    analyze_org_policy_governed_containers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_analyze_org_policy_governed_containers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_org_policy_governed_containers_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_org_policy_governed_containers({ scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_org_policy_governed_containers scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_org_policy_governed_containers ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest.new(scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_org_policy_governed_containers({ scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_org_policy_governed_containers(::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest.new(scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_org_policy_governed_containers_client_stub.call_count
      end
    end
  end

  def test_analyze_org_policy_governed_assets
    # Create test objects.
    client_result = ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = "hello world"
    constraint = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    analyze_org_policy_governed_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Asset::V1::AssetService::Rest::ServiceStub.stub :transcode_analyze_org_policy_governed_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_org_policy_governed_assets_client_stub do
        # Create client
        client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_org_policy_governed_assets({ scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_org_policy_governed_assets scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_org_policy_governed_assets ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest.new(scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_org_policy_governed_assets({ scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_org_policy_governed_assets(::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest.new(scope: scope, constraint: constraint, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_org_policy_governed_assets_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Asset::V1::AssetService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Asset::V1::AssetService::Rest::Client::Configuration, config
  end
end
