# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Asset
      module V1
        # An asset in Google Cloud and its temporal metadata, including the time window
        # when it was observed and its status during that window.
        # @!attribute [rw] window
        #   @return [::Google::Cloud::Asset::V1::TimeWindow]
        #     The time window when the asset data and state was observed.
        # @!attribute [rw] deleted
        #   @return [::Boolean]
        #     Whether the asset has been deleted or not.
        # @!attribute [rw] asset
        #   @return [::Google::Cloud::Asset::V1::Asset]
        #     An asset in Google Cloud.
        # @!attribute [rw] prior_asset_state
        #   @return [::Google::Cloud::Asset::V1::TemporalAsset::PriorAssetState]
        #     State of prior_asset.
        # @!attribute [rw] prior_asset
        #   @return [::Google::Cloud::Asset::V1::Asset]
        #     Prior copy of the asset. Populated if prior_asset_state is PRESENT.
        #     Currently this is only set for responses in Real-Time Feed.
        class TemporalAsset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of prior asset.
          module PriorAssetState
            # prior_asset is not applicable for the current asset.
            PRIOR_ASSET_STATE_UNSPECIFIED = 0

            # prior_asset is populated correctly.
            PRESENT = 1

            # Failed to set prior_asset.
            INVALID = 2

            # Current asset is the first known state.
            DOES_NOT_EXIST = 3

            # prior_asset is a deletion.
            DELETED = 4
          end
        end

        # A time window specified by its `start_time` and `end_time`.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Start time of the time window (exclusive).
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     End time of the time window (inclusive). If not specified, the current
        #     timestamp is used instead.
        class TimeWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The enhanced metadata information for a resource.
        # @!attribute [rw] resource_owners
        #   @return [::Google::Cloud::Asset::V1::ResourceOwners]
        #     The resource owners for a resource.
        #
        #     Note that this field only contains the members that have "roles/owner"
        #     role in the resource's IAM Policy.
        class AssetEnrichment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An asset in Google Cloud. An asset can be any resource in the Google Cloud
        # [resource
        # hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
        # a resource outside the Google Cloud resource hierarchy (such as Google
        # Kubernetes Engine clusters and objects), or a policy (e.g. IAM policy),
        # or a relationship (e.g. an INSTANCE_TO_INSTANCEGROUP relationship).
        # See [Supported asset
        # types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        # for more information.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update timestamp of an asset. update_time is updated when
        #     create/update/delete operation is performed.
        # @!attribute [rw] name
        #   @return [::String]
        #     The full name of the asset. Example:
        #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
        #
        #     See [Resource
        #     names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
        #     for more information.
        # @!attribute [rw] asset_type
        #   @return [::String]
        #     The type of the asset. Example: `compute.googleapis.com/Disk`
        #
        #     See [Supported asset
        #     types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        #     for more information.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::Asset::V1::Resource]
        #     A representation of the resource.
        # @!attribute [rw] iam_policy
        #   @return [::Google::Iam::V1::Policy]
        #     A representation of the IAM policy set on a Google Cloud resource.
        #     There can be a maximum of one IAM policy set on any given resource.
        #     In addition, IAM policies inherit their granted access scope from any
        #     policies set on parent resources in the resource hierarchy. Therefore, the
        #     effectively policy is the union of both the policy set on this resource
        #     and each policy set on all of the resource's ancestry resource levels in
        #     the hierarchy. See
        #     [this topic](https://cloud.google.com/iam/help/allow-policies/inheritance)
        #     for more information.
        # @!attribute [rw] org_policy
        #   @return [::Array<::Google::Cloud::OrgPolicy::V1::Policy>]
        #     A representation of an [organization
        #     policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
        #     There can be more than one organization policy with different constraints
        #     set on a given resource.
        # @!attribute [rw] access_policy
        #   @return [::Google::Identity::AccessContextManager::V1::AccessPolicy]
        #     Also refer to the [access policy user
        #     guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
        #
        #     Note: The following fields are mutually exclusive: `access_policy`, `access_level`, `service_perimeter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] access_level
        #   @return [::Google::Identity::AccessContextManager::V1::AccessLevel]
        #     Also refer to the [access level user
        #     guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
        #
        #     Note: The following fields are mutually exclusive: `access_level`, `access_policy`, `service_perimeter`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_perimeter
        #   @return [::Google::Identity::AccessContextManager::V1::ServicePerimeter]
        #     Also refer to the [service perimeter user
        #     guide](https://cloud.google.com/vpc-service-controls/docs/overview).
        #
        #     Note: The following fields are mutually exclusive: `service_perimeter`, `access_policy`, `access_level`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] os_inventory
        #   @return [::Google::Cloud::OsConfig::V1::Inventory]
        #     A representation of runtime OS Inventory information. See [this
        #     topic](https://cloud.google.com/compute/docs/instances/os-inventory-management)
        #     for more information.
        # @!attribute [rw] related_assets
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Asset::V1::RelatedAssets]
        #     DEPRECATED. This field only presents for the purpose of
        #     backward-compatibility. The server will never generate responses with this
        #     field.
        #     The related assets of the asset of one relationship type. One asset
        #     only represents one type of relationship.
        # @!attribute [rw] related_asset
        #   @return [::Google::Cloud::Asset::V1::RelatedAsset]
        #     One related asset of the current asset.
        # @!attribute [rw] ancestors
        #   @return [::Array<::String>]
        #     The ancestry path of an asset in Google Cloud [resource
        #     hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
        #     represented as a list of relative resource names. An ancestry path starts
        #     with the closest ancestor in the hierarchy and ends at root. If the asset
        #     is a project, folder, or organization, the ancestry path starts from the
        #     asset itself.
        #
        #     Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
        class Asset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A representation of a Google Cloud resource.
        # @!attribute [rw] version
        #   @return [::String]
        #     The API version. Example: `v1`
        # @!attribute [rw] discovery_document_uri
        #   @return [::String]
        #     The URL of the discovery document containing the resource's JSON schema.
        #     Example:
        #     `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
        #
        #     This value is unspecified for resources that do not have an API based on a
        #     discovery document, such as Cloud Bigtable.
        # @!attribute [rw] discovery_name
        #   @return [::String]
        #     The JSON schema name listed in the discovery document. Example:
        #     `Project`
        #
        #     This value is unspecified for resources that do not have an API based on a
        #     discovery document, such as Cloud Bigtable.
        # @!attribute [rw] resource_url
        #   @return [::String]
        #     The REST URL for accessing the resource. An HTTP `GET` request using this
        #     URL returns the resource itself. Example:
        #     `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
        #
        #     This value is unspecified for resources without a REST API.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The full name of the immediate parent of this resource. See
        #     [Resource
        #     Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
        #     for more information.
        #
        #     For Google Cloud assets, this value is the parent resource defined in the
        #     [IAM policy
        #     hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
        #     Example:
        #     `//cloudresourcemanager.googleapis.com/projects/my_project_123`
        # @!attribute [rw] data
        #   @return [::Google::Protobuf::Struct]
        #     The content of the resource, in which some sensitive fields are removed
        #     and may not be present.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location of the resource in Google Cloud, such as its zone and region.
        #     For more information, see https://cloud.google.com/about/locations/.
        class Resource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DEPRECATED. This message only presents for the purpose of
        # backward-compatibility. The server will never populate this message in
        # responses.
        # The detailed related assets with the `relationship_type`.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] relationship_attributes
        #   @return [::Google::Cloud::Asset::V1::RelationshipAttributes]
        #     The detailed relationship attributes.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::Asset::V1::RelatedAsset>]
        #     The peer resources of the relationship.
        class RelatedAssets
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DEPRECATED. This message only presents for the purpose of
        # backward-compatibility. The server will never populate this message in
        # responses.
        # The relationship attributes which include  `type`, `source_resource_type`,
        # `target_resource_type` and `action`.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] type
        #   @return [::String]
        #     The unique identifier of the relationship type. Example:
        #     `INSTANCE_TO_INSTANCEGROUP`
        # @!attribute [rw] source_resource_type
        #   @return [::String]
        #     The source asset type. Example: `compute.googleapis.com/Instance`
        # @!attribute [rw] target_resource_type
        #   @return [::String]
        #     The target asset type. Example: `compute.googleapis.com/Disk`
        # @!attribute [rw] action
        #   @return [::String]
        #     The detail of the relationship, e.g. `contains`, `attaches`
        class RelationshipAttributes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An asset identifier in Google Cloud which contains its name, type and
        # ancestors. An asset can be any resource in the Google Cloud [resource
        # hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
        # a resource outside the Google Cloud resource hierarchy (such as Google
        # Kubernetes Engine clusters and objects), or a policy (e.g. IAM policy).
        # See [Supported asset
        # types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        # for more information.
        # @!attribute [rw] asset
        #   @return [::String]
        #     The full name of the asset. Example:
        #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
        #
        #     See [Resource
        #     names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
        #     for more information.
        # @!attribute [rw] asset_type
        #   @return [::String]
        #     The type of the asset. Example: `compute.googleapis.com/Disk`
        #
        #     See [Supported asset
        #     types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        #     for more information.
        # @!attribute [rw] ancestors
        #   @return [::Array<::String>]
        #     The ancestors of an asset in Google Cloud [resource
        #     hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
        #     represented as a list of relative resource names. An ancestry path starts
        #     with the closest ancestor in the hierarchy and ends at root.
        #
        #     Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
        # @!attribute [rw] relationship_type
        #   @return [::String]
        #     The unique identifier of the relationship type. Example:
        #     `INSTANCE_TO_INSTANCEGROUP`
        class RelatedAsset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The key and value for a
        # [tag](https://cloud.google.com/resource-manager/docs/tags/tags-overview).
        # @!attribute [rw] tag_key
        #   @return [::String]
        #     TagKey namespaced name, in the format of \\{ORG_ID}/\\{TAG_KEY_SHORT_NAME}.
        # @!attribute [rw] tag_key_id
        #   @return [::String]
        #     TagKey ID, in the format of tagKeys/\\{TAG_KEY_ID}.
        # @!attribute [rw] tag_value
        #   @return [::String]
        #     TagValue namespaced name, in the format of
        #     \\{ORG_ID}/\\{TAG_KEY_SHORT_NAME}/\\{TAG_VALUE_SHORT_NAME}.
        # @!attribute [rw] tag_value_id
        #   @return [::String]
        #     TagValue ID, in the format of tagValues/\\{TAG_VALUE_ID}.
        class Tag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The effective tags and the ancestor resources from which they were inherited.
        # @!attribute [rw] attached_resource
        #   @return [::String]
        #     The [full resource
        #     name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     of the ancestor from which
        #     {::Google::Cloud::Asset::V1::EffectiveTagDetails#effective_tags effective_tags}
        #     are inherited, according to [tag
        #     inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
        # @!attribute [rw] effective_tags
        #   @return [::Array<::Google::Cloud::Asset::V1::Tag>]
        #     The effective tags inherited from the
        #     {::Google::Cloud::Asset::V1::EffectiveTagDetails#attached_resource attached_resource}.
        #     Note that tags with the same key but different values may attach to
        #     resources at a different hierarchy levels. The lower hierarchy tag value
        #     will overwrite the higher hierarchy tag value of the same tag key. In this
        #     case, the tag value at the higher hierarchy level will be removed. For more
        #     information, see [tag
        #     inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
        class EffectiveTagDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A result of Resource Search, containing information of a cloud resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     The full resource name of this resource. Example:
        #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
        #     See [Cloud Asset Inventory Resource Name
        #     Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     for more information.
        #
        #     To search against the `name`:
        #
        #     * Use a field query. Example: `name:instance1`
        #     * Use a free text query. Example: `instance1`
        # @!attribute [rw] asset_type
        #   @return [::String]
        #     The type of this resource. Example: `compute.googleapis.com/Disk`.
        #
        #     To search against the `asset_type`:
        #
        #     * Specify the `asset_type` field in your search request.
        # @!attribute [rw] project
        #   @return [::String]
        #     The project that this resource belongs to, in the form of
        #     projects/\\{PROJECT_NUMBER}. This field is available when the resource
        #     belongs to a project.
        #
        #     To search against `project`:
        #
        #     * Use a field query. Example: `project:12345`
        #     * Use a free text query. Example: `12345`
        #     * Specify the `scope` field as this project in your search request.
        # @!attribute [rw] folders
        #   @return [::Array<::String>]
        #     The folder(s) that this resource belongs to, in the form of
        #     folders/\\{FOLDER_NUMBER}. This field is available when the resource
        #     belongs to one or more folders.
        #
        #     To search against `folders`:
        #
        #     * Use a field query. Example: `folders:(123 OR 456)`
        #     * Use a free text query. Example: `123`
        #     * Specify the `scope` field as this folder in your search request.
        # @!attribute [rw] organization
        #   @return [::String]
        #     The organization that this resource belongs to, in the form of
        #     organizations/\\{ORGANIZATION_NUMBER}. This field is available when the
        #     resource belongs to an organization.
        #
        #     To search against `organization`:
        #
        #     * Use a field query. Example: `organization:123`
        #     * Use a free text query. Example: `123`
        #     * Specify the `scope` field as this organization in your search request.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of this resource. This field is available only when the
        #     resource's Protobuf contains it.
        #
        #     To search against the `display_name`:
        #
        #     * Use a field query. Example: `displayName:"My Instance"`
        #     * Use a free text query. Example: `"My Instance"`
        # @!attribute [rw] description
        #   @return [::String]
        #     One or more paragraphs of text description of this resource. Maximum length
        #     could be up to 1M bytes. This field is available only when the resource's
        #     Protobuf contains it.
        #
        #     To search against the `description`:
        #
        #     * Use a field query. Example: `description:"important instance"`
        #     * Use a free text query. Example: `"important instance"`
        # @!attribute [rw] location
        #   @return [::String]
        #     Location can be `global`, regional like `us-east1`, or zonal like
        #     `us-west1-b`. This field is available only when the resource's Protobuf
        #     contains it.
        #
        #     To search against the `location`:
        #
        #     * Use a field query. Example: `location:us-west*`
        #     * Use a free text query. Example: `us-west*`
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User labels associated with this resource. See [Labelling and grouping
        #     Google Cloud
        #     resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
        #     for more information. This field is available only when the resource's
        #     Protobuf contains it.
        #
        #     To search against the `labels`:
        #
        #     * Use a field query:
        #         - query on any label's key or value. Example: `labels:prod`
        #         - query by a given label. Example: `labels.env:prod`
        #         - query by a given label's existence. Example: `labels.env:*`
        #     * Use a free text query. Example: `prod`
        # @!attribute [rw] network_tags
        #   @return [::Array<::String>]
        #     Network tags associated with this resource. Like labels, network tags are a
        #     type of annotations used to group Google Cloud resources. See [Labelling
        #     Google Cloud
        #     resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
        #     for more information. This field is available only when the resource's
        #     Protobuf contains it.
        #
        #     To search against the `network_tags`:
        #
        #     * Use a field query. Example: `networkTags:internal`
        #     * Use a free text query. Example: `internal`
        # @!attribute [rw] kms_key
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The Cloud KMS
        #     [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
        #     name or
        #     [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
        #     name.
        #
        #     This field only presents for the purpose of backward compatibility.
        #     Use the `kms_keys` field to retrieve Cloud KMS key information. This field
        #     is available only when the resource's Protobuf contains it and will only be
        #     populated for [these resource
        #     types](https://cloud.google.com/asset-inventory/docs/legacy-field-names#resource_types_with_the_to_be_deprecated_kmskey_field)
        #     for backward compatible purposes.
        #
        #     To search against the `kms_key`:
        #
        #     * Use a field query. Example: `kmsKey:key`
        #     * Use a free text query. Example: `key`
        # @!attribute [rw] kms_keys
        #   @return [::Array<::String>]
        #     The Cloud KMS
        #     [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
        #     names or
        #     [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
        #     names. This field is available only when the resource's Protobuf contains
        #     it.
        #
        #     To search against the `kms_keys`:
        #
        #     * Use a field query. Example: `kmsKeys:key`
        #     * Use a free text query. Example: `key`
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The create timestamp of this resource, at which the resource was created.
        #     The granularity is in seconds. Timestamp.nanos will always be 0. This field
        #     is available only when the resource's Protobuf contains it.
        #
        #     To search against `create_time`:
        #
        #     * Use a field query.
        #         - value in seconds since unix epoch. Example: `createTime > 1609459200`
        #         - value in date string. Example: `createTime > 2021-01-01`
        #         - value in date-time string (must be quoted). Example: `createTime >
        #         "2021-01-01T00:00:00"`
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update timestamp of this resource, at which the resource was last
        #     modified or deleted. The granularity is in seconds. Timestamp.nanos will
        #     always be 0. This field is available only when the resource's Protobuf
        #     contains it.
        #
        #     To search against `update_time`:
        #
        #     * Use a field query.
        #         - value in seconds since unix epoch. Example: `updateTime < 1609459200`
        #         - value in date string. Example: `updateTime < 2021-01-01`
        #         - value in date-time string (must be quoted). Example: `updateTime <
        #         "2021-01-01T00:00:00"`
        # @!attribute [rw] state
        #   @return [::String]
        #     The state of this resource. Different resources types have different state
        #     definitions that are mapped from various fields of different resource
        #     types. This field is available only when the resource's Protobuf contains
        #     it.
        #
        #     Example:
        #     If the resource is an instance provided by Compute Engine,
        #     its state will include PROVISIONING, STAGING, RUNNING, STOPPING,
        #     SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. See `status` definition
        #     in [API
        #     Reference](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
        #     If the resource is a project provided by Resource Manager, its state
        #     will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
        #     DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
        #     Reference](https://cloud.google.com/resource-manager/reference/rest/v1/projects).
        #
        #     To search against the `state`:
        #
        #     * Use a field query. Example: `state:RUNNING`
        #     * Use a free text query. Example: `RUNNING`
        # @!attribute [rw] additional_attributes
        #   @return [::Google::Protobuf::Struct]
        #     The additional searchable attributes of this resource. The attributes may
        #     vary from one resource type to another. Examples: `projectId` for Project,
        #     `dnsName` for DNS ManagedZone. This field contains a subset of the resource
        #     metadata fields that are returned by the List or Get APIs provided by the
        #     corresponding Google Cloud service (e.g., Compute Engine). see [API
        #     references and supported searchable
        #     attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        #     to see which fields are included.
        #
        #     You can search values of these fields through free text search. However,
        #     you should not consume the field programically as the field names and
        #     values may change as the Google Cloud service updates to a new incompatible
        #     API version.
        #
        #     To search against the `additional_attributes`:
        #
        #     * Use a free text query to match the attributes values. Example: to search
        #       `additional_attributes = { dnsName: "foobar" }`, you can issue a query
        #       `foobar`.
        # @!attribute [rw] parent_full_resource_name
        #   @return [::String]
        #     The full resource name of this resource's parent, if it has one.
        #     To search against the `parent_full_resource_name`:
        #
        #     * Use a field query. Example:
        #     `parentFullResourceName:"project-name"`
        #     * Use a free text query. Example:
        #     `project-name`
        # @!attribute [rw] versioned_resources
        #   @return [::Array<::Google::Cloud::Asset::V1::VersionedResource>]
        #     Versioned resource representations of this resource. This is repeated
        #     because there could be multiple versions of resource representations during
        #     version migration.
        #
        #     This `versioned_resources` field is not searchable. Some attributes of the
        #     resource representations are exposed in `additional_attributes` field, so
        #     as to allow users to search on them.
        # @!attribute [rw] attached_resources
        #   @return [::Array<::Google::Cloud::Asset::V1::AttachedResource>]
        #     Attached resources of this resource. For example, an OSConfig
        #     Inventory is an attached resource of a Compute Instance. This field is
        #     repeated because a resource could have multiple attached resources.
        #
        #     This `attached_resources` field is not searchable. Some attributes
        #     of the attached resources are exposed in `additional_attributes` field, so
        #     as to allow users to search on them.
        # @!attribute [rw] relationships
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Asset::V1::RelatedResources}]
        #     A map of related resources of this resource, keyed by the
        #     relationship type. A relationship type is in the format of
        #     \\{SourceType}_\\{ACTION}_\\{DestType}. Example: `DISK_TO_INSTANCE`,
        #     `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`.
        #     See [supported relationship
        #     types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#supported_relationship_types).
        # @!attribute [rw] tag_keys
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::String>]
        #     This field is only present for the purpose of backward compatibility.
        #     Use the `tags` field instead.
        #
        #     TagKey namespaced names, in the format of \\{ORG_ID}/\\{TAG_KEY_SHORT_NAME}.
        #     To search against the `tagKeys`:
        #
        #     * Use a field query. Example:
        #         - `tagKeys:"123456789/env*"`
        #         - `tagKeys="123456789/env"`
        #         - `tagKeys:"env"`
        #
        #     * Use a free text query. Example:
        #         - `env`
        # @!attribute [rw] tag_values
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::String>]
        #     This field is only present for the purpose of backward compatibility.
        #     Use the `tags` field instead.
        #
        #     TagValue namespaced names, in the format of
        #     \\{ORG_ID}/\\{TAG_KEY_SHORT_NAME}/\\{TAG_VALUE_SHORT_NAME}.
        #     To search against the `tagValues`:
        #
        #     * Use a field query. Example:
        #         - `tagValues:"env"`
        #         - `tagValues:"env/prod"`
        #         - `tagValues:"123456789/env/prod*"`
        #         - `tagValues="123456789/env/prod"`
        #
        #     * Use a free text query. Example:
        #         - `prod`
        # @!attribute [rw] tag_value_ids
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::String>]
        #     This field is only present for the purpose of backward compatibility.
        #     Use the `tags` field instead.
        #
        #     TagValue IDs, in the format of tagValues/\\{TAG_VALUE_ID}.
        #     To search against the `tagValueIds`:
        #
        #     * Use a field query. Example:
        #         - `tagValueIds="tagValues/456"`
        #
        #     * Use a free text query. Example:
        #         - `456`
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::Asset::V1::Tag>]
        #     The tags directly attached to this resource.
        #
        #     To search against the `tags`:
        #
        #     * Use a field query. Example:
        #         - `tagKeys:"123456789/env*"`
        #         - `tagKeys="123456789/env"`
        #         - `tagKeys:"env"`
        #         - `tagKeyIds="tagKeys/123"`
        #         - `tagValues:"env"`
        #         - `tagValues:"env/prod"`
        #         - `tagValues:"123456789/env/prod*"`
        #         - `tagValues="123456789/env/prod"`
        #         - `tagValueIds="tagValues/456"`
        #
        #     * Use a free text query. Example:
        #         - `env/prod`
        # @!attribute [rw] effective_tags
        #   @return [::Array<::Google::Cloud::Asset::V1::EffectiveTagDetails>]
        #     The effective tags on this resource. All of the tags that are both attached
        #     to and inherited by a resource are collectively called the effective
        #     tags. For more information, see [tag
        #     inheritance](https://cloud.google.com/resource-manager/docs/tags/tags-overview#inheritance).
        #
        #     To search against the `effective_tags`:
        #
        #     * Use a field query. Example:
        #         - `effectiveTagKeys:"123456789/env*"`
        #         - `effectiveTagKeys="123456789/env"`
        #         - `effectiveTagKeys:"env"`
        #         - `effectiveTagKeyIds="tagKeys/123"`
        #         - `effectiveTagValues:"env"`
        #         - `effectiveTagValues:"env/prod"`
        #         - `effectiveTagValues:"123456789/env/prod*"`
        #         - `effectiveTagValues="123456789/env/prod"`
        #         - `effectiveTagValueIds="tagValues/456"`
        # @!attribute [rw] enrichments
        #   @return [::Array<::Google::Cloud::Asset::V1::AssetEnrichment>]
        #     Enrichments of the asset. Currently supported enrichment types with
        #     SearchAllResources API:
        #
        #     * RESOURCE_OWNERS
        #
        #     The corresponding read masks in order to get the enrichment:
        #
        #     * enrichments.resource_owners
        #
        #     The corresponding required permissions:
        #
        #     * cloudasset.assets.searchEnrichmentResourceOwners
        #
        #     Example query to get resource owner enrichment:
        #     ```
        #       scope: "projects/my-project"
        #       query: "name: my-project"
        #       assetTypes: "cloudresourcemanager.googleapis.com/Project"
        #       readMask: {
        #          paths: "asset_type"
        #          paths: "name"
        #          paths: "enrichments.resource_owners"
        #       }
        #     ```
        # @!attribute [rw] parent_asset_type
        #   @return [::String]
        #     The type of this resource's immediate parent, if there is one.
        #
        #     To search against the `parent_asset_type`:
        #
        #     * Use a field query. Example:
        #     `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
        #     * Use a free text query. Example:
        #     `cloudresourcemanager.googleapis.com/Project`
        # @!attribute [rw] scc_security_marks
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The actual content of Security Command Center security marks associated
        #     with the asset.
        #
        #
        #     To search against SCC SecurityMarks field:
        #
        #       * Use a field query:
        #         - query by a given key value pair. Example: `sccSecurityMarks.foo=bar`
        #         - query by a given key's existence. Example: `sccSecurityMarks.foo:*`
        class ResourceSearchResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Asset::V1::RelatedResources]
          class RelationshipsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SccSecurityMarksEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Resource representation as defined by the corresponding service providing the
        # resource for a given API version.
        # @!attribute [rw] version
        #   @return [::String]
        #     API version of the resource.
        #
        #     Example:
        #     If the resource is an instance provided by Compute Engine v1 API as defined
        #     in `https://cloud.google.com/compute/docs/reference/rest/v1/instances`,
        #     version will be "v1".
        # @!attribute [rw] resource
        #   @return [::Google::Protobuf::Struct]
        #     JSON representation of the resource as defined by the corresponding
        #     service providing this resource.
        #
        #     Example:
        #     If the resource is an instance provided by Compute Engine, this field will
        #     contain the JSON representation of the instance as defined by Compute
        #     Engine:
        #     `https://cloud.google.com/compute/docs/reference/rest/v1/instances`.
        #
        #     You can find the resource definition for each supported resource type in
        #     this table:
        #     `https://cloud.google.com/asset-inventory/docs/supported-asset-types`
        class VersionedResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Attached resource representation, which is defined by the corresponding
        # service provider. It represents an attached resource's payload.
        # @!attribute [rw] asset_type
        #   @return [::String]
        #     The type of this attached resource.
        #
        #     Example: `osconfig.googleapis.com/Inventory`
        #
        #     You can find the supported attached asset types of each resource in this
        #     table:
        #     `https://cloud.google.com/asset-inventory/docs/supported-asset-types`
        # @!attribute [rw] versioned_resources
        #   @return [::Array<::Google::Cloud::Asset::V1::VersionedResource>]
        #     Versioned resource representations of this attached resource. This is
        #     repeated because there could be multiple versions of the attached resource
        #     representations during version migration.
        class AttachedResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The related resources of the primary resource.
        # @!attribute [rw] related_resources
        #   @return [::Array<::Google::Cloud::Asset::V1::RelatedResource>]
        #     The detailed related resources of the primary resource.
        class RelatedResources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The detailed related resource.
        # @!attribute [rw] asset_type
        #   @return [::String]
        #     The type of the asset. Example: `compute.googleapis.com/Instance`
        # @!attribute [rw] full_resource_name
        #   @return [::String]
        #     The full resource name of the related resource. Example:
        #     `//compute.googleapis.com/projects/my_proj_123/zones/instance/instance123`
        class RelatedResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A result of IAM Policy search, containing information of an IAM policy.
        # @!attribute [rw] resource
        #   @return [::String]
        #     The full resource name of the resource associated with this IAM policy.
        #     Example:
        #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
        #     See [Cloud Asset Inventory Resource Name
        #     Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     for more information.
        #
        #     To search against the `resource`:
        #
        #     * use a field query. Example: `resource:organizations/123`
        # @!attribute [rw] asset_type
        #   @return [::String]
        #     The type of the resource associated with this IAM policy. Example:
        #     `compute.googleapis.com/Disk`.
        #
        #     To search against the `asset_type`:
        #
        #     * specify the `asset_types` field in your search request.
        # @!attribute [rw] project
        #   @return [::String]
        #     The project that the associated Google Cloud resource belongs to, in the
        #     form of projects/\\{PROJECT_NUMBER}. If an IAM policy is set on a resource
        #     (like VM instance, Cloud Storage bucket), the project field will indicate
        #     the project that contains the resource. If an IAM policy is set on a folder
        #     or organization, this field will be empty.
        #
        #     To search against the `project`:
        #
        #     * specify the `scope` field as this project in your search request.
        # @!attribute [rw] folders
        #   @return [::Array<::String>]
        #     The folder(s) that the IAM policy belongs to, in the form of
        #     folders/\\{FOLDER_NUMBER}. This field is available when the IAM policy
        #     belongs to one or more folders.
        #
        #     To search against `folders`:
        #
        #     * use a field query. Example: `folders:(123 OR 456)`
        #     * use a free text query. Example: `123`
        #     * specify the `scope` field as this folder in your search request.
        # @!attribute [rw] organization
        #   @return [::String]
        #     The organization that the IAM policy belongs to, in the form
        #     of organizations/\\{ORGANIZATION_NUMBER}. This field is available when the
        #     IAM policy belongs to an organization.
        #
        #     To search against `organization`:
        #
        #     * use a field query. Example: `organization:123`
        #     * use a free text query. Example: `123`
        #     * specify the `scope` field as this organization in your search request.
        # @!attribute [rw] policy
        #   @return [::Google::Iam::V1::Policy]
        #     The IAM policy directly set on the given resource. Note that the original
        #     IAM policy can contain multiple bindings. This only contains the bindings
        #     that match the given query. For queries that don't contain a constrain on
        #     policies (e.g., an empty query), this contains all the bindings.
        #
        #     To search against the `policy` bindings:
        #
        #     * use a field query:
        #         - query by the policy contained members. Example:
        #           `policy:amy@gmail.com`
        #         - query by the policy contained roles. Example:
        #           `policy:roles/compute.admin`
        #         - query by the policy contained roles' included permissions. Example:
        #           `policy.role.permissions:compute.instances.create`
        # @!attribute [rw] explanation
        #   @return [::Google::Cloud::Asset::V1::IamPolicySearchResult::Explanation]
        #     Explanation about the IAM policy search result. It contains additional
        #     information to explain why the search result matches the query.
        class IamPolicySearchResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Explanation about the IAM policy search result.
          # @!attribute [rw] matched_permissions
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Asset::V1::IamPolicySearchResult::Explanation::Permissions}]
          #     The map from roles to their included permissions that match the
          #     permission query (i.e., a query containing `policy.role.permissions:`).
          #     Example: if query `policy.role.permissions:compute.disk.get`
          #     matches a policy binding that contains owner role, the
          #     matched_permissions will be `{"roles/owner": ["compute.disk.get"]}`. The
          #     roles can also be found in the returned `policy` bindings. Note that the
          #     map is populated only for requests with permission queries.
          class Explanation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # IAM permissions
            # @!attribute [rw] permissions
            #   @return [::Array<::String>]
            #     A list of permissions. A sample permission string: `compute.disk.get`.
            class Permissions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Asset::V1::IamPolicySearchResult::Explanation::Permissions]
            class MatchedPermissionsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Represents the detailed state of an entity under analysis, such as a
        # resource, an identity or an access.
        # @!attribute [rw] code
        #   @return [::Google::Rpc::Code]
        #     The Google standard error code that best describes the state.
        #     For example:
        #     - OK means the analysis on this entity has been successfully finished;
        #     - PERMISSION_DENIED means an access denied error is encountered;
        #     - DEADLINE_EXCEEDED means the analysis on this entity hasn't been started
        #     in time;
        # @!attribute [rw] cause
        #   @return [::String]
        #     The human-readable description of the cause of failure.
        class IamPolicyAnalysisState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The condition evaluation.
        # @!attribute [rw] evaluation_value
        #   @return [::Google::Cloud::Asset::V1::ConditionEvaluation::EvaluationValue]
        #     The evaluation result.
        class ConditionEvaluation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Value of this expression.
          module EvaluationValue
            # Reserved for future use.
            EVALUATION_VALUE_UNSPECIFIED = 0

            # The evaluation result is `true`.
            TRUE = 1

            # The evaluation result is `false`.
            FALSE = 2

            # The evaluation result is `conditional` when the condition expression
            # contains variables that are either missing input values or have not been
            # supported by Policy Analyzer yet.
            CONDITIONAL = 3
          end
        end

        # IAM Policy analysis result, consisting of one IAM policy binding and derived
        # access control lists.
        # @!attribute [rw] attached_resource_full_name
        #   @return [::String]
        #     The [full resource
        #     name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     of the resource to which the
        #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult#iam_binding iam_binding}
        #     policy attaches.
        # @!attribute [rw] iam_binding
        #   @return [::Google::Iam::V1::Binding]
        #     The IAM policy binding under analysis.
        # @!attribute [rw] access_control_lists
        #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::AccessControlList>]
        #     The access control lists derived from the
        #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult#iam_binding iam_binding}
        #     that match or potentially match resource and access selectors specified in
        #     the request.
        # @!attribute [rw] identity_list
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::IdentityList]
        #     The identity list derived from members of the
        #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult#iam_binding iam_binding}
        #     that match or potentially match identity selector specified in the request.
        # @!attribute [rw] fully_explored
        #   @return [::Boolean]
        #     Represents whether all analyses on the
        #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult#iam_binding iam_binding}
        #     have successfully finished.
        class IamPolicyAnalysisResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A Google Cloud resource under analysis.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     The [full resource
          #     name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
          # @!attribute [rw] analysis_state
          #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisState]
          #     The analysis state of this resource.
          class Resource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An IAM role or permission under analysis.
          # @!attribute [rw] role
          #   @return [::String]
          #     The role.
          #
          #     Note: The following fields are mutually exclusive: `role`, `permission`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] permission
          #   @return [::String]
          #     The permission.
          #
          #     Note: The following fields are mutually exclusive: `permission`, `role`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] analysis_state
          #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisState]
          #     The analysis state of this access.
          class Access
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An identity under analysis.
          # @!attribute [rw] name
          #   @return [::String]
          #     The identity of members, formatted as appear in an
          #     [IAM policy
          #     binding](https://cloud.google.com/iam/reference/rest/v1/Binding). For
          #     example, they might be formatted like the following:
          #
          #     - user:foo@google.com
          #     - group:group1@google.com
          #     - serviceAccount:s1@prj1.iam.gserviceaccount.com
          #     - projectOwner:some_project_id
          #     - domain:google.com
          #     - allUsers
          # @!attribute [rw] analysis_state
          #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisState]
          #     The analysis state of this identity.
          class Identity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A directional edge.
          # @!attribute [rw] source_node
          #   @return [::String]
          #     The source node of the edge. For example, it could be a full resource
          #     name for a resource node or an email of an identity.
          # @!attribute [rw] target_node
          #   @return [::String]
          #     The target node of the edge. For example, it could be a full resource
          #     name for a resource node or an email of an identity.
          class Edge
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An access control list, derived from the above IAM policy binding, which
          # contains a set of resources and accesses. May include one
          # item from each set to compose an access control entry.
          #
          # NOTICE that there could be multiple access control lists for one IAM policy
          # binding. The access control lists are created based on resource and access
          # combinations.
          #
          # For example, assume we have the following cases in one IAM policy binding:
          # - Permission P1 and P2 apply to resource R1 and R2;
          # - Permission P3 applies to resource R2 and R3;
          #
          # This will result in the following access control lists:
          # - AccessControlList 1: [R1, R2], [P1, P2]
          # - AccessControlList 2: [R2, R3], [P3]
          # @!attribute [rw] resources
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Resource>]
          #     The resources that match one of the following conditions:
          #     - The resource_selector, if it is specified in request;
          #     - Otherwise, resources reachable from the policy attached resource.
          # @!attribute [rw] accesses
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Access>]
          #     The accesses that match one of the following conditions:
          #     - The access_selector, if it is specified in request;
          #     - Otherwise, access specifiers reachable from the policy binding's role.
          # @!attribute [rw] resource_edges
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Edge>]
          #     Resource edges of the graph starting from the policy attached
          #     resource to any descendant resources. The
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Edge#source_node Edge.source_node}
          #     contains the full resource name of a parent resource and
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Edge#target_node Edge.target_node}
          #     contains the full resource name of a child resource. This field is
          #     present only if the output_resource_edges option is enabled in request.
          # @!attribute [rw] condition_evaluation
          #   @return [::Google::Cloud::Asset::V1::ConditionEvaluation]
          #     Condition evaluation for this AccessControlList, if there is a condition
          #     defined in the above IAM policy binding.
          class AccessControlList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The identities and group edges.
          # @!attribute [rw] identities
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Identity>]
          #     Only the identities that match one of the following conditions will be
          #     presented:
          #     - The identity_selector, if it is specified in request;
          #     - Otherwise, identities reachable from the policy binding's members.
          # @!attribute [rw] group_edges
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Edge>]
          #     Group identity edges of the graph starting from the binding's
          #     group members to any node of the
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::IdentityList#identities identities}.
          #     The
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Edge#source_node Edge.source_node}
          #     contains a group, such as `group:parent@google.com`. The
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult::Edge#target_node Edge.target_node}
          #     contains a member of the group, such as `group:child@google.com` or
          #     `user:foo@google.com`. This field is present only if the
          #     output_group_edges option is enabled in request.
          class IdentityList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
