# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Asset
      module V1
        # Represents the metadata of the longrunning operation for the
        # AnalyzeIamPolicyLongrunning RPC.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        class AnalyzeIamPolicyLongrunningMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Export asset request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative name of the root asset. This can only be an
        #     organization number (such as "organizations/123"), a project ID (such as
        #     "projects/my-project-id"), or a project number (such as "projects/12345"),
        #     or a folder number (such as "folders/123").
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp to take an asset snapshot. This can only be set to a timestamp
        #     between the current time and the current time minus 35 days (inclusive).
        #     If not specified, the current time will be used. Due to delays in resource
        #     data collection and indexing, there is a volatile window during which
        #     running the same query may get different results.
        # @!attribute [rw] asset_types
        #   @return [::Array<::String>]
        #     A list of asset types to take a snapshot for. For example:
        #     "compute.googleapis.com/Disk".
        #
        #     Regular expressions are also supported. For example:
        #
        #     * "compute.googleapis.com.*" snapshots resources whose asset type starts
        #     with "compute.googleapis.com".
        #     * ".*Instance" snapshots resources whose asset type ends with "Instance".
        #     * ".*Instance.*" snapshots resources whose asset type contains "Instance".
        #
        #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
        #     regular expression syntax. If the regular expression does not match any
        #     supported asset type, an INVALID_ARGUMENT error will be returned.
        #
        #     If specified, only matching assets will be returned, otherwise, it will
        #     snapshot all asset types. See [Introduction to Cloud Asset
        #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
        #     for all supported asset types.
        # @!attribute [rw] content_type
        #   @return [::Google::Cloud::Asset::V1::ContentType]
        #     Asset content type. If not specified, no content but the asset name will be
        #     returned.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Asset::V1::OutputConfig]
        #     Required. Output configuration indicating where the results will be output
        #     to.
        # @!attribute [rw] relationship_types
        #   @return [::Array<::String>]
        #     A list of relationship types to export, for example:
        #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
        #     content_type=RELATIONSHIP.
        #     * If specified:
        #     it snapshots specified relationships. It returns an error if
        #     any of the [relationship_types] doesn't belong to the supported
        #     relationship types of the [asset_types] or if any of the [asset_types]
        #     doesn't belong to the source types of the [relationship_types].
        #     * Otherwise:
        #     it snapshots the supported relationships for all [asset_types] or returns
        #     an error if any of the [asset_types] has no relationship support.
        #     An unspecified asset types field means all supported asset_types.
        #     See [Introduction to Cloud Asset
        #     Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
        #     supported asset types and relationship types.
        class ExportAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The export asset response. This message is returned by the
        # google.longrunning.Operations.GetOperation
        # method in the returned
        # {::Google::Longrunning::Operation#response google.longrunning.Operation.response}
        # field.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the snapshot was taken.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Asset::V1::OutputConfig]
        #     Output configuration indicating where the results were output to.
        # @!attribute [rw] output_result
        #   @return [::Google::Cloud::Asset::V1::OutputResult]
        #     Output result indicating where the assets were exported to. For example, a
        #     set of actual Cloud Storage object URIs where the assets are exported to.
        #     The URIs can be different from what [output_config] has specified, as the
        #     service will split the output object into multiple ones once it exceeds a
        #     single Cloud Storage object limit.
        class ExportAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListAssets request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the organization, folder, or project the assets belong
        #     to. Format: "organizations/[organization-number]" (such as
        #     "organizations/123"), "projects/[project-id]" (such as
        #     "projects/my-project-id"), "projects/[project-number]" (such as
        #     "projects/12345"), or "folders/[folder-number]" (such as "folders/12345").
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp to take an asset snapshot. This can only be set to a timestamp
        #     between the current time and the current time minus 35 days (inclusive).
        #     If not specified, the current time will be used. Due to delays in resource
        #     data collection and indexing, there is a volatile window during which
        #     running the same query may get different results.
        # @!attribute [rw] asset_types
        #   @return [::Array<::String>]
        #     A list of asset types to take a snapshot for. For example:
        #     "compute.googleapis.com/Disk".
        #
        #     Regular expression is also supported. For example:
        #
        #     * "compute.googleapis.com.*" snapshots resources whose asset type starts
        #     with "compute.googleapis.com".
        #     * ".*Instance" snapshots resources whose asset type ends with "Instance".
        #     * ".*Instance.*" snapshots resources whose asset type contains "Instance".
        #
        #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
        #     regular expression syntax. If the regular expression does not match any
        #     supported asset type, an INVALID_ARGUMENT error will be returned.
        #
        #     If specified, only matching assets will be returned, otherwise, it will
        #     snapshot all asset types. See [Introduction to Cloud Asset
        #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
        #     for all supported asset types.
        # @!attribute [rw] content_type
        #   @return [::Google::Cloud::Asset::V1::ContentType]
        #     Asset content type. If not specified, no content but the asset name will
        #     be returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of assets to be returned in a single response. Default
        #     is 100, minimum is 1, and maximum is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The `next_page_token` returned from the previous `ListAssetsResponse`, or
        #     unspecified for the first `ListAssetsRequest`. It is a continuation of a
        #     prior `ListAssets` call, and the API should return the next page of assets.
        # @!attribute [rw] relationship_types
        #   @return [::Array<::String>]
        #     A list of relationship types to output, for example:
        #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
        #     content_type=RELATIONSHIP.
        #     * If specified:
        #     it snapshots specified relationships. It returns an error if
        #     any of the [relationship_types] doesn't belong to the supported
        #     relationship types of the [asset_types] or if any of the [asset_types]
        #     doesn't belong to the source types of the [relationship_types].
        #     * Otherwise:
        #     it snapshots the supported relationships for all [asset_types] or returns
        #     an error if any of the [asset_types] has no relationship support.
        #     An unspecified asset types field means all supported asset_types.
        #     See [Introduction to Cloud Asset
        #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
        #     for all supported asset types and relationship types.
        class ListAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListAssets response.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the snapshot was taken.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::Asset::V1::Asset>]
        #     Assets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. It expires 72 hours after the
        #     page token for the first page is generated. Set to empty if there are no
        #     remaining results.
        class ListAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Batch get assets history request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative name of the root asset. It can only be an
        #     organization number (such as "organizations/123"), a project ID (such as
        #     "projects/my-project-id")", or a project number (such as "projects/12345").
        # @!attribute [rw] asset_names
        #   @return [::Array<::String>]
        #     A list of the full names of the assets.
        #     See: https://cloud.google.com/asset-inventory/docs/resource-name-format
        #     Example:
        #
        #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
        #
        #     The request becomes a no-op if the asset name list is empty, and the max
        #     size of the asset name list is 100 in one request.
        # @!attribute [rw] content_type
        #   @return [::Google::Cloud::Asset::V1::ContentType]
        #     Optional. The content type.
        # @!attribute [rw] read_time_window
        #   @return [::Google::Cloud::Asset::V1::TimeWindow]
        #     Optional. The time window for the asset history. Both start_time and
        #     end_time are optional and if set, it must be after the current time minus
        #     35 days. If end_time is not set, it is default to current timestamp.
        #     If start_time is not set, the snapshot of the assets at end_time will be
        #     returned. The returned results contain all temporal assets whose time
        #     window overlap with read_time_window.
        # @!attribute [rw] relationship_types
        #   @return [::Array<::String>]
        #     Optional. A list of relationship types to output, for example:
        #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
        #     content_type=RELATIONSHIP.
        #     * If specified:
        #     it outputs specified relationships' history on the [asset_names]. It
        #     returns an error if any of the [relationship_types] doesn't belong to the
        #     supported relationship types of the [asset_names] or if any of the
        #     [asset_names]'s types doesn't belong to the source types of the
        #     [relationship_types].
        #     * Otherwise:
        #     it outputs the supported relationships' history on the [asset_names] or
        #     returns an error if any of the [asset_names]'s types has no relationship
        #     support.
        #     See [Introduction to Cloud Asset
        #     Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
        #     supported asset types and relationship types.
        class BatchGetAssetsHistoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Batch get assets history response.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::Asset::V1::TemporalAsset>]
        #     A list of assets with valid time windows.
        class BatchGetAssetsHistoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create asset feed request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project/folder/organization where this feed
        #     should be created in. It can only be an organization number (such as
        #     "organizations/123"), a folder number (such as "folders/123"), a project ID
        #     (such as "projects/my-project-id"), or a project number (such as
        #     "projects/12345").
        # @!attribute [rw] feed_id
        #   @return [::String]
        #     Required. This is the client-assigned asset feed identifier and it needs to
        #     be unique under a specific parent project/folder/organization.
        # @!attribute [rw] feed
        #   @return [::Google::Cloud::Asset::V1::Feed]
        #     Required. The feed details. The field `name` must be empty and it will be
        #     generated in the format of: projects/project_number/feeds/feed_id
        #     folders/folder_number/feeds/feed_id
        #     organizations/organization_number/feeds/feed_id
        class CreateFeedRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get asset feed request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Feed and it must be in the format of:
        #     projects/project_number/feeds/feed_id
        #     folders/folder_number/feeds/feed_id
        #     organizations/organization_number/feeds/feed_id
        class GetFeedRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List asset feeds request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent project/folder/organization whose feeds are to be
        #     listed. It can only be using project/folder/organization number (such as
        #     "folders/12345")", or a project ID (such as "projects/my-project-id").
        class ListFeedsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] feeds
        #   @return [::Array<::Google::Cloud::Asset::V1::Feed>]
        #     A list of feeds.
        class ListFeedsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update asset feed request.
        # @!attribute [rw] feed
        #   @return [::Google::Cloud::Asset::V1::Feed]
        #     Required. The new values of feed details. It must match an existing feed
        #     and the field `name` must be in the format of:
        #     projects/project_number/feeds/feed_id or
        #     folders/folder_number/feeds/feed_id or
        #     organizations/organization_number/feeds/feed_id.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Only updates the `feed` fields indicated by this mask.
        #     The field mask must not be empty, and it must not contain fields that
        #     are immutable or only set by the server.
        class UpdateFeedRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the feed and it must be in the format of:
        #     projects/project_number/feeds/feed_id
        #     folders/folder_number/feeds/feed_id
        #     organizations/organization_number/feeds/feed_id
        class DeleteFeedRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configuration for export assets destination.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Asset::V1::GcsDestination]
        #     Destination on Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `gcs_destination`, `bigquery_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::Asset::V1::BigQueryDestination]
        #     Destination on BigQuery. The output table stores the fields in asset
        #     Protobuf as columns in BigQuery.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_destination`, `gcs_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output result of export assets.
        # @!attribute [rw] gcs_result
        #   @return [::Google::Cloud::Asset::V1::GcsOutputResult]
        #     Export result on Cloud Storage.
        class OutputResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Cloud Storage output result.
        # @!attribute [rw] uris
        #   @return [::Array<::String>]
        #     List of URIs of the Cloud Storage objects. Example:
        #     "gs://bucket_name/object_name".
        class GcsOutputResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Cloud Storage location.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the Cloud Storage object. It's the same URI that is used by
        #     gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
        #     Editing Object
        #     Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
        #     for more information.
        #
        #     If the specified Cloud Storage object already exists and there is no
        #     [hold](https://cloud.google.com/storage/docs/object-holds), it will be
        #     overwritten with the exported result.
        #
        #     Note: The following fields are mutually exclusive: `uri`, `uri_prefix`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] uri_prefix
        #   @return [::String]
        #     The URI prefix of all generated Cloud Storage objects. Example:
        #     "gs://bucket_name/object_name_prefix". Each object URI is in format:
        #     "gs://bucket_name/object_name_prefix/<asset type>/<shard number> and only
        #     contains assets for that type. <shard number> starts from 0. Example:
        #     "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
        #     the first shard of output objects containing all
        #     compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
        #     returned if file with the same name "gs://bucket_name/object_name_prefix"
        #     already exists.
        #
        #     Note: The following fields are mutually exclusive: `uri_prefix`, `uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class GcsDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A BigQuery destination for exporting assets to.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The BigQuery dataset in format
        #     "projects/projectId/datasets/datasetId", to which the snapshot result
        #     should be exported. If this dataset does not exist, the export call returns
        #     an INVALID_ARGUMENT error. Setting the `contentType` for `exportAssets`
        #     determines the
        #     [schema](/asset-inventory/docs/exporting-to-bigquery#bigquery-schema)
        #     of the BigQuery table. Setting `separateTablesPerAssetType` to `TRUE` also
        #     influences the schema.
        # @!attribute [rw] table
        #   @return [::String]
        #     Required. The BigQuery table to which the snapshot result should be
        #     written. If this table does not exist, a new table with the given name
        #     will be created.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If the destination table already exists and this flag is `TRUE`, the
        #     table will be overwritten by the contents of assets snapshot. If the flag
        #     is `FALSE` or unset and the destination table already exists, the export
        #     call returns an INVALID_ARGUMEMT error.
        # @!attribute [rw] partition_spec
        #   @return [::Google::Cloud::Asset::V1::PartitionSpec]
        #     [partition_spec] determines whether to export to partitioned table(s) and
        #     how to partition the data.
        #
        #     If [partition_spec] is unset or [partition_spec.partition_key] is unset or
        #     `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported to
        #     non-partitioned table(s). [force] will decide whether to overwrite existing
        #     table(s).
        #
        #     If [partition_spec] is specified. First, the snapshot results will be
        #     written to partitioned table(s) with two additional timestamp columns,
        #     readTime and requestTime, one of which will be the partition key. Secondly,
        #     in the case when any destination table already exists, it will first try to
        #     update existing table's schema as necessary by appending additional
        #     columns. Then, if [force] is `TRUE`, the corresponding partition will be
        #     overwritten by the snapshot results (data in different partitions will
        #     remain intact); if [force] is unset or `FALSE`, it will append the data. An
        #     error will be returned if the schema update or data appension fails.
        # @!attribute [rw] separate_tables_per_asset_type
        #   @return [::Boolean]
        #     If this flag is `TRUE`, the snapshot results will be written to one or
        #     multiple tables, each of which contains results of one asset type. The
        #     [force] and [partition_spec] fields will apply to each of them.
        #
        #     Field [table] will be concatenated with "_" and the asset type names (see
        #     https://cloud.google.com/asset-inventory/docs/supported-asset-types for
        #     supported asset types) to construct per-asset-type table names, in which
        #     all non-alphanumeric characters like "." and "/" will be substituted by
        #     "_". Example: if field [table] is "mytable" and snapshot results
        #     contain "storage.googleapis.com/Bucket" assets, the corresponding table
        #     name will be "mytable_storage_googleapis_com_Bucket". If any of these
        #     tables does not exist, a new table with the concatenated name will be
        #     created.
        #
        #     When [content_type] in the ExportAssetsRequest is `RESOURCE`, the schema of
        #     each table will include RECORD-type columns mapped to the nested fields in
        #     the Asset.resource.data field of that asset type (up to the 15 nested level
        #     BigQuery supports
        #     (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)). The
        #     fields in >15 nested levels will be stored in JSON format string as a child
        #     column of its parent RECORD column.
        #
        #     If error occurs when exporting to any table, the whole export call will
        #     return an error but the export results that already succeed will persist.
        #     Example: if exporting to table_type_A succeeds when exporting to
        #     table_type_B fails during one export call, the results in table_type_A will
        #     persist and there will not be partial results persisting in a table.
        class BigQueryDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifications of BigQuery partitioned table as export destination.
        # @!attribute [rw] partition_key
        #   @return [::Google::Cloud::Asset::V1::PartitionSpec::PartitionKey]
        #     The partition key for BigQuery partitioned table.
        class PartitionSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This enum is used to determine the partition key column when exporting
          # assets to BigQuery partitioned table(s). Note that, if the partition key is
          # a timestamp column, the actual partition is based on its date value
          # (expressed in UTC. see details in
          # https://cloud.google.com/bigquery/docs/partitioned-tables#date_timestamp_partitioned_tables).
          module PartitionKey
            # Unspecified partition key. If used, it means using non-partitioned table.
            PARTITION_KEY_UNSPECIFIED = 0

            # The time when the snapshot is taken. If specified as partition key, the
            # result table(s) is partitioned by the additional timestamp column,
            # readTime. If [read_time] in ExportAssetsRequest is specified, the
            # readTime column's value will be the same as it. Otherwise, its value will
            # be the current time that is used to take the snapshot.
            READ_TIME = 1

            # The time when the request is received and started to be processed. If
            # specified as partition key, the result table(s) is partitioned by the
            # requestTime column, an additional timestamp column representing when the
            # request was received.
            REQUEST_TIME = 2
          end
        end

        # A Pub/Sub destination.
        # @!attribute [rw] topic
        #   @return [::String]
        #     The name of the Pub/Sub topic to publish to.
        #     Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
        class PubsubDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configuration for asset feed destination.
        # @!attribute [rw] pubsub_destination
        #   @return [::Google::Cloud::Asset::V1::PubsubDestination]
        #     Destination on Pub/Sub.
        class FeedOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An asset feed used to export asset updates to a destinations.
        # An asset feed filter controls what updates are exported.
        # The asset feed must be created within a project, organization, or
        # folder. Supported destinations are:
        # Pub/Sub topics.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The format will be
        #     projects/\\{project_number}/feeds/\\{client-assigned_feed_identifier} or
        #     folders/\\{folder_number}/feeds/\\{client-assigned_feed_identifier} or
        #     organizations/\\{organization_number}/feeds/\\{client-assigned_feed_identifier}
        #
        #     The client-assigned feed identifier must be unique within the parent
        #     project/folder/organization.
        # @!attribute [rw] asset_names
        #   @return [::Array<::String>]
        #     A list of the full names of the assets to receive updates. You must specify
        #     either or both of asset_names and asset_types. Only asset updates matching
        #     specified asset_names or asset_types are exported to the feed.
        #     Example:
        #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
        #     For a list of the full names for supported asset types, see [Resource
        #     name format](/asset-inventory/docs/resource-name-format).
        # @!attribute [rw] asset_types
        #   @return [::Array<::String>]
        #     A list of types of the assets to receive updates. You must specify either
        #     or both of asset_names and asset_types. Only asset updates matching
        #     specified asset_names or asset_types are exported to the feed.
        #     Example: `"compute.googleapis.com/Disk"`
        #
        #     For a list of all supported asset types, see
        #     [Supported asset types](/asset-inventory/docs/supported-asset-types).
        # @!attribute [rw] content_type
        #   @return [::Google::Cloud::Asset::V1::ContentType]
        #     Asset content type. If not specified, no content but the asset name and
        #     type will be returned.
        # @!attribute [rw] feed_output_config
        #   @return [::Google::Cloud::Asset::V1::FeedOutputConfig]
        #     Required. Feed output configuration defining where the asset updates are
        #     published to.
        # @!attribute [rw] condition
        #   @return [::Google::Type::Expr]
        #     A condition which determines whether an asset update should be published.
        #     If specified, an asset will be returned only when the expression evaluates
        #     to true.
        #     When set, `expression` field in the `Expr` must be a valid [CEL expression]
        #     (https://github.com/google/cel-spec) on a TemporalAsset with name
        #     `temporal_asset`. Example: a Feed with expression ("temporal_asset.deleted
        #     == true") will only publish Asset deletions. Other fields of `Expr` are
        #     optional.
        #
        #     See our [user
        #     guide](https://cloud.google.com/asset-inventory/docs/monitoring-asset-changes-with-condition)
        #     for detailed instructions.
        # @!attribute [rw] relationship_types
        #   @return [::Array<::String>]
        #     A list of relationship types to output, for example:
        #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
        #     content_type=RELATIONSHIP.
        #     * If specified:
        #     it outputs specified relationship updates on the [asset_names] or the
        #     [asset_types]. It returns an error if any of the [relationship_types]
        #     doesn't belong to the supported relationship types of the [asset_names] or
        #     [asset_types], or any of the [asset_names] or the [asset_types] doesn't
        #     belong to the source types of the [relationship_types].
        #     * Otherwise:
        #     it outputs the supported relationships of the types of [asset_names] and
        #     [asset_types] or returns an error if any of the [asset_names] or the
        #     [asset_types] has no replationship support.
        #     See [Introduction to Cloud Asset
        #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
        #     for all supported asset types and relationship types.
        class Feed
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Search all resources request.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. A scope can be a project, a folder, or an organization. The
        #     search is limited to the resources within the `scope`. The caller must be
        #     granted the
        #     [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
        #     permission on the desired scope.
        #
        #     The allowed values are:
        #
        #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
        #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
        #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] query
        #   @return [::String]
        #     Optional. The query statement. See [how to construct a
        #     query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
        #     for more information. If not specified or empty, it will search all the
        #     resources within the specified `scope`.
        #
        #     Examples:
        #
        #     * `name:Important` to find Google Cloud resources whose name contains
        #       `Important` as a word.
        #     * `name=Important` to find the Google Cloud resource whose name is exactly
        #       `Important`.
        #     * `displayName:Impor*` to find Google Cloud resources whose display name
        #       contains `Impor` as a prefix of any word in the field.
        #     * `location:us-west*` to find Google Cloud resources whose location
        #       contains both `us` and `west` as prefixes.
        #     * `labels:prod` to find Google Cloud resources whose labels contain `prod`
        #       as a key or value.
        #     * `labels.env:prod` to find Google Cloud resources that have a label `env`
        #       and its value is `prod`.
        #     * `labels.env:*` to find Google Cloud resources that have a label `env`.
        #     * `tagKeys:env` to find Google Cloud resources that have directly
        #       attached tags where the
        #       [`TagKey.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
        #       contains `env`.
        #     * `tagValues:prod*` to find Google Cloud resources that have directly
        #       attached tags where the
        #       [`TagValue.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
        #       contains a word prefixed by `prod`.
        #     * `tagValueIds=tagValues/123` to find Google Cloud resources that have
        #       directly attached tags where the
        #       [`TagValue.name`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
        #       is exactly `tagValues/123`.
        #     * `effectiveTagKeys:env` to find Google Cloud resources that have
        #       directly attached or inherited tags where the
        #       [`TagKey.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
        #       contains `env`.
        #     * `effectiveTagValues:prod*` to find Google Cloud resources that have
        #       directly attached or inherited tags where the
        #       [`TagValue.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
        #       contains a word prefixed by `prod`.
        #     * `effectiveTagValueIds=tagValues/123` to find Google Cloud resources that
        #        have directly attached or inherited tags where the
        #       [`TagValue.name`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
        #       is exactly `tagValues/123`.
        #     * `kmsKey:key` to find Google Cloud resources encrypted with a
        #       customer-managed encryption key whose name contains `key` as a word. This
        #       field is deprecated. Use the `kmsKeys` field to retrieve Cloud KMS
        #       key information.
        #     * `kmsKeys:key` to find Google Cloud resources encrypted with
        #       customer-managed encryption keys whose name contains the word `key`.
        #     * `relationships:instance-group-1` to find Google Cloud resources that have
        #       relationships with `instance-group-1` in the related resource name.
        #     * `relationships:INSTANCE_TO_INSTANCEGROUP` to find Compute Engine
        #       instances that have relationships of type `INSTANCE_TO_INSTANCEGROUP`.
        #     * `relationships.INSTANCE_TO_INSTANCEGROUP:instance-group-1` to find
        #       Compute Engine instances that have relationships with `instance-group-1`
        #       in the Compute Engine instance group resource name, for relationship type
        #       `INSTANCE_TO_INSTANCEGROUP`.
        #     * `sccSecurityMarks.key=value` to find Cloud resources that are attached
        #       with security marks whose key is `key` and value is `value`.
        #     * `sccSecurityMarks.key:*` to find Cloud resources that are attached with
        #       security marks whose key is `key`.
        #     * `state:ACTIVE` to find Google Cloud resources whose state contains
        #       `ACTIVE` as a word.
        #     * `NOT state:ACTIVE` to find Google Cloud resources whose state doesn't
        #       contain `ACTIVE` as a word.
        #     * `createTime<1609459200` to find Google Cloud resources that were created
        #       before `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
        #       `2021-01-01 00:00:00 UTC` in seconds.
        #     * `updateTime>1609459200` to find Google Cloud resources that were updated
        #       after `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
        #       `2021-01-01 00:00:00 UTC` in seconds.
        #     * `Important` to find Google Cloud resources that contain `Important` as a
        #       word in any of the searchable fields.
        #     * `Impor*` to find Google Cloud resources that contain `Impor` as a prefix
        #       of any word in any of the searchable fields.
        #     * `Important location:(us-west1 OR global)` to find Google Cloud
        #       resources that contain `Important` as a word in any of the searchable
        #       fields and are also located in the `us-west1` region or the `global`
        #       location.
        # @!attribute [rw] asset_types
        #   @return [::Array<::String>]
        #     Optional. A list of asset types that this request searches for. If empty,
        #     it will search all the asset types [supported by search
        #     APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
        #
        #     Regular expressions are also supported. For example:
        #
        #     * "compute.googleapis.com.*" snapshots resources whose asset type starts
        #     with "compute.googleapis.com".
        #     * ".*Instance" snapshots resources whose asset type ends with "Instance".
        #     * ".*Instance.*" snapshots resources whose asset type contains "Instance".
        #
        #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
        #     regular expression syntax. If the regular expression does not match any
        #     supported asset type, an INVALID_ARGUMENT error will be returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The page size for search result pagination. Page size is capped
        #     at 500 even if a larger value is given. If set to zero or a negative value,
        #     server will pick an appropriate default. Returned results may be fewer than
        #     requested. When this happens, there could be more results as long as
        #     `next_page_token` is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. If present, then retrieve the next batch of results from the
        #     preceding call to this method. `page_token` must be the value of
        #     `next_page_token` from the previous response. The values of all other
        #     method parameters, must be identical to those in the previous call.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A comma-separated list of fields specifying the sorting order of
        #     the results. The default order is ascending. Add " DESC" after the field
        #     name to indicate descending order. Redundant space characters are ignored.
        #     Example: "location DESC, name".
        #     Only the following fields in the response are sortable:
        #
        #       * name
        #       * assetType
        #       * project
        #       * displayName
        #       * description
        #       * location
        #       * createTime
        #       * updateTime
        #       * state
        #       * parentFullResourceName
        #       * parentAssetType
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. A comma-separated list of fields that you want returned in the
        #     results. The following fields are returned by default if not specified:
        #
        #       * `name`
        #       * `assetType`
        #       * `project`
        #       * `folders`
        #       * `organization`
        #       * `displayName`
        #       * `description`
        #       * `location`
        #       * `labels`
        #       * `tags`
        #       * `effectiveTags`
        #       * `networkTags`
        #       * `kmsKeys`
        #       * `createTime`
        #       * `updateTime`
        #       * `state`
        #       * `additionalAttributes`
        #       * `parentFullResourceName`
        #       * `parentAssetType`
        #
        #     Some fields of large size, such as `versionedResources`,
        #     `attachedResources`, `effectiveTags` etc., are not returned by default, but
        #     you can specify them in the `read_mask` parameter if you want to include
        #     them. If `"*"` is specified, all [available
        #     fields](https://cloud.google.com/asset-inventory/docs/reference/rest/v1/TopLevel/searchAllResources#resourcesearchresult)
        #     are returned.
        #     Examples: `"name,location"`, `"name,versionedResources"`, `"*"`.
        #     Any invalid field path will trigger INVALID_ARGUMENT error.
        class SearchAllResourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Search all resources response.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Asset::V1::ResourceSearchResult>]
        #     A list of Resources that match the search query. It contains the resource
        #     standard metadata information.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there are more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        class SearchAllResourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Search all IAM policies request.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. A scope can be a project, a folder, or an organization. The
        #     search is limited to the IAM policies within the `scope`. The caller must
        #     be granted the
        #     [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
        #     permission on the desired scope.
        #
        #     The allowed values are:
        #
        #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
        #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
        #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] query
        #   @return [::String]
        #     Optional. The query statement. See [how to construct a
        #     query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
        #     for more information. If not specified or empty, it will search all the
        #     IAM policies within the specified `scope`. Note that the query string is
        #     compared against each IAM policy binding, including its principals,
        #     roles, and IAM conditions. The returned IAM policies will only
        #     contain the bindings that match your query. To learn more about the IAM
        #     policy structure, see the [IAM policy
        #     documentation](https://cloud.google.com/iam/help/allow-policies/structure).
        #
        #     Examples:
        #
        #     * `policy:amy@gmail.com` to find IAM policy bindings that specify user
        #       "amy@gmail.com".
        #     * `policy:roles/compute.admin` to find IAM policy bindings that specify
        #       the Compute Admin role.
        #     * `policy:comp*` to find IAM policy bindings that contain "comp" as a
        #       prefix of any word in the binding.
        #     * `policy.role.permissions:storage.buckets.update` to find IAM policy
        #       bindings that specify a role containing "storage.buckets.update"
        #       permission. Note that if callers don't have `iam.roles.get` access to a
        #       role's included permissions, policy bindings that specify this role will
        #       be dropped from the search results.
        #     * `policy.role.permissions:upd*` to find IAM policy bindings that specify a
        #       role containing "upd" as a prefix of any word in the role permission.
        #       Note that if callers don't have `iam.roles.get` access to a role's
        #       included permissions, policy bindings that specify this role will be
        #       dropped from the search results.
        #     * `resource:organizations/123456` to find IAM policy bindings
        #       that are set on "organizations/123456".
        #     * `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
        #       find IAM policy bindings that are set on the project named "myproject".
        #     * `Important` to find IAM policy bindings that contain "Important" as a
        #       word in any of the searchable fields (except for the included
        #       permissions).
        #     * `resource:(instance1 OR instance2) policy:amy` to find
        #       IAM policy bindings that are set on resources "instance1" or
        #       "instance2" and also specify user "amy".
        #     * `roles:roles/compute.admin` to find IAM policy bindings that specify the
        #       Compute Admin role.
        #     * `memberTypes:user` to find IAM policy bindings that contain the
        #       principal type "user".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The page size for search result pagination. Page size is capped
        #     at 500 even if a larger value is given. If set to zero or a negative value,
        #     server will pick an appropriate default. Returned results may be fewer than
        #     requested. When this happens, there could be more results as long as
        #     `next_page_token` is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. If present, retrieve the next batch of results from the preceding
        #     call to this method. `page_token` must be the value of `next_page_token`
        #     from the previous response. The values of all other method parameters must
        #     be identical to those in the previous call.
        # @!attribute [rw] asset_types
        #   @return [::Array<::String>]
        #     Optional. A list of asset types that the IAM policies are attached to. If
        #     empty, it will search the IAM policies that are attached to all the asset
        #     types [supported by search
        #     APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
        #
        #     Regular expressions are also supported. For example:
        #
        #     * "compute.googleapis.com.*" snapshots IAM policies attached to asset type
        #     starts with "compute.googleapis.com".
        #     * ".*Instance" snapshots IAM policies attached to asset type ends with
        #     "Instance".
        #     * ".*Instance.*" snapshots IAM policies attached to asset type contains
        #     "Instance".
        #
        #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
        #     regular expression syntax. If the regular expression does not match any
        #     supported asset type, an INVALID_ARGUMENT error will be returned.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A comma-separated list of fields specifying the sorting order of
        #     the results. The default order is ascending. Add " DESC" after the field
        #     name to indicate descending order. Redundant space characters are ignored.
        #     Example: "assetType DESC, resource".
        #     Only singular primitive fields in the response are sortable:
        #       * resource
        #       * assetType
        #       * project
        #     All the other fields such as repeated fields (e.g., `folders`) and
        #     non-primitive fields (e.g., `policy`) are not supported.
        class SearchAllIamPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Search all IAM policies response.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicySearchResult>]
        #     A list of IAM policies that match the search query. Related information
        #     such as the associated resource is returned along with the policy.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Set if there are more results than those appearing in this response; to get
        #     the next set of results, call this method again, using this value as the
        #     `page_token`.
        class SearchAllIamPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # IAM policy analysis query message.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. The relative name of the root asset. Only resources and IAM
        #     policies within the scope will be analyzed.
        #
        #     This can only be an organization number (such as "organizations/123"), a
        #     folder number (such as "folders/123"), a project ID (such as
        #     "projects/my-project-id"), or a project number (such as "projects/12345").
        #
        #     To know how to get organization ID, visit [here
        #     ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
        #
        #     To know how to get folder or project ID, visit [here
        #     ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
        # @!attribute [rw] resource_selector
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery::ResourceSelector]
        #     Optional. Specifies a resource for analysis.
        # @!attribute [rw] identity_selector
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery::IdentitySelector]
        #     Optional. Specifies an identity for analysis.
        # @!attribute [rw] access_selector
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery::AccessSelector]
        #     Optional. Specifies roles or permissions for analysis. This is optional.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery::Options]
        #     Optional. The query options.
        # @!attribute [rw] condition_context
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery::ConditionContext]
        #     Optional. The hypothetical context for IAM conditions evaluation.
        class IamPolicyAnalysisQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the resource to analyze for access policies, which may be set
          # directly on the resource, or on ancestors such as organizations, folders or
          # projects.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     Required. The [full resource name]
          #     (https://cloud.google.com/asset-inventory/docs/resource-name-format)
          #     of a resource of [supported resource
          #     types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
          class ResourceSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies an identity for which to determine resource access, based on
          # roles assigned either directly to them or to the groups they belong to,
          # directly or indirectly.
          # @!attribute [rw] identity
          #   @return [::String]
          #     Required. The identity appear in the form of principals in
          #     [IAM policy
          #     binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
          #
          #     The examples of supported forms are:
          #     "user:mike@example.com",
          #     "group:admins@example.com",
          #     "domain:google.com",
          #     "serviceAccount:my-project-id@appspot.gserviceaccount.com".
          #
          #     Notice that wildcard characters (such as * and ?) are not supported.
          #     You must give a specific identity.
          class IdentitySelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies roles and/or permissions to analyze, to determine both the
          # identities possessing them and the resources they control. If multiple
          # values are specified, results will include roles or permissions matching
          # any of them. The total number of roles and permissions should be equal or
          # less than 10.
          # @!attribute [rw] roles
          #   @return [::Array<::String>]
          #     Optional. The roles to appear in result.
          # @!attribute [rw] permissions
          #   @return [::Array<::String>]
          #     Optional. The permissions to appear in result.
          class AccessSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains query options.
          # @!attribute [rw] expand_groups
          #   @return [::Boolean]
          #     Optional. If true, the identities section of the result will expand any
          #     Google groups appearing in an IAM policy binding.
          #
          #     If
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery#identity_selector IamPolicyAnalysisQuery.identity_selector}
          #     is specified, the identity in the result will be determined by the
          #     selector, and this flag is not allowed to set.
          #
          #     If true, the default max expansion per group is 1000 for
          #     AssetService.AnalyzeIamPolicy][].
          #
          #     Default is false.
          # @!attribute [rw] expand_roles
          #   @return [::Boolean]
          #     Optional. If true, the access section of result will expand any roles
          #     appearing in IAM policy bindings to include their permissions.
          #
          #     If
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery#access_selector IamPolicyAnalysisQuery.access_selector}
          #     is specified, the access section of the result will be determined by the
          #     selector, and this flag is not allowed to set.
          #
          #     Default is false.
          # @!attribute [rw] expand_resources
          #   @return [::Boolean]
          #     Optional. If true and
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery#resource_selector IamPolicyAnalysisQuery.resource_selector}
          #     is not specified, the resource section of the result will expand any
          #     resource attached to an IAM policy to include resources lower in the
          #     resource hierarchy.
          #
          #     For example, if the request analyzes for which resources user A has
          #     permission P, and the results include an IAM policy with P on a Google
          #     Cloud folder, the results will also include resources in that folder with
          #     permission P.
          #
          #     If true and
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery#resource_selector IamPolicyAnalysisQuery.resource_selector}
          #     is specified, the resource section of the result will expand the
          #     specified resource to include resources lower in the resource hierarchy.
          #     Only project or lower resources are supported. Folder and organization
          #     resources cannot be used together with this option.
          #
          #     For example, if the request analyzes for which users have permission P on
          #     a Google Cloud project with this option enabled, the results will include
          #     all users who have permission P on that project or any lower resource.
          #
          #     If true, the default max expansion per resource is 1000 for
          #     AssetService.AnalyzeIamPolicy][] and 100000 for
          #     AssetService.AnalyzeIamPolicyLongrunning][].
          #
          #     Default is false.
          # @!attribute [rw] output_resource_edges
          #   @return [::Boolean]
          #     Optional. If true, the result will output the relevant parent/child
          #     relationships between resources. Default is false.
          # @!attribute [rw] output_group_edges
          #   @return [::Boolean]
          #     Optional. If true, the result will output the relevant membership
          #     relationships between groups and other groups, and between groups and
          #     principals. Default is false.
          # @!attribute [rw] analyze_service_account_impersonation
          #   @return [::Boolean]
          #     Optional. If true, the response will include access analysis from
          #     identities to resources via service account impersonation. This is a very
          #     expensive operation, because many derived queries will be executed. We
          #     highly recommend you use
          #     {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy_longrunning AssetService.AnalyzeIamPolicyLongrunning}
          #     RPC instead.
          #
          #     For example, if the request analyzes for which resources user A has
          #     permission P, and there's an IAM policy states user A has
          #     iam.serviceAccounts.getAccessToken permission to a service account SA,
          #     and there's another IAM policy states service account SA has permission P
          #     to a Google Cloud folder F, then user A potentially has access to the
          #     Google Cloud folder F. And those advanced analysis results will be
          #     included in
          #     {::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse#service_account_impersonation_analysis AnalyzeIamPolicyResponse.service_account_impersonation_analysis}.
          #
          #     Another example, if the request analyzes for who has
          #     permission P to a Google Cloud folder F, and there's an IAM policy states
          #     user A has iam.serviceAccounts.actAs permission to a service account SA,
          #     and there's another IAM policy states service account SA has permission P
          #     to the Google Cloud folder F, then user A potentially has access to the
          #     Google Cloud folder F. And those advanced analysis results will be
          #     included in
          #     {::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse#service_account_impersonation_analysis AnalyzeIamPolicyResponse.service_account_impersonation_analysis}.
          #
          #     Only the following permissions are considered in this analysis:
          #
          #     * `iam.serviceAccounts.actAs`
          #     * `iam.serviceAccounts.signBlob`
          #     * `iam.serviceAccounts.signJwt`
          #     * `iam.serviceAccounts.getAccessToken`
          #     * `iam.serviceAccounts.getOpenIdToken`
          #     * `iam.serviceAccounts.implicitDelegation`
          #
          #     Default is false.
          class Options
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The IAM conditions context.
          # @!attribute [rw] access_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The hypothetical access timestamp to evaluate IAM conditions. Note that
          #     this value must not be earlier than the current time; otherwise, an
          #     INVALID_ARGUMENT error will be returned.
          class ConditionContext
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A request message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy AssetService.AnalyzeIamPolicy}.
        # @!attribute [rw] analysis_query
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery]
        #     Required. The request query.
        # @!attribute [rw] saved_analysis_query
        #   @return [::String]
        #     Optional. The name of a saved query, which must be in the format of:
        #
        #     * projects/project_number/savedQueries/saved_query_id
        #     * folders/folder_number/savedQueries/saved_query_id
        #     * organizations/organization_number/savedQueries/saved_query_id
        #
        #     If both `analysis_query` and `saved_analysis_query` are provided, they
        #     will be merged together with the `saved_analysis_query` as base and
        #     the `analysis_query` as overrides. For more details of the merge behavior,
        #     refer to the
        #     [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
        #     page.
        #
        #     Note that you cannot override primitive fields with default value, such as
        #     0 or empty string, etc., because we use proto3, which doesn't support field
        #     presence yet.
        # @!attribute [rw] execution_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Amount of time executable has to complete.  See JSON
        #     representation of
        #     [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
        #
        #     If this field is set with a value less than the RPC deadline, and the
        #     execution of your query hasn't finished in the specified
        #     execution timeout,  you will get a response with partial result.
        #     Otherwise, your query's execution will continue until the RPC deadline.
        #     If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
        #
        #     Default is empty.
        class AnalyzeIamPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy AssetService.AnalyzeIamPolicy}.
        # @!attribute [rw] main_analysis
        #   @return [::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse::IamPolicyAnalysis]
        #     The main analysis that matches the original request.
        # @!attribute [rw] service_account_impersonation_analysis
        #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse::IamPolicyAnalysis>]
        #     The service account impersonation analysis if
        #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery::Options#analyze_service_account_impersonation IamPolicyAnalysisQuery.Options.analyze_service_account_impersonation}
        #     is enabled.
        # @!attribute [rw] fully_explored
        #   @return [::Boolean]
        #     Represents whether all entries in the
        #     {::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse#main_analysis main_analysis}
        #     and
        #     {::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse#service_account_impersonation_analysis service_account_impersonation_analysis}
        #     have been fully explored to answer the query in the request.
        class AnalyzeIamPolicyResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An analysis message to group the query and results.
          # @!attribute [rw] analysis_query
          #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery]
          #     The analysis query.
          # @!attribute [rw] analysis_results
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisResult>]
          #     A list of
          #     {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult IamPolicyAnalysisResult}
          #     that matches the analysis query, or empty if no result is found.
          # @!attribute [rw] fully_explored
          #   @return [::Boolean]
          #     Represents whether all entries in the
          #     {::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse::IamPolicyAnalysis#analysis_results analysis_results}
          #     have been fully explored to answer the query.
          # @!attribute [rw] non_critical_errors
          #   @return [::Array<::Google::Cloud::Asset::V1::IamPolicyAnalysisState>]
          #     A list of non-critical errors happened during the query handling.
          class IamPolicyAnalysis
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Output configuration for export IAM policy analysis destination.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisOutputConfig::GcsDestination]
        #     Destination on Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `gcs_destination`, `bigquery_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisOutputConfig::BigQueryDestination]
        #     Destination on BigQuery.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_destination`, `gcs_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class IamPolicyAnalysisOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A Cloud Storage location.
          # @!attribute [rw] uri
          #   @return [::String]
          #     Required. The URI of the Cloud Storage object. It's the same URI that is
          #     used by gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
          #     Editing Object
          #     Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
          #     for more information.
          #
          #     If the specified Cloud Storage object already exists and there is no
          #     [hold](https://cloud.google.com/storage/docs/object-holds), it will be
          #     overwritten with the analysis result.
          class GcsDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A BigQuery destination.
          # @!attribute [rw] dataset
          #   @return [::String]
          #     Required. The BigQuery dataset in format
          #     "projects/projectId/datasets/datasetId", to which the analysis results
          #     should be exported. If this dataset does not exist, the export call will
          #     return an INVALID_ARGUMENT error.
          # @!attribute [rw] table_prefix
          #   @return [::String]
          #     Required. The prefix of the BigQuery tables to which the analysis results
          #     will be written. Tables will be created based on this table_prefix if not
          #     exist:
          #     * <table_prefix>_analysis table will contain export operation's metadata.
          #     * <table_prefix>_analysis_result will contain all the
          #       {::Google::Cloud::Asset::V1::IamPolicyAnalysisResult IamPolicyAnalysisResult}.
          #     When [partition_key] is specified, both tables will be partitioned based
          #     on the [partition_key].
          # @!attribute [rw] partition_key
          #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisOutputConfig::BigQueryDestination::PartitionKey]
          #     The partition key for BigQuery partitioned table.
          # @!attribute [rw] write_disposition
          #   @return [::String]
          #     Optional. Specifies the action that occurs if the destination table or
          #     partition already exists. The following values are supported:
          #
          #     * WRITE_TRUNCATE: If the table or partition already exists, BigQuery
          #     overwrites the entire table or all the partitions data.
          #     * WRITE_APPEND: If the table or partition already exists, BigQuery
          #     appends the data to the table or the latest partition.
          #     * WRITE_EMPTY: If the table already exists and contains data, an error is
          #     returned.
          #
          #     The default value is WRITE_APPEND. Each action is atomic and only occurs
          #     if BigQuery is able to complete the job successfully. Details are at
          #     https://cloud.google.com/bigquery/docs/loading-data-local#appending_to_or_overwriting_a_table_using_a_local_file.
          class BigQueryDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # This enum determines the partition key column for the bigquery tables.
            # Partitioning can improve query performance and reduce query cost by
            # filtering partitions. Refer to
            # https://cloud.google.com/bigquery/docs/partitioned-tables for details.
            module PartitionKey
              # Unspecified partition key. Tables won't be partitioned using this
              # option.
              PARTITION_KEY_UNSPECIFIED = 0

              # The time when the request is received. If specified as partition key,
              # the result table(s) is partitioned by the RequestTime column, an
              # additional timestamp column representing when the request was received.
              REQUEST_TIME = 1
            end
          end
        end

        # A request message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy_longrunning AssetService.AnalyzeIamPolicyLongrunning}.
        # @!attribute [rw] analysis_query
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery]
        #     Required. The request query.
        # @!attribute [rw] saved_analysis_query
        #   @return [::String]
        #     Optional. The name of a saved query, which must be in the format of:
        #
        #     * projects/project_number/savedQueries/saved_query_id
        #     * folders/folder_number/savedQueries/saved_query_id
        #     * organizations/organization_number/savedQueries/saved_query_id
        #
        #     If both `analysis_query` and `saved_analysis_query` are provided, they
        #     will be merged together with the `saved_analysis_query` as base and
        #     the `analysis_query` as overrides. For more details of the merge behavior,
        #     refer to the
        #     [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
        #     doc.
        #
        #     Note that you cannot override primitive fields with default value, such as
        #     0 or empty string, etc., because we use proto3, which doesn't support field
        #     presence yet.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisOutputConfig]
        #     Required. Output configuration indicating where the results will be output
        #     to.
        class AnalyzeIamPolicyLongrunningRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy_longrunning AssetService.AnalyzeIamPolicyLongrunning}.
        class AnalyzeIamPolicyLongrunningResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A saved query which can be shared with others or used later.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the saved query. The format must be:
        #
        #     * projects/project_number/savedQueries/saved_query_id
        #     * folders/folder_number/savedQueries/saved_query_id
        #     * organizations/organization_number/savedQueries/saved_query_id
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of this saved query. This value should be fewer than 255
        #     characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of this saved query.
        # @!attribute [r] creator
        #   @return [::String]
        #     Output only. The account's email address who has created this saved query.
        # @!attribute [r] last_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update time of this saved query.
        # @!attribute [r] last_updater
        #   @return [::String]
        #     Output only. The account's email address who has updated this saved query
        #     most recently.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels applied on the resource.
        #     This value should not contain more than 10 entries. The key and value of
        #     each entry must be non-empty and fewer than 64 characters.
        # @!attribute [rw] content
        #   @return [::Google::Cloud::Asset::V1::SavedQuery::QueryContent]
        #     The query content.
        class SavedQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The query content.
          # @!attribute [rw] iam_policy_analysis_query
          #   @return [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery]
          #     An IAM Policy Analysis query, which could be used in
          #     the
          #     {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy AssetService.AnalyzeIamPolicy}
          #     RPC or the
          #     {::Google::Cloud::Asset::V1::AssetService::Client#analyze_iam_policy_longrunning AssetService.AnalyzeIamPolicyLongrunning}
          #     RPC.
          class QueryContent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request to create a saved query.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project/folder/organization where this
        #     saved_query should be created in. It can only be an organization number
        #     (such as "organizations/123"), a folder number (such as "folders/123"), a
        #     project ID (such as "projects/my-project-id"), or a project number (such as
        #     "projects/12345").
        # @!attribute [rw] saved_query
        #   @return [::Google::Cloud::Asset::V1::SavedQuery]
        #     Required. The saved_query details. The `name` field must be empty as it
        #     will be generated based on the parent and saved_query_id.
        # @!attribute [rw] saved_query_id
        #   @return [::String]
        #     Required. The ID to use for the saved query, which must be unique in the
        #     specified parent. It will become the final component of the saved query's
        #     resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are `[a-z][0-9]-`.
        #
        #     Notice that this field is required in the saved query creation, and the
        #     `name` field of the `saved_query` will be ignored.
        class CreateSavedQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a saved query.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the saved query and it must be in the format of:
        #
        #     * projects/project_number/savedQueries/saved_query_id
        #     * folders/folder_number/savedQueries/saved_query_id
        #     * organizations/organization_number/savedQueries/saved_query_id
        class GetSavedQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list saved queries.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent project/folder/organization whose savedQueries are to
        #     be listed. It can only be using project/folder/organization number (such as
        #     "folders/12345")", or a project ID (such as "projects/my-project-id").
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The expression to filter resources.
        #     The expression is a list of zero or more restrictions combined via logical
        #     operators `AND` and `OR`. When `AND` and `OR` are both used in the
        #     expression, parentheses must be appropriately used to group the
        #     combinations. The expression may also contain regular expressions.
        #
        #     See https://google.aip.dev/160 for more information on the grammar.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of saved queries to return per page. The
        #     service may return fewer than this value. If unspecified, at most 50 will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListSavedQueries` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListSavedQueries` must
        #     match the call that provided the page token.
        class ListSavedQueriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of listing saved queries.
        # @!attribute [rw] saved_queries
        #   @return [::Array<::Google::Cloud::Asset::V1::SavedQuery>]
        #     A list of savedQueries.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSavedQueriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update a saved query.
        # @!attribute [rw] saved_query
        #   @return [::Google::Cloud::Asset::V1::SavedQuery]
        #     Required. The saved query to update.
        #
        #     The saved query's `name` field is used to identify the one to update,
        #     which has format as below:
        #
        #     * projects/project_number/savedQueries/saved_query_id
        #     * folders/folder_number/savedQueries/saved_query_id
        #     * organizations/organization_number/savedQueries/saved_query_id
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateSavedQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete a saved query.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the saved query to delete. It must be in the format
        #     of:
        #
        #     * projects/project_number/savedQueries/saved_query_id
        #     * folders/folder_number/savedQueries/saved_query_id
        #     * organizations/organization_number/savedQueries/saved_query_id
        class DeleteSavedQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for performing resource move analysis.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Required. Name of the resource to perform the analysis against.
        #     Only Google Cloud projects are supported as of today. Hence, this can only
        #     be a project ID (such as "projects/my-project-id") or a project number
        #     (such as "projects/12345").
        # @!attribute [rw] destination_parent
        #   @return [::String]
        #     Required. Name of the Google Cloud folder or organization to reparent the
        #     target resource. The analysis will be performed against hypothetically
        #     moving the resource to this specified destination parent. This can only be
        #     a folder number (such as "folders/123") or an organization number (such as
        #     "organizations/123").
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Asset::V1::AnalyzeMoveRequest::AnalysisView]
        #     Analysis view indicating what information should be included in the
        #     analysis response. If unspecified, the default view is FULL.
        class AnalyzeMoveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # View enum for supporting partial analysis responses.
          module AnalysisView
            # The default/unset value.
            # The API will default to the FULL view.
            ANALYSIS_VIEW_UNSPECIFIED = 0

            # Full analysis including all level of impacts of the specified resource
            # move.
            FULL = 1

            # Basic analysis only including blockers which will prevent the specified
            # resource move at runtime.
            BASIC = 2
          end
        end

        # The response message for resource move analysis.
        # @!attribute [rw] move_analysis
        #   @return [::Array<::Google::Cloud::Asset::V1::MoveAnalysis>]
        #     The list of analyses returned from performing the intended resource move
        #     analysis. The analysis is grouped by different Google Cloud services.
        class AnalyzeMoveResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message to group the analysis information.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The user friendly display name of the analysis. E.g. IAM, organization
        #     policy etc.
        # @!attribute [rw] analysis
        #   @return [::Google::Cloud::Asset::V1::MoveAnalysisResult]
        #     Analysis result of moving the target resource.
        #
        #     Note: The following fields are mutually exclusive: `analysis`, `error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Description of error encountered when performing the analysis.
        #
        #     Note: The following fields are mutually exclusive: `error`, `analysis`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class MoveAnalysis
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An analysis result including blockers and warnings.
        # @!attribute [rw] blockers
        #   @return [::Array<::Google::Cloud::Asset::V1::MoveImpact>]
        #     Blocking information that would prevent the target resource from moving
        #     to the specified destination at runtime.
        # @!attribute [rw] warnings
        #   @return [::Array<::Google::Cloud::Asset::V1::MoveImpact>]
        #     Warning information indicating that moving the target resource to the
        #     specified destination might be unsafe. This can include important policy
        #     information and configuration changes, but will not block moves at runtime.
        class MoveAnalysisResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message to group impacts of moving the target resource.
        # @!attribute [rw] detail
        #   @return [::String]
        #     User friendly impact detail in a free form message.
        class MoveImpact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configuration query assets.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::Asset::V1::QueryAssetsOutputConfig::BigQueryDestination]
        #     BigQuery destination where the query results will be saved.
        class QueryAssetsOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # BigQuery destination.
          # @!attribute [rw] dataset
          #   @return [::String]
          #     Required. The BigQuery dataset where the query results will be saved. It
          #     has the format of "projects/\\{projectId}/datasets/\\{datasetId}".
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The BigQuery table where the query results will be saved. If
          #     this table does not exist, a new table with the given name will be
          #     created.
          # @!attribute [rw] write_disposition
          #   @return [::String]
          #     Specifies the action that occurs if the destination table or partition
          #     already exists. The following values are supported:
          #
          #     * WRITE_TRUNCATE: If the table or partition already exists, BigQuery
          #     overwrites the entire table or all the partitions data.
          #     * WRITE_APPEND: If the table or partition already exists, BigQuery
          #     appends the data to the table or the latest partition.
          #     * WRITE_EMPTY: If the table already exists and contains data, a
          #     'duplicate' error is returned in the job result.
          #
          #     The default value is WRITE_EMPTY.
          class BigQueryDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # QueryAssets request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative name of the root asset. This can only be an
        #     organization number (such as "organizations/123"), a project ID (such as
        #     "projects/my-project-id"), or a project number (such as "projects/12345"),
        #     or a folder number (such as "folders/123").
        #
        #     Only assets belonging to the `parent` will be returned.
        # @!attribute [rw] statement
        #   @return [::String]
        #     Optional. A SQL statement that's compatible with [BigQuery
        #     SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
        #
        #     Note: The following fields are mutually exclusive: `statement`, `job_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] job_reference
        #   @return [::String]
        #     Optional. Reference to the query job, which is from the
        #     `QueryAssetsResponse` of previous `QueryAssets` call.
        #
        #     Note: The following fields are mutually exclusive: `job_reference`, `statement`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of rows to return in the results. Responses
        #     are limited to 10 MB and 1000 rows.
        #
        #     By default, the maximum row count is 1000. When the byte or row count limit
        #     is reached, the rest of the query results will be paginated.
        #
        #     The field will be ignored when [output_config] is specified.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token received from previous `QueryAssets`.
        #
        #     The field will be ignored when [output_config] is specified.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Specifies the maximum amount of time that the client is willing
        #     to wait for the query to complete. By default, this limit is 5 min for the
        #     first query, and 1 minute for the following queries. If the query is
        #     complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
        #     false.
        #
        #     Like BigQuery [jobs.query
        #     API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
        #     The call is not guaranteed to wait for the specified timeout; it typically
        #     returns after around 200 seconds (200,000 milliseconds), even if the query
        #     is not complete.
        #
        #     The field will be ignored when [output_config] is specified.
        # @!attribute [rw] read_time_window
        #   @return [::Google::Cloud::Asset::V1::TimeWindow]
        #     Optional. [start_time] is required. [start_time] must be less than
        #     [end_time] Defaults [end_time] to now if [start_time] is set and
        #     [end_time] isn't. Maximum permitted time range is 7 days.
        #
        #     Note: The following fields are mutually exclusive: `read_time_window`, `read_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] read_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Queries cloud assets as they appeared at the specified point in
        #     time.
        #
        #     Note: The following fields are mutually exclusive: `read_time`, `read_time_window`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Asset::V1::QueryAssetsOutputConfig]
        #     Optional. Destination where the query results will be saved.
        #
        #     When this field is specified, the query results won't be saved in the
        #     [QueryAssetsResponse.query_result]. Instead
        #     [QueryAssetsResponse.output_config] will be set.
        #
        #     Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
        #     to check the status of the query job when passed to a following
        #     [QueryAssets] API call.
        class QueryAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # QueryAssets response.
        # @!attribute [rw] job_reference
        #   @return [::String]
        #     Reference to a query job.
        # @!attribute [rw] done
        #   @return [::Boolean]
        #     The query response, which can be either an `error` or a valid `response`.
        #
        #     If `done` == `false` and the query result is being saved in an output, the
        #     output_config field will be set.
        #     If `done` == `true`, exactly one of
        #     `error`, `query_result` or `output_config` will be set.
        #     [done] is unset unless the [QueryAssetsResponse] contains a
        #     [QueryAssetsResponse.job_reference].
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Error status.
        #
        #     Note: The following fields are mutually exclusive: `error`, `query_result`, `output_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] query_result
        #   @return [::Google::Cloud::Asset::V1::QueryResult]
        #     Result of the query.
        #
        #     Note: The following fields are mutually exclusive: `query_result`, `error`, `output_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Asset::V1::QueryAssetsOutputConfig]
        #     Output configuration, which indicates that instead of being returned in
        #     an API response on the fly, the query result will be saved in a specific
        #     output.
        #
        #     Note: The following fields are mutually exclusive: `output_config`, `error`, `query_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class QueryAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Execution results of the query.
        #
        # The result is formatted as rows represented by BigQuery compatible [schema].
        # When pagination is necessary, it will contains the page token to retrieve
        # the results of following pages.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Protobuf::Struct>]
        #     Each row hold a query result in the format of `Struct`.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::Asset::V1::TableSchema]
        #     Describes the format of the [rows].
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of the results.
        # @!attribute [rw] total_rows
        #   @return [::Integer]
        #     Total rows of the whole query results.
        class QueryResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BigQuery Compatible table schema.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::Asset::V1::TableFieldSchema>]
        #     Describes the fields in a table.
        class TableSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A field in TableSchema.
        # @!attribute [rw] field
        #   @return [::String]
        #     The field name. The name must contain only letters (a-z, A-Z),
        #     numbers (0-9), or underscores (_), and must start with a letter or
        #     underscore. The maximum length is 128 characters.
        # @!attribute [rw] type
        #   @return [::String]
        #     The field data type. Possible values include
        #     * STRING
        #     * BYTES
        #     * INTEGER
        #     * FLOAT
        #     * BOOLEAN
        #     * TIMESTAMP
        #     * DATE
        #     * TIME
        #     * DATETIME
        #     * GEOGRAPHY,
        #     * NUMERIC,
        #     * BIGNUMERIC,
        #     * RECORD
        #     (where RECORD indicates that the field contains a nested schema).
        # @!attribute [rw] mode
        #   @return [::String]
        #     The field mode. Possible values include NULLABLE, REQUIRED and
        #     REPEATED. The default value is NULLABLE.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::Asset::V1::TableFieldSchema>]
        #     Describes the nested schema fields if the type property is set
        #     to RECORD.
        class TableFieldSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#batch_get_effective_iam_policies AssetService.BatchGetEffectiveIamPolicies}.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. Only IAM policies on or below the scope will be returned.
        #
        #     This can only be an organization number (such as "organizations/123"), a
        #     folder number (such as "folders/123"), a project ID (such as
        #     "projects/my-project-id"), or a project number (such as "projects/12345").
        #
        #     To know how to get organization ID, visit [here
        #     ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
        #
        #     To know how to get folder or project ID, visit [here
        #     ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The names refer to the [full_resource_names]
        #     (https://cloud.google.com/asset-inventory/docs/resource-name-format)
        #     of the asset types [supported by search
        #     APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
        #     A maximum of 20 resources' effective policies can be retrieved in a batch.
        class BatchGetEffectiveIamPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#batch_get_effective_iam_policies AssetService.BatchGetEffectiveIamPolicies}.
        # @!attribute [rw] policy_results
        #   @return [::Array<::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy>]
        #     The effective policies for a batch of resources. Note that the results
        #     order is the same as the order of
        #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest#names BatchGetEffectiveIamPoliciesRequest.names}.
        #     When a resource does not have any effective IAM policies, its corresponding
        #     policy_result will contain empty
        #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy#policies EffectiveIamPolicy.policies}.
        class BatchGetEffectiveIamPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The effective IAM policies on one resource.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     The [full_resource_name]
          #     (https://cloud.google.com/asset-inventory/docs/resource-name-format)
          #     for which the
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy#policies policies}
          #     are computed. This is one of the
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest#names BatchGetEffectiveIamPoliciesRequest.names}
          #     the caller provides in the request.
          # @!attribute [rw] policies
          #   @return [::Array<::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy::PolicyInfo>]
          #     The effective policies for the
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy#full_resource_name full_resource_name}.
          #
          #     These policies include the policy set on the
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy#full_resource_name full_resource_name}
          #     and those set on its parents and ancestors up to the
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest#scope BatchGetEffectiveIamPoliciesRequest.scope}.
          #     Note that these policies are not filtered according to the resource type
          #     of the
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy#full_resource_name full_resource_name}.
          #
          #     These policies are hierarchically ordered by
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy::PolicyInfo#attached_resource PolicyInfo.attached_resource}
          #     starting from
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy#full_resource_name full_resource_name}
          #     itself to its parents and ancestors, such that policies[i]'s
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy::PolicyInfo#attached_resource PolicyInfo.attached_resource}
          #     is the child of policies[i+1]'s
          #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy::PolicyInfo#attached_resource PolicyInfo.attached_resource},
          #     if policies[i+1] exists.
          class EffectiveIamPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The IAM policy and its attached resource.
            # @!attribute [rw] attached_resource
            #   @return [::String]
            #     The full resource name the
            #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy::PolicyInfo#policy policy}
            #     is directly attached to.
            # @!attribute [rw] policy
            #   @return [::Google::Iam::V1::Policy]
            #     The IAM policy that's directly attached to the
            #     {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse::EffectiveIamPolicy::PolicyInfo#attached_resource attached_resource}.
            class PolicyInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # This organization policy message is a modified version of the one defined in
        # the Organization Policy system. This message contains several fields defined
        # in the original organization policy with some new fields for analysis
        # purpose.
        # @!attribute [rw] attached_resource
        #   @return [::String]
        #     The [full resource name]
        #     (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
        #     an organization/folder/project resource where this organization policy is
        #     set.
        #
        #     Notice that some type of constraints are defined with default policy. This
        #     field will be empty for them.
        # @!attribute [rw] applied_resource
        #   @return [::String]
        #     The [full resource name]
        #     (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
        #     an organization/folder/project resource where this organization policy
        #     applies to.
        #
        #     For any user defined org policies, this field has the same value as
        #     the [attached_resource] field. Only for default policy, this field has
        #     the different value.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzerOrgPolicy::Rule>]
        #     List of rules for this organization policy.
        # @!attribute [rw] inherit_from_parent
        #   @return [::Boolean]
        #     If `inherit_from_parent` is true, Rules set higher up in the
        #     hierarchy (up to the closest root) are inherited and present in the
        #     effective policy. If it is false, then no rules are inherited, and this
        #     policy becomes the effective root for evaluation.
        # @!attribute [rw] reset
        #   @return [::Boolean]
        #     Ignores policies set above this resource and restores the default behavior
        #     of the constraint at this resource.
        #     This field can be set in policies for either list or boolean
        #     constraints. If set, `rules` must be empty and `inherit_from_parent`
        #     must be set to false.
        class AnalyzerOrgPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This rule message is a customized version of the one defined in the
          # Organization Policy system. In addition to the fields defined in the
          # original organization policy, it contains additional field(s) under
          # specific circumstances to support analysis results.
          # @!attribute [rw] values
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicy::Rule::StringValues]
          #     List of values to be used for this policy rule. This field can be set
          #     only in policies for list constraints.
          #
          #     Note: The following fields are mutually exclusive: `values`, `allow_all`, `deny_all`, `enforce`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] allow_all
          #   @return [::Boolean]
          #     Setting this to true means that all values are allowed. This field can
          #     be set only in Policies for list constraints.
          #
          #     Note: The following fields are mutually exclusive: `allow_all`, `values`, `deny_all`, `enforce`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] deny_all
          #   @return [::Boolean]
          #     Setting this to true means that all values are denied. This field can
          #     be set only in Policies for list constraints.
          #
          #     Note: The following fields are mutually exclusive: `deny_all`, `values`, `allow_all`, `enforce`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] enforce
          #   @return [::Boolean]
          #     If `true`, then the `Policy` is enforced. If `false`, then any
          #     configuration is acceptable.
          #     This field can be set only in Policies for boolean constraints.
          #
          #     Note: The following fields are mutually exclusive: `enforce`, `values`, `allow_all`, `deny_all`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] condition
          #   @return [::Google::Type::Expr]
          #     The evaluating condition for this rule.
          # @!attribute [rw] condition_evaluation
          #   @return [::Google::Cloud::Asset::V1::ConditionEvaluation]
          #     The condition evaluation result for this rule.
          #     Only populated if it meets all the following criteria:
          #
          #     * There is a
          #     {::Google::Cloud::Asset::V1::AnalyzerOrgPolicy::Rule#condition condition}
          #     defined for this rule.
          #     * This rule is within
          #       {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer#consolidated_policy AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.consolidated_policy},
          #       or
          #       {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset#consolidated_policy AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.consolidated_policy}
          #       when the
          #       {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset}
          #       has
          #       {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset#governed_resource AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.governed_resource}.
          class Rule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The string values for the list constraints.
            # @!attribute [rw] allowed_values
            #   @return [::Array<::String>]
            #     List of values allowed at this resource.
            # @!attribute [rw] denied_values
            #   @return [::Array<::String>]
            #     List of values denied at this resource.
            class StringValues
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The organization policy constraint definition.
        # @!attribute [rw] google_defined_constraint
        #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::Constraint]
        #     The definition of the canned constraint defined by Google.
        #
        #     Note: The following fields are mutually exclusive: `google_defined_constraint`, `custom_constraint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_constraint
        #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::CustomConstraint]
        #     The definition of the custom constraint.
        #
        #     Note: The following fields are mutually exclusive: `custom_constraint`, `google_defined_constraint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AnalyzerOrgPolicyConstraint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The definition of a constraint.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the constraint. Format of the name should be
          #     * `constraints/{constraint_name}`
          #
          #     For example, `constraints/compute.disableSerialPortAccess`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The human readable name of the constraint.
          # @!attribute [rw] description
          #   @return [::String]
          #     Detailed description of what this `Constraint` controls as well as how
          #     and where it is enforced.
          # @!attribute [rw] constraint_default
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::Constraint::ConstraintDefault]
          #     The evaluation behavior of this constraint in the absence of 'Policy'.
          # @!attribute [rw] list_constraint
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::Constraint::ListConstraint]
          #     Defines this constraint as being a ListConstraint.
          #
          #     Note: The following fields are mutually exclusive: `list_constraint`, `boolean_constraint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] boolean_constraint
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::Constraint::BooleanConstraint]
          #     Defines this constraint as being a BooleanConstraint.
          #
          #     Note: The following fields are mutually exclusive: `boolean_constraint`, `list_constraint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Constraint
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A `Constraint` that allows or disallows a list of string values, which
            # are configured by an organization's policy administrator with a `Policy`.
            # @!attribute [rw] supports_in
            #   @return [::Boolean]
            #     Indicates whether values grouped into categories can be used in
            #     `Policy.allowed_values` and `Policy.denied_values`. For example,
            #     `"in:Python"` would match any value in the 'Python' group.
            # @!attribute [rw] supports_under
            #   @return [::Boolean]
            #     Indicates whether subtrees of Cloud Resource Manager resource hierarchy
            #     can be used in `Policy.allowed_values` and `Policy.denied_values`. For
            #     example, `"under:folders/123"` would match any resource under the
            #     'folders/123' folder.
            class ListConstraint
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A `Constraint` that is either enforced or not.
            #
            # For example a constraint `constraints/compute.disableSerialPortAccess`.
            # If it is enforced on a VM instance, serial port connections will not be
            # opened to that instance.
            class BooleanConstraint
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies the default behavior in the absence of any `Policy` for the
            # `Constraint`. This must not be `CONSTRAINT_DEFAULT_UNSPECIFIED`.
            module ConstraintDefault
              # This is only used for distinguishing unset values and should never be
              # used.
              CONSTRAINT_DEFAULT_UNSPECIFIED = 0

              # Indicate that all values are allowed for list constraints.
              # Indicate that enforcement is off for boolean constraints.
              ALLOW = 1

              # Indicate that all values are denied for list constraints.
              # Indicate that enforcement is on for boolean constraints.
              DENY = 2
            end
          end

          # The definition of a custom constraint.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the constraint. This is unique within the organization. Format of
          #     the name should be
          #     * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
          #
          #     Example :
          #     "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
          # @!attribute [rw] resource_types
          #   @return [::Array<::String>]
          #     The Resource Instance type on which this policy applies to. Format will
          #     be of the form : "<canonical service name>/<type>" Example:
          #      * `compute.googleapis.com/Instance`.
          # @!attribute [rw] method_types
          #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::CustomConstraint::MethodType>]
          #     All the operations being applied for this constraint.
          # @!attribute [rw] condition
          #   @return [::String]
          #     Organization Policy condition/expression. For example:
          #     `resource.instanceName.matches("[production|test]_.*_(\d)+")'` or,
          #     `resource.management.auto_upgrade == true`
          # @!attribute [rw] action_type
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint::CustomConstraint::ActionType]
          #     Allow or deny type.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     One line display name for the UI.
          # @!attribute [rw] description
          #   @return [::String]
          #     Detailed information about this custom policy constraint.
          class CustomConstraint
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The operation in which this constraint will be applied. For example:
            # If the constraint applies only when create VMs, the method_types will be
            # "CREATE" only. If the constraint applied when create or delete VMs, the
            # method_types will be "CREATE" and "DELETE".
            module MethodType
              # Unspecified. Will results in user error.
              METHOD_TYPE_UNSPECIFIED = 0

              # Constraint applied when creating the resource.
              CREATE = 1

              # Constraint applied when updating the resource.
              UPDATE = 2

              # Constraint applied when deleting the resource.
              DELETE = 3

              # Constraint applied when removing an IAM grant.
              REMOVE_GRANT = 4

              # Constraint applied when enforcing forced tagging.
              GOVERN_TAGS = 5
            end

            # Allow or deny type.
            module ActionType
              # Unspecified. Will results in user error.
              ACTION_TYPE_UNSPECIFIED = 0

              # Allowed action type.
              ALLOW = 1

              # Deny action type.
              DENY = 2
            end
          end
        end

        # A request message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_org_policies AssetService.AnalyzeOrgPolicies}.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. The organization to scope the request. Only organization
        #     policies within the scope will be analyzed.
        #
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] constraint
        #   @return [::String]
        #     Required. The name of the constraint to analyze organization policies for.
        #     The response only contains analyzed organization policies for the provided
        #     constraint.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The expression to filter
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse#org_policy_results AnalyzeOrgPoliciesResponse.org_policy_results}.
        #     Filtering is currently available for bare literal values and the following
        #     fields:
        #     * consolidated_policy.attached_resource
        #     * consolidated_policy.rules.enforce
        #
        #     When filtering by a specific field, the only supported operator is `=`.
        #     For example, filtering by
        #     consolidated_policy.attached_resource="//cloudresourcemanager.googleapis.com/folders/001"
        #     will return all the Organization Policy results attached to "folders/001".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return per page. If unspecified,
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse#org_policy_results AnalyzeOrgPoliciesResponse.org_policy_results}
        #     will contain 20 items with a maximum of 200.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page.
        class AnalyzeOrgPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_org_policies AssetService.AnalyzeOrgPolicies}.
        # @!attribute [rw] org_policy_results
        #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>]
        #     The organization policies under the
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest#scope AnalyzeOrgPoliciesRequest.scope}
        #     with the
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest#constraint AnalyzeOrgPoliciesRequest.constraint}.
        # @!attribute [rw] constraint
        #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint]
        #     The definition of the constraint in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The page token to fetch the next page for
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse#org_policy_results AnalyzeOrgPoliciesResponse.org_policy_results}.
        class AnalyzeOrgPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The organization policy result to the query.
          # @!attribute [rw] consolidated_policy
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicy]
          #     The consolidated organization policy for the analyzed resource. The
          #     consolidated organization policy is computed by merging and evaluating
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse::OrgPolicyResult#policy_bundle policy_bundle}.
          #     The evaluation will respect the organization policy [hierarchy
          #     rules](https://cloud.google.com/resource-manager/docs/organization-policy/understanding-hierarchy).
          # @!attribute [rw] policy_bundle
          #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzerOrgPolicy>]
          #     The ordered list of all organization policies from the
          #     {::Google::Cloud::Asset::V1::AnalyzerOrgPolicy#attached_resource consolidated_policy.attached_resource}.
          #     to the scope specified in the request.
          #
          #     If the constraint is defined with default policy, it will also appear in
          #     the list.
          # @!attribute [rw] project
          #   @return [::String]
          #     The project that this consolidated policy belongs to, in the format of
          #     projects/\\{PROJECT_NUMBER}. This field is available when the consolidated
          #     policy belongs to a project.
          # @!attribute [rw] folders
          #   @return [::Array<::String>]
          #     The folder(s) that this consolidated policy belongs to, in the format of
          #     folders/\\{FOLDER_NUMBER}. This field is available when the consolidated
          #     policy belongs (directly or cascadingly) to one or more folders.
          # @!attribute [rw] organization
          #   @return [::String]
          #     The organization that this consolidated policy belongs to, in the format
          #     of organizations/\\{ORGANIZATION_NUMBER}. This field is available when the
          #     consolidated policy belongs (directly or cascadingly) to an organization.
          class OrgPolicyResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A request message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_org_policy_governed_containers AssetService.AnalyzeOrgPolicyGovernedContainers}.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. The organization to scope the request. Only organization
        #     policies within the scope will be analyzed. The output containers will
        #     also be limited to the ones governed by those in-scope organization
        #     policies.
        #
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] constraint
        #   @return [::String]
        #     Required. The name of the constraint to analyze governed containers for.
        #     The analysis only contains organization policies for the provided
        #     constraint.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The expression to filter
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse#governed_containers AnalyzeOrgPolicyGovernedContainersResponse.governed_containers}.
        #     Filtering is currently available for bare literal values and the following
        #     fields:
        #     * parent
        #     * consolidated_policy.rules.enforce
        #
        #     When filtering by a specific field, the only supported operator is `=`.
        #     For example, filtering by
        #     parent="//cloudresourcemanager.googleapis.com/folders/001"
        #     will return all the containers under "folders/001".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return per page. If unspecified,
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse#governed_containers AnalyzeOrgPolicyGovernedContainersResponse.governed_containers}
        #     will contain 100 items with a maximum of 200.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page.
        class AnalyzeOrgPolicyGovernedContainersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_org_policy_governed_containers AssetService.AnalyzeOrgPolicyGovernedContainers}.
        # @!attribute [rw] governed_containers
        #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>]
        #     The list of the analyzed governed containers.
        # @!attribute [rw] constraint
        #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint]
        #     The definition of the constraint in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The page token to fetch the next page for
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse#governed_containers AnalyzeOrgPolicyGovernedContainersResponse.governed_containers}.
        class AnalyzeOrgPolicyGovernedContainersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The organization/folder/project resource governed by organization policies
          # of
          # {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest#constraint AnalyzeOrgPolicyGovernedContainersRequest.constraint}.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     The [full resource name]
          #     (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
          #     an organization/folder/project resource.
          # @!attribute [rw] parent
          #   @return [::String]
          #     The [full resource name]
          #     (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
          #     the parent of
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer#full_resource_name AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.full_resource_name}.
          # @!attribute [rw] consolidated_policy
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicy]
          #     The consolidated organization policy for the analyzed resource. The
          #     consolidated organization policy is computed by merging and evaluating
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer#policy_bundle AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.policy_bundle}.
          #     The evaluation will respect the organization policy [hierarchy
          #     rules](https://cloud.google.com/resource-manager/docs/organization-policy/understanding-hierarchy).
          # @!attribute [rw] policy_bundle
          #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzerOrgPolicy>]
          #     The ordered list of all organization policies from the
          #     {::Google::Cloud::Asset::V1::AnalyzerOrgPolicy#attached_resource consolidated_policy.attached_resource}.
          #     to the scope specified in the request.
          #
          #     If the constraint is defined with default policy, it will also appear in
          #     the list.
          # @!attribute [rw] project
          #   @return [::String]
          #     The project that this resource belongs to, in the format of
          #     projects/\\{PROJECT_NUMBER}. This field is available when the resource
          #     belongs to a project.
          # @!attribute [rw] folders
          #   @return [::Array<::String>]
          #     The folder(s) that this resource belongs to, in the format of
          #     folders/\\{FOLDER_NUMBER}. This field is available when the resource
          #     belongs (directly or cascadingly) to one or more folders.
          # @!attribute [rw] organization
          #   @return [::String]
          #     The organization that this resource belongs to, in the format of
          #     organizations/\\{ORGANIZATION_NUMBER}. This field is available when the
          #     resource belongs (directly or cascadingly) to an organization.
          # @!attribute [rw] effective_tags
          #   @return [::Array<::Google::Cloud::Asset::V1::EffectiveTagDetails>]
          #     The effective tags on this resource.
          class GovernedContainer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A request message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_org_policy_governed_assets AssetService.AnalyzeOrgPolicyGovernedAssets}.
        # @!attribute [rw] scope
        #   @return [::String]
        #     Required. The organization to scope the request. Only organization
        #     policies within the scope will be analyzed. The output assets will
        #     also be limited to the ones governed by those in-scope organization
        #     policies.
        #
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] constraint
        #   @return [::String]
        #     Required. The name of the constraint to analyze governed assets for. The
        #     analysis only contains analyzed organization policies for the provided
        #     constraint.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The expression to filter
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse#governed_assets AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets}.
        #
        #     For governed resources, filtering is currently available for bare literal
        #     values and the following fields:
        #     * governed_resource.project
        #     * governed_resource.folders
        #     * consolidated_policy.rules.enforce
        #     When filtering by `governed_resource.project` or
        #     `consolidated_policy.rules.enforce`, the only supported operator is `=`.
        #     When filtering by `governed_resource.folders`, the supported operators
        #     are `=` and `:`.
        #     For example, filtering by `governed_resource.project="projects/12345678"`
        #     will return all the governed resources under "projects/12345678",
        #     including the project itself if applicable.
        #
        #     For governed IAM policies, filtering is currently available for bare
        #     literal values and the following fields:
        #     * governed_iam_policy.project
        #     * governed_iam_policy.folders
        #     * consolidated_policy.rules.enforce
        #     When filtering by `governed_iam_policy.project` or
        #     `consolidated_policy.rules.enforce`, the only supported operator is `=`.
        #     When filtering by `governed_iam_policy.folders`, the supported operators
        #     are `=` and `:`.
        #     For example, filtering by `governed_iam_policy.folders:"folders/12345678"`
        #     will return all the governed IAM policies under "folders/001".
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return per page. If unspecified,
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse#governed_assets AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets}
        #     will contain 100 items with a maximum of 200.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The pagination token to retrieve the next page.
        class AnalyzeOrgPolicyGovernedAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Asset::V1::AssetService::Client#analyze_org_policy_governed_assets AssetService.AnalyzeOrgPolicyGovernedAssets}.
        # @!attribute [rw] governed_assets
        #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset>]
        #     The list of the analyzed governed assets.
        # @!attribute [rw] constraint
        #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicyConstraint]
        #     The definition of the constraint in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The page token to fetch the next page for
        #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse#governed_assets AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets}.
        class AnalyzeOrgPolicyGovernedAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Google Cloud resources governed by the organization policies of the
          # {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest#constraint AnalyzeOrgPolicyGovernedAssetsRequest.constraint}.
          # @!attribute [rw] full_resource_name
          #   @return [::String]
          #     The [full resource name]
          #     (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
          #     the Google Cloud resource.
          # @!attribute [rw] parent
          #   @return [::String]
          #     The [full resource name]
          #     (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
          #     the parent of
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedResource#full_resource_name AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.full_resource_name}.
          # @!attribute [rw] project
          #   @return [::String]
          #     The project that this resource belongs to, in the format of
          #     projects/\\{PROJECT_NUMBER}. This field is available when the resource
          #     belongs to a project.
          # @!attribute [rw] folders
          #   @return [::Array<::String>]
          #     The folder(s) that this resource belongs to, in the format of
          #     folders/\\{FOLDER_NUMBER}. This field is available when the resource
          #     belongs (directly or cascadingly) to one or more folders.
          # @!attribute [rw] organization
          #   @return [::String]
          #     The organization that this resource belongs to, in the format of
          #     organizations/\\{ORGANIZATION_NUMBER}. This field is available when the
          #     resource belongs (directly or cascadingly) to an organization.
          # @!attribute [rw] asset_type
          #   @return [::String]
          #     The asset type of the
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedResource#full_resource_name AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.full_resource_name}
          #     Example:
          #     `cloudresourcemanager.googleapis.com/Project`
          #     See [Cloud Asset Inventory Supported Asset
          #     Types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
          #     for all supported asset types.
          # @!attribute [rw] effective_tags
          #   @return [::Array<::Google::Cloud::Asset::V1::EffectiveTagDetails>]
          #     The effective tags on this resource.
          class GovernedResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The IAM policies governed by the organization policies of the
          # {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest#constraint AnalyzeOrgPolicyGovernedAssetsRequest.constraint}.
          # @!attribute [rw] attached_resource
          #   @return [::String]
          #     The full resource name of the resource on which this IAM policy is set.
          #     Example:
          #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
          #     See [Cloud Asset Inventory Resource Name
          #     Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
          #     for more information.
          # @!attribute [rw] policy
          #   @return [::Google::Iam::V1::Policy]
          #     The IAM policy directly set on the given resource.
          # @!attribute [rw] project
          #   @return [::String]
          #     The project that this IAM policy belongs to, in the format of
          #     projects/\\{PROJECT_NUMBER}. This field is available when the IAM policy
          #     belongs to a project.
          # @!attribute [rw] folders
          #   @return [::Array<::String>]
          #     The folder(s) that this IAM policy belongs to, in the format of
          #     folders/\\{FOLDER_NUMBER}. This field is available when the IAM policy
          #     belongs (directly or cascadingly) to one or more folders.
          # @!attribute [rw] organization
          #   @return [::String]
          #     The organization that this IAM policy belongs to, in the format of
          #     organizations/\\{ORGANIZATION_NUMBER}. This field is available when the
          #     IAM policy belongs (directly or cascadingly) to an organization.
          # @!attribute [rw] asset_type
          #   @return [::String]
          #     The asset type of the
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedIamPolicy#attached_resource AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy.attached_resource}.
          #     Example:
          #     `cloudresourcemanager.googleapis.com/Project`
          #     See [Cloud Asset Inventory Supported Asset
          #     Types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
          #     for all supported asset types.
          class GovernedIamPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a Google Cloud asset(resource or IAM policy) governed by the
          # organization policies of the
          # {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest#constraint AnalyzeOrgPolicyGovernedAssetsRequest.constraint}.
          # @!attribute [rw] governed_resource
          #   @return [::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedResource]
          #     A Google Cloud resource governed by the organization
          #     policies of the
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest#constraint AnalyzeOrgPolicyGovernedAssetsRequest.constraint}.
          #
          #     Note: The following fields are mutually exclusive: `governed_resource`, `governed_iam_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] governed_iam_policy
          #   @return [::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedIamPolicy]
          #     An IAM policy governed by the organization
          #     policies of the
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest#constraint AnalyzeOrgPolicyGovernedAssetsRequest.constraint}.
          #
          #     Note: The following fields are mutually exclusive: `governed_iam_policy`, `governed_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] consolidated_policy
          #   @return [::Google::Cloud::Asset::V1::AnalyzerOrgPolicy]
          #     The consolidated policy for the analyzed asset. The consolidated
          #     policy is computed by merging and evaluating
          #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset#policy_bundle AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.policy_bundle}.
          #     The evaluation will respect the organization policy [hierarchy
          #     rules](https://cloud.google.com/resource-manager/docs/organization-policy/understanding-hierarchy).
          # @!attribute [rw] policy_bundle
          #   @return [::Array<::Google::Cloud::Asset::V1::AnalyzerOrgPolicy>]
          #     The ordered list of all organization policies from the
          #     {::Google::Cloud::Asset::V1::AnalyzerOrgPolicy#attached_resource consolidated_policy.attached_resource}
          #     to the scope specified in the request.
          #
          #     If the constraint is defined with default policy, it will also appear in
          #     the list.
          class GovernedAsset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Asset content type.
        module ContentType
          # Unspecified content type.
          CONTENT_TYPE_UNSPECIFIED = 0

          # Resource metadata.
          RESOURCE = 1

          # The actual IAM policy set on a resource.
          IAM_POLICY = 2

          # The organization policy set on an asset.
          ORG_POLICY = 4

          # The Access Context Manager policy set on an asset.
          ACCESS_POLICY = 5

          # The runtime OS Inventory information.
          OS_INVENTORY = 6

          # The related resources.
          RELATIONSHIP = 7
        end
      end
    end
  end
end
