# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/asset/v1/asset_service.proto for package 'google.cloud.asset.v1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/asset/v1/asset_service_pb'

module Google
  module Cloud
    module Asset
      module V1
        module AssetService
          # Asset service definition.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.asset.v1.AssetService'

            # Exports assets with time and resource types to a given Cloud Storage
            # location/BigQuery table. For Cloud Storage location destinations, the
            # output format is newline-delimited JSON. Each line represents a
            # [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
            # format; for BigQuery table destinations, the output table stores the fields
            # in asset Protobuf as columns. This API implements the
            # [google.longrunning.Operation][google.longrunning.Operation] API, which
            # allows you to keep track of the export. We recommend intervals of at least
            # 2 seconds with exponential retry to poll the export operation result. For
            # regular-size resource parent, the export operation usually finishes within
            # 5 minutes.
            rpc :ExportAssets, ::Google::Cloud::Asset::V1::ExportAssetsRequest, ::Google::Longrunning::Operation
            # Lists assets with time and resource types and returns paged results in
            # response.
            rpc :ListAssets, ::Google::Cloud::Asset::V1::ListAssetsRequest, ::Google::Cloud::Asset::V1::ListAssetsResponse
            # Batch gets the update history of assets that overlap a time window.
            # For IAM_POLICY content, this API outputs history when the asset and its
            # attached IAM POLICY both exist. This can create gaps in the output history.
            # Otherwise, this API outputs history with asset in both non-delete or
            # deleted status.
            # If a specified asset does not exist, this API returns an INVALID_ARGUMENT
            # error.
            rpc :BatchGetAssetsHistory, ::Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest, ::Google::Cloud::Asset::V1::BatchGetAssetsHistoryResponse
            # Creates a feed in a parent project/folder/organization to listen to its
            # asset updates.
            rpc :CreateFeed, ::Google::Cloud::Asset::V1::CreateFeedRequest, ::Google::Cloud::Asset::V1::Feed
            # Gets details about an asset feed.
            rpc :GetFeed, ::Google::Cloud::Asset::V1::GetFeedRequest, ::Google::Cloud::Asset::V1::Feed
            # Lists all asset feeds in a parent project/folder/organization.
            rpc :ListFeeds, ::Google::Cloud::Asset::V1::ListFeedsRequest, ::Google::Cloud::Asset::V1::ListFeedsResponse
            # Updates an asset feed configuration.
            rpc :UpdateFeed, ::Google::Cloud::Asset::V1::UpdateFeedRequest, ::Google::Cloud::Asset::V1::Feed
            # Deletes an asset feed.
            rpc :DeleteFeed, ::Google::Cloud::Asset::V1::DeleteFeedRequest, ::Google::Protobuf::Empty
            # Searches all Google Cloud resources within the specified scope, such as a
            # project, folder, or organization. The caller must be granted the
            # `cloudasset.assets.searchAllResources` permission on the desired scope,
            # otherwise the request will be rejected.
            rpc :SearchAllResources, ::Google::Cloud::Asset::V1::SearchAllResourcesRequest, ::Google::Cloud::Asset::V1::SearchAllResourcesResponse
            # Searches all IAM policies within the specified scope, such as a project,
            # folder, or organization. The caller must be granted the
            # `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
            # otherwise the request will be rejected.
            rpc :SearchAllIamPolicies, ::Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest, ::Google::Cloud::Asset::V1::SearchAllIamPoliciesResponse
            # Analyzes IAM policies to answer which identities have what accesses on
            # which resources.
            rpc :AnalyzeIamPolicy, ::Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest, ::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse
            # Analyzes IAM policies asynchronously to answer which identities have what
            # accesses on which resources, and writes the analysis results to a Google
            # Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
            # output format is the JSON format that represents a
            # [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
            # This method implements the
            # [google.longrunning.Operation][google.longrunning.Operation], which allows
            # you to track the operation status. We recommend intervals of at least 2
            # seconds with exponential backoff retry to poll the operation result. The
            # metadata contains the metadata for the long-running operation.
            rpc :AnalyzeIamPolicyLongrunning, ::Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest, ::Google::Longrunning::Operation
            # Analyze moving a resource to a specified destination without kicking off
            # the actual move. The analysis is best effort depending on the user's
            # permissions of viewing different hierarchical policies and configurations.
            # The policies and configuration are subject to change before the actual
            # resource migration takes place.
            rpc :AnalyzeMove, ::Google::Cloud::Asset::V1::AnalyzeMoveRequest, ::Google::Cloud::Asset::V1::AnalyzeMoveResponse
            # Issue a job that queries assets using a SQL statement compatible with
            # [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
            #
            # If the query execution finishes within timeout and there's no pagination,
            # the full query results will be returned in the `QueryAssetsResponse`.
            #
            # Otherwise, full query results can be obtained by issuing extra requests
            # with the `job_reference` from the a previous `QueryAssets` call.
            #
            # Note, the query result has approximately 10 GB limitation enforced by
            # [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
            # Queries return larger results will result in errors.
            rpc :QueryAssets, ::Google::Cloud::Asset::V1::QueryAssetsRequest, ::Google::Cloud::Asset::V1::QueryAssetsResponse
            # Creates a saved query in a parent project/folder/organization.
            rpc :CreateSavedQuery, ::Google::Cloud::Asset::V1::CreateSavedQueryRequest, ::Google::Cloud::Asset::V1::SavedQuery
            # Gets details about a saved query.
            rpc :GetSavedQuery, ::Google::Cloud::Asset::V1::GetSavedQueryRequest, ::Google::Cloud::Asset::V1::SavedQuery
            # Lists all saved queries in a parent project/folder/organization.
            rpc :ListSavedQueries, ::Google::Cloud::Asset::V1::ListSavedQueriesRequest, ::Google::Cloud::Asset::V1::ListSavedQueriesResponse
            # Updates a saved query.
            rpc :UpdateSavedQuery, ::Google::Cloud::Asset::V1::UpdateSavedQueryRequest, ::Google::Cloud::Asset::V1::SavedQuery
            # Deletes a saved query.
            rpc :DeleteSavedQuery, ::Google::Cloud::Asset::V1::DeleteSavedQueryRequest, ::Google::Protobuf::Empty
            # Gets effective IAM policies for a batch of resources.
            rpc :BatchGetEffectiveIamPolicies, ::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest, ::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse
            # Analyzes organization policies under a scope.
            rpc :AnalyzeOrgPolicies, ::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest, ::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse
            # Analyzes organization policies governed containers (projects, folders or
            # organization) under a scope.
            rpc :AnalyzeOrgPolicyGovernedContainers, ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest, ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse
            # Analyzes organization policies governed assets (Google Cloud resources or
            # policies) under a scope. This RPC supports custom constraints and the
            # following canned constraints:
            #
            # * constraints/ainotebooks.accessMode
            # * constraints/ainotebooks.disableFileDownloads
            # * constraints/ainotebooks.disableRootAccess
            # * constraints/ainotebooks.disableTerminal
            # * constraints/ainotebooks.environmentOptions
            # * constraints/ainotebooks.requireAutoUpgradeSchedule
            # * constraints/ainotebooks.restrictVpcNetworks
            # * constraints/compute.disableGuestAttributesAccess
            # * constraints/compute.disableInstanceDataAccessApis
            # * constraints/compute.disableNestedVirtualization
            # * constraints/compute.disableSerialPortAccess
            # * constraints/compute.disableSerialPortLogging
            # * constraints/compute.disableVpcExternalIpv6
            # * constraints/compute.requireOsLogin
            # * constraints/compute.requireShieldedVm
            # * constraints/compute.restrictLoadBalancerCreationForTypes
            # * constraints/compute.restrictProtocolForwardingCreationForTypes
            # * constraints/compute.restrictXpnProjectLienRemoval
            # * constraints/compute.setNewProjectDefaultToZonalDNSOnly
            # * constraints/compute.skipDefaultNetworkCreation
            # * constraints/compute.trustedImageProjects
            # * constraints/compute.vmCanIpForward
            # * constraints/compute.vmExternalIpAccess
            # * constraints/gcp.detailedAuditLoggingMode
            # * constraints/gcp.resourceLocations
            # * constraints/iam.allowedPolicyMemberDomains
            # * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
            # * constraints/iam.disableServiceAccountCreation
            # * constraints/iam.disableServiceAccountKeyCreation
            # * constraints/iam.disableServiceAccountKeyUpload
            # * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
            # * constraints/iam.serviceAccountKeyExpiryHours
            # * constraints/resourcemanager.accessBoundaries
            # * constraints/resourcemanager.allowedExportDestinations
            # * constraints/sql.restrictAuthorizedNetworks
            # * constraints/sql.restrictNoncompliantDiagnosticDataAccess
            # * constraints/sql.restrictNoncompliantResourceCreation
            # * constraints/sql.restrictPublicIp
            # * constraints/storage.publicAccessPrevention
            # * constraints/storage.restrictAuthTypes
            # * constraints/storage.uniformBucketLevelAccess
            #
            # This RPC only returns either resources of types [supported by search
            # APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
            # or IAM policies.
            rpc :AnalyzeOrgPolicyGovernedAssets, ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest, ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
