# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/asset/v1/asset_service_pb"

module Google
  module Cloud
    module Asset
      module V1
        module AssetService
          ##
          # Client for the AssetService service.
          #
          # Asset service definition.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudasset.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :asset_service_stub

            ##
            # Configure the AssetService Client class.
            #
            # See {::Google::Cloud::Asset::V1::AssetService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all AssetService clients
            #   ::Google::Cloud::Asset::V1::AssetService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Asset", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.export_assets.timeout = 60.0

                default_config.rpcs.list_assets.timeout = 60.0
                default_config.rpcs.list_assets.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.batch_get_assets_history.timeout = 60.0
                default_config.rpcs.batch_get_assets_history.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.create_feed.timeout = 60.0

                default_config.rpcs.get_feed.timeout = 60.0
                default_config.rpcs.get_feed.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_feeds.timeout = 60.0
                default_config.rpcs.list_feeds.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.update_feed.timeout = 60.0

                default_config.rpcs.delete_feed.timeout = 60.0
                default_config.rpcs.delete_feed.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.search_all_resources.timeout = 30.0
                default_config.rpcs.search_all_resources.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.search_all_iam_policies.timeout = 30.0
                default_config.rpcs.search_all_iam_policies.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.analyze_iam_policy.timeout = 300.0
                default_config.rpcs.analyze_iam_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.analyze_iam_policy_longrunning.timeout = 60.0

                default_config.rpcs.query_assets.timeout = 200.0
                default_config.rpcs.query_assets.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_saved_query.timeout = 60.0

                default_config.rpcs.get_saved_query.timeout = 60.0
                default_config.rpcs.get_saved_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_saved_queries.timeout = 60.0
                default_config.rpcs.list_saved_queries.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.update_saved_query.timeout = 60.0

                default_config.rpcs.delete_saved_query.timeout = 60.0
                default_config.rpcs.delete_saved_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.batch_get_effective_iam_policies.timeout = 300.0
                default_config.rpcs.batch_get_effective_iam_policies.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.analyze_org_policies.timeout = 60.0
                default_config.rpcs.analyze_org_policies.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.analyze_org_policy_governed_containers.timeout = 60.0
                default_config.rpcs.analyze_org_policy_governed_containers.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.analyze_org_policy_governed_assets.timeout = 60.0
                default_config.rpcs.analyze_org_policy_governed_assets.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the AssetService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Asset::V1::AssetService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @asset_service_stub.universe_domain
            end

            ##
            # Create a new AssetService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Asset::V1::AssetService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the AssetService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/asset/v1/asset_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @asset_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Asset::V1::AssetService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @asset_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Asset::V1::AssetService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @asset_service_stub.logger
            end

            # Service calls

            ##
            # Exports assets with time and resource types to a given Cloud Storage
            # location/BigQuery table. For Cloud Storage location destinations, the
            # output format is newline-delimited JSON. Each line represents a
            # {::Google::Cloud::Asset::V1::Asset google.cloud.asset.v1.Asset} in the JSON
            # format; for BigQuery table destinations, the output table stores the fields
            # in asset Protobuf as columns. This API implements the
            # {::Google::Longrunning::Operation google.longrunning.Operation} API, which
            # allows you to keep track of the export. We recommend intervals of at least
            # 2 seconds with exponential retry to poll the export operation result. For
            # regular-size resource parent, the export operation usually finishes within
            # 5 minutes.
            #
            # @overload export_assets(request, options = nil)
            #   Pass arguments to `export_assets` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::ExportAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::ExportAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_assets(parent: nil, read_time: nil, asset_types: nil, content_type: nil, output_config: nil, relationship_types: nil)
            #   Pass arguments to `export_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative name of the root asset. This can only be an
            #     organization number (such as "organizations/123"), a project ID (such as
            #     "projects/my-project-id"), or a project number (such as "projects/12345"),
            #     or a folder number (such as "folders/123").
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Timestamp to take an asset snapshot. This can only be set to a timestamp
            #     between the current time and the current time minus 35 days (inclusive).
            #     If not specified, the current time will be used. Due to delays in resource
            #     data collection and indexing, there is a volatile window during which
            #     running the same query may get different results.
            #   @param asset_types [::Array<::String>]
            #     A list of asset types to take a snapshot for. For example:
            #     "compute.googleapis.com/Disk".
            #
            #     Regular expressions are also supported. For example:
            #
            #     * "compute.googleapis.com.*" snapshots resources whose asset type starts
            #     with "compute.googleapis.com".
            #     * ".*Instance" snapshots resources whose asset type ends with "Instance".
            #     * ".*Instance.*" snapshots resources whose asset type contains "Instance".
            #
            #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
            #     regular expression syntax. If the regular expression does not match any
            #     supported asset type, an INVALID_ARGUMENT error will be returned.
            #
            #     If specified, only matching assets will be returned, otherwise, it will
            #     snapshot all asset types. See [Introduction to Cloud Asset
            #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
            #     for all supported asset types.
            #   @param content_type [::Google::Cloud::Asset::V1::ContentType]
            #     Asset content type. If not specified, no content but the asset name will be
            #     returned.
            #   @param output_config [::Google::Cloud::Asset::V1::OutputConfig, ::Hash]
            #     Required. Output configuration indicating where the results will be output
            #     to.
            #   @param relationship_types [::Array<::String>]
            #     A list of relationship types to export, for example:
            #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
            #     content_type=RELATIONSHIP.
            #     * If specified:
            #     it snapshots specified relationships. It returns an error if
            #     any of the [relationship_types] doesn't belong to the supported
            #     relationship types of the [asset_types] or if any of the [asset_types]
            #     doesn't belong to the source types of the [relationship_types].
            #     * Otherwise:
            #     it snapshots the supported relationships for all [asset_types] or returns
            #     an error if any of the [asset_types] has no relationship support.
            #     An unspecified asset types field means all supported asset_types.
            #     See [Introduction to Cloud Asset
            #     Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
            #     supported asset types and relationship types.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::ExportAssetsRequest.new
            #
            #   # Call the export_assets method.
            #   result = client.export_assets request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def export_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::ExportAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :export_assets, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists assets with time and resource types and returns paged results in
            # response.
            #
            # @overload list_assets(request, options = nil)
            #   Pass arguments to `list_assets` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::ListAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::ListAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_assets(parent: nil, read_time: nil, asset_types: nil, content_type: nil, page_size: nil, page_token: nil, relationship_types: nil)
            #   Pass arguments to `list_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the organization, folder, or project the assets belong
            #     to. Format: "organizations/[organization-number]" (such as
            #     "organizations/123"), "projects/[project-id]" (such as
            #     "projects/my-project-id"), "projects/[project-number]" (such as
            #     "projects/12345"), or "folders/[folder-number]" (such as "folders/12345").
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Timestamp to take an asset snapshot. This can only be set to a timestamp
            #     between the current time and the current time minus 35 days (inclusive).
            #     If not specified, the current time will be used. Due to delays in resource
            #     data collection and indexing, there is a volatile window during which
            #     running the same query may get different results.
            #   @param asset_types [::Array<::String>]
            #     A list of asset types to take a snapshot for. For example:
            #     "compute.googleapis.com/Disk".
            #
            #     Regular expression is also supported. For example:
            #
            #     * "compute.googleapis.com.*" snapshots resources whose asset type starts
            #     with "compute.googleapis.com".
            #     * ".*Instance" snapshots resources whose asset type ends with "Instance".
            #     * ".*Instance.*" snapshots resources whose asset type contains "Instance".
            #
            #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
            #     regular expression syntax. If the regular expression does not match any
            #     supported asset type, an INVALID_ARGUMENT error will be returned.
            #
            #     If specified, only matching assets will be returned, otherwise, it will
            #     snapshot all asset types. See [Introduction to Cloud Asset
            #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
            #     for all supported asset types.
            #   @param content_type [::Google::Cloud::Asset::V1::ContentType]
            #     Asset content type. If not specified, no content but the asset name will
            #     be returned.
            #   @param page_size [::Integer]
            #     The maximum number of assets to be returned in a single response. Default
            #     is 100, minimum is 1, and maximum is 1000.
            #   @param page_token [::String]
            #     The `next_page_token` returned from the previous `ListAssetsResponse`, or
            #     unspecified for the first `ListAssetsRequest`. It is a continuation of a
            #     prior `ListAssets` call, and the API should return the next page of assets.
            #   @param relationship_types [::Array<::String>]
            #     A list of relationship types to output, for example:
            #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
            #     content_type=RELATIONSHIP.
            #     * If specified:
            #     it snapshots specified relationships. It returns an error if
            #     any of the [relationship_types] doesn't belong to the supported
            #     relationship types of the [asset_types] or if any of the [asset_types]
            #     doesn't belong to the source types of the [relationship_types].
            #     * Otherwise:
            #     it snapshots the supported relationships for all [asset_types] or returns
            #     an error if any of the [asset_types] has no relationship support.
            #     An unspecified asset types field means all supported asset_types.
            #     See [Introduction to Cloud Asset
            #     Inventory](https://cloud.google.com/asset-inventory/docs/overview)
            #     for all supported asset types and relationship types.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::Asset>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::Asset>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::ListAssetsRequest.new
            #
            #   # Call the list_assets method.
            #   result = client.list_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::Asset.
            #     p item
            #   end
            #
            def list_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::ListAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :list_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :list_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Batch gets the update history of assets that overlap a time window.
            # For IAM_POLICY content, this API outputs history when the asset and its
            # attached IAM POLICY both exist. This can create gaps in the output history.
            # Otherwise, this API outputs history with asset in both non-delete or
            # deleted status.
            # If a specified asset does not exist, this API returns an INVALID_ARGUMENT
            # error.
            #
            # @overload batch_get_assets_history(request, options = nil)
            #   Pass arguments to `batch_get_assets_history` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_get_assets_history(parent: nil, asset_names: nil, content_type: nil, read_time_window: nil, relationship_types: nil)
            #   Pass arguments to `batch_get_assets_history` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative name of the root asset. It can only be an
            #     organization number (such as "organizations/123"), a project ID (such as
            #     "projects/my-project-id")", or a project number (such as "projects/12345").
            #   @param asset_names [::Array<::String>]
            #     A list of the full names of the assets.
            #     See: https://cloud.google.com/asset-inventory/docs/resource-name-format
            #     Example:
            #
            #     `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
            #
            #     The request becomes a no-op if the asset name list is empty, and the max
            #     size of the asset name list is 100 in one request.
            #   @param content_type [::Google::Cloud::Asset::V1::ContentType]
            #     Optional. The content type.
            #   @param read_time_window [::Google::Cloud::Asset::V1::TimeWindow, ::Hash]
            #     Optional. The time window for the asset history. Both start_time and
            #     end_time are optional and if set, it must be after the current time minus
            #     35 days. If end_time is not set, it is default to current timestamp.
            #     If start_time is not set, the snapshot of the assets at end_time will be
            #     returned. The returned results contain all temporal assets whose time
            #     window overlap with read_time_window.
            #   @param relationship_types [::Array<::String>]
            #     Optional. A list of relationship types to output, for example:
            #     `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
            #     content_type=RELATIONSHIP.
            #     * If specified:
            #     it outputs specified relationships' history on the [asset_names]. It
            #     returns an error if any of the [relationship_types] doesn't belong to the
            #     supported relationship types of the [asset_names] or if any of the
            #     [asset_names]'s types doesn't belong to the source types of the
            #     [relationship_types].
            #     * Otherwise:
            #     it outputs the supported relationships' history on the [asset_names] or
            #     returns an error if any of the [asset_names]'s types has no relationship
            #     support.
            #     See [Introduction to Cloud Asset
            #     Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
            #     supported asset types and relationship types.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::BatchGetAssetsHistoryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::BatchGetAssetsHistoryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest.new
            #
            #   # Call the batch_get_assets_history method.
            #   result = client.batch_get_assets_history request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::BatchGetAssetsHistoryResponse.
            #   p result
            #
            def batch_get_assets_history request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::BatchGetAssetsHistoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_get_assets_history.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_get_assets_history.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_get_assets_history.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :batch_get_assets_history, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a feed in a parent project/folder/organization to listen to its
            # asset updates.
            #
            # @overload create_feed(request, options = nil)
            #   Pass arguments to `create_feed` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::CreateFeedRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::CreateFeedRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_feed(parent: nil, feed_id: nil, feed: nil)
            #   Pass arguments to `create_feed` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project/folder/organization where this feed
            #     should be created in. It can only be an organization number (such as
            #     "organizations/123"), a folder number (such as "folders/123"), a project ID
            #     (such as "projects/my-project-id"), or a project number (such as
            #     "projects/12345").
            #   @param feed_id [::String]
            #     Required. This is the client-assigned asset feed identifier and it needs to
            #     be unique under a specific parent project/folder/organization.
            #   @param feed [::Google::Cloud::Asset::V1::Feed, ::Hash]
            #     Required. The feed details. The field `name` must be empty and it will be
            #     generated in the format of: projects/project_number/feeds/feed_id
            #     folders/folder_number/feeds/feed_id
            #     organizations/organization_number/feeds/feed_id
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::Feed]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::Feed]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::CreateFeedRequest.new
            #
            #   # Call the create_feed method.
            #   result = client.create_feed request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::Feed.
            #   p result
            #
            def create_feed request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::CreateFeedRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_feed.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_feed.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_feed.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :create_feed, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about an asset feed.
            #
            # @overload get_feed(request, options = nil)
            #   Pass arguments to `get_feed` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::GetFeedRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::GetFeedRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_feed(name: nil)
            #   Pass arguments to `get_feed` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Feed and it must be in the format of:
            #     projects/project_number/feeds/feed_id
            #     folders/folder_number/feeds/feed_id
            #     organizations/organization_number/feeds/feed_id
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::Feed]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::Feed]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::GetFeedRequest.new
            #
            #   # Call the get_feed method.
            #   result = client.get_feed request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::Feed.
            #   p result
            #
            def get_feed request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::GetFeedRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_feed.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_feed.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_feed.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :get_feed, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all asset feeds in a parent project/folder/organization.
            #
            # @overload list_feeds(request, options = nil)
            #   Pass arguments to `list_feeds` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::ListFeedsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::ListFeedsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_feeds(parent: nil)
            #   Pass arguments to `list_feeds` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent project/folder/organization whose feeds are to be
            #     listed. It can only be using project/folder/organization number (such as
            #     "folders/12345")", or a project ID (such as "projects/my-project-id").
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::ListFeedsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::ListFeedsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::ListFeedsRequest.new
            #
            #   # Call the list_feeds method.
            #   result = client.list_feeds request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::ListFeedsResponse.
            #   p result
            #
            def list_feeds request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::ListFeedsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_feeds.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_feeds.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_feeds.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :list_feeds, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an asset feed configuration.
            #
            # @overload update_feed(request, options = nil)
            #   Pass arguments to `update_feed` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::UpdateFeedRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::UpdateFeedRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_feed(feed: nil, update_mask: nil)
            #   Pass arguments to `update_feed` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param feed [::Google::Cloud::Asset::V1::Feed, ::Hash]
            #     Required. The new values of feed details. It must match an existing feed
            #     and the field `name` must be in the format of:
            #     projects/project_number/feeds/feed_id or
            #     folders/folder_number/feeds/feed_id or
            #     organizations/organization_number/feeds/feed_id.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Only updates the `feed` fields indicated by this mask.
            #     The field mask must not be empty, and it must not contain fields that
            #     are immutable or only set by the server.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::Feed]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::Feed]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::UpdateFeedRequest.new
            #
            #   # Call the update_feed method.
            #   result = client.update_feed request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::Feed.
            #   p result
            #
            def update_feed request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::UpdateFeedRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_feed.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.feed&.name
                header_params["feed.name"] = request.feed.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_feed.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_feed.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :update_feed, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an asset feed.
            #
            # @overload delete_feed(request, options = nil)
            #   Pass arguments to `delete_feed` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::DeleteFeedRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::DeleteFeedRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_feed(name: nil)
            #   Pass arguments to `delete_feed` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the feed and it must be in the format of:
            #     projects/project_number/feeds/feed_id
            #     folders/folder_number/feeds/feed_id
            #     organizations/organization_number/feeds/feed_id
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::DeleteFeedRequest.new
            #
            #   # Call the delete_feed method.
            #   result = client.delete_feed request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_feed request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::DeleteFeedRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_feed.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_feed.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_feed.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :delete_feed, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches all Google Cloud resources within the specified scope, such as a
            # project, folder, or organization. The caller must be granted the
            # `cloudasset.assets.searchAllResources` permission on the desired scope,
            # otherwise the request will be rejected.
            #
            # @overload search_all_resources(request, options = nil)
            #   Pass arguments to `search_all_resources` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::SearchAllResourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::SearchAllResourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_all_resources(scope: nil, query: nil, asset_types: nil, page_size: nil, page_token: nil, order_by: nil, read_mask: nil)
            #   Pass arguments to `search_all_resources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::String]
            #     Required. A scope can be a project, a folder, or an organization. The
            #     search is limited to the resources within the `scope`. The caller must be
            #     granted the
            #     [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
            #     permission on the desired scope.
            #
            #     The allowed values are:
            #
            #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
            #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
            #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param query [::String]
            #     Optional. The query statement. See [how to construct a
            #     query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
            #     for more information. If not specified or empty, it will search all the
            #     resources within the specified `scope`.
            #
            #     Examples:
            #
            #     * `name:Important` to find Google Cloud resources whose name contains
            #       `Important` as a word.
            #     * `name=Important` to find the Google Cloud resource whose name is exactly
            #       `Important`.
            #     * `displayName:Impor*` to find Google Cloud resources whose display name
            #       contains `Impor` as a prefix of any word in the field.
            #     * `location:us-west*` to find Google Cloud resources whose location
            #       contains both `us` and `west` as prefixes.
            #     * `labels:prod` to find Google Cloud resources whose labels contain `prod`
            #       as a key or value.
            #     * `labels.env:prod` to find Google Cloud resources that have a label `env`
            #       and its value is `prod`.
            #     * `labels.env:*` to find Google Cloud resources that have a label `env`.
            #     * `tagKeys:env` to find Google Cloud resources that have directly
            #       attached tags where the
            #       [`TagKey.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
            #       contains `env`.
            #     * `tagValues:prod*` to find Google Cloud resources that have directly
            #       attached tags where the
            #       [`TagValue.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
            #       contains a word prefixed by `prod`.
            #     * `tagValueIds=tagValues/123` to find Google Cloud resources that have
            #       directly attached tags where the
            #       [`TagValue.name`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
            #       is exactly `tagValues/123`.
            #     * `effectiveTagKeys:env` to find Google Cloud resources that have
            #       directly attached or inherited tags where the
            #       [`TagKey.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
            #       contains `env`.
            #     * `effectiveTagValues:prod*` to find Google Cloud resources that have
            #       directly attached or inherited tags where the
            #       [`TagValue.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
            #       contains a word prefixed by `prod`.
            #     * `effectiveTagValueIds=tagValues/123` to find Google Cloud resources that
            #        have directly attached or inherited tags where the
            #       [`TagValue.name`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
            #       is exactly `tagValues/123`.
            #     * `kmsKey:key` to find Google Cloud resources encrypted with a
            #       customer-managed encryption key whose name contains `key` as a word. This
            #       field is deprecated. Use the `kmsKeys` field to retrieve Cloud KMS
            #       key information.
            #     * `kmsKeys:key` to find Google Cloud resources encrypted with
            #       customer-managed encryption keys whose name contains the word `key`.
            #     * `relationships:instance-group-1` to find Google Cloud resources that have
            #       relationships with `instance-group-1` in the related resource name.
            #     * `relationships:INSTANCE_TO_INSTANCEGROUP` to find Compute Engine
            #       instances that have relationships of type `INSTANCE_TO_INSTANCEGROUP`.
            #     * `relationships.INSTANCE_TO_INSTANCEGROUP:instance-group-1` to find
            #       Compute Engine instances that have relationships with `instance-group-1`
            #       in the Compute Engine instance group resource name, for relationship type
            #       `INSTANCE_TO_INSTANCEGROUP`.
            #     * `sccSecurityMarks.key=value` to find Cloud resources that are attached
            #       with security marks whose key is `key` and value is `value`.
            #     * `sccSecurityMarks.key:*` to find Cloud resources that are attached with
            #       security marks whose key is `key`.
            #     * `state:ACTIVE` to find Google Cloud resources whose state contains
            #       `ACTIVE` as a word.
            #     * `NOT state:ACTIVE` to find Google Cloud resources whose state doesn't
            #       contain `ACTIVE` as a word.
            #     * `createTime<1609459200` to find Google Cloud resources that were created
            #       before `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
            #       `2021-01-01 00:00:00 UTC` in seconds.
            #     * `updateTime>1609459200` to find Google Cloud resources that were updated
            #       after `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
            #       `2021-01-01 00:00:00 UTC` in seconds.
            #     * `Important` to find Google Cloud resources that contain `Important` as a
            #       word in any of the searchable fields.
            #     * `Impor*` to find Google Cloud resources that contain `Impor` as a prefix
            #       of any word in any of the searchable fields.
            #     * `Important location:(us-west1 OR global)` to find Google Cloud
            #       resources that contain `Important` as a word in any of the searchable
            #       fields and are also located in the `us-west1` region or the `global`
            #       location.
            #   @param asset_types [::Array<::String>]
            #     Optional. A list of asset types that this request searches for. If empty,
            #     it will search all the asset types [supported by search
            #     APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
            #
            #     Regular expressions are also supported. For example:
            #
            #     * "compute.googleapis.com.*" snapshots resources whose asset type starts
            #     with "compute.googleapis.com".
            #     * ".*Instance" snapshots resources whose asset type ends with "Instance".
            #     * ".*Instance.*" snapshots resources whose asset type contains "Instance".
            #
            #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
            #     regular expression syntax. If the regular expression does not match any
            #     supported asset type, an INVALID_ARGUMENT error will be returned.
            #   @param page_size [::Integer]
            #     Optional. The page size for search result pagination. Page size is capped
            #     at 500 even if a larger value is given. If set to zero or a negative value,
            #     server will pick an appropriate default. Returned results may be fewer than
            #     requested. When this happens, there could be more results as long as
            #     `next_page_token` is returned.
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method. `page_token` must be the value of
            #     `next_page_token` from the previous response. The values of all other
            #     method parameters, must be identical to those in the previous call.
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields specifying the sorting order of
            #     the results. The default order is ascending. Add " DESC" after the field
            #     name to indicate descending order. Redundant space characters are ignored.
            #     Example: "location DESC, name".
            #     Only the following fields in the response are sortable:
            #
            #       * name
            #       * assetType
            #       * project
            #       * displayName
            #       * description
            #       * location
            #       * createTime
            #       * updateTime
            #       * state
            #       * parentFullResourceName
            #       * parentAssetType
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. A comma-separated list of fields that you want returned in the
            #     results. The following fields are returned by default if not specified:
            #
            #       * `name`
            #       * `assetType`
            #       * `project`
            #       * `folders`
            #       * `organization`
            #       * `displayName`
            #       * `description`
            #       * `location`
            #       * `labels`
            #       * `tags`
            #       * `effectiveTags`
            #       * `networkTags`
            #       * `kmsKeys`
            #       * `createTime`
            #       * `updateTime`
            #       * `state`
            #       * `additionalAttributes`
            #       * `parentFullResourceName`
            #       * `parentAssetType`
            #
            #     Some fields of large size, such as `versionedResources`,
            #     `attachedResources`, `effectiveTags` etc., are not returned by default, but
            #     you can specify them in the `read_mask` parameter if you want to include
            #     them. If `"*"` is specified, all [available
            #     fields](https://cloud.google.com/asset-inventory/docs/reference/rest/v1/TopLevel/searchAllResources#resourcesearchresult)
            #     are returned.
            #     Examples: `"name,location"`, `"name,versionedResources"`, `"*"`.
            #     Any invalid field path will trigger INVALID_ARGUMENT error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::ResourceSearchResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::ResourceSearchResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::SearchAllResourcesRequest.new
            #
            #   # Call the search_all_resources method.
            #   result = client.search_all_resources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::ResourceSearchResult.
            #     p item
            #   end
            #
            def search_all_resources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::SearchAllResourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_all_resources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.scope
                header_params["scope"] = request.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_all_resources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_all_resources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :search_all_resources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :search_all_resources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches all IAM policies within the specified scope, such as a project,
            # folder, or organization. The caller must be granted the
            # `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
            # otherwise the request will be rejected.
            #
            # @overload search_all_iam_policies(request, options = nil)
            #   Pass arguments to `search_all_iam_policies` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_all_iam_policies(scope: nil, query: nil, page_size: nil, page_token: nil, asset_types: nil, order_by: nil)
            #   Pass arguments to `search_all_iam_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::String]
            #     Required. A scope can be a project, a folder, or an organization. The
            #     search is limited to the IAM policies within the `scope`. The caller must
            #     be granted the
            #     [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
            #     permission on the desired scope.
            #
            #     The allowed values are:
            #
            #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
            #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
            #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param query [::String]
            #     Optional. The query statement. See [how to construct a
            #     query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
            #     for more information. If not specified or empty, it will search all the
            #     IAM policies within the specified `scope`. Note that the query string is
            #     compared against each IAM policy binding, including its principals,
            #     roles, and IAM conditions. The returned IAM policies will only
            #     contain the bindings that match your query. To learn more about the IAM
            #     policy structure, see the [IAM policy
            #     documentation](https://cloud.google.com/iam/help/allow-policies/structure).
            #
            #     Examples:
            #
            #     * `policy:amy@gmail.com` to find IAM policy bindings that specify user
            #       "amy@gmail.com".
            #     * `policy:roles/compute.admin` to find IAM policy bindings that specify
            #       the Compute Admin role.
            #     * `policy:comp*` to find IAM policy bindings that contain "comp" as a
            #       prefix of any word in the binding.
            #     * `policy.role.permissions:storage.buckets.update` to find IAM policy
            #       bindings that specify a role containing "storage.buckets.update"
            #       permission. Note that if callers don't have `iam.roles.get` access to a
            #       role's included permissions, policy bindings that specify this role will
            #       be dropped from the search results.
            #     * `policy.role.permissions:upd*` to find IAM policy bindings that specify a
            #       role containing "upd" as a prefix of any word in the role permission.
            #       Note that if callers don't have `iam.roles.get` access to a role's
            #       included permissions, policy bindings that specify this role will be
            #       dropped from the search results.
            #     * `resource:organizations/123456` to find IAM policy bindings
            #       that are set on "organizations/123456".
            #     * `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
            #       find IAM policy bindings that are set on the project named "myproject".
            #     * `Important` to find IAM policy bindings that contain "Important" as a
            #       word in any of the searchable fields (except for the included
            #       permissions).
            #     * `resource:(instance1 OR instance2) policy:amy` to find
            #       IAM policy bindings that are set on resources "instance1" or
            #       "instance2" and also specify user "amy".
            #     * `roles:roles/compute.admin` to find IAM policy bindings that specify the
            #       Compute Admin role.
            #     * `memberTypes:user` to find IAM policy bindings that contain the
            #       principal type "user".
            #   @param page_size [::Integer]
            #     Optional. The page size for search result pagination. Page size is capped
            #     at 500 even if a larger value is given. If set to zero or a negative value,
            #     server will pick an appropriate default. Returned results may be fewer than
            #     requested. When this happens, there could be more results as long as
            #     `next_page_token` is returned.
            #   @param page_token [::String]
            #     Optional. If present, retrieve the next batch of results from the preceding
            #     call to this method. `page_token` must be the value of `next_page_token`
            #     from the previous response. The values of all other method parameters must
            #     be identical to those in the previous call.
            #   @param asset_types [::Array<::String>]
            #     Optional. A list of asset types that the IAM policies are attached to. If
            #     empty, it will search the IAM policies that are attached to all the asset
            #     types [supported by search
            #     APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
            #
            #     Regular expressions are also supported. For example:
            #
            #     * "compute.googleapis.com.*" snapshots IAM policies attached to asset type
            #     starts with "compute.googleapis.com".
            #     * ".*Instance" snapshots IAM policies attached to asset type ends with
            #     "Instance".
            #     * ".*Instance.*" snapshots IAM policies attached to asset type contains
            #     "Instance".
            #
            #     See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
            #     regular expression syntax. If the regular expression does not match any
            #     supported asset type, an INVALID_ARGUMENT error will be returned.
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields specifying the sorting order of
            #     the results. The default order is ascending. Add " DESC" after the field
            #     name to indicate descending order. Redundant space characters are ignored.
            #     Example: "assetType DESC, resource".
            #     Only singular primitive fields in the response are sortable:
            #       * resource
            #       * assetType
            #       * project
            #     All the other fields such as repeated fields (e.g., `folders`) and
            #     non-primitive fields (e.g., `policy`) are not supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::IamPolicySearchResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::IamPolicySearchResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest.new
            #
            #   # Call the search_all_iam_policies method.
            #   result = client.search_all_iam_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::IamPolicySearchResult.
            #     p item
            #   end
            #
            def search_all_iam_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::SearchAllIamPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_all_iam_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.scope
                header_params["scope"] = request.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_all_iam_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_all_iam_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :search_all_iam_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :search_all_iam_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyzes IAM policies to answer which identities have what accesses on
            # which resources.
            #
            # @overload analyze_iam_policy(request, options = nil)
            #   Pass arguments to `analyze_iam_policy` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_iam_policy(analysis_query: nil, saved_analysis_query: nil, execution_timeout: nil)
            #   Pass arguments to `analyze_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param analysis_query [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery, ::Hash]
            #     Required. The request query.
            #   @param saved_analysis_query [::String]
            #     Optional. The name of a saved query, which must be in the format of:
            #
            #     * projects/project_number/savedQueries/saved_query_id
            #     * folders/folder_number/savedQueries/saved_query_id
            #     * organizations/organization_number/savedQueries/saved_query_id
            #
            #     If both `analysis_query` and `saved_analysis_query` are provided, they
            #     will be merged together with the `saved_analysis_query` as base and
            #     the `analysis_query` as overrides. For more details of the merge behavior,
            #     refer to the
            #     [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
            #     page.
            #
            #     Note that you cannot override primitive fields with default value, such as
            #     0 or empty string, etc., because we use proto3, which doesn't support field
            #     presence yet.
            #   @param execution_timeout [::Google::Protobuf::Duration, ::Hash]
            #     Optional. Amount of time executable has to complete.  See JSON
            #     representation of
            #     [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
            #
            #     If this field is set with a value less than the RPC deadline, and the
            #     execution of your query hasn't finished in the specified
            #     execution timeout,  you will get a response with partial result.
            #     Otherwise, your query's execution will continue until the RPC deadline.
            #     If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
            #
            #     Default is empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest.new
            #
            #   # Call the analyze_iam_policy method.
            #   result = client.analyze_iam_policy request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse.
            #   p result
            #
            def analyze_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::AnalyzeIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.analysis_query&.scope
                header_params["analysis_query.scope"] = request.analysis_query.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :analyze_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyzes IAM policies asynchronously to answer which identities have what
            # accesses on which resources, and writes the analysis results to a Google
            # Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
            # output format is the JSON format that represents a
            # {::Google::Cloud::Asset::V1::AnalyzeIamPolicyResponse AnalyzeIamPolicyResponse}.
            # This method implements the
            # {::Google::Longrunning::Operation google.longrunning.Operation}, which allows
            # you to track the operation status. We recommend intervals of at least 2
            # seconds with exponential backoff retry to poll the operation result. The
            # metadata contains the metadata for the long-running operation.
            #
            # @overload analyze_iam_policy_longrunning(request, options = nil)
            #   Pass arguments to `analyze_iam_policy_longrunning` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_iam_policy_longrunning(analysis_query: nil, saved_analysis_query: nil, output_config: nil)
            #   Pass arguments to `analyze_iam_policy_longrunning` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param analysis_query [::Google::Cloud::Asset::V1::IamPolicyAnalysisQuery, ::Hash]
            #     Required. The request query.
            #   @param saved_analysis_query [::String]
            #     Optional. The name of a saved query, which must be in the format of:
            #
            #     * projects/project_number/savedQueries/saved_query_id
            #     * folders/folder_number/savedQueries/saved_query_id
            #     * organizations/organization_number/savedQueries/saved_query_id
            #
            #     If both `analysis_query` and `saved_analysis_query` are provided, they
            #     will be merged together with the `saved_analysis_query` as base and
            #     the `analysis_query` as overrides. For more details of the merge behavior,
            #     refer to the
            #     [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
            #     doc.
            #
            #     Note that you cannot override primitive fields with default value, such as
            #     0 or empty string, etc., because we use proto3, which doesn't support field
            #     presence yet.
            #   @param output_config [::Google::Cloud::Asset::V1::IamPolicyAnalysisOutputConfig, ::Hash]
            #     Required. Output configuration indicating where the results will be output
            #     to.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest.new
            #
            #   # Call the analyze_iam_policy_longrunning method.
            #   result = client.analyze_iam_policy_longrunning request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def analyze_iam_policy_longrunning request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::AnalyzeIamPolicyLongrunningRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_iam_policy_longrunning.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.analysis_query&.scope
                header_params["analysis_query.scope"] = request.analysis_query.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_iam_policy_longrunning.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_iam_policy_longrunning.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :analyze_iam_policy_longrunning, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyze moving a resource to a specified destination without kicking off
            # the actual move. The analysis is best effort depending on the user's
            # permissions of viewing different hierarchical policies and configurations.
            # The policies and configuration are subject to change before the actual
            # resource migration takes place.
            #
            # @overload analyze_move(request, options = nil)
            #   Pass arguments to `analyze_move` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::AnalyzeMoveRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::AnalyzeMoveRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_move(resource: nil, destination_parent: nil, view: nil)
            #   Pass arguments to `analyze_move` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     Required. Name of the resource to perform the analysis against.
            #     Only Google Cloud projects are supported as of today. Hence, this can only
            #     be a project ID (such as "projects/my-project-id") or a project number
            #     (such as "projects/12345").
            #   @param destination_parent [::String]
            #     Required. Name of the Google Cloud folder or organization to reparent the
            #     target resource. The analysis will be performed against hypothetically
            #     moving the resource to this specified destination parent. This can only be
            #     a folder number (such as "folders/123") or an organization number (such as
            #     "organizations/123").
            #   @param view [::Google::Cloud::Asset::V1::AnalyzeMoveRequest::AnalysisView]
            #     Analysis view indicating what information should be included in the
            #     analysis response. If unspecified, the default view is FULL.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::AnalyzeMoveResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::AnalyzeMoveResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::AnalyzeMoveRequest.new
            #
            #   # Call the analyze_move method.
            #   result = client.analyze_move request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::AnalyzeMoveResponse.
            #   p result
            #
            def analyze_move request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::AnalyzeMoveRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_move.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_move.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_move.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :analyze_move, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Issue a job that queries assets using a SQL statement compatible with
            # [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
            #
            # If the query execution finishes within timeout and there's no pagination,
            # the full query results will be returned in the `QueryAssetsResponse`.
            #
            # Otherwise, full query results can be obtained by issuing extra requests
            # with the `job_reference` from the a previous `QueryAssets` call.
            #
            # Note, the query result has approximately 10 GB limitation enforced by
            # [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
            # Queries return larger results will result in errors.
            #
            # @overload query_assets(request, options = nil)
            #   Pass arguments to `query_assets` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::QueryAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::QueryAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_assets(parent: nil, statement: nil, job_reference: nil, page_size: nil, page_token: nil, timeout: nil, read_time_window: nil, read_time: nil, output_config: nil)
            #   Pass arguments to `query_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative name of the root asset. This can only be an
            #     organization number (such as "organizations/123"), a project ID (such as
            #     "projects/my-project-id"), or a project number (such as "projects/12345"),
            #     or a folder number (such as "folders/123").
            #
            #     Only assets belonging to the `parent` will be returned.
            #   @param statement [::String]
            #     Optional. A SQL statement that's compatible with [BigQuery
            #     SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
            #
            #     Note: The following parameters are mutually exclusive: `statement`, `job_reference`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param job_reference [::String]
            #     Optional. Reference to the query job, which is from the
            #     `QueryAssetsResponse` of previous `QueryAssets` call.
            #
            #     Note: The following parameters are mutually exclusive: `job_reference`, `statement`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of rows to return in the results. Responses
            #     are limited to 10 MB and 1000 rows.
            #
            #     By default, the maximum row count is 1000. When the byte or row count limit
            #     is reached, the rest of the query results will be paginated.
            #
            #     The field will be ignored when [output_config] is specified.
            #   @param page_token [::String]
            #     Optional. A page token received from previous `QueryAssets`.
            #
            #     The field will be ignored when [output_config] is specified.
            #   @param timeout [::Google::Protobuf::Duration, ::Hash]
            #     Optional. Specifies the maximum amount of time that the client is willing
            #     to wait for the query to complete. By default, this limit is 5 min for the
            #     first query, and 1 minute for the following queries. If the query is
            #     complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
            #     false.
            #
            #     Like BigQuery [jobs.query
            #     API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
            #     The call is not guaranteed to wait for the specified timeout; it typically
            #     returns after around 200 seconds (200,000 milliseconds), even if the query
            #     is not complete.
            #
            #     The field will be ignored when [output_config] is specified.
            #   @param read_time_window [::Google::Cloud::Asset::V1::TimeWindow, ::Hash]
            #     Optional. [start_time] is required. [start_time] must be less than
            #     [end_time] Defaults [end_time] to now if [start_time] is set and
            #     [end_time] isn't. Maximum permitted time range is 7 days.
            #
            #     Note: The following parameters are mutually exclusive: `read_time_window`, `read_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param read_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Optional. Queries cloud assets as they appeared at the specified point in
            #     time.
            #
            #     Note: The following parameters are mutually exclusive: `read_time`, `read_time_window`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param output_config [::Google::Cloud::Asset::V1::QueryAssetsOutputConfig, ::Hash]
            #     Optional. Destination where the query results will be saved.
            #
            #     When this field is specified, the query results won't be saved in the
            #     [QueryAssetsResponse.query_result]. Instead
            #     [QueryAssetsResponse.output_config] will be set.
            #
            #     Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
            #     to check the status of the query job when passed to a following
            #     [QueryAssets] API call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::QueryAssetsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::QueryAssetsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::QueryAssetsRequest.new
            #
            #   # Call the query_assets method.
            #   result = client.query_assets request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::QueryAssetsResponse.
            #   p result
            #
            def query_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::QueryAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :query_assets, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a saved query in a parent project/folder/organization.
            #
            # @overload create_saved_query(request, options = nil)
            #   Pass arguments to `create_saved_query` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::CreateSavedQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::CreateSavedQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_saved_query(parent: nil, saved_query: nil, saved_query_id: nil)
            #   Pass arguments to `create_saved_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project/folder/organization where this
            #     saved_query should be created in. It can only be an organization number
            #     (such as "organizations/123"), a folder number (such as "folders/123"), a
            #     project ID (such as "projects/my-project-id"), or a project number (such as
            #     "projects/12345").
            #   @param saved_query [::Google::Cloud::Asset::V1::SavedQuery, ::Hash]
            #     Required. The saved_query details. The `name` field must be empty as it
            #     will be generated based on the parent and saved_query_id.
            #   @param saved_query_id [::String]
            #     Required. The ID to use for the saved query, which must be unique in the
            #     specified parent. It will become the final component of the saved query's
            #     resource name.
            #
            #     This value should be 4-63 characters, and valid characters
            #     are `[a-z][0-9]-`.
            #
            #     Notice that this field is required in the saved query creation, and the
            #     `name` field of the `saved_query` will be ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::SavedQuery]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::SavedQuery]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::CreateSavedQueryRequest.new
            #
            #   # Call the create_saved_query method.
            #   result = client.create_saved_query request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::SavedQuery.
            #   p result
            #
            def create_saved_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::CreateSavedQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_saved_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_saved_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_saved_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :create_saved_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details about a saved query.
            #
            # @overload get_saved_query(request, options = nil)
            #   Pass arguments to `get_saved_query` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::GetSavedQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::GetSavedQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_saved_query(name: nil)
            #   Pass arguments to `get_saved_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the saved query and it must be in the format of:
            #
            #     * projects/project_number/savedQueries/saved_query_id
            #     * folders/folder_number/savedQueries/saved_query_id
            #     * organizations/organization_number/savedQueries/saved_query_id
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::SavedQuery]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::SavedQuery]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::GetSavedQueryRequest.new
            #
            #   # Call the get_saved_query method.
            #   result = client.get_saved_query request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::SavedQuery.
            #   p result
            #
            def get_saved_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::GetSavedQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_saved_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_saved_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_saved_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :get_saved_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all saved queries in a parent project/folder/organization.
            #
            # @overload list_saved_queries(request, options = nil)
            #   Pass arguments to `list_saved_queries` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::ListSavedQueriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::ListSavedQueriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_saved_queries(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_saved_queries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent project/folder/organization whose savedQueries are to
            #     be listed. It can only be using project/folder/organization number (such as
            #     "folders/12345")", or a project ID (such as "projects/my-project-id").
            #   @param filter [::String]
            #     Optional. The expression to filter resources.
            #     The expression is a list of zero or more restrictions combined via logical
            #     operators `AND` and `OR`. When `AND` and `OR` are both used in the
            #     expression, parentheses must be appropriately used to group the
            #     combinations. The expression may also contain regular expressions.
            #
            #     See https://google.aip.dev/160 for more information on the grammar.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of saved queries to return per page. The
            #     service may return fewer than this value. If unspecified, at most 50 will
            #     be returned. The maximum value is 1000; values above 1000 will be coerced
            #     to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `ListSavedQueries` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListSavedQueries` must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::SavedQuery>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::SavedQuery>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::ListSavedQueriesRequest.new
            #
            #   # Call the list_saved_queries method.
            #   result = client.list_saved_queries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::SavedQuery.
            #     p item
            #   end
            #
            def list_saved_queries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::ListSavedQueriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_saved_queries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_saved_queries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_saved_queries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :list_saved_queries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :list_saved_queries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a saved query.
            #
            # @overload update_saved_query(request, options = nil)
            #   Pass arguments to `update_saved_query` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::UpdateSavedQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::UpdateSavedQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_saved_query(saved_query: nil, update_mask: nil)
            #   Pass arguments to `update_saved_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param saved_query [::Google::Cloud::Asset::V1::SavedQuery, ::Hash]
            #     Required. The saved query to update.
            #
            #     The saved query's `name` field is used to identify the one to update,
            #     which has format as below:
            #
            #     * projects/project_number/savedQueries/saved_query_id
            #     * folders/folder_number/savedQueries/saved_query_id
            #     * organizations/organization_number/savedQueries/saved_query_id
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The list of fields to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::SavedQuery]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::SavedQuery]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::UpdateSavedQueryRequest.new
            #
            #   # Call the update_saved_query method.
            #   result = client.update_saved_query request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::SavedQuery.
            #   p result
            #
            def update_saved_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::UpdateSavedQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_saved_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.saved_query&.name
                header_params["saved_query.name"] = request.saved_query.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_saved_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_saved_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :update_saved_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a saved query.
            #
            # @overload delete_saved_query(request, options = nil)
            #   Pass arguments to `delete_saved_query` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::DeleteSavedQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::DeleteSavedQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_saved_query(name: nil)
            #   Pass arguments to `delete_saved_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the saved query to delete. It must be in the format
            #     of:
            #
            #     * projects/project_number/savedQueries/saved_query_id
            #     * folders/folder_number/savedQueries/saved_query_id
            #     * organizations/organization_number/savedQueries/saved_query_id
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::DeleteSavedQueryRequest.new
            #
            #   # Call the delete_saved_query method.
            #   result = client.delete_saved_query request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_saved_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::DeleteSavedQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_saved_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_saved_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_saved_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :delete_saved_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets effective IAM policies for a batch of resources.
            #
            # @overload batch_get_effective_iam_policies(request, options = nil)
            #   Pass arguments to `batch_get_effective_iam_policies` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_get_effective_iam_policies(scope: nil, names: nil)
            #   Pass arguments to `batch_get_effective_iam_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::String]
            #     Required. Only IAM policies on or below the scope will be returned.
            #
            #     This can only be an organization number (such as "organizations/123"), a
            #     folder number (such as "folders/123"), a project ID (such as
            #     "projects/my-project-id"), or a project number (such as "projects/12345").
            #
            #     To know how to get organization ID, visit [here
            #     ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
            #
            #     To know how to get folder or project ID, visit [here
            #     ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
            #   @param names [::Array<::String>]
            #     Required. The names refer to the [full_resource_names]
            #     (https://cloud.google.com/asset-inventory/docs/resource-name-format)
            #     of the asset types [supported by search
            #     APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
            #     A maximum of 20 resources' effective policies can be retrieved in a batch.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest.new
            #
            #   # Call the batch_get_effective_iam_policies method.
            #   result = client.batch_get_effective_iam_policies request
            #
            #   # The returned object is of type Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesResponse.
            #   p result
            #
            def batch_get_effective_iam_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::BatchGetEffectiveIamPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_get_effective_iam_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.scope
                header_params["scope"] = request.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_get_effective_iam_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_get_effective_iam_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :batch_get_effective_iam_policies, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyzes organization policies under a scope.
            #
            # @overload analyze_org_policies(request, options = nil)
            #   Pass arguments to `analyze_org_policies` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_org_policies(scope: nil, constraint: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `analyze_org_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::String]
            #     Required. The organization to scope the request. Only organization
            #     policies within the scope will be analyzed.
            #
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param constraint [::String]
            #     Required. The name of the constraint to analyze organization policies for.
            #     The response only contains analyzed organization policies for the provided
            #     constraint.
            #   @param filter [::String]
            #     The expression to filter
            #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse#org_policy_results AnalyzeOrgPoliciesResponse.org_policy_results}.
            #     Filtering is currently available for bare literal values and the following
            #     fields:
            #     * consolidated_policy.attached_resource
            #     * consolidated_policy.rules.enforce
            #
            #     When filtering by a specific field, the only supported operator is `=`.
            #     For example, filtering by
            #     consolidated_policy.attached_resource="//cloudresourcemanager.googleapis.com/folders/001"
            #     will return all the Organization Policy results attached to "folders/001".
            #   @param page_size [::Integer]
            #     The maximum number of items to return per page. If unspecified,
            #     {::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse#org_policy_results AnalyzeOrgPoliciesResponse.org_policy_results}
            #     will contain 20 items with a maximum of 200.
            #   @param page_token [::String]
            #     The pagination token to retrieve the next page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse::OrgPolicyResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest.new
            #
            #   # Call the analyze_org_policies method.
            #   result = client.analyze_org_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesResponse::OrgPolicyResult.
            #     p item
            #   end
            #
            def analyze_org_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::AnalyzeOrgPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_org_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.scope
                header_params["scope"] = request.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_org_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_org_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :analyze_org_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :analyze_org_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyzes organization policies governed containers (projects, folders or
            # organization) under a scope.
            #
            # @overload analyze_org_policy_governed_containers(request, options = nil)
            #   Pass arguments to `analyze_org_policy_governed_containers` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_org_policy_governed_containers(scope: nil, constraint: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `analyze_org_policy_governed_containers` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::String]
            #     Required. The organization to scope the request. Only organization
            #     policies within the scope will be analyzed. The output containers will
            #     also be limited to the ones governed by those in-scope organization
            #     policies.
            #
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param constraint [::String]
            #     Required. The name of the constraint to analyze governed containers for.
            #     The analysis only contains organization policies for the provided
            #     constraint.
            #   @param filter [::String]
            #     The expression to filter
            #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse#governed_containers AnalyzeOrgPolicyGovernedContainersResponse.governed_containers}.
            #     Filtering is currently available for bare literal values and the following
            #     fields:
            #     * parent
            #     * consolidated_policy.rules.enforce
            #
            #     When filtering by a specific field, the only supported operator is `=`.
            #     For example, filtering by
            #     parent="//cloudresourcemanager.googleapis.com/folders/001"
            #     will return all the containers under "folders/001".
            #   @param page_size [::Integer]
            #     The maximum number of items to return per page. If unspecified,
            #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse#governed_containers AnalyzeOrgPolicyGovernedContainersResponse.governed_containers}
            #     will contain 100 items with a maximum of 200.
            #   @param page_token [::String]
            #     The pagination token to retrieve the next page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest.new
            #
            #   # Call the analyze_org_policy_governed_containers method.
            #   result = client.analyze_org_policy_governed_containers request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersResponse::GovernedContainer.
            #     p item
            #   end
            #
            def analyze_org_policy_governed_containers request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedContainersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_org_policy_governed_containers.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.scope
                header_params["scope"] = request.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_org_policy_governed_containers.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_org_policy_governed_containers.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :analyze_org_policy_governed_containers, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :analyze_org_policy_governed_containers, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyzes organization policies governed assets (Google Cloud resources or
            # policies) under a scope. This RPC supports custom constraints and the
            # following canned constraints:
            #
            # * constraints/ainotebooks.accessMode
            # * constraints/ainotebooks.disableFileDownloads
            # * constraints/ainotebooks.disableRootAccess
            # * constraints/ainotebooks.disableTerminal
            # * constraints/ainotebooks.environmentOptions
            # * constraints/ainotebooks.requireAutoUpgradeSchedule
            # * constraints/ainotebooks.restrictVpcNetworks
            # * constraints/compute.disableGuestAttributesAccess
            # * constraints/compute.disableInstanceDataAccessApis
            # * constraints/compute.disableNestedVirtualization
            # * constraints/compute.disableSerialPortAccess
            # * constraints/compute.disableSerialPortLogging
            # * constraints/compute.disableVpcExternalIpv6
            # * constraints/compute.requireOsLogin
            # * constraints/compute.requireShieldedVm
            # * constraints/compute.restrictLoadBalancerCreationForTypes
            # * constraints/compute.restrictProtocolForwardingCreationForTypes
            # * constraints/compute.restrictXpnProjectLienRemoval
            # * constraints/compute.setNewProjectDefaultToZonalDNSOnly
            # * constraints/compute.skipDefaultNetworkCreation
            # * constraints/compute.trustedImageProjects
            # * constraints/compute.vmCanIpForward
            # * constraints/compute.vmExternalIpAccess
            # * constraints/gcp.detailedAuditLoggingMode
            # * constraints/gcp.resourceLocations
            # * constraints/iam.allowedPolicyMemberDomains
            # * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
            # * constraints/iam.disableServiceAccountCreation
            # * constraints/iam.disableServiceAccountKeyCreation
            # * constraints/iam.disableServiceAccountKeyUpload
            # * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
            # * constraints/iam.serviceAccountKeyExpiryHours
            # * constraints/resourcemanager.accessBoundaries
            # * constraints/resourcemanager.allowedExportDestinations
            # * constraints/sql.restrictAuthorizedNetworks
            # * constraints/sql.restrictNoncompliantDiagnosticDataAccess
            # * constraints/sql.restrictNoncompliantResourceCreation
            # * constraints/sql.restrictPublicIp
            # * constraints/storage.publicAccessPrevention
            # * constraints/storage.restrictAuthTypes
            # * constraints/storage.uniformBucketLevelAccess
            #
            # This RPC only returns either resources of types [supported by search
            # APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
            # or IAM policies.
            #
            # @overload analyze_org_policy_governed_assets(request, options = nil)
            #   Pass arguments to `analyze_org_policy_governed_assets` via a request object, either of type
            #   {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_org_policy_governed_assets(scope: nil, constraint: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `analyze_org_policy_governed_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::String]
            #     Required. The organization to scope the request. Only organization
            #     policies within the scope will be analyzed. The output assets will
            #     also be limited to the ones governed by those in-scope organization
            #     policies.
            #
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param constraint [::String]
            #     Required. The name of the constraint to analyze governed assets for. The
            #     analysis only contains analyzed organization policies for the provided
            #     constraint.
            #   @param filter [::String]
            #     The expression to filter
            #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse#governed_assets AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets}.
            #
            #     For governed resources, filtering is currently available for bare literal
            #     values and the following fields:
            #     * governed_resource.project
            #     * governed_resource.folders
            #     * consolidated_policy.rules.enforce
            #     When filtering by `governed_resource.project` or
            #     `consolidated_policy.rules.enforce`, the only supported operator is `=`.
            #     When filtering by `governed_resource.folders`, the supported operators
            #     are `=` and `:`.
            #     For example, filtering by `governed_resource.project="projects/12345678"`
            #     will return all the governed resources under "projects/12345678",
            #     including the project itself if applicable.
            #
            #     For governed IAM policies, filtering is currently available for bare
            #     literal values and the following fields:
            #     * governed_iam_policy.project
            #     * governed_iam_policy.folders
            #     * consolidated_policy.rules.enforce
            #     When filtering by `governed_iam_policy.project` or
            #     `consolidated_policy.rules.enforce`, the only supported operator is `=`.
            #     When filtering by `governed_iam_policy.folders`, the supported operators
            #     are `=` and `:`.
            #     For example, filtering by `governed_iam_policy.folders:"folders/12345678"`
            #     will return all the governed IAM policies under "folders/001".
            #   @param page_size [::Integer]
            #     The maximum number of items to return per page. If unspecified,
            #     {::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse#governed_assets AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets}
            #     will contain 100 items with a maximum of 200.
            #   @param page_token [::String]
            #     The pagination token to retrieve the next page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/asset/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Asset::V1::AssetService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest.new
            #
            #   # Call the analyze_org_policy_governed_assets method.
            #   result = client.analyze_org_policy_governed_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset.
            #     p item
            #   end
            #
            def analyze_org_policy_governed_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Asset::V1::AnalyzeOrgPolicyGovernedAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_org_policy_governed_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Asset::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.scope
                header_params["scope"] = request.scope
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_org_policy_governed_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_org_policy_governed_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @asset_service_stub.call_rpc :analyze_org_policy_governed_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @asset_service_stub, :analyze_org_policy_governed_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the AssetService API.
            #
            # This class represents the configuration for AssetService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Asset::V1::AssetService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # export_assets to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Asset::V1::AssetService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.export_assets.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Asset::V1::AssetService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.export_assets.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Asset::V1::AssetService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudasset.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the AssetService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `export_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_assets
                ##
                # RPC-specific configuration for `list_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_assets
                ##
                # RPC-specific configuration for `batch_get_assets_history`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_get_assets_history
                ##
                # RPC-specific configuration for `create_feed`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_feed
                ##
                # RPC-specific configuration for `get_feed`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_feed
                ##
                # RPC-specific configuration for `list_feeds`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_feeds
                ##
                # RPC-specific configuration for `update_feed`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_feed
                ##
                # RPC-specific configuration for `delete_feed`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_feed
                ##
                # RPC-specific configuration for `search_all_resources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_all_resources
                ##
                # RPC-specific configuration for `search_all_iam_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_all_iam_policies
                ##
                # RPC-specific configuration for `analyze_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_iam_policy
                ##
                # RPC-specific configuration for `analyze_iam_policy_longrunning`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_iam_policy_longrunning
                ##
                # RPC-specific configuration for `analyze_move`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_move
                ##
                # RPC-specific configuration for `query_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_assets
                ##
                # RPC-specific configuration for `create_saved_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_saved_query
                ##
                # RPC-specific configuration for `get_saved_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_saved_query
                ##
                # RPC-specific configuration for `list_saved_queries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_saved_queries
                ##
                # RPC-specific configuration for `update_saved_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_saved_query
                ##
                # RPC-specific configuration for `delete_saved_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_saved_query
                ##
                # RPC-specific configuration for `batch_get_effective_iam_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_get_effective_iam_policies
                ##
                # RPC-specific configuration for `analyze_org_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_org_policies
                ##
                # RPC-specific configuration for `analyze_org_policy_governed_containers`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_org_policy_governed_containers
                ##
                # RPC-specific configuration for `analyze_org_policy_governed_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_org_policy_governed_assets

                # @private
                def initialize parent_rpcs = nil
                  export_assets_config = parent_rpcs.export_assets if parent_rpcs.respond_to? :export_assets
                  @export_assets = ::Gapic::Config::Method.new export_assets_config
                  list_assets_config = parent_rpcs.list_assets if parent_rpcs.respond_to? :list_assets
                  @list_assets = ::Gapic::Config::Method.new list_assets_config
                  batch_get_assets_history_config = parent_rpcs.batch_get_assets_history if parent_rpcs.respond_to? :batch_get_assets_history
                  @batch_get_assets_history = ::Gapic::Config::Method.new batch_get_assets_history_config
                  create_feed_config = parent_rpcs.create_feed if parent_rpcs.respond_to? :create_feed
                  @create_feed = ::Gapic::Config::Method.new create_feed_config
                  get_feed_config = parent_rpcs.get_feed if parent_rpcs.respond_to? :get_feed
                  @get_feed = ::Gapic::Config::Method.new get_feed_config
                  list_feeds_config = parent_rpcs.list_feeds if parent_rpcs.respond_to? :list_feeds
                  @list_feeds = ::Gapic::Config::Method.new list_feeds_config
                  update_feed_config = parent_rpcs.update_feed if parent_rpcs.respond_to? :update_feed
                  @update_feed = ::Gapic::Config::Method.new update_feed_config
                  delete_feed_config = parent_rpcs.delete_feed if parent_rpcs.respond_to? :delete_feed
                  @delete_feed = ::Gapic::Config::Method.new delete_feed_config
                  search_all_resources_config = parent_rpcs.search_all_resources if parent_rpcs.respond_to? :search_all_resources
                  @search_all_resources = ::Gapic::Config::Method.new search_all_resources_config
                  search_all_iam_policies_config = parent_rpcs.search_all_iam_policies if parent_rpcs.respond_to? :search_all_iam_policies
                  @search_all_iam_policies = ::Gapic::Config::Method.new search_all_iam_policies_config
                  analyze_iam_policy_config = parent_rpcs.analyze_iam_policy if parent_rpcs.respond_to? :analyze_iam_policy
                  @analyze_iam_policy = ::Gapic::Config::Method.new analyze_iam_policy_config
                  analyze_iam_policy_longrunning_config = parent_rpcs.analyze_iam_policy_longrunning if parent_rpcs.respond_to? :analyze_iam_policy_longrunning
                  @analyze_iam_policy_longrunning = ::Gapic::Config::Method.new analyze_iam_policy_longrunning_config
                  analyze_move_config = parent_rpcs.analyze_move if parent_rpcs.respond_to? :analyze_move
                  @analyze_move = ::Gapic::Config::Method.new analyze_move_config
                  query_assets_config = parent_rpcs.query_assets if parent_rpcs.respond_to? :query_assets
                  @query_assets = ::Gapic::Config::Method.new query_assets_config
                  create_saved_query_config = parent_rpcs.create_saved_query if parent_rpcs.respond_to? :create_saved_query
                  @create_saved_query = ::Gapic::Config::Method.new create_saved_query_config
                  get_saved_query_config = parent_rpcs.get_saved_query if parent_rpcs.respond_to? :get_saved_query
                  @get_saved_query = ::Gapic::Config::Method.new get_saved_query_config
                  list_saved_queries_config = parent_rpcs.list_saved_queries if parent_rpcs.respond_to? :list_saved_queries
                  @list_saved_queries = ::Gapic::Config::Method.new list_saved_queries_config
                  update_saved_query_config = parent_rpcs.update_saved_query if parent_rpcs.respond_to? :update_saved_query
                  @update_saved_query = ::Gapic::Config::Method.new update_saved_query_config
                  delete_saved_query_config = parent_rpcs.delete_saved_query if parent_rpcs.respond_to? :delete_saved_query
                  @delete_saved_query = ::Gapic::Config::Method.new delete_saved_query_config
                  batch_get_effective_iam_policies_config = parent_rpcs.batch_get_effective_iam_policies if parent_rpcs.respond_to? :batch_get_effective_iam_policies
                  @batch_get_effective_iam_policies = ::Gapic::Config::Method.new batch_get_effective_iam_policies_config
                  analyze_org_policies_config = parent_rpcs.analyze_org_policies if parent_rpcs.respond_to? :analyze_org_policies
                  @analyze_org_policies = ::Gapic::Config::Method.new analyze_org_policies_config
                  analyze_org_policy_governed_containers_config = parent_rpcs.analyze_org_policy_governed_containers if parent_rpcs.respond_to? :analyze_org_policy_governed_containers
                  @analyze_org_policy_governed_containers = ::Gapic::Config::Method.new analyze_org_policy_governed_containers_config
                  analyze_org_policy_governed_assets_config = parent_rpcs.analyze_org_policy_governed_assets if parent_rpcs.respond_to? :analyze_org_policy_governed_assets
                  @analyze_org_policy_governed_assets = ::Gapic::Config::Method.new analyze_org_policy_governed_assets_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
