# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/devtools/artifactregistry/v1beta2/service_pb"
require "google/cloud/artifact_registry/v1beta2/artifact_registry/rest"


class ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_import_apt_artifacts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"

    import_apt_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_import_apt_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_apt_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_apt_artifacts({ gcs_source: gcs_source, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_apt_artifacts gcs_source: gcs_source, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_apt_artifacts ::Google::Cloud::ArtifactRegistry::V1beta2::ImportAptArtifactsRequest.new(gcs_source: gcs_source, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_apt_artifacts({ gcs_source: gcs_source, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_apt_artifacts(::Google::Cloud::ArtifactRegistry::V1beta2::ImportAptArtifactsRequest.new(gcs_source: gcs_source, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_apt_artifacts_client_stub.call_count
      end
    end
  end

  def test_import_yum_artifacts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"

    import_yum_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_import_yum_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_yum_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_yum_artifacts({ gcs_source: gcs_source, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_yum_artifacts gcs_source: gcs_source, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_yum_artifacts ::Google::Cloud::ArtifactRegistry::V1beta2::ImportYumArtifactsRequest.new(gcs_source: gcs_source, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_yum_artifacts({ gcs_source: gcs_source, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_yum_artifacts(::Google::Cloud::ArtifactRegistry::V1beta2::ImportYumArtifactsRequest.new(gcs_source: gcs_source, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_yum_artifacts_client_stub.call_count
      end
    end
  end

  def test_list_repositories
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ListRepositoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_repositories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_repositories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_repositories_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_repositories parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_repositories ::Google::Cloud::ArtifactRegistry::V1beta2::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_repositories(::Google::Cloud::ArtifactRegistry::V1beta2::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_repositories_client_stub.call_count
      end
    end
  end

  def test_get_repository
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_repository({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_repository name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_repository ::Google::Cloud::ArtifactRegistry::V1beta2::GetRepositoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_repository({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_repository(::Google::Cloud::ArtifactRegistry::V1beta2::GetRepositoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_repository_client_stub.call_count
      end
    end
  end

  def test_create_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    repository_id = "hello world"
    repository = {}

    create_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_create_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_repository({ parent: parent, repository_id: repository_id, repository: repository }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_repository parent: parent, repository_id: repository_id, repository: repository do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_repository ::Google::Cloud::ArtifactRegistry::V1beta2::CreateRepositoryRequest.new(parent: parent, repository_id: repository_id, repository: repository) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_repository({ parent: parent, repository_id: repository_id, repository: repository }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_repository(::Google::Cloud::ArtifactRegistry::V1beta2::CreateRepositoryRequest.new(parent: parent, repository_id: repository_id, repository: repository), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_repository_client_stub.call_count
      end
    end
  end

  def test_update_repository
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    repository = {}
    update_mask = {}

    update_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_repository({ repository: repository, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_repository repository: repository, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_repository ::Google::Cloud::ArtifactRegistry::V1beta2::UpdateRepositoryRequest.new(repository: repository, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_repository({ repository: repository, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_repository(::Google::Cloud::ArtifactRegistry::V1beta2::UpdateRepositoryRequest.new(repository: repository, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_repository_client_stub.call_count
      end
    end
  end

  def test_delete_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_repository({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_repository name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_repository ::Google::Cloud::ArtifactRegistry::V1beta2::DeleteRepositoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_repository({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_repository(::Google::Cloud::ArtifactRegistry::V1beta2::DeleteRepositoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_repository_client_stub.call_count
      end
    end
  end

  def test_list_packages
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ListPackagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_packages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_packages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_packages_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_packages({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_packages parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_packages ::Google::Cloud::ArtifactRegistry::V1beta2::ListPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_packages({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_packages(::Google::Cloud::ArtifactRegistry::V1beta2::ListPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_packages_client_stub.call_count
      end
    end
  end

  def test_get_package
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Package.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_package ::Google::Cloud::ArtifactRegistry::V1beta2::GetPackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_package(::Google::Cloud::ArtifactRegistry::V1beta2::GetPackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_package_client_stub.call_count
      end
    end
  end

  def test_delete_package
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_package ::Google::Cloud::ArtifactRegistry::V1beta2::DeletePackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_package(::Google::Cloud::ArtifactRegistry::V1beta2::DeletePackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_package_client_stub.call_count
      end
    end
  end

  def test_list_versions
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ListVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :VERSION_VIEW_UNSPECIFIED
    order_by = "hello world"

    list_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_versions parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_versions ::Google::Cloud::ArtifactRegistry::V1beta2::ListVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_versions(::Google::Cloud::ArtifactRegistry::V1beta2::ListVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_versions_client_stub.call_count
      end
    end
  end

  def test_get_version
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Version.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :VERSION_VIEW_UNSPECIFIED

    get_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_version_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_version({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_version name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_version ::Google::Cloud::ArtifactRegistry::V1beta2::GetVersionRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_version({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_version(::Google::Cloud::ArtifactRegistry::V1beta2::GetVersionRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_version_client_stub.call_count
      end
    end
  end

  def test_delete_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_version_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_version({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_version name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_version ::Google::Cloud::ArtifactRegistry::V1beta2::DeleteVersionRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_version({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_version(::Google::Cloud::ArtifactRegistry::V1beta2::DeleteVersionRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_version_client_stub.call_count
      end
    end
  end

  def test_list_files
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ListFilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_files_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_files({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_files parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_files ::Google::Cloud::ArtifactRegistry::V1beta2::ListFilesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_files({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_files(::Google::Cloud::ArtifactRegistry::V1beta2::ListFilesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_files_client_stub.call_count
      end
    end
  end

  def test_get_file
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::File.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_file_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_file ::Google::Cloud::ArtifactRegistry::V1beta2::GetFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_file(::Google::Cloud::ArtifactRegistry::V1beta2::GetFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_file_client_stub.call_count
      end
    end
  end

  def test_list_tags
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ListTagsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_tags_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_tags_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tags_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tags({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tags parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tags ::Google::Cloud::ArtifactRegistry::V1beta2::ListTagsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tags({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tags(::Google::Cloud::ArtifactRegistry::V1beta2::ListTagsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tags_client_stub.call_count
      end
    end
  end

  def test_get_tag
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tag({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tag name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tag ::Google::Cloud::ArtifactRegistry::V1beta2::GetTagRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tag({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tag(::Google::Cloud::ArtifactRegistry::V1beta2::GetTagRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tag_client_stub.call_count
      end
    end
  end

  def test_create_tag
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tag_id = "hello world"
    tag = {}

    create_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_create_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tag({ parent: parent, tag_id: tag_id, tag: tag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tag parent: parent, tag_id: tag_id, tag: tag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tag ::Google::Cloud::ArtifactRegistry::V1beta2::CreateTagRequest.new(parent: parent, tag_id: tag_id, tag: tag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tag({ parent: parent, tag_id: tag_id, tag: tag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tag(::Google::Cloud::ArtifactRegistry::V1beta2::CreateTagRequest.new(parent: parent, tag_id: tag_id, tag: tag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tag_client_stub.call_count
      end
    end
  end

  def test_update_tag
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tag = {}
    update_mask = {}

    update_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tag({ tag: tag, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tag tag: tag, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tag ::Google::Cloud::ArtifactRegistry::V1beta2::UpdateTagRequest.new(tag: tag, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tag({ tag: tag, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tag(::Google::Cloud::ArtifactRegistry::V1beta2::UpdateTagRequest.new(tag: tag, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tag_client_stub.call_count
      end
    end
  end

  def test_delete_tag
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tag({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tag name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tag ::Google::Cloud::ArtifactRegistry::V1beta2::DeleteTagRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tag({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tag(::Google::Cloud::ArtifactRegistry::V1beta2::DeleteTagRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tag_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_get_project_settings
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ProjectSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_project_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_project_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_project_settings_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_project_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_project_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_project_settings ::Google::Cloud::ArtifactRegistry::V1beta2::GetProjectSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_project_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_project_settings(::Google::Cloud::ArtifactRegistry::V1beta2::GetProjectSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_project_settings_client_stub.call_count
      end
    end
  end

  def test_update_project_settings
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1beta2::ProjectSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_settings = {}
    update_mask = {}

    update_project_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_project_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_project_settings_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_project_settings({ project_settings: project_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_project_settings project_settings: project_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_project_settings ::Google::Cloud::ArtifactRegistry::V1beta2::UpdateProjectSettingsRequest.new(project_settings: project_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_project_settings({ project_settings: project_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_project_settings(::Google::Cloud::ArtifactRegistry::V1beta2::UpdateProjectSettingsRequest.new(project_settings: project_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_project_settings_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client::Configuration, config
  end
end
