# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1beta2
        # A Repository for storing artifacts with a specific format.
        # @!attribute [rw] maven_config
        #   @return [::Google::Cloud::ArtifactRegistry::V1beta2::Repository::MavenRepositoryConfig]
        #     Maven repository config contains repository level configuration
        #     for the repositories of maven type.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the repository, for example:
        #     "projects/p1/locations/us-central1/repositories/repo1".
        # @!attribute [rw] format
        #   @return [::Google::Cloud::ArtifactRegistry::V1beta2::Repository::Format]
        #     The format of packages that are stored in the repository.
        # @!attribute [rw] description
        #   @return [::String]
        #     The user-provided description of the repository.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels with user-defined metadata.
        #     This field may contain up to 64 entries. Label keys and values may be no
        #     longer than 63 characters. Label keys must begin with a lowercase letter
        #     and may only contain lowercase letters, numeric characters, underscores,
        #     and dashes.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the repository was created.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the repository was last updated.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     The Cloud KMS resource name of the customer managed encryption key that’s
        #     used to encrypt the contents of the Repository. Has the form:
        #     `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
        #     This value may not be changed after the Repository has been created.
        class Repository
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # MavenRepositoryConfig is maven related repository details.
          # Provides additional configuration details for repositories of the maven
          # format type.
          # @!attribute [rw] allow_snapshot_overwrites
          #   @return [::Boolean]
          #     The repository with this flag will allow publishing
          #     the same snapshot versions.
          # @!attribute [rw] version_policy
          #   @return [::Google::Cloud::ArtifactRegistry::V1beta2::Repository::MavenRepositoryConfig::VersionPolicy]
          #     Version policy defines the versions that the registry will accept.
          class MavenRepositoryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # VersionPolicy is the version policy for the repository.
            module VersionPolicy
              # VERSION_POLICY_UNSPECIFIED - the version policy is not defined.
              # When the version policy is not defined, no validation is performed
              # for the versions.
              VERSION_POLICY_UNSPECIFIED = 0

              # RELEASE - repository will accept only Release versions.
              RELEASE = 1

              # SNAPSHOT - repository will accept only Snapshot versions.
              SNAPSHOT = 2
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A package format.
          module Format
            # Unspecified package format.
            FORMAT_UNSPECIFIED = 0

            # Docker package format.
            DOCKER = 1

            # Maven package format.
            MAVEN = 2

            # NPM package format.
            NPM = 3

            # APT package format.
            APT = 5

            # YUM package format.
            YUM = 6

            # Python package format.
            PYTHON = 8
          end
        end

        # The request to list repositories.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose repositories will be listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of repositories to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListRepositoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing repositories.
        # @!attribute [rw] repositories
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1beta2::Repository>]
        #     The repositories returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of repositories, or empty if there are
        #     no more repositories to return.
        class ListRepositoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to retrieve a repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the repository to retrieve.
        class GetRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create a new repository.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource where the repository will be created.
        # @!attribute [rw] repository_id
        #   @return [::String]
        #     The repository id to use for this repository.
        # @!attribute [rw] repository
        #   @return [::Google::Cloud::ArtifactRegistry::V1beta2::Repository]
        #     The repository to be created.
        class CreateRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a repository.
        # @!attribute [rw] repository
        #   @return [::Google::Cloud::ArtifactRegistry::V1beta2::Repository]
        #     The repository that replaces the resource on the server.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The update mask applies to the resource. For the `FieldMask` definition,
        #     see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
        class UpdateRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the repository to delete.
        class DeleteRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
