# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1beta2
        # Packages are named collections of versions.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the package, for example:
        #     "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1".
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the package.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the package was created.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the package was last updated. This includes publishing a new
        #     version of the package.
        class Package
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list packages.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The name of the parent resource whose packages will be listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of packages to return.
        #     Maximum page size is 10,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListPackagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing packages.
        # @!attribute [rw] packages
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1beta2::Package>]
        #     The packages returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of packages, or empty if there are no
        #     more packages to return.
        class ListPackagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to retrieve a package.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the package to retrieve.
        class GetPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a package.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the package to delete.
        class DeletePackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
