# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/artifact_registry/v1beta2/version"

require "google/cloud/artifact_registry/v1beta2/artifact_registry/credentials"
require "google/cloud/artifact_registry/v1beta2/artifact_registry/paths"
require "google/cloud/artifact_registry/v1beta2/artifact_registry/operations"
require "google/cloud/artifact_registry/v1beta2/artifact_registry/client"
require "google/cloud/artifact_registry/v1beta2/artifact_registry/rest"

module Google
  module Cloud
    module ArtifactRegistry
      module V1beta2
        ##
        # The Artifact Registry API service.
        #
        # Artifact Registry is an artifact management system for storing artifacts
        # from different package management systems.
        #
        # The resources managed by this API are:
        #
        # * Repositories, which group packages and their data.
        # * Packages, which group versions and their tags.
        # * Versions, which are specific forms of a package.
        # * Tags, which represent alternative names for versions.
        # * Files, which contain content and are optionally associated with a Package
        #   or Version.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/artifact_registry/v1beta2/artifact_registry"
        #     client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/artifact_registry/v1beta2/artifact_registry/rest"
        #     client = ::Google::Cloud::ArtifactRegistry::V1beta2::ArtifactRegistry::Rest::Client.new
        #
        module ArtifactRegistry
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "artifact_registry", "helpers.rb"
require "google/cloud/artifact_registry/v1beta2/artifact_registry/helpers" if ::File.file? helper_path
