# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/devtools/artifactregistry/v1/service_pb"
require "google/cloud/artifact_registry/v1/artifact_registry/rest"


class ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_docker_images
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListDockerImagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_docker_images_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_docker_images_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_docker_images_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_docker_images({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_docker_images parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_docker_images ::Google::Cloud::ArtifactRegistry::V1::ListDockerImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_docker_images({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_docker_images(::Google::Cloud::ArtifactRegistry::V1::ListDockerImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_docker_images_client_stub.call_count
      end
    end
  end

  def test_get_docker_image
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::DockerImage.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_docker_image_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_docker_image_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_docker_image_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_docker_image({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_docker_image name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_docker_image ::Google::Cloud::ArtifactRegistry::V1::GetDockerImageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_docker_image({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_docker_image(::Google::Cloud::ArtifactRegistry::V1::GetDockerImageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_docker_image_client_stub.call_count
      end
    end
  end

  def test_list_maven_artifacts
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListMavenArtifactsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_maven_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_maven_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_maven_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_maven_artifacts({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_maven_artifacts parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_maven_artifacts ::Google::Cloud::ArtifactRegistry::V1::ListMavenArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_maven_artifacts({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_maven_artifacts(::Google::Cloud::ArtifactRegistry::V1::ListMavenArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_maven_artifacts_client_stub.call_count
      end
    end
  end

  def test_get_maven_artifact
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::MavenArtifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_maven_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_maven_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_maven_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_maven_artifact({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_maven_artifact name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_maven_artifact ::Google::Cloud::ArtifactRegistry::V1::GetMavenArtifactRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_maven_artifact({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_maven_artifact(::Google::Cloud::ArtifactRegistry::V1::GetMavenArtifactRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_maven_artifact_client_stub.call_count
      end
    end
  end

  def test_list_npm_packages
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListNpmPackagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_npm_packages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_npm_packages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_npm_packages_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_npm_packages({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_npm_packages parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_npm_packages ::Google::Cloud::ArtifactRegistry::V1::ListNpmPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_npm_packages({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_npm_packages(::Google::Cloud::ArtifactRegistry::V1::ListNpmPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_npm_packages_client_stub.call_count
      end
    end
  end

  def test_get_npm_package
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::NpmPackage.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_npm_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_npm_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_npm_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_npm_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_npm_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_npm_package ::Google::Cloud::ArtifactRegistry::V1::GetNpmPackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_npm_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_npm_package(::Google::Cloud::ArtifactRegistry::V1::GetNpmPackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_npm_package_client_stub.call_count
      end
    end
  end

  def test_list_python_packages
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListPythonPackagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_python_packages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_python_packages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_python_packages_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_python_packages({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_python_packages parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_python_packages ::Google::Cloud::ArtifactRegistry::V1::ListPythonPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_python_packages({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_python_packages(::Google::Cloud::ArtifactRegistry::V1::ListPythonPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_python_packages_client_stub.call_count
      end
    end
  end

  def test_get_python_package
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::PythonPackage.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_python_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_python_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_python_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_python_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_python_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_python_package ::Google::Cloud::ArtifactRegistry::V1::GetPythonPackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_python_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_python_package(::Google::Cloud::ArtifactRegistry::V1::GetPythonPackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_python_package_client_stub.call_count
      end
    end
  end

  def test_import_apt_artifacts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"

    import_apt_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_import_apt_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_apt_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_apt_artifacts({ gcs_source: gcs_source, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_apt_artifacts gcs_source: gcs_source, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_apt_artifacts ::Google::Cloud::ArtifactRegistry::V1::ImportAptArtifactsRequest.new(gcs_source: gcs_source, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_apt_artifacts({ gcs_source: gcs_source, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_apt_artifacts(::Google::Cloud::ArtifactRegistry::V1::ImportAptArtifactsRequest.new(gcs_source: gcs_source, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_apt_artifacts_client_stub.call_count
      end
    end
  end

  def test_import_yum_artifacts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_source = {}
    parent = "hello world"

    import_yum_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_import_yum_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_yum_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_yum_artifacts({ gcs_source: gcs_source, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_yum_artifacts gcs_source: gcs_source, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_yum_artifacts ::Google::Cloud::ArtifactRegistry::V1::ImportYumArtifactsRequest.new(gcs_source: gcs_source, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_yum_artifacts({ gcs_source: gcs_source, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_yum_artifacts(::Google::Cloud::ArtifactRegistry::V1::ImportYumArtifactsRequest.new(gcs_source: gcs_source, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_yum_artifacts_client_stub.call_count
      end
    end
  end

  def test_list_repositories
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListRepositoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_repositories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_repositories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_repositories_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_repositories parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_repositories ::Google::Cloud::ArtifactRegistry::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_repositories(::Google::Cloud::ArtifactRegistry::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_repositories_client_stub.call_count
      end
    end
  end

  def test_get_repository
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_repository({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_repository name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_repository ::Google::Cloud::ArtifactRegistry::V1::GetRepositoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_repository({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_repository(::Google::Cloud::ArtifactRegistry::V1::GetRepositoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_repository_client_stub.call_count
      end
    end
  end

  def test_create_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    repository_id = "hello world"
    repository = {}

    create_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_create_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_repository({ parent: parent, repository_id: repository_id, repository: repository }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_repository parent: parent, repository_id: repository_id, repository: repository do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_repository ::Google::Cloud::ArtifactRegistry::V1::CreateRepositoryRequest.new(parent: parent, repository_id: repository_id, repository: repository) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_repository({ parent: parent, repository_id: repository_id, repository: repository }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_repository(::Google::Cloud::ArtifactRegistry::V1::CreateRepositoryRequest.new(parent: parent, repository_id: repository_id, repository: repository), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_repository_client_stub.call_count
      end
    end
  end

  def test_update_repository
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    repository = {}
    update_mask = {}

    update_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_repository({ repository: repository, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_repository repository: repository, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_repository ::Google::Cloud::ArtifactRegistry::V1::UpdateRepositoryRequest.new(repository: repository, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_repository({ repository: repository, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_repository(::Google::Cloud::ArtifactRegistry::V1::UpdateRepositoryRequest.new(repository: repository, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_repository_client_stub.call_count
      end
    end
  end

  def test_delete_repository
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_repository_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_repository({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_repository name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_repository ::Google::Cloud::ArtifactRegistry::V1::DeleteRepositoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_repository({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_repository(::Google::Cloud::ArtifactRegistry::V1::DeleteRepositoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_repository_client_stub.call_count
      end
    end
  end

  def test_list_packages
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListPackagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_packages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_packages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_packages_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_packages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_packages parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_packages ::Google::Cloud::ArtifactRegistry::V1::ListPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_packages({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_packages(::Google::Cloud::ArtifactRegistry::V1::ListPackagesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_packages_client_stub.call_count
      end
    end
  end

  def test_get_package
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Package.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_package ::Google::Cloud::ArtifactRegistry::V1::GetPackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_package(::Google::Cloud::ArtifactRegistry::V1::GetPackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_package_client_stub.call_count
      end
    end
  end

  def test_delete_package
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_package({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_package name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_package ::Google::Cloud::ArtifactRegistry::V1::DeletePackageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_package({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_package(::Google::Cloud::ArtifactRegistry::V1::DeletePackageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_package_client_stub.call_count
      end
    end
  end

  def test_list_versions
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :VERSION_VIEW_UNSPECIFIED
    order_by = "hello world"
    filter = "hello world"

    list_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_versions parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_versions ::Google::Cloud::ArtifactRegistry::V1::ListVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_versions({ parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_versions(::Google::Cloud::ArtifactRegistry::V1::ListVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_versions_client_stub.call_count
      end
    end
  end

  def test_get_version
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Version.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :VERSION_VIEW_UNSPECIFIED

    get_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_version_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_version({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_version name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_version ::Google::Cloud::ArtifactRegistry::V1::GetVersionRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_version({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_version(::Google::Cloud::ArtifactRegistry::V1::GetVersionRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_version_client_stub.call_count
      end
    end
  end

  def test_delete_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_version_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_version({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_version name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_version ::Google::Cloud::ArtifactRegistry::V1::DeleteVersionRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_version({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_version(::Google::Cloud::ArtifactRegistry::V1::DeleteVersionRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_version_client_stub.call_count
      end
    end
  end

  def test_batch_delete_versions
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    validate_only = true

    batch_delete_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_batch_delete_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_versions({ parent: parent, names: names, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_versions parent: parent, names: names, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_versions ::Google::Cloud::ArtifactRegistry::V1::BatchDeleteVersionsRequest.new(parent: parent, names: names, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_versions({ parent: parent, names: names, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_versions(::Google::Cloud::ArtifactRegistry::V1::BatchDeleteVersionsRequest.new(parent: parent, names: names, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_versions_client_stub.call_count
      end
    end
  end

  def test_update_version
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Version.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    version = {}
    update_mask = {}

    update_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_version_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_version({ version: version, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_version version: version, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_version ::Google::Cloud::ArtifactRegistry::V1::UpdateVersionRequest.new(version: version, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_version({ version: version, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_version(::Google::Cloud::ArtifactRegistry::V1::UpdateVersionRequest.new(version: version, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_version_client_stub.call_count
      end
    end
  end

  def test_list_files
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListFilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_files_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_files({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_files parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_files ::Google::Cloud::ArtifactRegistry::V1::ListFilesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_files({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_files(::Google::Cloud::ArtifactRegistry::V1::ListFilesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_files_client_stub.call_count
      end
    end
  end

  def test_get_file
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::File.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_file_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_file ::Google::Cloud::ArtifactRegistry::V1::GetFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_file(::Google::Cloud::ArtifactRegistry::V1::GetFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_file_client_stub.call_count
      end
    end
  end

  def test_delete_file
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_file_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_file ::Google::Cloud::ArtifactRegistry::V1::DeleteFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_file(::Google::Cloud::ArtifactRegistry::V1::DeleteFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_file_client_stub.call_count
      end
    end
  end

  def test_update_file
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::File.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    file = {}
    update_mask = {}

    update_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_file_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_file({ file: file, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_file file: file, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_file ::Google::Cloud::ArtifactRegistry::V1::UpdateFileRequest.new(file: file, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_file({ file: file, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_file(::Google::Cloud::ArtifactRegistry::V1::UpdateFileRequest.new(file: file, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_file_client_stub.call_count
      end
    end
  end

  def test_list_tags
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListTagsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_tags_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_tags_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tags_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tags({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tags parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tags ::Google::Cloud::ArtifactRegistry::V1::ListTagsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tags({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tags(::Google::Cloud::ArtifactRegistry::V1::ListTagsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tags_client_stub.call_count
      end
    end
  end

  def test_get_tag
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tag({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tag name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tag ::Google::Cloud::ArtifactRegistry::V1::GetTagRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tag({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tag(::Google::Cloud::ArtifactRegistry::V1::GetTagRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tag_client_stub.call_count
      end
    end
  end

  def test_create_tag
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tag_id = "hello world"
    tag = {}

    create_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_create_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tag({ parent: parent, tag_id: tag_id, tag: tag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tag parent: parent, tag_id: tag_id, tag: tag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tag ::Google::Cloud::ArtifactRegistry::V1::CreateTagRequest.new(parent: parent, tag_id: tag_id, tag: tag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tag({ parent: parent, tag_id: tag_id, tag: tag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tag(::Google::Cloud::ArtifactRegistry::V1::CreateTagRequest.new(parent: parent, tag_id: tag_id, tag: tag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tag_client_stub.call_count
      end
    end
  end

  def test_update_tag
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tag = {}
    update_mask = {}

    update_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tag({ tag: tag, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tag tag: tag, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tag ::Google::Cloud::ArtifactRegistry::V1::UpdateTagRequest.new(tag: tag, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tag({ tag: tag, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tag(::Google::Cloud::ArtifactRegistry::V1::UpdateTagRequest.new(tag: tag, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tag_client_stub.call_count
      end
    end
  end

  def test_delete_tag
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tag_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tag({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tag name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tag ::Google::Cloud::ArtifactRegistry::V1::DeleteTagRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tag({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tag(::Google::Cloud::ArtifactRegistry::V1::DeleteTagRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tag_client_stub.call_count
      end
    end
  end

  def test_create_rule
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Rule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rule_id = "hello world"
    rule = {}

    create_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_create_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rule({ parent: parent, rule_id: rule_id, rule: rule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rule parent: parent, rule_id: rule_id, rule: rule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rule ::Google::Cloud::ArtifactRegistry::V1::CreateRuleRequest.new(parent: parent, rule_id: rule_id, rule: rule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rule({ parent: parent, rule_id: rule_id, rule: rule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rule(::Google::Cloud::ArtifactRegistry::V1::CreateRuleRequest.new(parent: parent, rule_id: rule_id, rule: rule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rule_client_stub.call_count
      end
    end
  end

  def test_list_rules
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rules_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rules({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rules parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rules ::Google::Cloud::ArtifactRegistry::V1::ListRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rules({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rules(::Google::Cloud::ArtifactRegistry::V1::ListRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rules_client_stub.call_count
      end
    end
  end

  def test_get_rule
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Rule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rule ::Google::Cloud::ArtifactRegistry::V1::GetRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rule(::Google::Cloud::ArtifactRegistry::V1::GetRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rule_client_stub.call_count
      end
    end
  end

  def test_update_rule
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Rule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rule = {}
    update_mask = {}

    update_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_rule({ rule: rule, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_rule rule: rule, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_rule ::Google::Cloud::ArtifactRegistry::V1::UpdateRuleRequest.new(rule: rule, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_rule({ rule: rule, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_rule(::Google::Cloud::ArtifactRegistry::V1::UpdateRuleRequest.new(rule: rule, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_rule_client_stub.call_count
      end
    end
  end

  def test_delete_rule
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_rule_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_rule ::Google::Cloud::ArtifactRegistry::V1::DeleteRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_rule(::Google::Cloud::ArtifactRegistry::V1::DeleteRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_rule_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_get_project_settings
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ProjectSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_project_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_project_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_project_settings_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_project_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_project_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_project_settings ::Google::Cloud::ArtifactRegistry::V1::GetProjectSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_project_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_project_settings(::Google::Cloud::ArtifactRegistry::V1::GetProjectSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_project_settings_client_stub.call_count
      end
    end
  end

  def test_update_project_settings
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ProjectSettings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_settings = {}
    update_mask = {}

    update_project_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_project_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_project_settings_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_project_settings({ project_settings: project_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_project_settings project_settings: project_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_project_settings ::Google::Cloud::ArtifactRegistry::V1::UpdateProjectSettingsRequest.new(project_settings: project_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_project_settings({ project_settings: project_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_project_settings(::Google::Cloud::ArtifactRegistry::V1::UpdateProjectSettingsRequest.new(project_settings: project_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_project_settings_client_stub.call_count
      end
    end
  end

  def test_get_vpcsc_config
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::VPCSCConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vpcsc_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_vpcsc_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_vpcsc_config_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_vpcsc_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_vpcsc_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_vpcsc_config ::Google::Cloud::ArtifactRegistry::V1::GetVPCSCConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_vpcsc_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_vpcsc_config(::Google::Cloud::ArtifactRegistry::V1::GetVPCSCConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_vpcsc_config_client_stub.call_count
      end
    end
  end

  def test_update_vpcsc_config
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::VPCSCConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    vpcsc_config = {}
    update_mask = {}

    update_vpcsc_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_vpcsc_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_vpcsc_config_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_vpcsc_config({ vpcsc_config: vpcsc_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_vpcsc_config vpcsc_config: vpcsc_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_vpcsc_config ::Google::Cloud::ArtifactRegistry::V1::UpdateVPCSCConfigRequest.new(vpcsc_config: vpcsc_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_vpcsc_config({ vpcsc_config: vpcsc_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_vpcsc_config(::Google::Cloud::ArtifactRegistry::V1::UpdateVPCSCConfigRequest.new(vpcsc_config: vpcsc_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_vpcsc_config_client_stub.call_count
      end
    end
  end

  def test_update_package
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Package.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    package = {}
    update_mask = {}

    update_package_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_update_package_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_package_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_package({ package: package, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_package package: package, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_package ::Google::Cloud::ArtifactRegistry::V1::UpdatePackageRequest.new(package: package, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_package({ package: package, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_package(::Google::Cloud::ArtifactRegistry::V1::UpdatePackageRequest.new(package: package, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_package_client_stub.call_count
      end
    end
  end

  def test_list_attachments
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::ListAttachmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_attachments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_list_attachments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_attachments_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_attachments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_attachments parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_attachments ::Google::Cloud::ArtifactRegistry::V1::ListAttachmentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_attachments({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_attachments(::Google::Cloud::ArtifactRegistry::V1::ListAttachmentsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_attachments_client_stub.call_count
      end
    end
  end

  def test_get_attachment
    # Create test objects.
    client_result = ::Google::Cloud::ArtifactRegistry::V1::Attachment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_get_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_attachment ::Google::Cloud::ArtifactRegistry::V1::GetAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_attachment(::Google::Cloud::ArtifactRegistry::V1::GetAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_attachment_client_stub.call_count
      end
    end
  end

  def test_create_attachment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    attachment_id = "hello world"
    attachment = {}

    create_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_create_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_attachment({ parent: parent, attachment_id: attachment_id, attachment: attachment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_attachment parent: parent, attachment_id: attachment_id, attachment: attachment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_attachment ::Google::Cloud::ArtifactRegistry::V1::CreateAttachmentRequest.new(parent: parent, attachment_id: attachment_id, attachment: attachment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_attachment({ parent: parent, attachment_id: attachment_id, attachment: attachment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_attachment(::Google::Cloud::ArtifactRegistry::V1::CreateAttachmentRequest.new(parent: parent, attachment_id: attachment_id, attachment: attachment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_attachment_client_stub.call_count
      end
    end
  end

  def test_delete_attachment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_delete_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_attachment ::Google::Cloud::ArtifactRegistry::V1::DeleteAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_attachment(::Google::Cloud::ArtifactRegistry::V1::DeleteAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_attachment_client_stub.call_count
      end
    end
  end

  def test_export_artifact
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    source_version = "hello world"
    gcs_path = "hello world"
    repository = "hello world"

    export_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::ServiceStub.stub :transcode_export_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_artifact({ source_version: source_version, gcs_path: gcs_path, repository: repository }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_artifact source_version: source_version, gcs_path: gcs_path, repository: repository do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_artifact ::Google::Cloud::ArtifactRegistry::V1::ExportArtifactRequest.new(source_version: source_version, gcs_path: gcs_path, repository: repository) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_artifact({ source_version: source_version, gcs_path: gcs_path, repository: repository }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_artifact(::Google::Cloud::ArtifactRegistry::V1::ExportArtifactRequest.new(source_version: source_version, gcs_path: gcs_path, repository: repository), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_artifact_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ArtifactRegistry::V1::ArtifactRegistry::Rest::Client::Configuration, config
  end
end
