# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # A rule defines the deny or allow action of the operation it applies to and
        # the conditions required for the rule to apply. You can set one rule for an
        # entire repository and one rule for each package within.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the rule, for example:
        #     `projects/p1/locations/us-central1/repositories/repo1/rules/rule1`.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Rule::Action]
        #     The action this rule takes.
        # @!attribute [rw] operation
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Rule::Operation]
        # @!attribute [rw] condition
        #   @return [::Google::Type::Expr]
        #     Optional. A CEL expression for conditions that must be met in order for the
        #     rule to apply. If not provided, the rule matches all objects.
        # @!attribute [rw] package_id
        #   @return [::String]
        #     The package ID the rule applies to.
        #     If empty, this rule applies to all packages inside the repository.
        class Rule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the action of the rule.
          module Action
            # Action not specified.
            ACTION_UNSPECIFIED = 0

            # Allow the operation.
            ALLOW = 1

            # Deny the operation.
            DENY = 2
          end

          # The operation the rule applies to.
          module Operation
            # Operation not specified.
            OPERATION_UNSPECIFIED = 0

            # Download operation.
            DOWNLOAD = 1
          end
        end

        # The request to list rules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent repository whose rules will be listed.
        #     For example:
        #     `projects/p1/locations/us-central1/repositories/repo1`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of rules to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing rules.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::Rule>]
        #     The rules returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of rules, or empty if there are no
        #     more rules to return.
        class ListRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to retrieve a rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the rule to retrieve.
        class GetRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create a new rule.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource where the rule will be created.
        # @!attribute [rw] rule_id
        #   @return [::String]
        #     The rule id to use for this repository.
        # @!attribute [rw] rule
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Rule]
        #     The rule to be created.
        class CreateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a rule.
        # @!attribute [rw] rule
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Rule]
        #     The rule that replaces the resource on the server.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The update mask applies to the resource. For the `FieldMask` definition,
        #     see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
        class UpdateRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the rule to delete.
        class DeleteRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
