# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # A hash of file content.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Hash::HashType]
        #     The algorithm used to compute the hash value.
        # @!attribute [rw] value
        #   @return [::String]
        #     The hash value.
        class Hash
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The algorithm used to compute the hash.
          module HashType
            # Unspecified.
            HASH_TYPE_UNSPECIFIED = 0

            # SHA256 hash.
            SHA256 = 1

            # MD5 hash.
            MD5 = 2
          end
        end

        # Files store content that is potentially associated with Packages or Versions.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the file, for example:
        #     `projects/p1/locations/us-central1/repositories/repo1/files/a%2Fb%2Fc.txt`.
        #     If the file ID part contains slashes, they are escaped.
        # @!attribute [rw] size_bytes
        #   @return [::Integer]
        #     The size of the File in bytes.
        # @!attribute [rw] hashes
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::Hash>]
        #     The hashes of the file content.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the File was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the File was last updated.
        # @!attribute [rw] owner
        #   @return [::String]
        #     The name of the Package or Version that owns this file, if any.
        # @!attribute [r] fetch_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the last attempt to refresh the file's data was
        #     made. Only set when the repository is remote.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Client specified annotations.
        class File
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request to list files.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the repository whose files will be listed. For
        #     example: "projects/p1/locations/us-central1/repositories/repo1
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression for filtering the results of the request. Filter rules are
        #     case insensitive. The fields eligible for filtering are:
        #
        #       * `name`
        #       * `owner`
        #       * `annotations`
        #
        #     Examples of using a filter:
        #
        #      To filter the results of your request to files with the name `my_file.txt`
        #      in project `my-project` in the `us-central` region, in repository
        #      `my-repo`, append the following filter expression to your request:
        #
        #       * `name="projects/my-project/locations/us-central1/repositories/my-repo/files/my-file.txt"`
        #
        #      You can also use wildcards to match any number of characters before or
        #      after the value:
        #
        #       * `name="projects/my-project/locations/us-central1/repositories/my-repo/files/my-*"`
        #       * `name="projects/my-project/locations/us-central1/repositories/my-repo/files/*file.txt"`
        #       * `name="projects/my-project/locations/us-central1/repositories/my-repo/files/*file*"`
        #
        #      To filter the results of your request to files owned by the version `1.0`
        #      in package `pkg1`, append the following filter expression to your request:
        #
        #       * `owner="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/versions/1.0"`
        #
        #      To filter the results of your request to files with the annotation
        #      key-value pair [`external_link`: `external_link_value`], append the
        #      following filter expression to your request:
        #
        #       * `"annotations.external_link:external_link_value"`
        #
        #      To filter just for a specific annotation key `external_link`, append the
        #      following filter expression to your request:
        #
        #       * `"annotations.external_link"`
        #
        #      If the annotation key or value contains special characters, you can escape
        #      them by surrounding the value with backticks. For example, to filter the
        #      results of your request to files with the annotation key-value pair
        #      [`external.link`:`https://example.com/my-file`], append the following
        #      filter expression to your request:
        #
        #       * `` "annotations.`external.link`:`https://example.com/my-file`" ``
        #
        #      You can also filter with annotations with a wildcard to
        #      match any number of characters before or after the value:
        #
        #       * `` "annotations.*_link:`*example.com*`" ``
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of files to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     The field to order the results by.
        class ListFilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing files.
        # @!attribute [rw] files
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::File>]
        #     The files returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of files, or empty if there are no
        #     more files to return.
        class ListFilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to retrieve a file.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the file to retrieve.
        class GetFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete a file.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the file to delete.
        class DeleteFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to update a file.
        # @!attribute [rw] file
        #   @return [::Google::Cloud::ArtifactRegistry::V1::File]
        #     Required. The File that replaces the resource on the server.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. For the `FieldMask`
        #     definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
        class UpdateFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
