# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # The request for exporting an artifact to a destination.
        # @!attribute [rw] source_version
        #   @return [::String]
        #     The artifact version to export.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/repositories/\\{repository}/packages/\\{package}/versions/\\{version}
        #
        #     Note: The following fields are mutually exclusive: `source_version`, `source_tag`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_tag
        #   @return [::String]
        #     The artifact tag to export.
        #     Format:projects/\\{project}/locations/\\{location}/repositories/\\{repository}/packages/\\{package}/tags/\\{tag}
        #
        #     Note: The following fields are mutually exclusive: `source_tag`, `source_version`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_path
        #   @return [::String]
        #     The Cloud Storage path to export the artifact to. Should start with the
        #     bucket name, and optionally have a directory path. Examples:
        #     `dst_bucket`, `dst_bucket/sub_dir`.
        #     Existing objects with the same path will be overwritten.
        # @!attribute [rw] repository
        #   @return [::String]
        #     Required. The repository of the artifact to export.
        #     Format: projects/\\{project}/locations/\\{location}/repositories/\\{repository}
        class ExportArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for exporting an artifact to a destination.
        # @!attribute [rw] exported_version
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Version]
        #     The exported version. Should be the same as the request version with
        #     fingerprint resource name.
        class ExportArtifactResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The LRO metadata for exporting an artifact.
        # @!attribute [rw] exported_files
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::ExportArtifactMetadata::ExportedFile>]
        #     The exported artifact files.
        class ExportArtifactMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The exported artifact file.
          # @!attribute [rw] gcs_object_path
          #   @return [::String]
          #     Cloud Storage Object path of the exported file. Examples:
          #     `dst_bucket/file1`, `dst_bucket/sub_dir/file1`
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the exported artifact file.
          #     Format: `projects/p1/locations/us/repositories/repo1/files/file1`
          # @!attribute [rw] hashes
          #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::Hash>]
          #     The hashes of the file content.
          class ExportedFile
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
