# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # An Attachment refers to additional metadata that can be attached to
        # artifacts in Artifact Registry. An attachment consists of one or more files.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the attachment. E.g.
        #     `projects/p1/locations/us/repositories/repo/attachments/sbom`.
        # @!attribute [rw] target
        #   @return [::String]
        #     Required. The target the attachment is for, can be a Version, Package or
        #     Repository. E.g.
        #     `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
        # @!attribute [rw] type
        #   @return [::String]
        #     Type of attachment.
        #     E.g. `application/vnd.spdx+json`
        # @!attribute [rw] attachment_namespace
        #   @return [::String]
        #     The namespace this attachment belongs to.
        #     E.g. If an attachment is created by artifact analysis, namespace is set
        #     to `artifactanalysis.googleapis.com`.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Artifact Registry. See
        #     https://google.aip.dev/128#annotations for more details such as format and
        #     size limitations.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the attachment was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the attachment was last updated.
        # @!attribute [rw] files
        #   @return [::Array<::String>]
        #     Required. The files that belong to this attachment.
        #     If the file ID part contains slashes, they are escaped. E.g.
        #     `projects/p1/locations/us-central1/repositories/repo1/files/sha:<sha-of-file>`.
        # @!attribute [r] oci_version_name
        #   @return [::String]
        #     Output only. The name of the OCI version that this attachment created. Only
        #     populated for Docker attachments. E.g.
        #     `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
        class Attachment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request to list attachments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose attachments will be listed.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the results of the request. Filter
        #     rules are case insensitive. The fields eligible for filtering are:
        #
        #       * `target`
        #       * `type`
        #       * `attachment_namespace`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of attachments to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing attachments.
        # @!attribute [rw] attachments
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::Attachment>]
        #     The attachments returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of attachments, or empty if there are
        #     no more attachments to return.
        class ListAttachmentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to retrieve an attachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the attachment to retrieve.
        class GetAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to create a new attachment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource where the attachment will be
        #     created.
        # @!attribute [rw] attachment_id
        #   @return [::String]
        #     Required. The attachment id to use for this attachment.
        # @!attribute [rw] attachment
        #   @return [::Google::Cloud::ArtifactRegistry::V1::Attachment]
        #     Required. The attachment to be created.
        class CreateAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to delete an attachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the attachment to delete.
        class DeleteAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
