# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        # DockerImage represents a docker artifact.
        # The following fields are returned as untyped metadata in the Version
        # resource, using camelcase keys (i.e. metadata.imageSizeBytes):
        # * imageSizeBytes
        # * mediaType
        # * buildTime
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. registry_location, project_id, repository_name and image id forms
        #     a unique image
        #     name:`projects/<project_id>/locations/<location>/repositories/<repository_name>/dockerImages/<docker_image>`.
        #     For example,
        #     "projects/test-project/locations/us-west4/repositories/test-repo/dockerImages/
        #     nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf",
        #     where "us-west4" is the registry_location, "test-project" is the
        #     project_id, "test-repo" is the repository_name and
        #     "nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf"
        #     is the image's digest.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. URL to access the image.
        #     Example:
        #     us-west4-docker.pkg.dev/test-project/test-repo/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Tags attached to this image.
        # @!attribute [rw] image_size_bytes
        #   @return [::Integer]
        #     Calculated size of the image.
        #     This field is returned as the 'metadata.imageSizeBytes' field in the
        #     Version resource.
        # @!attribute [rw] upload_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the image was uploaded.
        # @!attribute [rw] media_type
        #   @return [::String]
        #     Media type of this image, e.g.
        #     "application/vnd.docker.distribution.manifest.v2+json".
        #     This field is returned as the 'metadata.mediaType' field in the
        #     Version resource.
        # @!attribute [rw] build_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time this image was built.
        #     This field is returned as the 'metadata.buildTime' field in the
        #     Version resource.
        #     The build time is returned to the client as an RFC 3339 string, which can
        #     be easily used with the JavaScript Date constructor.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the docker image was last updated.
        # @!attribute [rw] artifact_type
        #   @return [::String]
        #     ArtifactType of this image, e.g. "application/vnd.example+type".
        #     If the `subject_digest` is set and no `artifact_type` is given, the
        #     `media_type` will be considered as the `artifact_type`. This field is
        #     returned as the `metadata.artifactType` field in the Version resource.
        # @!attribute [rw] image_manifests
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::ImageManifest>]
        #     Optional. For multi-arch images (manifest lists), this field contains the
        #     list of image manifests.
        class DockerImage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of a single image manifest within a multi-arch image.
        # @!attribute [rw] architecture
        #   @return [::String]
        #     Optional. The CPU architecture of the image.
        #     Values are provided by the Docker client and are not validated by Artifact
        #     Registry. Example values include "amd64", "arm64", "ppc64le", "s390x",
        #     "riscv64", "mips64le", etc.
        # @!attribute [rw] os
        #   @return [::String]
        #     Optional. The operating system of the image.
        #     Values are provided by the Docker client and are not validated by Artifact
        #     Registry. Example values include "linux", "windows", "darwin", "aix", etc.
        # @!attribute [rw] digest
        #   @return [::String]
        #     Optional. The manifest digest, in the format "sha256:<sha256_hex_digest>".
        # @!attribute [rw] media_type
        #   @return [::String]
        #     Optional. The media type of the manifest, e.g.,
        #     "application/vnd.docker.distribution.manifest.v2+json"
        # @!attribute [rw] os_version
        #   @return [::String]
        #     Optional. The OS version of the image, for example on Windows
        #     `10.0.14393.1066`.
        # @!attribute [rw] os_features
        #   @return [::Array<::String>]
        #     Optional. The required OS features for the image, for example on Windows
        #     `win32k`.
        # @!attribute [rw] variant
        #   @return [::String]
        #     Optional. The variant of the CPU in the image, for example `v7` to specify
        #     ARMv7 when architecture is `arm`.
        class ImageManifest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list docker images.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose docker images will be
        #     listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of artifacts to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     The field to order the results by.
        class ListDockerImagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing docker images.
        # @!attribute [rw] docker_images
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::DockerImage>]
        #     The docker images returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of artifacts, or empty if there are no
        #     more artifacts to return.
        class ListDockerImagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get docker images.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the docker images.
        class GetDockerImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MavenArtifact represents a maven artifact.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. registry_location, project_id, repository_name and maven_artifact
        #     forms a unique artifact For example,
        #     "projects/test-project/locations/us-west4/repositories/test-repo/mavenArtifacts/
        #     com.google.guava:guava:31.0-jre",
        #     where "us-west4" is the registry_location, "test-project" is the
        #     project_id, "test-repo" is the repository_name and
        #     "com.google.guava:guava:31.0-jre"
        #     is the maven artifact.
        # @!attribute [rw] pom_uri
        #   @return [::String]
        #     Required. URL to access the pom file of the artifact.
        #     Example:
        #     us-west4-maven.pkg.dev/test-project/test-repo/com/google/guava/guava/31.0/guava-31.0.pom
        # @!attribute [rw] group_id
        #   @return [::String]
        #     Group ID for the artifact.
        #     Example:
        #     com.google.guava
        # @!attribute [rw] artifact_id
        #   @return [::String]
        #     Artifact ID for the artifact.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of this artifact.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the artifact was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the artifact was updated.
        class MavenArtifact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list maven artifacts.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose maven artifacts will be
        #     listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of artifacts to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListMavenArtifactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing maven artifacts.
        # @!attribute [rw] maven_artifacts
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::MavenArtifact>]
        #     The maven artifacts returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of artifacts, or empty if there are no
        #     more artifacts to return.
        class ListMavenArtifactsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get maven artifacts.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the maven artifact.
        class GetMavenArtifactRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NpmPackage represents an npm artifact.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. registry_location, project_id, repository_name and npm_package
        #     forms a unique package For example,
        #     "projects/test-project/locations/us-west4/repositories/test-repo/npmPackages/
        #     npm_test:1.0.0",
        #     where "us-west4" is the registry_location, "test-project" is the
        #     project_id, "test-repo" is the repository_name and
        #     npm_test:1.0.0" is the npm package.
        # @!attribute [rw] package_name
        #   @return [::String]
        #     Package for the artifact.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of this package.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Tags attached to this package.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the package was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the package was updated.
        class NpmPackage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list npm packages.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose npm packages will be
        #     listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of artifacts to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListNpmPackagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing npm packages.
        # @!attribute [rw] npm_packages
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::NpmPackage>]
        #     The npm packages returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of artifacts, or empty if there are no
        #     more artifacts to return.
        class ListNpmPackagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get npm packages.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the npm package.
        class GetNpmPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PythonPackage represents a python artifact.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. registry_location, project_id, repository_name and python_package
        #     forms a unique package
        #     name:`projects/<project_id>/locations/<location>/repository/<repository_name>/pythonPackages/<python_package>`.
        #     For example,
        #     "projects/test-project/locations/us-west4/repositories/test-repo/pythonPackages/
        #     python_package:1.0.0",
        #     where "us-west4" is the registry_location, "test-project" is the
        #     project_id, "test-repo" is the repository_name and
        #     python_package:1.0.0" is the python package.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. URL to access the package.
        #     Example:
        #     us-west4-python.pkg.dev/test-project/test-repo/python_package/file-name-1.0.0.tar.gz
        # @!attribute [rw] package_name
        #   @return [::String]
        #     Package for the artifact.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of this package.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the package was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the package was updated.
        class PythonPackage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to list python packages.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose python packages will be
        #     listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of artifacts to return. Maximum page size is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value returned from a previous list request, if any.
        class ListPythonPackagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from listing python packages.
        # @!attribute [rw] python_packages
        #   @return [::Array<::Google::Cloud::ArtifactRegistry::V1::PythonPackage>]
        #     The python packages returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token to retrieve the next page of artifacts, or empty if there are no
        #     more artifacts to return.
        class ListPythonPackagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to get python packages.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the python package.
        class GetPythonPackageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
