# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/devtools/artifactregistry/v1/service.proto for package 'Google.Cloud.ArtifactRegistry.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/devtools/artifactregistry/v1/service_pb'

module Google
  module Cloud
    module ArtifactRegistry
      module V1
        module ArtifactRegistry
          # The Artifact Registry API service.
          #
          # Artifact Registry is an artifact management system for storing artifacts
          # from different package management systems.
          #
          # The resources managed by this API are:
          #
          # * Repositories, which group packages and their data.
          # * Packages, which group versions and their tags.
          # * Versions, which are specific forms of a package.
          # * Tags, which represent alternative names for versions.
          # * Files, which contain content and are optionally associated with a Package
          #   or Version.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.devtools.artifactregistry.v1.ArtifactRegistry'

            # Lists docker images.
            rpc :ListDockerImages, ::Google::Cloud::ArtifactRegistry::V1::ListDockerImagesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListDockerImagesResponse
            # Gets a docker image.
            rpc :GetDockerImage, ::Google::Cloud::ArtifactRegistry::V1::GetDockerImageRequest, ::Google::Cloud::ArtifactRegistry::V1::DockerImage
            # Lists maven artifacts.
            rpc :ListMavenArtifacts, ::Google::Cloud::ArtifactRegistry::V1::ListMavenArtifactsRequest, ::Google::Cloud::ArtifactRegistry::V1::ListMavenArtifactsResponse
            # Gets a maven artifact.
            rpc :GetMavenArtifact, ::Google::Cloud::ArtifactRegistry::V1::GetMavenArtifactRequest, ::Google::Cloud::ArtifactRegistry::V1::MavenArtifact
            # Lists npm packages.
            rpc :ListNpmPackages, ::Google::Cloud::ArtifactRegistry::V1::ListNpmPackagesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListNpmPackagesResponse
            # Gets a npm package.
            rpc :GetNpmPackage, ::Google::Cloud::ArtifactRegistry::V1::GetNpmPackageRequest, ::Google::Cloud::ArtifactRegistry::V1::NpmPackage
            # Lists python packages.
            rpc :ListPythonPackages, ::Google::Cloud::ArtifactRegistry::V1::ListPythonPackagesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListPythonPackagesResponse
            # Gets a python package.
            rpc :GetPythonPackage, ::Google::Cloud::ArtifactRegistry::V1::GetPythonPackageRequest, ::Google::Cloud::ArtifactRegistry::V1::PythonPackage
            # Imports Apt artifacts. The returned Operation will complete once the
            # resources are imported. Package, Version, and File resources are created
            # based on the imported artifacts. Imported artifacts that conflict with
            # existing resources are ignored.
            rpc :ImportAptArtifacts, ::Google::Cloud::ArtifactRegistry::V1::ImportAptArtifactsRequest, ::Google::Longrunning::Operation
            # Imports Yum (RPM) artifacts. The returned Operation will complete once the
            # resources are imported. Package, Version, and File resources are created
            # based on the imported artifacts. Imported artifacts that conflict with
            # existing resources are ignored.
            rpc :ImportYumArtifacts, ::Google::Cloud::ArtifactRegistry::V1::ImportYumArtifactsRequest, ::Google::Longrunning::Operation
            # Lists repositories.
            rpc :ListRepositories, ::Google::Cloud::ArtifactRegistry::V1::ListRepositoriesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListRepositoriesResponse
            # Gets a repository.
            rpc :GetRepository, ::Google::Cloud::ArtifactRegistry::V1::GetRepositoryRequest, ::Google::Cloud::ArtifactRegistry::V1::Repository
            # Creates a repository. The returned Operation will finish once the
            # repository has been created. Its response will be the created Repository.
            rpc :CreateRepository, ::Google::Cloud::ArtifactRegistry::V1::CreateRepositoryRequest, ::Google::Longrunning::Operation
            # Updates a repository.
            rpc :UpdateRepository, ::Google::Cloud::ArtifactRegistry::V1::UpdateRepositoryRequest, ::Google::Cloud::ArtifactRegistry::V1::Repository
            # Deletes a repository and all of its contents. The returned Operation will
            # finish once the repository has been deleted. It will not have any Operation
            # metadata and will return a google.protobuf.Empty response.
            rpc :DeleteRepository, ::Google::Cloud::ArtifactRegistry::V1::DeleteRepositoryRequest, ::Google::Longrunning::Operation
            # Lists packages.
            rpc :ListPackages, ::Google::Cloud::ArtifactRegistry::V1::ListPackagesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListPackagesResponse
            # Gets a package.
            rpc :GetPackage, ::Google::Cloud::ArtifactRegistry::V1::GetPackageRequest, ::Google::Cloud::ArtifactRegistry::V1::Package
            # Deletes a package and all of its versions and tags. The returned operation
            # will complete once the package has been deleted.
            rpc :DeletePackage, ::Google::Cloud::ArtifactRegistry::V1::DeletePackageRequest, ::Google::Longrunning::Operation
            # Lists versions.
            rpc :ListVersions, ::Google::Cloud::ArtifactRegistry::V1::ListVersionsRequest, ::Google::Cloud::ArtifactRegistry::V1::ListVersionsResponse
            # Gets a version
            rpc :GetVersion, ::Google::Cloud::ArtifactRegistry::V1::GetVersionRequest, ::Google::Cloud::ArtifactRegistry::V1::Version
            # Deletes a version and all of its content. The returned operation will
            # complete once the version has been deleted.
            rpc :DeleteVersion, ::Google::Cloud::ArtifactRegistry::V1::DeleteVersionRequest, ::Google::Longrunning::Operation
            # Deletes multiple versions across a repository. The returned operation will
            # complete once the versions have been deleted.
            rpc :BatchDeleteVersions, ::Google::Cloud::ArtifactRegistry::V1::BatchDeleteVersionsRequest, ::Google::Longrunning::Operation
            # Updates a version.
            rpc :UpdateVersion, ::Google::Cloud::ArtifactRegistry::V1::UpdateVersionRequest, ::Google::Cloud::ArtifactRegistry::V1::Version
            # Lists files.
            rpc :ListFiles, ::Google::Cloud::ArtifactRegistry::V1::ListFilesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListFilesResponse
            # Gets a file.
            rpc :GetFile, ::Google::Cloud::ArtifactRegistry::V1::GetFileRequest, ::Google::Cloud::ArtifactRegistry::V1::File
            # Deletes a file and all of its content. It is only allowed on generic
            # repositories. The returned operation will complete once the file has been
            # deleted.
            rpc :DeleteFile, ::Google::Cloud::ArtifactRegistry::V1::DeleteFileRequest, ::Google::Longrunning::Operation
            # Updates a file.
            rpc :UpdateFile, ::Google::Cloud::ArtifactRegistry::V1::UpdateFileRequest, ::Google::Cloud::ArtifactRegistry::V1::File
            # Lists tags.
            rpc :ListTags, ::Google::Cloud::ArtifactRegistry::V1::ListTagsRequest, ::Google::Cloud::ArtifactRegistry::V1::ListTagsResponse
            # Gets a tag.
            rpc :GetTag, ::Google::Cloud::ArtifactRegistry::V1::GetTagRequest, ::Google::Cloud::ArtifactRegistry::V1::Tag
            # Creates a tag.
            rpc :CreateTag, ::Google::Cloud::ArtifactRegistry::V1::CreateTagRequest, ::Google::Cloud::ArtifactRegistry::V1::Tag
            # Updates a tag.
            rpc :UpdateTag, ::Google::Cloud::ArtifactRegistry::V1::UpdateTagRequest, ::Google::Cloud::ArtifactRegistry::V1::Tag
            # Deletes a tag.
            rpc :DeleteTag, ::Google::Cloud::ArtifactRegistry::V1::DeleteTagRequest, ::Google::Protobuf::Empty
            # Creates a rule.
            rpc :CreateRule, ::Google::Cloud::ArtifactRegistry::V1::CreateRuleRequest, ::Google::Cloud::ArtifactRegistry::V1::Rule
            # Lists rules.
            rpc :ListRules, ::Google::Cloud::ArtifactRegistry::V1::ListRulesRequest, ::Google::Cloud::ArtifactRegistry::V1::ListRulesResponse
            # Gets a rule.
            rpc :GetRule, ::Google::Cloud::ArtifactRegistry::V1::GetRuleRequest, ::Google::Cloud::ArtifactRegistry::V1::Rule
            # Updates a rule.
            rpc :UpdateRule, ::Google::Cloud::ArtifactRegistry::V1::UpdateRuleRequest, ::Google::Cloud::ArtifactRegistry::V1::Rule
            # Deletes a rule.
            rpc :DeleteRule, ::Google::Cloud::ArtifactRegistry::V1::DeleteRuleRequest, ::Google::Protobuf::Empty
            # Updates the IAM policy for a given resource.
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Gets the IAM policy for a given resource.
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Tests if the caller has a list of permissions on a resource.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
            # Retrieves the Settings for the Project.
            rpc :GetProjectSettings, ::Google::Cloud::ArtifactRegistry::V1::GetProjectSettingsRequest, ::Google::Cloud::ArtifactRegistry::V1::ProjectSettings
            # Updates the Settings for the Project.
            rpc :UpdateProjectSettings, ::Google::Cloud::ArtifactRegistry::V1::UpdateProjectSettingsRequest, ::Google::Cloud::ArtifactRegistry::V1::ProjectSettings
            # Retrieves the VPCSC Config for the Project.
            rpc :GetVPCSCConfig, ::Google::Cloud::ArtifactRegistry::V1::GetVPCSCConfigRequest, ::Google::Cloud::ArtifactRegistry::V1::VPCSCConfig
            # Updates the VPCSC Config for the Project.
            rpc :UpdateVPCSCConfig, ::Google::Cloud::ArtifactRegistry::V1::UpdateVPCSCConfigRequest, ::Google::Cloud::ArtifactRegistry::V1::VPCSCConfig
            # Updates a package.
            rpc :UpdatePackage, ::Google::Cloud::ArtifactRegistry::V1::UpdatePackageRequest, ::Google::Cloud::ArtifactRegistry::V1::Package
            # Lists attachments.
            rpc :ListAttachments, ::Google::Cloud::ArtifactRegistry::V1::ListAttachmentsRequest, ::Google::Cloud::ArtifactRegistry::V1::ListAttachmentsResponse
            # Gets an attachment.
            rpc :GetAttachment, ::Google::Cloud::ArtifactRegistry::V1::GetAttachmentRequest, ::Google::Cloud::ArtifactRegistry::V1::Attachment
            # Creates an attachment. The returned Operation will finish once the
            # attachment has been created. Its response will be the created attachment.
            rpc :CreateAttachment, ::Google::Cloud::ArtifactRegistry::V1::CreateAttachmentRequest, ::Google::Longrunning::Operation
            # Deletes an attachment. The returned Operation will
            # finish once the attachments has been deleted. It will not have any
            # Operation metadata and will return a `google.protobuf.Empty` response.
            rpc :DeleteAttachment, ::Google::Cloud::ArtifactRegistry::V1::DeleteAttachmentRequest, ::Google::Longrunning::Operation
            # Exports an artifact to a Cloud Storage bucket.
            rpc :ExportArtifact, ::Google::Cloud::ArtifactRegistry::V1::ExportArtifactRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
