# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/apphub/v1/apphub_service_pb"
require "google/cloud/app_hub/v1/app_hub/rest"


class ::Google::Cloud::AppHub::V1::AppHub::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_lookup_service_project_attachment
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    lookup_service_project_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_lookup_service_project_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_service_project_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_service_project_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_service_project_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_service_project_attachment ::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_service_project_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_service_project_attachment(::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_service_project_attachment_client_stub.call_count
      end
    end
  end

  def test_list_service_project_attachments
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_service_project_attachments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_list_service_project_attachments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_service_project_attachments_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_service_project_attachments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_service_project_attachments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_service_project_attachments ::Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_service_project_attachments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_service_project_attachments(::Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_service_project_attachments_client_stub.call_count
      end
    end
  end

  def test_create_service_project_attachment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_project_attachment_id = "hello world"
    service_project_attachment = {}
    request_id = "hello world"

    create_service_project_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_create_service_project_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_service_project_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_service_project_attachment({ parent: parent, service_project_attachment_id: service_project_attachment_id, service_project_attachment: service_project_attachment, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_service_project_attachment parent: parent, service_project_attachment_id: service_project_attachment_id, service_project_attachment: service_project_attachment, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_service_project_attachment ::Google::Cloud::AppHub::V1::CreateServiceProjectAttachmentRequest.new(parent: parent, service_project_attachment_id: service_project_attachment_id, service_project_attachment: service_project_attachment, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_service_project_attachment({ parent: parent, service_project_attachment_id: service_project_attachment_id, service_project_attachment: service_project_attachment, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_service_project_attachment(::Google::Cloud::AppHub::V1::CreateServiceProjectAttachmentRequest.new(parent: parent, service_project_attachment_id: service_project_attachment_id, service_project_attachment: service_project_attachment, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_service_project_attachment_client_stub.call_count
      end
    end
  end

  def test_get_service_project_attachment
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ServiceProjectAttachment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_project_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_get_service_project_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_service_project_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_service_project_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_service_project_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_service_project_attachment ::Google::Cloud::AppHub::V1::GetServiceProjectAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_service_project_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_service_project_attachment(::Google::Cloud::AppHub::V1::GetServiceProjectAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_service_project_attachment_client_stub.call_count
      end
    end
  end

  def test_delete_service_project_attachment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_service_project_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_delete_service_project_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_service_project_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_service_project_attachment({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_service_project_attachment name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_service_project_attachment ::Google::Cloud::AppHub::V1::DeleteServiceProjectAttachmentRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_service_project_attachment({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_service_project_attachment(::Google::Cloud::AppHub::V1::DeleteServiceProjectAttachmentRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_service_project_attachment_client_stub.call_count
      end
    end
  end

  def test_detach_service_project_attachment
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    detach_service_project_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_detach_service_project_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, detach_service_project_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.detach_service_project_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.detach_service_project_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.detach_service_project_attachment ::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.detach_service_project_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.detach_service_project_attachment(::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, detach_service_project_attachment_client_stub.call_count
      end
    end
  end

  def test_list_discovered_services
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ListDiscoveredServicesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_discovered_services_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_list_discovered_services_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_discovered_services_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_discovered_services({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_discovered_services parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_discovered_services ::Google::Cloud::AppHub::V1::ListDiscoveredServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_discovered_services({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_discovered_services(::Google::Cloud::AppHub::V1::ListDiscoveredServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_discovered_services_client_stub.call_count
      end
    end
  end

  def test_get_discovered_service
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::DiscoveredService.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_discovered_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_get_discovered_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_discovered_service_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_discovered_service({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_discovered_service name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_discovered_service ::Google::Cloud::AppHub::V1::GetDiscoveredServiceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_discovered_service({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_discovered_service(::Google::Cloud::AppHub::V1::GetDiscoveredServiceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_discovered_service_client_stub.call_count
      end
    end
  end

  def test_lookup_discovered_service
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::LookupDiscoveredServiceResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    uri = "hello world"

    lookup_discovered_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_lookup_discovered_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_discovered_service_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_discovered_service({ parent: parent, uri: uri }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_discovered_service parent: parent, uri: uri do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_discovered_service ::Google::Cloud::AppHub::V1::LookupDiscoveredServiceRequest.new(parent: parent, uri: uri) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_discovered_service({ parent: parent, uri: uri }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_discovered_service(::Google::Cloud::AppHub::V1::LookupDiscoveredServiceRequest.new(parent: parent, uri: uri), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_discovered_service_client_stub.call_count
      end
    end
  end

  def test_list_services
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ListServicesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_services_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_list_services_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_services_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_services({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_services parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_services ::Google::Cloud::AppHub::V1::ListServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_services({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_services(::Google::Cloud::AppHub::V1::ListServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_services_client_stub.call_count
      end
    end
  end

  def test_create_service
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_id = "hello world"
    service = {}
    request_id = "hello world"

    create_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_create_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_service_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_service({ parent: parent, service_id: service_id, service: service, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_service parent: parent, service_id: service_id, service: service, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_service ::Google::Cloud::AppHub::V1::CreateServiceRequest.new(parent: parent, service_id: service_id, service: service, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_service({ parent: parent, service_id: service_id, service: service, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_service(::Google::Cloud::AppHub::V1::CreateServiceRequest.new(parent: parent, service_id: service_id, service: service, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_service_client_stub.call_count
      end
    end
  end

  def test_get_service
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::Service.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_get_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_service_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_service({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_service name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_service ::Google::Cloud::AppHub::V1::GetServiceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_service({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_service(::Google::Cloud::AppHub::V1::GetServiceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_service_client_stub.call_count
      end
    end
  end

  def test_update_service
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service = {}
    request_id = "hello world"

    update_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_update_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_service_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_service({ update_mask: update_mask, service: service, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_service update_mask: update_mask, service: service, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_service ::Google::Cloud::AppHub::V1::UpdateServiceRequest.new(update_mask: update_mask, service: service, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_service({ update_mask: update_mask, service: service, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_service(::Google::Cloud::AppHub::V1::UpdateServiceRequest.new(update_mask: update_mask, service: service, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_service_client_stub.call_count
      end
    end
  end

  def test_delete_service
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_delete_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_service_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_service({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_service name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_service ::Google::Cloud::AppHub::V1::DeleteServiceRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_service({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_service(::Google::Cloud::AppHub::V1::DeleteServiceRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_service_client_stub.call_count
      end
    end
  end

  def test_list_discovered_workloads
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_discovered_workloads_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_list_discovered_workloads_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_discovered_workloads_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_discovered_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_discovered_workloads parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_discovered_workloads ::Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_discovered_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_discovered_workloads(::Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_discovered_workloads_client_stub.call_count
      end
    end
  end

  def test_get_discovered_workload
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::DiscoveredWorkload.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_discovered_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_get_discovered_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_discovered_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_discovered_workload({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_discovered_workload name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_discovered_workload ::Google::Cloud::AppHub::V1::GetDiscoveredWorkloadRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_discovered_workload({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_discovered_workload(::Google::Cloud::AppHub::V1::GetDiscoveredWorkloadRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_discovered_workload_client_stub.call_count
      end
    end
  end

  def test_lookup_discovered_workload
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    uri = "hello world"

    lookup_discovered_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_lookup_discovered_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_discovered_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_discovered_workload({ parent: parent, uri: uri }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_discovered_workload parent: parent, uri: uri do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_discovered_workload ::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadRequest.new(parent: parent, uri: uri) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_discovered_workload({ parent: parent, uri: uri }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_discovered_workload(::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadRequest.new(parent: parent, uri: uri), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_discovered_workload_client_stub.call_count
      end
    end
  end

  def test_list_workloads
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ListWorkloadsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_workloads_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_list_workloads_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workloads_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workloads parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workloads ::Google::Cloud::AppHub::V1::ListWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workloads({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workloads(::Google::Cloud::AppHub::V1::ListWorkloadsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workloads_client_stub.call_count
      end
    end
  end

  def test_create_workload
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workload_id = "hello world"
    workload = {}
    request_id = "hello world"

    create_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_create_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workload({ parent: parent, workload_id: workload_id, workload: workload, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workload parent: parent, workload_id: workload_id, workload: workload, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workload ::Google::Cloud::AppHub::V1::CreateWorkloadRequest.new(parent: parent, workload_id: workload_id, workload: workload, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workload({ parent: parent, workload_id: workload_id, workload: workload, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workload(::Google::Cloud::AppHub::V1::CreateWorkloadRequest.new(parent: parent, workload_id: workload_id, workload: workload, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workload_client_stub.call_count
      end
    end
  end

  def test_get_workload
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::Workload.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_get_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workload({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workload name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workload ::Google::Cloud::AppHub::V1::GetWorkloadRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workload({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workload(::Google::Cloud::AppHub::V1::GetWorkloadRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workload_client_stub.call_count
      end
    end
  end

  def test_update_workload
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    workload = {}
    request_id = "hello world"

    update_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_update_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_workload({ update_mask: update_mask, workload: workload, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_workload update_mask: update_mask, workload: workload, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_workload ::Google::Cloud::AppHub::V1::UpdateWorkloadRequest.new(update_mask: update_mask, workload: workload, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_workload({ update_mask: update_mask, workload: workload, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_workload(::Google::Cloud::AppHub::V1::UpdateWorkloadRequest.new(update_mask: update_mask, workload: workload, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_workload_client_stub.call_count
      end
    end
  end

  def test_delete_workload
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_workload_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_delete_workload_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workload_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workload({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workload name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workload ::Google::Cloud::AppHub::V1::DeleteWorkloadRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workload({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workload(::Google::Cloud::AppHub::V1::DeleteWorkloadRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workload_client_stub.call_count
      end
    end
  end

  def test_list_applications
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::ListApplicationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_applications_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_list_applications_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_applications_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_applications({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_applications parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_applications ::Google::Cloud::AppHub::V1::ListApplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_applications({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_applications(::Google::Cloud::AppHub::V1::ListApplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_applications_client_stub.call_count
      end
    end
  end

  def test_create_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    application_id = "hello world"
    application = {}
    request_id = "hello world"

    create_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_create_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_application_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_application({ parent: parent, application_id: application_id, application: application, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_application parent: parent, application_id: application_id, application: application, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_application ::Google::Cloud::AppHub::V1::CreateApplicationRequest.new(parent: parent, application_id: application_id, application: application, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_application({ parent: parent, application_id: application_id, application: application, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_application(::Google::Cloud::AppHub::V1::CreateApplicationRequest.new(parent: parent, application_id: application_id, application: application, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_application_client_stub.call_count
      end
    end
  end

  def test_get_application
    # Create test objects.
    client_result = ::Google::Cloud::AppHub::V1::Application.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_get_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_application_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_application({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_application name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_application ::Google::Cloud::AppHub::V1::GetApplicationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_application({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_application(::Google::Cloud::AppHub::V1::GetApplicationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_application_client_stub.call_count
      end
    end
  end

  def test_update_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    application = {}
    request_id = "hello world"

    update_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_update_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_application_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_application({ update_mask: update_mask, application: application, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_application update_mask: update_mask, application: application, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_application ::Google::Cloud::AppHub::V1::UpdateApplicationRequest.new(update_mask: update_mask, application: application, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_application({ update_mask: update_mask, application: application, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_application(::Google::Cloud::AppHub::V1::UpdateApplicationRequest.new(update_mask: update_mask, application: application, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_application_client_stub.call_count
      end
    end
  end

  def test_delete_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppHub::V1::AppHub::Rest::ServiceStub.stub :transcode_delete_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_application_client_stub do
        # Create client
        client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_application({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_application name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_application ::Google::Cloud::AppHub::V1::DeleteApplicationRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_application({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_application(::Google::Cloud::AppHub::V1::DeleteApplicationRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_application_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AppHub::V1::AppHub::Rest::Client::Configuration, config
  end
end
