# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppHub
      module V1
        # Workload is an App Hub data model that contains a discovered workload, which
        # represents a binary deployment (such as managed instance groups (MIGs) and
        # GKE deployments) that performs the smallest logical subset of business
        # functionality.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the Workload. Format:
        #     `"projects/{host-project-id}/locations/{location}/applications/{application-id}/workloads/{workload-id}"`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User-defined name for the Workload.
        #     Can have a maximum length of 63 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-defined description of a Workload.
        #     Can have a maximum length of 2048 characters.
        # @!attribute [r] workload_reference
        #   @return [::Google::Cloud::AppHub::V1::WorkloadReference]
        #     Output only. Reference of an underlying compute resource represented by the
        #     Workload. These are immutable.
        # @!attribute [r] workload_properties
        #   @return [::Google::Cloud::AppHub::V1::WorkloadProperties]
        #     Output only. Properties of an underlying compute resource represented by
        #     the Workload. These are immutable.
        # @!attribute [rw] discovered_workload
        #   @return [::String]
        #     Required. Immutable. The resource name of the original discovered workload.
        # @!attribute [rw] attributes
        #   @return [::Google::Cloud::AppHub::V1::Attributes]
        #     Optional. Consumer provided attributes.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A universally unique identifier (UUID) for the `Workload` in
        #     the UUID4 format.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AppHub::V1::Workload::State]
        #     Output only. Workload state.
        class Workload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Workload state.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # The Workload is being created.
            CREATING = 1

            # The Workload is ready.
            ACTIVE = 2

            # The Workload is being deleted.
            DELETING = 3

            # The underlying compute resources have been deleted.
            DETACHED = 4
          end
        end

        # Reference of an underlying compute resource represented by the Workload.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. The underlying compute resource uri.
        class WorkloadReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Properties of an underlying compute resource represented by the Workload.
        # @!attribute [r] gcp_project
        #   @return [::String]
        #     Output only. The service project identifier that the underlying cloud
        #     resource resides in. Empty for non-cloud resources.
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. The location that the underlying compute resource resides in
        #     (for example, us-west1).
        # @!attribute [r] zone
        #   @return [::String]
        #     Output only. The location that the underlying compute resource resides in
        #     if it is zonal (for example, us-west1-a).
        class WorkloadProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DiscoveredWorkload is a binary deployment (such as managed instance groups
        # (MIGs) and GKE deployments) that performs the smallest logical subset of
        # business functionality. A discovered workload can be registered to an App Hub
        # Workload.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the discovered workload. Format:
        #     `"projects/{host-project-id}/locations/{location}/discoveredWorkloads/{uuid}"`
        # @!attribute [r] workload_reference
        #   @return [::Google::Cloud::AppHub::V1::WorkloadReference]
        #     Output only. Reference of an underlying compute resource represented by the
        #     Workload. These are immutable.
        # @!attribute [r] workload_properties
        #   @return [::Google::Cloud::AppHub::V1::WorkloadProperties]
        #     Output only. Properties of an underlying compute resource represented by
        #     the Workload. These are immutable.
        class DiscoveredWorkload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
