# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppHub
      module V1
        # Service is an App Hub data model that contains a discovered service, which
        # represents a network or API interface that exposes some functionality to
        # clients for consumption over the network.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of a Service. Format:
        #     `"projects/{host-project-id}/locations/{location}/applications/{application-id}/services/{service-id}"`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User-defined name for the Service.
        #     Can have a maximum length of 63 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-defined description of a Service.
        #     Can have a maximum length of 2048 characters.
        # @!attribute [r] service_reference
        #   @return [::Google::Cloud::AppHub::V1::ServiceReference]
        #     Output only. Reference to an underlying networking resource that can
        #     comprise a Service. These are immutable.
        # @!attribute [r] service_properties
        #   @return [::Google::Cloud::AppHub::V1::ServiceProperties]
        #     Output only. Properties of an underlying compute resource that can comprise
        #     a Service. These are immutable.
        # @!attribute [rw] attributes
        #   @return [::Google::Cloud::AppHub::V1::Attributes]
        #     Optional. Consumer provided attributes.
        # @!attribute [rw] discovered_service
        #   @return [::String]
        #     Required. Immutable. The resource name of the original discovered service.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A universally unique identifier (UUID) for the `Service` in
        #     the UUID4 format.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AppHub::V1::Service::State]
        #     Output only. Service state.
        class Service
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Service state.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # The service is being created.
            CREATING = 1

            # The service is ready.
            ACTIVE = 2

            # The service is being deleted.
            DELETING = 3

            # The underlying networking resources have been deleted.
            DETACHED = 4
          end
        end

        # Reference to an underlying networking resource that can comprise a Service.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. The underlying resource URI. For example, URI of Forwarding
        #     Rule, URL Map, and Backend Service.
        class ServiceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Properties of an underlying cloud resource that can comprise a Service.
        # @!attribute [r] gcp_project
        #   @return [::String]
        #     Output only. The service project identifier that the underlying cloud
        #     resource resides in.
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. The location that the underlying resource resides in, for
        #     example, us-west1.
        # @!attribute [r] zone
        #   @return [::String]
        #     Output only. The location that the underlying resource resides in if it is
        #     zonal, for example, us-west1-a).
        class ServiceProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DiscoveredService is a network or API interface that exposes some
        # functionality to clients for consumption over the network. A discovered
        # service can be registered to a App Hub service.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the discovered service. Format:
        #     `"projects/{host-project-id}/locations/{location}/discoveredServices/{uuid}"`
        # @!attribute [r] service_reference
        #   @return [::Google::Cloud::AppHub::V1::ServiceReference]
        #     Output only. Reference to an underlying networking resource that can
        #     comprise a Service. These are immutable.
        # @!attribute [r] service_properties
        #   @return [::Google::Cloud::AppHub::V1::ServiceProperties]
        #     Output only. Properties of an underlying compute resource that can comprise
        #     a Service. These are immutable.
        class DiscoveredService
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
