# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppHub
      module V1
        # Consumer provided attributes.
        # @!attribute [rw] criticality
        #   @return [::Google::Cloud::AppHub::V1::Criticality]
        #     Optional. User-defined criticality information.
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::AppHub::V1::Environment]
        #     Optional. User-defined environment information.
        # @!attribute [rw] developer_owners
        #   @return [::Array<::Google::Cloud::AppHub::V1::ContactInfo>]
        #     Optional. Developer team that owns development and coding.
        # @!attribute [rw] operator_owners
        #   @return [::Array<::Google::Cloud::AppHub::V1::ContactInfo>]
        #     Optional. Operator team that ensures runtime and operations.
        # @!attribute [rw] business_owners
        #   @return [::Array<::Google::Cloud::AppHub::V1::ContactInfo>]
        #     Optional. Business team that ensures user needs are met and value is
        #     delivered
        class Attributes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Criticality of the Application, Service, or Workload
        # @!attribute [rw] type
        #   @return [::Google::Cloud::AppHub::V1::Criticality::Type]
        #     Required. Criticality Type.
        class Criticality
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Criticality Type.
          module Type
            # Unspecified type.
            TYPE_UNSPECIFIED = 0

            # Mission critical service, application or workload.
            MISSION_CRITICAL = 1

            # High impact.
            HIGH = 2

            # Medium impact.
            MEDIUM = 3

            # Low impact.
            LOW = 4
          end
        end

        # Environment of the Application, Service, or Workload
        # @!attribute [rw] type
        #   @return [::Google::Cloud::AppHub::V1::Environment::Type]
        #     Required. Environment Type.
        class Environment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Environment Type.
          module Type
            # Unspecified type.
            TYPE_UNSPECIFIED = 0

            # Production environment.
            PRODUCTION = 1

            # Staging environment.
            STAGING = 2

            # Test environment.
            TEST = 3

            # Development environment.
            DEVELOPMENT = 4
          end
        end

        # Contact information of stakeholders.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Contact's name.
        #     Can have a maximum length of 63 characters.
        # @!attribute [rw] email
        #   @return [::String]
        #     Required. Email address of the contacts.
        class ContactInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
