# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppHub
      module V1
        # Request for LookupServiceProjectAttachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Service project ID and location to lookup service project
        #     attachment for. Only global location is supported. Expected format:
        #     `projects/{project}/locations/{location}`.
        class LookupServiceProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for LookupServiceProjectAttachment.
        # @!attribute [rw] service_project_attachment
        #   @return [::Google::Cloud::AppHub::V1::ServiceProjectAttachment]
        #     Service project attachment for a project if exists, empty otherwise.
        class LookupServiceProjectAttachmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListServiceProjectAttachments.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Host project ID and location to list service project attachments.
        #     Only global location is supported. Expected format:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListServiceProjectAttachmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServiceProjectAttachments.
        # @!attribute [rw] service_project_attachments
        #   @return [::Array<::Google::Cloud::AppHub::V1::ServiceProjectAttachment>]
        #     List of service project attachments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServiceProjectAttachmentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateServiceProjectAttachment.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Host project ID and location to which service project is being
        #     attached. Only global location is supported. Expected format:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] service_project_attachment_id
        #   @return [::String]
        #     Required. The service project attachment identifier must contain the
        #     project id of the service project specified in the
        #     service_project_attachment.service_project field.
        # @!attribute [rw] service_project_attachment
        #   @return [::Google::Cloud::AppHub::V1::ServiceProjectAttachment]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateServiceProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetServiceProjectAttachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the service project attachment to
        #     retrieve. Expected format:
        #     `projects/{project}/locations/{location}/serviceProjectAttachments/{serviceProjectAttachment}`.
        class GetServiceProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteServiceProjectAttachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the service project attachment to delete.
        #     Expected format:
        #     `projects/{project}/locations/{location}/serviceProjectAttachments/{serviceProjectAttachment}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteServiceProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DetachServiceProjectAttachment.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Service project id and location to detach from a host project.
        #     Only global location is supported. Expected format:
        #     `projects/{project}/locations/{location}`.
        class DetachServiceProjectAttachmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for DetachServiceProjectAttachment.
        class DetachServiceProjectAttachmentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListServices.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Fully qualified name of the parent Application to list Services
        #     for. Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServices.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::AppHub::V1::Service>]
        #     List of Services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListDiscoveredServices.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project and location to list Discovered Services on.
        #     Expected format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListDiscoveredServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListDiscoveredServices.
        # @!attribute [rw] discovered_services
        #   @return [::Array<::Google::Cloud::AppHub::V1::DiscoveredService>]
        #     List of Discovered Services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDiscoveredServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateService.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Fully qualified name of the parent Application to create the
        #     Service in. Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}`.
        # @!attribute [rw] service_id
        #   @return [::String]
        #     Required. The Service identifier.
        #     Must contain only lowercase letters, numbers
        #     or hyphens, with the first character a letter, the last a letter or a
        #     number, and a 63 character maximum.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::AppHub::V1::Service]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetService.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Service to fetch.
        #     Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}/services/{service}`.
        class GetServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetDiscoveredService.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Discovered Service to fetch.
        #     Expected format:
        #     `projects/{project}/locations/{location}/discoveredServices/{discoveredService}`.
        class GetDiscoveredServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for LookupDiscoveredService.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Host project ID and location to lookup Discovered Service in.
        #     Expected format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. Resource URI to find DiscoveredService for.
        #     Accepts both project number and project ID and does translation when
        #     needed.
        class LookupDiscoveredServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for LookupDiscoveredService.
        # @!attribute [rw] discovered_service
        #   @return [::Google::Cloud::AppHub::V1::DiscoveredService]
        #     Discovered Service if exists, empty otherwise.
        class LookupDiscoveredServiceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateService.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Service resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request.
        #     The API changes the values of the fields as specified in the update_mask.
        #     The API ignores the values of all fields not covered by the update_mask.
        #     You can also unset a field by not specifying it in the updated message, but
        #     adding the field to the mask. This clears whatever value the field
        #     previously had.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::AppHub::V1::Service]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteService.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Service to delete from an
        #     Application. Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}/services/{service}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListApplications.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project and location to list Applications on.
        #     Expected format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListApplicationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListApplications.
        # @!attribute [rw] applications
        #   @return [::Array<::Google::Cloud::AppHub::V1::Application>]
        #     List of Applications.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListApplicationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateApplication.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project and location to create Application in.
        #     Expected format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] application_id
        #   @return [::String]
        #     Required. The Application identifier.
        #     Must contain only lowercase letters, numbers
        #     or hyphens, with the first character a letter, the last a letter or a
        #     number, and a 63 character maximum.
        # @!attribute [rw] application
        #   @return [::Google::Cloud::AppHub::V1::Application]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetApplication.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Application to fetch.
        #     Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}`.
        class GetApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateApplication.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Application resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request.
        #     The API changes the values of the fields as specified in the update_mask.
        #     The API ignores the values of all fields not covered by the update_mask.
        #     You can also unset a field by not specifying it in the updated message, but
        #     adding the field to the mask. This clears whatever value the field
        #     previously had.
        # @!attribute [rw] application
        #   @return [::Google::Cloud::AppHub::V1::Application]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteApplication.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Application to delete.
        #     Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListWorkloads.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Fully qualified name of the parent Application to list Workloads
        #     for. Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListWorkloadsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListWorkloads.
        # @!attribute [rw] workloads
        #   @return [::Array<::Google::Cloud::AppHub::V1::Workload>]
        #     List of Workloads.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListWorkloadsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListDiscoveredWorkloads.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project and location to list Discovered Workloads on.
        #     Expected format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListDiscoveredWorkloadsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListDiscoveredWorkloads.
        # @!attribute [rw] discovered_workloads
        #   @return [::Array<::Google::Cloud::AppHub::V1::DiscoveredWorkload>]
        #     List of Discovered Workloads.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDiscoveredWorkloadsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateWorkload.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Fully qualified name of the Application to create Workload in.
        #     Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}`.
        # @!attribute [rw] workload_id
        #   @return [::String]
        #     Required. The Workload identifier.
        #     Must contain only lowercase letters, numbers
        #     or hyphens, with the first character a letter, the last a letter or a
        #     number, and a 63 character maximum.
        # @!attribute [rw] workload
        #   @return [::Google::Cloud::AppHub::V1::Workload]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetWorkload.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Workload to fetch.
        #     Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
        class GetWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetDiscoveredWorkload.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Discovered Workload to fetch.
        #     Expected format:
        #     `projects/{project}/locations/{location}/discoveredWorkloads/{discoveredWorkload}`.
        class GetDiscoveredWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for LookupDiscoveredWorkload.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Host project ID and location to lookup Discovered Workload in.
        #     Expected format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. Resource URI to find Discovered Workload for.
        #     Accepts both project number and project ID and does translation when
        #     needed.
        class LookupDiscoveredWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for LookupDiscoveredWorkload.
        # @!attribute [rw] discovered_workload
        #   @return [::Google::Cloud::AppHub::V1::DiscoveredWorkload]
        #     Discovered Workload if exists, empty otherwise.
        class LookupDiscoveredWorkloadResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateWorkload.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Workload resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request.
        #     The API changes the values of the fields as specified in the update_mask.
        #     The API ignores the values of all fields not covered by the update_mask.
        #     You can also unset a field by not specifying it in the updated message, but
        #     adding the field to the mask. This clears whatever value the field
        #     previously had.
        # @!attribute [rw] workload
        #   @return [::Google::Cloud::AppHub::V1::Workload]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteWorkload.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Fully qualified name of the Workload to delete from an
        #     Application. Expected format:
        #     `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteWorkloadRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
