# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/apphub/v1/apphub_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module AppHub
      module V1
        module AppHub
          ##
          # Client for the AppHub service.
          #
          # The App Hub API allows you to manage App Hub resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "apphub.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :app_hub_stub

            ##
            # Configure the AppHub Client class.
            #
            # See {::Google::Cloud::AppHub::V1::AppHub::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all AppHub clients
            #   ::Google::Cloud::AppHub::V1::AppHub::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "AppHub", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.lookup_service_project_attachment.timeout = 60.0
                default_config.rpcs.lookup_service_project_attachment.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_service_project_attachments.timeout = 60.0
                default_config.rpcs.list_service_project_attachments.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_service_project_attachment.timeout = 60.0

                default_config.rpcs.get_service_project_attachment.timeout = 60.0
                default_config.rpcs.get_service_project_attachment.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_service_project_attachment.timeout = 60.0

                default_config.rpcs.detach_service_project_attachment.timeout = 60.0

                default_config.rpcs.list_discovered_services.timeout = 60.0
                default_config.rpcs.list_discovered_services.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_discovered_service.timeout = 60.0
                default_config.rpcs.get_discovered_service.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.lookup_discovered_service.timeout = 60.0
                default_config.rpcs.lookup_discovered_service.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_services.timeout = 60.0
                default_config.rpcs.list_services.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_service.timeout = 60.0

                default_config.rpcs.get_service.timeout = 60.0
                default_config.rpcs.get_service.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_service.timeout = 60.0

                default_config.rpcs.delete_service.timeout = 60.0

                default_config.rpcs.list_discovered_workloads.timeout = 60.0
                default_config.rpcs.list_discovered_workloads.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_discovered_workload.timeout = 60.0
                default_config.rpcs.get_discovered_workload.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.lookup_discovered_workload.timeout = 60.0
                default_config.rpcs.lookup_discovered_workload.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_workloads.timeout = 60.0
                default_config.rpcs.list_workloads.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_workload.timeout = 60.0

                default_config.rpcs.get_workload.timeout = 60.0
                default_config.rpcs.get_workload.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_workload.timeout = 60.0

                default_config.rpcs.delete_workload.timeout = 60.0

                default_config.rpcs.list_applications.timeout = 60.0
                default_config.rpcs.list_applications.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_application.timeout = 60.0

                default_config.rpcs.get_application.timeout = 60.0
                default_config.rpcs.get_application.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_application.timeout = 60.0

                default_config.rpcs.delete_application.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the AppHub Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::AppHub::V1::AppHub::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @app_hub_stub.universe_domain
            end

            ##
            # Create a new AppHub client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::AppHub::V1::AppHub::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the AppHub client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/apphub/v1/apphub_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @app_hub_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::AppHub::V1::AppHub::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @app_hub_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @app_hub_stub.endpoint
                config.universe_domain = @app_hub_stub.universe_domain
                config.logger = @app_hub_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @app_hub_stub.endpoint
                config.universe_domain = @app_hub_stub.universe_domain
                config.logger = @app_hub_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::AppHub::V1::AppHub::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @app_hub_stub.logger
            end

            # Service calls

            ##
            # Lists a service project attachment for a given service project. You can
            # call this API from any project to find if it is attached to a host project.
            #
            # @overload lookup_service_project_attachment(request, options = nil)
            #   Pass arguments to `lookup_service_project_attachment` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lookup_service_project_attachment(name: nil)
            #   Pass arguments to `lookup_service_project_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Service project ID and location to lookup service project
            #     attachment for. Only global location is supported. Expected format:
            #     `projects/{project}/locations/{location}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentRequest.new
            #
            #   # Call the lookup_service_project_attachment method.
            #   result = client.lookup_service_project_attachment request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentResponse.
            #   p result
            #
            def lookup_service_project_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::LookupServiceProjectAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lookup_service_project_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.lookup_service_project_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lookup_service_project_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :lookup_service_project_attachment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists service projects attached to the host project.
            #
            # @overload list_service_project_attachments(request, options = nil)
            #   Pass arguments to `list_service_project_attachments` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_project_attachments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_service_project_attachments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Host project ID and location to list service project attachments.
            #     Only global location is supported. Expected format:
            #     `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::ServiceProjectAttachment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::ServiceProjectAttachment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsRequest.new
            #
            #   # Call the list_service_project_attachments method.
            #   result = client.list_service_project_attachments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AppHub::V1::ServiceProjectAttachment.
            #     p item
            #   end
            #
            def list_service_project_attachments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::ListServiceProjectAttachmentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_project_attachments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_project_attachments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_project_attachments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :list_service_project_attachments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @app_hub_stub, :list_service_project_attachments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Attaches a service project to the host project.
            #
            # @overload create_service_project_attachment(request, options = nil)
            #   Pass arguments to `create_service_project_attachment` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::CreateServiceProjectAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::CreateServiceProjectAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_project_attachment(parent: nil, service_project_attachment_id: nil, service_project_attachment: nil, request_id: nil)
            #   Pass arguments to `create_service_project_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Host project ID and location to which service project is being
            #     attached. Only global location is supported. Expected format:
            #     `projects/{project}/locations/{location}`.
            #   @param service_project_attachment_id [::String]
            #     Required. The service project attachment identifier must contain the
            #     project id of the service project specified in the
            #     service_project_attachment.service_project field.
            #   @param service_project_attachment [::Google::Cloud::AppHub::V1::ServiceProjectAttachment, ::Hash]
            #     Required. The resource being created.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::CreateServiceProjectAttachmentRequest.new
            #
            #   # Call the create_service_project_attachment method.
            #   result = client.create_service_project_attachment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service_project_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::CreateServiceProjectAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_project_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_project_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_project_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :create_service_project_attachment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a service project attachment.
            #
            # @overload get_service_project_attachment(request, options = nil)
            #   Pass arguments to `get_service_project_attachment` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::GetServiceProjectAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::GetServiceProjectAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_project_attachment(name: nil)
            #   Pass arguments to `get_service_project_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the service project attachment to
            #     retrieve. Expected format:
            #     `projects/{project}/locations/{location}/serviceProjectAttachments/{serviceProjectAttachment}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::ServiceProjectAttachment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::ServiceProjectAttachment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::GetServiceProjectAttachmentRequest.new
            #
            #   # Call the get_service_project_attachment method.
            #   result = client.get_service_project_attachment request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::ServiceProjectAttachment.
            #   p result
            #
            def get_service_project_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::GetServiceProjectAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_project_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_project_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_project_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :get_service_project_attachment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a service project attachment.
            #
            # @overload delete_service_project_attachment(request, options = nil)
            #   Pass arguments to `delete_service_project_attachment` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::DeleteServiceProjectAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::DeleteServiceProjectAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_project_attachment(name: nil, request_id: nil)
            #   Pass arguments to `delete_service_project_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the service project attachment to delete.
            #     Expected format:
            #     `projects/{project}/locations/{location}/serviceProjectAttachments/{serviceProjectAttachment}`.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::DeleteServiceProjectAttachmentRequest.new
            #
            #   # Call the delete_service_project_attachment method.
            #   result = client.delete_service_project_attachment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_project_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::DeleteServiceProjectAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_project_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_project_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_project_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :delete_service_project_attachment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Detaches a service project from a host project.
            # You can call this API from any service project without needing access to
            # the host project that it is attached to.
            #
            # @overload detach_service_project_attachment(request, options = nil)
            #   Pass arguments to `detach_service_project_attachment` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload detach_service_project_attachment(name: nil)
            #   Pass arguments to `detach_service_project_attachment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Service project id and location to detach from a host project.
            #     Only global location is supported. Expected format:
            #     `projects/{project}/locations/{location}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentRequest.new
            #
            #   # Call the detach_service_project_attachment method.
            #   result = client.detach_service_project_attachment request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentResponse.
            #   p result
            #
            def detach_service_project_attachment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::DetachServiceProjectAttachmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.detach_service_project_attachment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.detach_service_project_attachment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.detach_service_project_attachment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :detach_service_project_attachment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Discovered Services that can be added to an Application in a host
            # project and location.
            #
            # @overload list_discovered_services(request, options = nil)
            #   Pass arguments to `list_discovered_services` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::ListDiscoveredServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::ListDiscoveredServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_discovered_services(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_discovered_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Project and location to list Discovered Services on.
            #     Expected format: `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::DiscoveredService>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::DiscoveredService>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::ListDiscoveredServicesRequest.new
            #
            #   # Call the list_discovered_services method.
            #   result = client.list_discovered_services request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AppHub::V1::DiscoveredService.
            #     p item
            #   end
            #
            def list_discovered_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::ListDiscoveredServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_discovered_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_discovered_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_discovered_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :list_discovered_services, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @app_hub_stub, :list_discovered_services, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Discovered Service in a host project and location.
            #
            # @overload get_discovered_service(request, options = nil)
            #   Pass arguments to `get_discovered_service` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::GetDiscoveredServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::GetDiscoveredServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_discovered_service(name: nil)
            #   Pass arguments to `get_discovered_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Discovered Service to fetch.
            #     Expected format:
            #     `projects/{project}/locations/{location}/discoveredServices/{discoveredService}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::DiscoveredService]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::DiscoveredService]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::GetDiscoveredServiceRequest.new
            #
            #   # Call the get_discovered_service method.
            #   result = client.get_discovered_service request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::DiscoveredService.
            #   p result
            #
            def get_discovered_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::GetDiscoveredServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_discovered_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_discovered_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_discovered_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :get_discovered_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists a Discovered Service in a host project and location, with a
            # given resource URI.
            #
            # @overload lookup_discovered_service(request, options = nil)
            #   Pass arguments to `lookup_discovered_service` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::LookupDiscoveredServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::LookupDiscoveredServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lookup_discovered_service(parent: nil, uri: nil)
            #   Pass arguments to `lookup_discovered_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Host project ID and location to lookup Discovered Service in.
            #     Expected format: `projects/{project}/locations/{location}`.
            #   @param uri [::String]
            #     Required. Resource URI to find DiscoveredService for.
            #     Accepts both project number and project ID and does translation when
            #     needed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::LookupDiscoveredServiceResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::LookupDiscoveredServiceResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::LookupDiscoveredServiceRequest.new
            #
            #   # Call the lookup_discovered_service method.
            #   result = client.lookup_discovered_service request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::LookupDiscoveredServiceResponse.
            #   p result
            #
            def lookup_discovered_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::LookupDiscoveredServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lookup_discovered_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.lookup_discovered_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lookup_discovered_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :lookup_discovered_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Services in an Application.
            #
            # @overload list_services(request, options = nil)
            #   Pass arguments to `list_services` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::ListServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::ListServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_services(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Fully qualified name of the parent Application to list Services
            #     for. Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}`.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::Service>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::Service>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::ListServicesRequest.new
            #
            #   # Call the list_services method.
            #   result = client.list_services request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AppHub::V1::Service.
            #     p item
            #   end
            #
            def list_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::ListServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :list_services, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @app_hub_stub, :list_services, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a Service in an Application.
            #
            # @overload create_service(request, options = nil)
            #   Pass arguments to `create_service` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::CreateServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::CreateServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service(parent: nil, service_id: nil, service: nil, request_id: nil)
            #   Pass arguments to `create_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Fully qualified name of the parent Application to create the
            #     Service in. Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}`.
            #   @param service_id [::String]
            #     Required. The Service identifier.
            #     Must contain only lowercase letters, numbers
            #     or hyphens, with the first character a letter, the last a letter or a
            #     number, and a 63 character maximum.
            #   @param service [::Google::Cloud::AppHub::V1::Service, ::Hash]
            #     Required. The resource being created.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::CreateServiceRequest.new
            #
            #   # Call the create_service method.
            #   result = client.create_service request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::CreateServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :create_service, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Service in an Application.
            #
            # @overload get_service(request, options = nil)
            #   Pass arguments to `get_service` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::GetServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::GetServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service(name: nil)
            #   Pass arguments to `get_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Service to fetch.
            #     Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}/services/{service}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::Service]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::Service]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::GetServiceRequest.new
            #
            #   # Call the get_service method.
            #   result = client.get_service request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::Service.
            #   p result
            #
            def get_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::GetServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :get_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a Service in an Application.
            #
            # @overload update_service(request, options = nil)
            #   Pass arguments to `update_service` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::UpdateServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::UpdateServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service(update_mask: nil, service: nil, request_id: nil)
            #   Pass arguments to `update_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Service resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request.
            #     The API changes the values of the fields as specified in the update_mask.
            #     The API ignores the values of all fields not covered by the update_mask.
            #     You can also unset a field by not specifying it in the updated message, but
            #     adding the field to the mask. This clears whatever value the field
            #     previously had.
            #   @param service [::Google::Cloud::AppHub::V1::Service, ::Hash]
            #     Required. The resource being updated.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::UpdateServiceRequest.new
            #
            #   # Call the update_service method.
            #   result = client.update_service request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::UpdateServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service&.name
                header_params["service.name"] = request.service.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :update_service, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Service from an Application.
            #
            # @overload delete_service(request, options = nil)
            #   Pass arguments to `delete_service` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::DeleteServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::DeleteServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service(name: nil, request_id: nil)
            #   Pass arguments to `delete_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Service to delete from an
            #     Application. Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}/services/{service}`.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::DeleteServiceRequest.new
            #
            #   # Call the delete_service method.
            #   result = client.delete_service request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::DeleteServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :delete_service, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Discovered Workloads that can be added to an Application in a host
            # project and location.
            #
            # @overload list_discovered_workloads(request, options = nil)
            #   Pass arguments to `list_discovered_workloads` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_discovered_workloads(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_discovered_workloads` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Project and location to list Discovered Workloads on.
            #     Expected format: `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::DiscoveredWorkload>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::DiscoveredWorkload>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsRequest.new
            #
            #   # Call the list_discovered_workloads method.
            #   result = client.list_discovered_workloads request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AppHub::V1::DiscoveredWorkload.
            #     p item
            #   end
            #
            def list_discovered_workloads request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::ListDiscoveredWorkloadsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_discovered_workloads.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_discovered_workloads.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_discovered_workloads.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :list_discovered_workloads, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @app_hub_stub, :list_discovered_workloads, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Discovered Workload in a host project and location.
            #
            # @overload get_discovered_workload(request, options = nil)
            #   Pass arguments to `get_discovered_workload` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::GetDiscoveredWorkloadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::GetDiscoveredWorkloadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_discovered_workload(name: nil)
            #   Pass arguments to `get_discovered_workload` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Discovered Workload to fetch.
            #     Expected format:
            #     `projects/{project}/locations/{location}/discoveredWorkloads/{discoveredWorkload}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::DiscoveredWorkload]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::DiscoveredWorkload]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::GetDiscoveredWorkloadRequest.new
            #
            #   # Call the get_discovered_workload method.
            #   result = client.get_discovered_workload request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::DiscoveredWorkload.
            #   p result
            #
            def get_discovered_workload request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::GetDiscoveredWorkloadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_discovered_workload.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_discovered_workload.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_discovered_workload.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :get_discovered_workload, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists a Discovered Workload in a host project and location, with a
            # given resource URI.
            #
            # @overload lookup_discovered_workload(request, options = nil)
            #   Pass arguments to `lookup_discovered_workload` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lookup_discovered_workload(parent: nil, uri: nil)
            #   Pass arguments to `lookup_discovered_workload` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Host project ID and location to lookup Discovered Workload in.
            #     Expected format: `projects/{project}/locations/{location}`.
            #   @param uri [::String]
            #     Required. Resource URI to find Discovered Workload for.
            #     Accepts both project number and project ID and does translation when
            #     needed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadRequest.new
            #
            #   # Call the lookup_discovered_workload method.
            #   result = client.lookup_discovered_workload request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadResponse.
            #   p result
            #
            def lookup_discovered_workload request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::LookupDiscoveredWorkloadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lookup_discovered_workload.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.lookup_discovered_workload.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lookup_discovered_workload.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :lookup_discovered_workload, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Workloads in an Application.
            #
            # @overload list_workloads(request, options = nil)
            #   Pass arguments to `list_workloads` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::ListWorkloadsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::ListWorkloadsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workloads(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_workloads` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Fully qualified name of the parent Application to list Workloads
            #     for. Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}`.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::Workload>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::Workload>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::ListWorkloadsRequest.new
            #
            #   # Call the list_workloads method.
            #   result = client.list_workloads request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AppHub::V1::Workload.
            #     p item
            #   end
            #
            def list_workloads request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::ListWorkloadsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workloads.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workloads.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workloads.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :list_workloads, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @app_hub_stub, :list_workloads, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a Workload in an Application.
            #
            # @overload create_workload(request, options = nil)
            #   Pass arguments to `create_workload` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::CreateWorkloadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::CreateWorkloadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workload(parent: nil, workload_id: nil, workload: nil, request_id: nil)
            #   Pass arguments to `create_workload` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Fully qualified name of the Application to create Workload in.
            #     Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}`.
            #   @param workload_id [::String]
            #     Required. The Workload identifier.
            #     Must contain only lowercase letters, numbers
            #     or hyphens, with the first character a letter, the last a letter or a
            #     number, and a 63 character maximum.
            #   @param workload [::Google::Cloud::AppHub::V1::Workload, ::Hash]
            #     Required. The resource being created.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::CreateWorkloadRequest.new
            #
            #   # Call the create_workload method.
            #   result = client.create_workload request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_workload request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::CreateWorkloadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workload.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workload.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workload.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :create_workload, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Workload in an Application.
            #
            # @overload get_workload(request, options = nil)
            #   Pass arguments to `get_workload` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::GetWorkloadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::GetWorkloadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workload(name: nil)
            #   Pass arguments to `get_workload` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Workload to fetch.
            #     Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::Workload]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::Workload]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::GetWorkloadRequest.new
            #
            #   # Call the get_workload method.
            #   result = client.get_workload request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::Workload.
            #   p result
            #
            def get_workload request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::GetWorkloadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workload.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workload.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workload.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :get_workload, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a Workload in an Application.
            #
            # @overload update_workload(request, options = nil)
            #   Pass arguments to `update_workload` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::UpdateWorkloadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::UpdateWorkloadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_workload(update_mask: nil, workload: nil, request_id: nil)
            #   Pass arguments to `update_workload` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Workload resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request.
            #     The API changes the values of the fields as specified in the update_mask.
            #     The API ignores the values of all fields not covered by the update_mask.
            #     You can also unset a field by not specifying it in the updated message, but
            #     adding the field to the mask. This clears whatever value the field
            #     previously had.
            #   @param workload [::Google::Cloud::AppHub::V1::Workload, ::Hash]
            #     Required. The resource being updated.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::UpdateWorkloadRequest.new
            #
            #   # Call the update_workload method.
            #   result = client.update_workload request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_workload request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::UpdateWorkloadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_workload.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workload&.name
                header_params["workload.name"] = request.workload.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_workload.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_workload.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :update_workload, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Workload from an Application.
            #
            # @overload delete_workload(request, options = nil)
            #   Pass arguments to `delete_workload` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::DeleteWorkloadRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::DeleteWorkloadRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workload(name: nil, request_id: nil)
            #   Pass arguments to `delete_workload` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Workload to delete from an
            #     Application. Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::DeleteWorkloadRequest.new
            #
            #   # Call the delete_workload method.
            #   result = client.delete_workload request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_workload request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::DeleteWorkloadRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workload.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workload.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workload.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :delete_workload, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Applications in a host project and location.
            #
            # @overload list_applications(request, options = nil)
            #   Pass arguments to `list_applications` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::ListApplicationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::ListApplicationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_applications(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_applications` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Project and location to list Applications on.
            #     Expected format: `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results.
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::Application>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::AppHub::V1::Application>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::ListApplicationsRequest.new
            #
            #   # Call the list_applications method.
            #   result = client.list_applications request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::AppHub::V1::Application.
            #     p item
            #   end
            #
            def list_applications request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::ListApplicationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_applications.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_applications.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_applications.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :list_applications, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @app_hub_stub, :list_applications, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Application in a host project and location.
            #
            # @overload create_application(request, options = nil)
            #   Pass arguments to `create_application` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::CreateApplicationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::CreateApplicationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_application(parent: nil, application_id: nil, application: nil, request_id: nil)
            #   Pass arguments to `create_application` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Project and location to create Application in.
            #     Expected format: `projects/{project}/locations/{location}`.
            #   @param application_id [::String]
            #     Required. The Application identifier.
            #     Must contain only lowercase letters, numbers
            #     or hyphens, with the first character a letter, the last a letter or a
            #     number, and a 63 character maximum.
            #   @param application [::Google::Cloud::AppHub::V1::Application, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::CreateApplicationRequest.new
            #
            #   # Call the create_application method.
            #   result = client.create_application request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_application request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::CreateApplicationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_application.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_application.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_application.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :create_application, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an Application in a host project and location.
            #
            # @overload get_application(request, options = nil)
            #   Pass arguments to `get_application` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::GetApplicationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::GetApplicationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_application(name: nil)
            #   Pass arguments to `get_application` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Application to fetch.
            #     Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::AppHub::V1::Application]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::AppHub::V1::Application]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::GetApplicationRequest.new
            #
            #   # Call the get_application method.
            #   result = client.get_application request
            #
            #   # The returned object is of type Google::Cloud::AppHub::V1::Application.
            #   p result
            #
            def get_application request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::GetApplicationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_application.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_application.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_application.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :get_application, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an Application in a host project and location.
            #
            # @overload update_application(request, options = nil)
            #   Pass arguments to `update_application` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::UpdateApplicationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::UpdateApplicationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_application(update_mask: nil, application: nil, request_id: nil)
            #   Pass arguments to `update_application` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Application resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request.
            #     The API changes the values of the fields as specified in the update_mask.
            #     The API ignores the values of all fields not covered by the update_mask.
            #     You can also unset a field by not specifying it in the updated message, but
            #     adding the field to the mask. This clears whatever value the field
            #     previously had.
            #   @param application [::Google::Cloud::AppHub::V1::Application, ::Hash]
            #     Required. The resource being updated.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::UpdateApplicationRequest.new
            #
            #   # Call the update_application method.
            #   result = client.update_application request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_application request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::UpdateApplicationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_application.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.application&.name
                header_params["application.name"] = request.application.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_application.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_application.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :update_application, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Application in a host project and location.
            #
            # @overload delete_application(request, options = nil)
            #   Pass arguments to `delete_application` via a request object, either of type
            #   {::Google::Cloud::AppHub::V1::DeleteApplicationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::AppHub::V1::DeleteApplicationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_application(name: nil, request_id: nil)
            #   Pass arguments to `delete_application` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Fully qualified name of the Application to delete.
            #     Expected format:
            #     `projects/{project}/locations/{location}/applications/{application}`.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/app_hub/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::AppHub::V1::AppHub::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::AppHub::V1::DeleteApplicationRequest.new
            #
            #   # Call the delete_application method.
            #   result = client.delete_application request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_application request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppHub::V1::DeleteApplicationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_application.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::AppHub::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_application.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_application.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @app_hub_stub.call_rpc :delete_application, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the AppHub API.
            #
            # This class represents the configuration for AppHub,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::AppHub::V1::AppHub::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # lookup_service_project_attachment to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::AppHub::V1::AppHub::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.lookup_service_project_attachment.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::AppHub::V1::AppHub::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.lookup_service_project_attachment.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::AppHub::V1::AppHub::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "apphub.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the AppHub API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `lookup_service_project_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lookup_service_project_attachment
                ##
                # RPC-specific configuration for `list_service_project_attachments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_project_attachments
                ##
                # RPC-specific configuration for `create_service_project_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_project_attachment
                ##
                # RPC-specific configuration for `get_service_project_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_project_attachment
                ##
                # RPC-specific configuration for `delete_service_project_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_project_attachment
                ##
                # RPC-specific configuration for `detach_service_project_attachment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :detach_service_project_attachment
                ##
                # RPC-specific configuration for `list_discovered_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_discovered_services
                ##
                # RPC-specific configuration for `get_discovered_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_discovered_service
                ##
                # RPC-specific configuration for `lookup_discovered_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lookup_discovered_service
                ##
                # RPC-specific configuration for `list_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_services
                ##
                # RPC-specific configuration for `create_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service
                ##
                # RPC-specific configuration for `get_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service
                ##
                # RPC-specific configuration for `update_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service
                ##
                # RPC-specific configuration for `delete_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service
                ##
                # RPC-specific configuration for `list_discovered_workloads`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_discovered_workloads
                ##
                # RPC-specific configuration for `get_discovered_workload`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_discovered_workload
                ##
                # RPC-specific configuration for `lookup_discovered_workload`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lookup_discovered_workload
                ##
                # RPC-specific configuration for `list_workloads`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workloads
                ##
                # RPC-specific configuration for `create_workload`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workload
                ##
                # RPC-specific configuration for `get_workload`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workload
                ##
                # RPC-specific configuration for `update_workload`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_workload
                ##
                # RPC-specific configuration for `delete_workload`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workload
                ##
                # RPC-specific configuration for `list_applications`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_applications
                ##
                # RPC-specific configuration for `create_application`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_application
                ##
                # RPC-specific configuration for `get_application`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_application
                ##
                # RPC-specific configuration for `update_application`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_application
                ##
                # RPC-specific configuration for `delete_application`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_application

                # @private
                def initialize parent_rpcs = nil
                  lookup_service_project_attachment_config = parent_rpcs.lookup_service_project_attachment if parent_rpcs.respond_to? :lookup_service_project_attachment
                  @lookup_service_project_attachment = ::Gapic::Config::Method.new lookup_service_project_attachment_config
                  list_service_project_attachments_config = parent_rpcs.list_service_project_attachments if parent_rpcs.respond_to? :list_service_project_attachments
                  @list_service_project_attachments = ::Gapic::Config::Method.new list_service_project_attachments_config
                  create_service_project_attachment_config = parent_rpcs.create_service_project_attachment if parent_rpcs.respond_to? :create_service_project_attachment
                  @create_service_project_attachment = ::Gapic::Config::Method.new create_service_project_attachment_config
                  get_service_project_attachment_config = parent_rpcs.get_service_project_attachment if parent_rpcs.respond_to? :get_service_project_attachment
                  @get_service_project_attachment = ::Gapic::Config::Method.new get_service_project_attachment_config
                  delete_service_project_attachment_config = parent_rpcs.delete_service_project_attachment if parent_rpcs.respond_to? :delete_service_project_attachment
                  @delete_service_project_attachment = ::Gapic::Config::Method.new delete_service_project_attachment_config
                  detach_service_project_attachment_config = parent_rpcs.detach_service_project_attachment if parent_rpcs.respond_to? :detach_service_project_attachment
                  @detach_service_project_attachment = ::Gapic::Config::Method.new detach_service_project_attachment_config
                  list_discovered_services_config = parent_rpcs.list_discovered_services if parent_rpcs.respond_to? :list_discovered_services
                  @list_discovered_services = ::Gapic::Config::Method.new list_discovered_services_config
                  get_discovered_service_config = parent_rpcs.get_discovered_service if parent_rpcs.respond_to? :get_discovered_service
                  @get_discovered_service = ::Gapic::Config::Method.new get_discovered_service_config
                  lookup_discovered_service_config = parent_rpcs.lookup_discovered_service if parent_rpcs.respond_to? :lookup_discovered_service
                  @lookup_discovered_service = ::Gapic::Config::Method.new lookup_discovered_service_config
                  list_services_config = parent_rpcs.list_services if parent_rpcs.respond_to? :list_services
                  @list_services = ::Gapic::Config::Method.new list_services_config
                  create_service_config = parent_rpcs.create_service if parent_rpcs.respond_to? :create_service
                  @create_service = ::Gapic::Config::Method.new create_service_config
                  get_service_config = parent_rpcs.get_service if parent_rpcs.respond_to? :get_service
                  @get_service = ::Gapic::Config::Method.new get_service_config
                  update_service_config = parent_rpcs.update_service if parent_rpcs.respond_to? :update_service
                  @update_service = ::Gapic::Config::Method.new update_service_config
                  delete_service_config = parent_rpcs.delete_service if parent_rpcs.respond_to? :delete_service
                  @delete_service = ::Gapic::Config::Method.new delete_service_config
                  list_discovered_workloads_config = parent_rpcs.list_discovered_workloads if parent_rpcs.respond_to? :list_discovered_workloads
                  @list_discovered_workloads = ::Gapic::Config::Method.new list_discovered_workloads_config
                  get_discovered_workload_config = parent_rpcs.get_discovered_workload if parent_rpcs.respond_to? :get_discovered_workload
                  @get_discovered_workload = ::Gapic::Config::Method.new get_discovered_workload_config
                  lookup_discovered_workload_config = parent_rpcs.lookup_discovered_workload if parent_rpcs.respond_to? :lookup_discovered_workload
                  @lookup_discovered_workload = ::Gapic::Config::Method.new lookup_discovered_workload_config
                  list_workloads_config = parent_rpcs.list_workloads if parent_rpcs.respond_to? :list_workloads
                  @list_workloads = ::Gapic::Config::Method.new list_workloads_config
                  create_workload_config = parent_rpcs.create_workload if parent_rpcs.respond_to? :create_workload
                  @create_workload = ::Gapic::Config::Method.new create_workload_config
                  get_workload_config = parent_rpcs.get_workload if parent_rpcs.respond_to? :get_workload
                  @get_workload = ::Gapic::Config::Method.new get_workload_config
                  update_workload_config = parent_rpcs.update_workload if parent_rpcs.respond_to? :update_workload
                  @update_workload = ::Gapic::Config::Method.new update_workload_config
                  delete_workload_config = parent_rpcs.delete_workload if parent_rpcs.respond_to? :delete_workload
                  @delete_workload = ::Gapic::Config::Method.new delete_workload_config
                  list_applications_config = parent_rpcs.list_applications if parent_rpcs.respond_to? :list_applications
                  @list_applications = ::Gapic::Config::Method.new list_applications_config
                  create_application_config = parent_rpcs.create_application if parent_rpcs.respond_to? :create_application
                  @create_application = ::Gapic::Config::Method.new create_application_config
                  get_application_config = parent_rpcs.get_application if parent_rpcs.respond_to? :get_application
                  @get_application = ::Gapic::Config::Method.new get_application_config
                  update_application_config = parent_rpcs.update_application if parent_rpcs.respond_to? :update_application
                  @update_application = ::Gapic::Config::Method.new update_application_config
                  delete_application_config = parent_rpcs.delete_application if parent_rpcs.respond_to? :delete_application
                  @delete_application = ::Gapic::Config::Method.new delete_application_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
