# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/app_hub/v1/version"

require "google/cloud/app_hub/v1/app_hub/credentials"
require "google/cloud/app_hub/v1/app_hub/paths"
require "google/cloud/app_hub/v1/app_hub/operations"
require "google/cloud/app_hub/v1/app_hub/client"
require "google/cloud/app_hub/v1/app_hub/rest"

module Google
  module Cloud
    module AppHub
      module V1
        ##
        # The App Hub API allows you to manage App Hub resources.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/app_hub/v1/app_hub"
        #     client = ::Google::Cloud::AppHub::V1::AppHub::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/app_hub/v1/app_hub/rest"
        #     client = ::Google::Cloud::AppHub::V1::AppHub::Rest::Client.new
        #
        module AppHub
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "app_hub", "helpers.rb"
require "google/cloud/app_hub/v1/app_hub/helpers" if ::File.file? helper_path
