# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/app_engine"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::AppEngine::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_applications_grpc
    skip unless Google::Cloud::AppEngine.applications_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.applications transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Applications::Client, client
    end
  end

  def test_applications_rest
    skip unless Google::Cloud::AppEngine.applications_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.applications transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Applications::Rest::Client, client
    end
  end

  def test_services_grpc
    skip unless Google::Cloud::AppEngine.services_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.services transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Services::Client, client
    end
  end

  def test_services_rest
    skip unless Google::Cloud::AppEngine.services_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.services transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Services::Rest::Client, client
    end
  end

  def test_versions_grpc
    skip unless Google::Cloud::AppEngine.versions_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.versions transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Versions::Client, client
    end
  end

  def test_versions_rest
    skip unless Google::Cloud::AppEngine.versions_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.versions transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Versions::Rest::Client, client
    end
  end

  def test_instances_grpc
    skip unless Google::Cloud::AppEngine.instances_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.instances transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Instances::Client, client
    end
  end

  def test_instances_rest
    skip unless Google::Cloud::AppEngine.instances_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.instances transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Instances::Rest::Client, client
    end
  end

  def test_firewall_grpc
    skip unless Google::Cloud::AppEngine.firewall_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.firewall transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Firewall::Client, client
    end
  end

  def test_firewall_rest
    skip unless Google::Cloud::AppEngine.firewall_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.firewall transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::Firewall::Rest::Client, client
    end
  end

  def test_authorized_domains_grpc
    skip unless Google::Cloud::AppEngine.authorized_domains_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.authorized_domains transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::AuthorizedDomains::Client, client
    end
  end

  def test_authorized_domains_rest
    skip unless Google::Cloud::AppEngine.authorized_domains_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.authorized_domains transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::AuthorizedDomains::Rest::Client, client
    end
  end

  def test_authorized_certificates_grpc
    skip unless Google::Cloud::AppEngine.authorized_certificates_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.authorized_certificates transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::AuthorizedCertificates::Client, client
    end
  end

  def test_authorized_certificates_rest
    skip unless Google::Cloud::AppEngine.authorized_certificates_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.authorized_certificates transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::AuthorizedCertificates::Rest::Client, client
    end
  end

  def test_domain_mappings_grpc
    skip unless Google::Cloud::AppEngine.domain_mappings_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::AppEngine.domain_mappings transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::AppEngine::V1::DomainMappings::Client, client
    end
  end

  def test_domain_mappings_rest
    skip unless Google::Cloud::AppEngine.domain_mappings_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::AppEngine.domain_mappings transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::AppEngine::V1::DomainMappings::Rest::Client, client
    end
  end
end
