# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/app_engine/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :app_engine do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module AppEngine
      ##
      # Create a new client object for Applications.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::Applications::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-Applications-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Applications service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Applications service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.applications_available?}.
      #
      # ## About Applications
      #
      # Manages App Engine applications.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.applications version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:Applications)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Applications service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.applications}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Applications service,
      # or if the versioned client gem needs an update to support the Applications service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.applications_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :Applications
        service_module = service_module.const_get :Applications
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Services.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::Services::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-Services-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Services service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Services service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.services_available?}.
      #
      # ## About Services
      #
      # Manages services of an application.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.services version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:Services)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Services service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.services}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Services service,
      # or if the versioned client gem needs an update to support the Services service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.services_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :Services
        service_module = service_module.const_get :Services
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Versions.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::Versions::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-Versions-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Versions service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Versions service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.versions_available?}.
      #
      # ## About Versions
      #
      # Manages versions of a service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.versions version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:Versions)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Versions service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.versions}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Versions service,
      # or if the versioned client gem needs an update to support the Versions service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.versions_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :Versions
        service_module = service_module.const_get :Versions
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Instances.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::Instances::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-Instances-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Instances service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Instances service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.instances_available?}.
      #
      # ## About Instances
      #
      # Manages instances of a version.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.instances version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:Instances)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Instances service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.instances}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Instances service,
      # or if the versioned client gem needs an update to support the Instances service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.instances_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :Instances
        service_module = service_module.const_get :Instances
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Firewall.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::Firewall::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-Firewall-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Firewall service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Firewall service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.firewall_available?}.
      #
      # ## About Firewall
      #
      # Firewall resources are used to define a collection of access control rules
      # for an Application. Each rule is defined with a position which specifies
      # the rule's order in the sequence of rules, an IP range to be matched against
      # requests, and an action to take upon matching requests.
      #
      # Every request is evaluated against the Firewall rules in priority order.
      # Processesing stops at the first rule which matches the request's IP address.
      # A final rule always specifies an action that applies to all remaining
      # IP addresses. The default final rule for a newly-created application will be
      # set to "allow" if not otherwise specified by the user.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.firewall version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:Firewall)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Firewall service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.firewall}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Firewall service,
      # or if the versioned client gem needs an update to support the Firewall service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.firewall_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :Firewall
        service_module = service_module.const_get :Firewall
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AuthorizedDomains.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::AuthorizedDomains::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-AuthorizedDomains-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AuthorizedDomains service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the AuthorizedDomains service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.authorized_domains_available?}.
      #
      # ## About AuthorizedDomains
      #
      # Manages domains a user is authorized to administer. To authorize use of a
      # domain, verify ownership via
      # [Webmaster Central](https://www.google.com/webmasters/verification/home).
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.authorized_domains version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:AuthorizedDomains)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AuthorizedDomains service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.authorized_domains}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AuthorizedDomains service,
      # or if the versioned client gem needs an update to support the AuthorizedDomains service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.authorized_domains_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :AuthorizedDomains
        service_module = service_module.const_get :AuthorizedDomains
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AuthorizedCertificates.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::AuthorizedCertificates::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-AuthorizedCertificates-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AuthorizedCertificates service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the AuthorizedCertificates service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.authorized_certificates_available?}.
      #
      # ## About AuthorizedCertificates
      #
      # Manages SSL certificates a user is authorized to administer. A user can
      # administer any SSL certificates applicable to their authorized domains.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.authorized_certificates version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:AuthorizedCertificates)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AuthorizedCertificates service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.authorized_certificates}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AuthorizedCertificates service,
      # or if the versioned client gem needs an update to support the AuthorizedCertificates service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.authorized_certificates_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :AuthorizedCertificates
        service_module = service_module.const_get :AuthorizedCertificates
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DomainMappings.
      #
      # By default, this returns an instance of
      # [Google::Cloud::AppEngine::V1::DomainMappings::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-app_engine-v1/latest/Google-Cloud-AppEngine-V1-DomainMappings-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DomainMappings service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DomainMappings service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::AppEngine.domain_mappings_available?}.
      #
      # ## About DomainMappings
      #
      # Manages domains serving an application.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.domain_mappings version: :v1, transport: :grpc, &block
        require "google/cloud/app_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::AppEngine.const_get(package_name).const_get(:DomainMappings)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DomainMappings service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::AppEngine.domain_mappings}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DomainMappings service,
      # or if the versioned client gem needs an update to support the DomainMappings service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.domain_mappings_available? version: :v1, transport: :grpc
        require "google/cloud/app_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::AppEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::AppEngine.const_get package_name
        return false unless service_module.const_defined? :DomainMappings
        service_module = service_module.const_get :DomainMappings
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-app_engine library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.app_engine if block_given?

        ::Google::Cloud.configure.app_engine
      end
    end
  end
end

helper_path = ::File.join __dir__, "app_engine", "helpers.rb"
require "google/cloud/app_engine/helpers" if ::File.file? helper_path
