# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/appengine/v1/appengine_pb"
require "google/cloud/app_engine/v1/firewall"

class ::Google::Cloud::AppEngine::V1::Firewall::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_ingress_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AppEngine::V1::ListIngressRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    matching_address = "hello world"

    list_ingress_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_ingress_rules, name
      assert_kind_of ::Google::Cloud::AppEngine::V1::ListIngressRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["matching_address"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_ingress_rules_client_stub do
      # Create client
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_ingress_rules({ parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_ingress_rules parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_ingress_rules ::Google::Cloud::AppEngine::V1::ListIngressRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_ingress_rules({ parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_ingress_rules(::Google::Cloud::AppEngine::V1::ListIngressRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_ingress_rules_client_stub.call_rpc_count
    end
  end

  def test_batch_update_ingress_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ingress_rules = [{}]

    batch_update_ingress_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_update_ingress_rules, name
      assert_kind_of ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::AppEngine::V1::FirewallRule, request["ingress_rules"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_update_ingress_rules_client_stub do
      # Create client
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_update_ingress_rules({ name: name, ingress_rules: ingress_rules }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_update_ingress_rules name: name, ingress_rules: ingress_rules do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_update_ingress_rules ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest.new(name: name, ingress_rules: ingress_rules) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_update_ingress_rules({ name: name, ingress_rules: ingress_rules }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_update_ingress_rules(::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest.new(name: name, ingress_rules: ingress_rules), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_update_ingress_rules_client_stub.call_rpc_count
    end
  end

  def test_create_ingress_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AppEngine::V1::FirewallRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rule = {}

    create_ingress_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_ingress_rule, name
      assert_kind_of ::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AppEngine::V1::FirewallRule), request["rule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_ingress_rule_client_stub do
      # Create client
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_ingress_rule({ parent: parent, rule: rule }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_ingress_rule parent: parent, rule: rule do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_ingress_rule ::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest.new(parent: parent, rule: rule) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_ingress_rule({ parent: parent, rule: rule }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_ingress_rule(::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest.new(parent: parent, rule: rule), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_ingress_rule_client_stub.call_rpc_count
    end
  end

  def test_get_ingress_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AppEngine::V1::FirewallRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ingress_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_ingress_rule, name
      assert_kind_of ::Google::Cloud::AppEngine::V1::GetIngressRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_ingress_rule_client_stub do
      # Create client
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_ingress_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_ingress_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_ingress_rule ::Google::Cloud::AppEngine::V1::GetIngressRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_ingress_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_ingress_rule(::Google::Cloud::AppEngine::V1::GetIngressRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_ingress_rule_client_stub.call_rpc_count
    end
  end

  def test_update_ingress_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AppEngine::V1::FirewallRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    rule = {}
    update_mask = {}

    update_ingress_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_ingress_rule, name
      assert_kind_of ::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AppEngine::V1::FirewallRule), request["rule"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_ingress_rule_client_stub do
      # Create client
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_ingress_rule({ name: name, rule: rule, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_ingress_rule name: name, rule: rule, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_ingress_rule ::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest.new(name: name, rule: rule, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_ingress_rule({ name: name, rule: rule, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_ingress_rule(::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest.new(name: name, rule: rule, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_ingress_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_ingress_rule
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_ingress_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_ingress_rule, name
      assert_kind_of ::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_ingress_rule_client_stub do
      # Create client
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_ingress_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_ingress_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_ingress_rule ::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_ingress_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_ingress_rule(::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_ingress_rule_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AppEngine::V1::Firewall::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AppEngine::V1::Firewall::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AppEngine::V1::Firewall::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
