# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/appengine/v1/appengine_pb"
require "google/cloud/app_engine/v1/firewall/rest"


class ::Google::Cloud::AppEngine::V1::Firewall::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_ingress_rules
    # Create test objects.
    client_result = ::Google::Cloud::AppEngine::V1::ListIngressRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    matching_address = "hello world"

    list_ingress_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.stub :transcode_list_ingress_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_ingress_rules_client_stub do
        # Create client
        client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_ingress_rules({ parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_ingress_rules parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_ingress_rules ::Google::Cloud::AppEngine::V1::ListIngressRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_ingress_rules({ parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_ingress_rules(::Google::Cloud::AppEngine::V1::ListIngressRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, matching_address: matching_address), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_ingress_rules_client_stub.call_count
      end
    end
  end

  def test_batch_update_ingress_rules
    # Create test objects.
    client_result = ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    ingress_rules = [{}]

    batch_update_ingress_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.stub :transcode_batch_update_ingress_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_update_ingress_rules_client_stub do
        # Create client
        client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_update_ingress_rules({ name: name, ingress_rules: ingress_rules }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_update_ingress_rules name: name, ingress_rules: ingress_rules do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_update_ingress_rules ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest.new(name: name, ingress_rules: ingress_rules) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_update_ingress_rules({ name: name, ingress_rules: ingress_rules }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_update_ingress_rules(::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest.new(name: name, ingress_rules: ingress_rules), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_update_ingress_rules_client_stub.call_count
      end
    end
  end

  def test_create_ingress_rule
    # Create test objects.
    client_result = ::Google::Cloud::AppEngine::V1::FirewallRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rule = {}

    create_ingress_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.stub :transcode_create_ingress_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_ingress_rule_client_stub do
        # Create client
        client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_ingress_rule({ parent: parent, rule: rule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_ingress_rule parent: parent, rule: rule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_ingress_rule ::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest.new(parent: parent, rule: rule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_ingress_rule({ parent: parent, rule: rule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_ingress_rule(::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest.new(parent: parent, rule: rule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_ingress_rule_client_stub.call_count
      end
    end
  end

  def test_get_ingress_rule
    # Create test objects.
    client_result = ::Google::Cloud::AppEngine::V1::FirewallRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_ingress_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.stub :transcode_get_ingress_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_ingress_rule_client_stub do
        # Create client
        client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_ingress_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_ingress_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_ingress_rule ::Google::Cloud::AppEngine::V1::GetIngressRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_ingress_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_ingress_rule(::Google::Cloud::AppEngine::V1::GetIngressRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_ingress_rule_client_stub.call_count
      end
    end
  end

  def test_update_ingress_rule
    # Create test objects.
    client_result = ::Google::Cloud::AppEngine::V1::FirewallRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    rule = {}
    update_mask = {}

    update_ingress_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.stub :transcode_update_ingress_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_ingress_rule_client_stub do
        # Create client
        client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_ingress_rule({ name: name, rule: rule, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_ingress_rule name: name, rule: rule, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_ingress_rule ::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest.new(name: name, rule: rule, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_ingress_rule({ name: name, rule: rule, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_ingress_rule(::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest.new(name: name, rule: rule, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_ingress_rule_client_stub.call_count
      end
    end
  end

  def test_delete_ingress_rule
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_ingress_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.stub :transcode_delete_ingress_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_ingress_rule_client_stub do
        # Create client
        client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_ingress_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_ingress_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_ingress_rule ::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_ingress_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_ingress_rule(::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_ingress_rule_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client::Configuration, config
  end
end
