# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppEngine
      module V1
        # An Instance resource is the computing unit that App Engine uses to
        # automatically scale an application.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Full path to the Instance resource in the API.
        #     Example: `apps/myapp/services/default/versions/v1/instances/instance-1`.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. Relative name of the instance within the version.
        #     Example: `instance-1`.
        # @!attribute [r] app_engine_release
        #   @return [::String]
        #     Output only. App Engine release this instance is running on.
        # @!attribute [r] availability
        #   @return [::Google::Cloud::AppEngine::V1::Instance::Availability]
        #     Output only. Availability of the instance.
        # @!attribute [r] vm_name
        #   @return [::String]
        #     Output only. Name of the virtual machine where this instance lives. Only applicable
        #     for instances in App Engine flexible environment.
        # @!attribute [r] vm_zone_name
        #   @return [::String]
        #     Output only. Zone where the virtual machine is located. Only applicable for instances
        #     in App Engine flexible environment.
        # @!attribute [r] vm_id
        #   @return [::String]
        #     Output only. Virtual machine ID of this instance. Only applicable for instances in
        #     App Engine flexible environment.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time that this instance was started.
        # @!attribute [r] requests
        #   @return [::Integer]
        #     Output only. Number of requests since this instance was started.
        # @!attribute [r] errors
        #   @return [::Integer]
        #     Output only. Number of errors since this instance was started.
        # @!attribute [r] qps
        #   @return [::Float]
        #     Output only. Average queries per second (QPS) over the last minute.
        # @!attribute [r] average_latency
        #   @return [::Integer]
        #     Output only. Average latency (ms) over the last minute.
        # @!attribute [r] memory_usage
        #   @return [::Integer]
        #     Output only. Total memory in use (bytes).
        # @!attribute [r] vm_status
        #   @return [::String]
        #     Output only. Status of the virtual machine where this instance lives. Only applicable
        #     for instances in App Engine flexible environment.
        # @!attribute [r] vm_debug_enabled
        #   @return [::Boolean]
        #     Output only. Whether this instance is in debug mode. Only applicable for instances in
        #     App Engine flexible environment.
        # @!attribute [r] vm_ip
        #   @return [::String]
        #     Output only. The IP address of this instance. Only applicable for instances in App
        #     Engine flexible environment.
        # @!attribute [r] vm_liveness
        #   @return [::Google::Cloud::AppEngine::V1::Instance::Liveness::LivenessState]
        #     Output only. The liveness health check of this instance. Only applicable for instances
        #     in App Engine flexible environment.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Wrapper for LivenessState enum.
          class Liveness
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Liveness health check status for Flex instances.
            module LivenessState
              # There is no liveness health check for the instance. Only applicable for
              # instances in App Engine standard environment.
              LIVENESS_STATE_UNSPECIFIED = 0

              # The health checking system is aware of the instance but its health is
              # not known at the moment.
              UNKNOWN = 1

              # The instance is reachable i.e. a connection to the application health
              # checking endpoint can be established, and conforms to the requirements
              # defined by the health check.
              HEALTHY = 2

              # The instance is reachable, but does not conform to the requirements
              # defined by the health check.
              UNHEALTHY = 3

              # The instance is being drained. The existing connections to the instance
              # have time to complete, but the new ones are being refused.
              DRAINING = 4

              # The instance is unreachable i.e. a connection to the application health
              # checking endpoint cannot be established, or the server does not respond
              # within the specified timeout.
              TIMEOUT = 5
            end
          end

          # Availability of the instance.
          module Availability
            UNSPECIFIED = 0

            RESIDENT = 1

            DYNAMIC = 2
          end
        end
      end
    end
  end
end
