# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppEngine
      module V1
        # A single firewall rule that is evaluated against incoming traffic
        # and provides an action to take on matched requests.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     A positive integer between [1, Int32.MaxValue-1] that defines the order of
        #     rule evaluation. Rules with the lowest priority are evaluated first.
        #
        #     A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic
        #     when no previous rule matches. Only the action of this rule can be modified
        #     by the user.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::AppEngine::V1::FirewallRule::Action]
        #     The action to take on matched requests.
        # @!attribute [rw] source_range
        #   @return [::String]
        #     IP address or range, defined using CIDR notation, of requests that this
        #     rule applies to. You can use the wildcard character "*" to match all IPs
        #     equivalent to "0/0" and "::/0" together.
        #     Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
        #               or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
        #
        #
        #     <p>Truncation will be silently performed on addresses which are not
        #     properly truncated. For example, `1.2.3.4/24` is accepted as the same
        #     address as `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` is accepted
        #     as the same address as `2001:db8::/32`.
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional string description of this rule.
        #     This field has a maximum length of 100 characters.
        class FirewallRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Available actions to take on matching requests.
          module Action
            UNSPECIFIED_ACTION = 0

            # Matching requests are allowed.
            ALLOW = 1

            # Matching requests are denied.
            DENY = 2
          end
        end
      end
    end
  end
end
