# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppEngine
      module V1
        # A domain serving an App Engine application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full path to the `DomainMapping` resource in the API. Example:
        #     `apps/myapp/domainMapping/example.com`.
        # @!attribute [rw] id
        #   @return [::String]
        #     Relative name of the domain serving the application. Example:
        #     `example.com`.
        # @!attribute [rw] ssl_settings
        #   @return [::Google::Cloud::AppEngine::V1::SslSettings]
        #     SSL configuration for this domain. If unconfigured, this domain will not
        #     serve with SSL.
        # @!attribute [rw] resource_records
        #   @return [::Array<::Google::Cloud::AppEngine::V1::ResourceRecord>]
        #     The resource records required to configure this domain mapping. These
        #     records must be added to the domain's DNS configuration in order to
        #     serve the application via this domain mapping.
        class DomainMapping
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SSL configuration for a `DomainMapping` resource.
        # @!attribute [rw] certificate_id
        #   @return [::String]
        #     ID of the `AuthorizedCertificate` resource configuring SSL for the
        #     application. Clearing this field will remove SSL support.
        #
        #     By default, a managed certificate is automatically created for every
        #     domain mapping. To omit SSL support or to configure SSL manually, specify
        #     `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must
        #     be authorized to administer the `AuthorizedCertificate` resource to
        #     manually map it to a `DomainMapping` resource.
        #     Example: `12345`.
        # @!attribute [rw] ssl_management_type
        #   @return [::Google::Cloud::AppEngine::V1::SslSettings::SslManagementType]
        #     SSL management type for this domain. If `AUTOMATIC`, a managed certificate
        #     is automatically provisioned. If `MANUAL`, `certificate_id` must be
        #     manually specified in order to configure SSL for this domain.
        # @!attribute [rw] pending_managed_certificate_id
        #   @return [::String]
        #     ID of the managed `AuthorizedCertificate` resource currently being
        #     provisioned, if applicable. Until the new managed certificate has been
        #     successfully provisioned, the previous SSL state will be preserved. Once
        #     the provisioning process completes, the `certificate_id` field will reflect
        #     the new managed certificate and this field will be left empty. To remove
        #     SSL support while there is still a pending managed certificate, clear the
        #     `certificate_id` field with an `UpdateDomainMappingRequest`.
        class SslSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The SSL management type for this domain.
          module SslManagementType
            # Defaults to `AUTOMATIC`.
            SSL_MANAGEMENT_TYPE_UNSPECIFIED = 0

            # SSL support for this domain is configured automatically. The mapped SSL
            # certificate will be automatically renewed.
            AUTOMATIC = 1

            # SSL support for this domain is configured manually by the user. Either
            # the domain has no SSL support or a user-obtained SSL certificate has been
            # explictly mapped to this domain.
            MANUAL = 2
          end
        end

        # A DNS resource record.
        # @!attribute [rw] name
        #   @return [::String]
        #     Relative name of the object affected by this record. Only applicable for
        #     `CNAME` records. Example: 'www'.
        # @!attribute [rw] rrdata
        #   @return [::String]
        #     Data for this record. Values vary by record type, as defined in RFC 1035
        #     (section 5) and RFC 1034 (section 3.6.1).
        # @!attribute [rw] type
        #   @return [::Google::Cloud::AppEngine::V1::ResourceRecord::RecordType]
        #     Resource record type. Example: `AAAA`.
        class ResourceRecord
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A resource record type.
          module RecordType
            # An unknown resource record.
            RECORD_TYPE_UNSPECIFIED = 0

            # An A resource record. Data is an IPv4 address.
            A = 1

            # An AAAA resource record. Data is an IPv6 address.
            AAAA = 2

            # A CNAME resource record. Data is a domain name to be aliased.
            CNAME = 3
          end
        end
      end
    end
  end
end
