# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppEngine
      module V1
        # Code and application artifacts used to deploy a version to App Engine.
        # @!attribute [rw] files
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AppEngine::V1::FileInfo}]
        #     Manifest of the files stored in Google Cloud Storage that are included
        #     as part of this version. All files must be readable using the
        #     credentials supplied with this call.
        # @!attribute [rw] container
        #   @return [::Google::Cloud::AppEngine::V1::ContainerInfo]
        #     The Docker image for the container that runs the version.
        #     Only applicable for instances running in the App Engine flexible environment.
        # @!attribute [rw] zip
        #   @return [::Google::Cloud::AppEngine::V1::ZipInfo]
        #     The zip file for this deployment, if this is a zip deployment.
        # @!attribute [rw] cloud_build_options
        #   @return [::Google::Cloud::AppEngine::V1::CloudBuildOptions]
        #     Options for any Google Cloud Build builds created as a part of this
        #     deployment.
        #
        #     These options will only be used if a new build is created, such as when
        #     deploying to the App Engine flexible environment using files or zip.
        class Deployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AppEngine::V1::FileInfo]
          class FilesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Single source file that is part of the version to be deployed. Each source
        # file that is deployed must be specified separately.
        # @!attribute [rw] source_url
        #   @return [::String]
        #     URL source to use to fetch this file. Must be a URL to a resource in
        #     Google Cloud Storage in the form
        #     'http(s)://storage.googleapis.com/\<bucket\>/\<object\>'.
        # @!attribute [rw] sha1_sum
        #   @return [::String]
        #     The SHA1 hash of the file, in hex.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     The MIME type of the file.
        #
        #     Defaults to the value from Google Cloud Storage.
        class FileInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Docker image that is used to create a container and start a VM instance for
        # the version that you deploy. Only applicable for instances running in the App
        # Engine flexible environment.
        # @!attribute [rw] image
        #   @return [::String]
        #     URI to the hosted container image in Google Container Registry. The URI
        #     must be fully qualified and include a tag or digest.
        #     Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        class ContainerInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options for the build operations performed as a part of the version
        # deployment. Only applicable for App Engine flexible environment when creating
        # a version using source code directly.
        # @!attribute [rw] app_yaml_path
        #   @return [::String]
        #     Path to the yaml file used in deployment, used to determine runtime
        #     configuration details.
        #
        #     Required for flexible environment builds.
        #
        #     See https://cloud.google.com/appengine/docs/standard/python/config/appref
        #     for more details.
        # @!attribute [rw] cloud_build_timeout
        #   @return [::Google::Protobuf::Duration]
        #     The Cloud Build timeout used as part of any dependent builds performed by
        #     version creation. Defaults to 10 minutes.
        class CloudBuildOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The zip file information for a zip deployment.
        # @!attribute [rw] source_url
        #   @return [::String]
        #     URL of the zip file to deploy from. Must be a URL to a resource in
        #     Google Cloud Storage in the form
        #     'http(s)://storage.googleapis.com/\<bucket\>/\<object\>'.
        # @!attribute [rw] files_count
        #   @return [::Integer]
        #     An estimate of the number of files in a zip for a zip deployment.
        #     If set, must be greater than or equal to the actual number of files.
        #     Used for optimizing performance; if not provided, deployment may be slow.
        class ZipInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
