# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppEngine
      module V1
        # An Application resource contains the top-level configuration of an App
        # Engine application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full path to the Application resource in the API.
        #     Example: `apps/myapp`.
        # @!attribute [rw] id
        #   @return [::String]
        #     Identifier of the Application resource. This identifier is equivalent
        #     to the project ID of the Google Cloud Platform project where you want to
        #     deploy your application.
        #     Example: `myapp`.
        # @!attribute [rw] dispatch_rules
        #   @return [::Array<::Google::Cloud::AppEngine::V1::UrlDispatchRule>]
        #     HTTP path dispatch rules for requests to the application that do not
        #     explicitly target a service or version. Rules are order-dependent.
        #     Up to 20 dispatch rules can be supported.
        # @!attribute [rw] auth_domain
        #   @return [::String]
        #     Google Apps authentication domain that controls which users can access
        #     this application.
        #
        #     Defaults to open access for any Google Account.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Location from which this application runs. Application instances
        #     run out of the data centers in the specified location, which is also where
        #     all of the application's end user content is stored.
        #
        #     Defaults to `us-central`.
        #
        #     View the list of
        #     [supported locations](https://cloud.google.com/appengine/docs/locations).
        # @!attribute [rw] code_bucket
        #   @return [::String]
        #     Google Cloud Storage bucket that can be used for storing files
        #     associated with this application. This bucket is associated with the
        #     application and can be used by the gcloud deployment commands.
        # @!attribute [rw] default_cookie_expiration
        #   @return [::Google::Protobuf::Duration]
        #     Cookie expiration policy for this application.
        # @!attribute [rw] serving_status
        #   @return [::Google::Cloud::AppEngine::V1::Application::ServingStatus]
        #     Serving status of this application.
        # @!attribute [rw] default_hostname
        #   @return [::String]
        #     Hostname used to reach this application, as resolved by App Engine.
        # @!attribute [rw] default_bucket
        #   @return [::String]
        #     Google Cloud Storage bucket that can be used by this application to store
        #     content.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account associated with the application.
        #     This is the app-level default identity. If no identity provided during
        #     create version, Admin API will fallback to this one.
        # @!attribute [rw] iap
        #   @return [::Google::Cloud::AppEngine::V1::Application::IdentityAwareProxy]
        # @!attribute [rw] gcr_domain
        #   @return [::String]
        #     The Google Container Registry domain used for storing managed build docker
        #     images for this application.
        # @!attribute [rw] database_type
        #   @return [::Google::Cloud::AppEngine::V1::Application::DatabaseType]
        #     The type of the Cloud Firestore or Cloud Datastore database associated with
        #     this application.
        # @!attribute [rw] feature_settings
        #   @return [::Google::Cloud::AppEngine::V1::Application::FeatureSettings]
        #     The feature specific settings to be used in the application.
        class Application
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Identity-Aware Proxy
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Whether the serving infrastructure will authenticate and
          #     authorize all incoming requests.
          #
          #     If true, the `oauth2_client_id` and `oauth2_client_secret`
          #     fields must be non-empty.
          # @!attribute [rw] oauth2_client_id
          #   @return [::String]
          #     OAuth2 client ID to use for the authentication flow.
          # @!attribute [rw] oauth2_client_secret
          #   @return [::String]
          #     OAuth2 client secret to use for the authentication flow.
          #
          #     For security reasons, this value cannot be retrieved via the API.
          #     Instead, the SHA-256 hash of the value is returned in the
          #     `oauth2_client_secret_sha256` field.
          # @!attribute [rw] oauth2_client_secret_sha256
          #   @return [::String]
          #     Hex-encoded SHA-256 hash of the client secret.
          class IdentityAwareProxy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The feature specific settings to be used in the application. These define
          # behaviors that are user configurable.
          # @!attribute [rw] split_health_checks
          #   @return [::Boolean]
          #     Boolean value indicating if split health checks should be used instead
          #     of the legacy health checks. At an app.yaml level, this means defaulting
          #     to 'readiness_check' and 'liveness_check' values instead of
          #     'health_check' ones. Once the legacy 'health_check' behavior is
          #     deprecated, and this value is always true, this setting can
          #     be removed.
          # @!attribute [rw] use_container_optimized_os
          #   @return [::Boolean]
          #     If true, use [Container-Optimized OS](https://cloud.google.com/container-optimized-os/)
          #     base image for VMs, rather than a base Debian image.
          class FeatureSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          module ServingStatus
            # Serving status is unspecified.
            UNSPECIFIED = 0

            # Application is serving.
            SERVING = 1

            # Application has been disabled by the user.
            USER_DISABLED = 2

            # Application has been disabled by the system.
            SYSTEM_DISABLED = 3
          end

          module DatabaseType
            # Database type is unspecified.
            DATABASE_TYPE_UNSPECIFIED = 0

            # Cloud Datastore
            CLOUD_DATASTORE = 1

            # Cloud Firestore Native
            CLOUD_FIRESTORE = 2

            # Cloud Firestore in Datastore Mode
            CLOUD_DATASTORE_COMPATIBILITY = 3
          end
        end

        # Rules to match an HTTP request and dispatch that request to a service.
        # @!attribute [rw] domain
        #   @return [::String]
        #     Domain name to match against. The wildcard "`*`" is supported if
        #     specified before a period: "`*.`".
        #
        #     Defaults to matching all domains: "`*`".
        # @!attribute [rw] path
        #   @return [::String]
        #     Pathname within the host. Must start with a "`/`". A
        #     single "`*`" can be included at the end of the path.
        #
        #     The sum of the lengths of the domain and path may not
        #     exceed 100 characters.
        # @!attribute [rw] service
        #   @return [::String]
        #     Resource ID of a service in this application that should
        #     serve the matched request. The service must already
        #     exist. Example: `default`.
        class UrlDispatchRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
