# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AppEngine
      module V1
        # [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/)
        # configuration for API handlers.
        # @!attribute [rw] auth_fail_action
        #   @return [::Google::Cloud::AppEngine::V1::AuthFailAction]
        #     Action to take when users access resources that require
        #     authentication. Defaults to `redirect`.
        # @!attribute [rw] login
        #   @return [::Google::Cloud::AppEngine::V1::LoginRequirement]
        #     Level of login required to access this resource. Defaults to
        #     `optional`.
        # @!attribute [rw] script
        #   @return [::String]
        #     Path to the script from the application root directory.
        # @!attribute [rw] security_level
        #   @return [::Google::Cloud::AppEngine::V1::SecurityLevel]
        #     Security (HTTPS) enforcement for this URL.
        # @!attribute [rw] url
        #   @return [::String]
        #     URL to serve the endpoint at.
        class ApiConfigHandler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Custom static error page to be served when an error occurs.
        # @!attribute [rw] error_code
        #   @return [::Google::Cloud::AppEngine::V1::ErrorHandler::ErrorCode]
        #     Error condition this handler applies to.
        # @!attribute [rw] static_file
        #   @return [::String]
        #     Static file content to be served for this error.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     MIME type of file. Defaults to `text/html`.
        class ErrorHandler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Error codes.
          module ErrorCode
            # Not specified. ERROR_CODE_DEFAULT is assumed.
            ERROR_CODE_UNSPECIFIED = 0

            # All other error types.
            ERROR_CODE_DEFAULT = 0

            # Application has exceeded a resource quota.
            ERROR_CODE_OVER_QUOTA = 1

            # Client blocked by the application's Denial of Service protection
            # configuration.
            ERROR_CODE_DOS_API_DENIAL = 2

            # Deadline reached before the application responds.
            ERROR_CODE_TIMEOUT = 3
          end
        end

        # URL pattern and description of how the URL should be handled. App Engine can
        # handle URLs by executing application code or by serving static files
        # uploaded with the version, such as images, CSS, or JavaScript.
        # @!attribute [rw] url_regex
        #   @return [::String]
        #     URL prefix. Uses regular expression syntax, which means regexp
        #     special characters must be escaped, but should not contain groupings.
        #     All URLs that begin with this prefix are handled by this handler, using the
        #     portion of the URL after the prefix as part of the file path.
        # @!attribute [rw] static_files
        #   @return [::Google::Cloud::AppEngine::V1::StaticFilesHandler]
        #     Returns the contents of a file, such as an image, as the response.
        #
        #     Note: The following fields are mutually exclusive: `static_files`, `script`, `api_endpoint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] script
        #   @return [::Google::Cloud::AppEngine::V1::ScriptHandler]
        #     Executes a script to handle the requests that match this URL
        #     pattern. Only the `auto` value is supported for Node.js in the
        #     App Engine standard environment, for example `"script": "auto"`.
        #
        #     Note: The following fields are mutually exclusive: `script`, `static_files`, `api_endpoint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] api_endpoint
        #   @return [::Google::Cloud::AppEngine::V1::ApiEndpointHandler]
        #     Uses API Endpoints to handle requests.
        #
        #     Note: The following fields are mutually exclusive: `api_endpoint`, `static_files`, `script`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] security_level
        #   @return [::Google::Cloud::AppEngine::V1::SecurityLevel]
        #     Security (HTTPS) enforcement for this URL.
        # @!attribute [rw] login
        #   @return [::Google::Cloud::AppEngine::V1::LoginRequirement]
        #     Level of login required to access this resource. Not supported for Node.js
        #     in the App Engine standard environment.
        # @!attribute [rw] auth_fail_action
        #   @return [::Google::Cloud::AppEngine::V1::AuthFailAction]
        #     Action to take when users access resources that require
        #     authentication. Defaults to `redirect`.
        # @!attribute [rw] redirect_http_response_code
        #   @return [::Google::Cloud::AppEngine::V1::UrlMap::RedirectHttpResponseCode]
        #     `30x` code to use when performing redirects for the `secure` field.
        #     Defaults to `302`.
        class UrlMap
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Redirect codes.
          module RedirectHttpResponseCode
            # Not specified. `302` is assumed.
            REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED = 0

            # `301 Moved Permanently` code.
            REDIRECT_HTTP_RESPONSE_CODE_301 = 1

            # `302 Moved Temporarily` code.
            REDIRECT_HTTP_RESPONSE_CODE_302 = 2

            # `303 See Other` code.
            REDIRECT_HTTP_RESPONSE_CODE_303 = 3

            # `307 Temporary Redirect` code.
            REDIRECT_HTTP_RESPONSE_CODE_307 = 4
          end
        end

        # Files served directly to the user for a given URL, such as images, CSS
        # stylesheets, or JavaScript source files. Static file handlers describe which
        # files in the application directory are static files, and which URLs serve
        # them.
        # @!attribute [rw] path
        #   @return [::String]
        #     Path to the static files matched by the URL pattern, from the
        #     application root directory. The path can refer to text matched in groupings
        #     in the URL pattern.
        # @!attribute [rw] upload_path_regex
        #   @return [::String]
        #     Regular expression that matches the file paths for all files that should be
        #     referenced by this handler.
        # @!attribute [rw] http_headers
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     HTTP headers to use for all responses from these URLs.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     MIME type used to serve all files served by this handler.
        #
        #     Defaults to file-specific MIME types, which are derived from each file's
        #     filename extension.
        # @!attribute [rw] expiration
        #   @return [::Google::Protobuf::Duration]
        #     Time a static file served by this handler should be cached
        #     by web proxies and browsers.
        # @!attribute [rw] require_matching_file
        #   @return [::Boolean]
        #     Whether this handler should match the request if the file
        #     referenced by the handler does not exist.
        # @!attribute [rw] application_readable
        #   @return [::Boolean]
        #     Whether files should also be uploaded as code data. By default, files
        #     declared in static file handlers are uploaded as static
        #     data and are only served to end users; they cannot be read by the
        #     application. If enabled, uploads are charged against both your code and
        #     static data storage resource quotas.
        class StaticFilesHandler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class HttpHeadersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Executes a script to handle the request that matches the URL pattern.
        # @!attribute [rw] script_path
        #   @return [::String]
        #     Path to the script from the application root directory.
        class ScriptHandler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Uses Google Cloud Endpoints to handle requests.
        # @!attribute [rw] script_path
        #   @return [::String]
        #     Path to the script from the application root directory.
        class ApiEndpointHandler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Health checking configuration for VM instances. Unhealthy instances
        # are killed and replaced with new instances. Only applicable for
        # instances in App Engine flexible environment.
        # @!attribute [rw] disable_health_check
        #   @return [::Boolean]
        #     Whether to explicitly disable health checks for this instance.
        # @!attribute [rw] host
        #   @return [::String]
        #     Host header to send when performing an HTTP health check.
        #     Example: "myapp.appspot.com"
        # @!attribute [rw] healthy_threshold
        #   @return [::Integer]
        #     Number of consecutive successful health checks required before receiving
        #     traffic.
        # @!attribute [rw] unhealthy_threshold
        #   @return [::Integer]
        #     Number of consecutive failed health checks required before removing
        #     traffic.
        # @!attribute [rw] restart_threshold
        #   @return [::Integer]
        #     Number of consecutive failed health checks required before an instance is
        #     restarted.
        # @!attribute [rw] check_interval
        #   @return [::Google::Protobuf::Duration]
        #     Interval between health checks.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Time before the health check is considered failed.
        class HealthCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Readiness checking configuration for VM instances. Unhealthy instances
        # are removed from traffic rotation.
        # @!attribute [rw] path
        #   @return [::String]
        #     The request path.
        # @!attribute [rw] host
        #   @return [::String]
        #     Host header to send when performing a HTTP Readiness check.
        #     Example: "myapp.appspot.com"
        # @!attribute [rw] failure_threshold
        #   @return [::Integer]
        #     Number of consecutive failed checks required before removing
        #     traffic.
        # @!attribute [rw] success_threshold
        #   @return [::Integer]
        #     Number of consecutive successful checks required before receiving
        #     traffic.
        # @!attribute [rw] check_interval
        #   @return [::Google::Protobuf::Duration]
        #     Interval between health checks.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Time before the check is considered failed.
        # @!attribute [rw] app_start_timeout
        #   @return [::Google::Protobuf::Duration]
        #     A maximum time limit on application initialization, measured from moment
        #     the application successfully replies to a healthcheck until it is ready to
        #     serve traffic.
        class ReadinessCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Health checking configuration for VM instances. Unhealthy instances
        # are killed and replaced with new instances.
        # @!attribute [rw] path
        #   @return [::String]
        #     The request path.
        # @!attribute [rw] host
        #   @return [::String]
        #     Host header to send when performing a HTTP Liveness check.
        #     Example: "myapp.appspot.com"
        # @!attribute [rw] failure_threshold
        #   @return [::Integer]
        #     Number of consecutive failed checks required before considering the
        #     VM unhealthy.
        # @!attribute [rw] success_threshold
        #   @return [::Integer]
        #     Number of consecutive successful checks required before considering
        #     the VM healthy.
        # @!attribute [rw] check_interval
        #   @return [::Google::Protobuf::Duration]
        #     Interval between health checks.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Time before the check is considered failed.
        # @!attribute [rw] initial_delay
        #   @return [::Google::Protobuf::Duration]
        #     The initial delay before starting to execute the checks.
        class LivenessCheck
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Third-party Python runtime library that is required by the application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the library. Example: "django".
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the library to select, or "latest".
        class Library
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Actions to take when the user is not logged in.
        module AuthFailAction
          # Not specified. `AUTH_FAIL_ACTION_REDIRECT` is assumed.
          AUTH_FAIL_ACTION_UNSPECIFIED = 0

          # Redirects user to "accounts.google.com". The user is redirected back to the
          # application URL after signing in or creating an account.
          AUTH_FAIL_ACTION_REDIRECT = 1

          # Rejects request with a `401` HTTP status code and an error
          # message.
          AUTH_FAIL_ACTION_UNAUTHORIZED = 2
        end

        # Methods to restrict access to a URL based on login status.
        module LoginRequirement
          # Not specified. `LOGIN_OPTIONAL` is assumed.
          LOGIN_UNSPECIFIED = 0

          # Does not require that the user is signed in.
          LOGIN_OPTIONAL = 1

          # If the user is not signed in, the `auth_fail_action` is taken.
          # In addition, if the user is not an administrator for the
          # application, they are given an error message regardless of
          # `auth_fail_action`. If the user is an administrator, the handler
          # proceeds.
          LOGIN_ADMIN = 2

          # If the user has signed in, the handler proceeds normally. Otherwise, the
          # auth_fail_action is taken.
          LOGIN_REQUIRED = 3
        end

        # Methods to enforce security (HTTPS) on a URL.
        module SecurityLevel
          # Not specified.
          SECURE_UNSPECIFIED = 0

          # Both HTTP and HTTPS requests with URLs that match the handler succeed
          # without redirects. The application can examine the request to determine
          # which protocol was used, and respond accordingly.
          SECURE_DEFAULT = 0

          # Requests for a URL that match this handler that use HTTPS are automatically
          # redirected to the HTTP equivalent URL.
          SECURE_NEVER = 1

          # Both HTTP and HTTPS requests with URLs that match the handler succeed
          # without redirects. The application can examine the request to determine
          # which protocol was used and respond accordingly.
          SECURE_OPTIONAL = 2

          # Requests for a URL that match this handler that do not use HTTPS are
          # automatically redirected to the HTTPS URL with the same path. Query
          # parameters are reserved for the redirect.
          SECURE_ALWAYS = 3
        end
      end
    end
  end
end
