# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/appengine/v1/appengine_pb"
require "google/cloud/app_engine/v1/firewall/rest/service_stub"

module Google
  module Cloud
    module AppEngine
      module V1
        module Firewall
          module Rest
            ##
            # REST client for the Firewall service.
            #
            # Firewall resources are used to define a collection of access control rules
            # for an Application. Each rule is defined with a position which specifies
            # the rule's order in the sequence of rules, an IP range to be matched against
            # requests, and an action to take upon matching requests.
            #
            # Every request is evaluated against the Firewall rules in priority order.
            # Processesing stops at the first rule which matches the request's IP address.
            # A final rule always specifies an action that applies to all remaining
            # IP addresses. The default final rule for a newly-created application will be
            # set to "allow" if not otherwise specified by the user.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "appengine.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :firewall_stub

              ##
              # Configure the Firewall Client class.
              #
              # See {::Google::Cloud::AppEngine::V1::Firewall::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Firewall clients
              #   ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "AppEngine", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Firewall Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::AppEngine::V1::Firewall::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @firewall_stub.universe_domain
              end

              ##
              # Create a new Firewall REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Firewall client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @firewall_stub = ::Google::Cloud::AppEngine::V1::Firewall::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @firewall_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @firewall_stub.logger
              end

              # Service calls

              ##
              # Lists the firewall rules of an application.
              #
              # @overload list_ingress_rules(request, options = nil)
              #   Pass arguments to `list_ingress_rules` via a request object, either of type
              #   {::Google::Cloud::AppEngine::V1::ListIngressRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AppEngine::V1::ListIngressRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_ingress_rules(parent: nil, page_size: nil, page_token: nil, matching_address: nil)
              #   Pass arguments to `list_ingress_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Name of the Firewall collection to retrieve.
              #     Example: `apps/myapp/firewall/ingressRules`.
              #   @param page_size [::Integer]
              #     Maximum results to return per page.
              #   @param page_token [::String]
              #     Continuation token for fetching the next page of results.
              #   @param matching_address [::String]
              #     A valid IP Address. If set, only rules matching this address will be
              #     returned. The first returned rule will be the rule that fires on requests
              #     from this IP.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AppEngine::V1::FirewallRule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::AppEngine::V1::FirewallRule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/app_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AppEngine::V1::ListIngressRulesRequest.new
              #
              #   # Call the list_ingress_rules method.
              #   result = client.list_ingress_rules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::AppEngine::V1::FirewallRule.
              #     p item
              #   end
              #
              def list_ingress_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppEngine::V1::ListIngressRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_ingress_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AppEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_ingress_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_ingress_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @firewall_stub.list_ingress_rules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @firewall_stub, :list_ingress_rules, "ingress_rules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Replaces the entire firewall ruleset in one bulk operation. This overrides
              # and replaces the rules of an existing firewall with the new rules.
              #
              # If the final rule does not match traffic with the '*' wildcard IP range,
              # then an "allow all" rule is explicitly added to the end of the list.
              #
              # @overload batch_update_ingress_rules(request, options = nil)
              #   Pass arguments to `batch_update_ingress_rules` via a request object, either of type
              #   {::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_update_ingress_rules(name: nil, ingress_rules: nil)
              #   Pass arguments to `batch_update_ingress_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the Firewall collection to set.
              #     Example: `apps/myapp/firewall/ingressRules`.
              #   @param ingress_rules [::Array<::Google::Cloud::AppEngine::V1::FirewallRule, ::Hash>]
              #     A list of FirewallRules to replace the existing set.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/app_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest.new
              #
              #   # Call the batch_update_ingress_rules method.
              #   result = client.batch_update_ingress_rules request
              #
              #   # The returned object is of type Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesResponse.
              #   p result
              #
              def batch_update_ingress_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppEngine::V1::BatchUpdateIngressRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_update_ingress_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AppEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_update_ingress_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_update_ingress_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @firewall_stub.batch_update_ingress_rules request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a firewall rule for the application.
              #
              # @overload create_ingress_rule(request, options = nil)
              #   Pass arguments to `create_ingress_rule` via a request object, either of type
              #   {::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_ingress_rule(parent: nil, rule: nil)
              #   Pass arguments to `create_ingress_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Name of the parent Firewall collection in which to create a new rule.
              #     Example: `apps/myapp/firewall/ingressRules`.
              #   @param rule [::Google::Cloud::AppEngine::V1::FirewallRule, ::Hash]
              #     A FirewallRule containing the new resource.
              #
              #     The user may optionally provide a position at which the new rule will be
              #     placed. The positions define a sequential list starting at 1. If a rule
              #     already exists at the given position, rules greater than the provided
              #     position will be moved forward by one.
              #
              #     If no position is provided, the server will place the rule as the second to
              #     last rule in the sequence before the required default allow-all or deny-all
              #     rule.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AppEngine::V1::FirewallRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AppEngine::V1::FirewallRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/app_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AppEngine::V1::CreateIngressRuleRequest.new
              #
              #   # Call the create_ingress_rule method.
              #   result = client.create_ingress_rule request
              #
              #   # The returned object is of type Google::Cloud::AppEngine::V1::FirewallRule.
              #   p result
              #
              def create_ingress_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppEngine::V1::CreateIngressRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_ingress_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AppEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_ingress_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_ingress_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @firewall_stub.create_ingress_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the specified firewall rule.
              #
              # @overload get_ingress_rule(request, options = nil)
              #   Pass arguments to `get_ingress_rule` via a request object, either of type
              #   {::Google::Cloud::AppEngine::V1::GetIngressRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AppEngine::V1::GetIngressRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_ingress_rule(name: nil)
              #   Pass arguments to `get_ingress_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the Firewall resource to retrieve.
              #     Example: `apps/myapp/firewall/ingressRules/100`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AppEngine::V1::FirewallRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AppEngine::V1::FirewallRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/app_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AppEngine::V1::GetIngressRuleRequest.new
              #
              #   # Call the get_ingress_rule method.
              #   result = client.get_ingress_rule request
              #
              #   # The returned object is of type Google::Cloud::AppEngine::V1::FirewallRule.
              #   p result
              #
              def get_ingress_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppEngine::V1::GetIngressRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_ingress_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AppEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_ingress_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_ingress_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @firewall_stub.get_ingress_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified firewall rule.
              #
              # @overload update_ingress_rule(request, options = nil)
              #   Pass arguments to `update_ingress_rule` via a request object, either of type
              #   {::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_ingress_rule(name: nil, rule: nil, update_mask: nil)
              #   Pass arguments to `update_ingress_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the Firewall resource to update.
              #     Example: `apps/myapp/firewall/ingressRules/100`.
              #   @param rule [::Google::Cloud::AppEngine::V1::FirewallRule, ::Hash]
              #     A FirewallRule containing the updated resource
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Standard field mask for the set of fields to be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::AppEngine::V1::FirewallRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::AppEngine::V1::FirewallRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/app_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest.new
              #
              #   # Call the update_ingress_rule method.
              #   result = client.update_ingress_rule request
              #
              #   # The returned object is of type Google::Cloud::AppEngine::V1::FirewallRule.
              #   p result
              #
              def update_ingress_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppEngine::V1::UpdateIngressRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_ingress_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AppEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_ingress_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_ingress_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @firewall_stub.update_ingress_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified firewall rule.
              #
              # @overload delete_ingress_rule(request, options = nil)
              #   Pass arguments to `delete_ingress_rule` via a request object, either of type
              #   {::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_ingress_rule(name: nil)
              #   Pass arguments to `delete_ingress_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Name of the Firewall resource to delete.
              #     Example: `apps/myapp/firewall/ingressRules/100`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/app_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest.new
              #
              #   # Call the delete_ingress_rule method.
              #   result = client.delete_ingress_rule request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_ingress_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::AppEngine::V1::DeleteIngressRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_ingress_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::AppEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_ingress_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_ingress_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @firewall_stub.delete_ingress_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Firewall REST API.
              #
              # This class represents the configuration for Firewall REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::AppEngine::V1::Firewall::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_ingress_rules to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_ingress_rules.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::AppEngine::V1::Firewall::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_ingress_rules.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "appengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Firewall API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_ingress_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_ingress_rules
                  ##
                  # RPC-specific configuration for `batch_update_ingress_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_update_ingress_rules
                  ##
                  # RPC-specific configuration for `create_ingress_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_ingress_rule
                  ##
                  # RPC-specific configuration for `get_ingress_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_ingress_rule
                  ##
                  # RPC-specific configuration for `update_ingress_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_ingress_rule
                  ##
                  # RPC-specific configuration for `delete_ingress_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_ingress_rule

                  # @private
                  def initialize parent_rpcs = nil
                    list_ingress_rules_config = parent_rpcs.list_ingress_rules if parent_rpcs.respond_to? :list_ingress_rules
                    @list_ingress_rules = ::Gapic::Config::Method.new list_ingress_rules_config
                    batch_update_ingress_rules_config = parent_rpcs.batch_update_ingress_rules if parent_rpcs.respond_to? :batch_update_ingress_rules
                    @batch_update_ingress_rules = ::Gapic::Config::Method.new batch_update_ingress_rules_config
                    create_ingress_rule_config = parent_rpcs.create_ingress_rule if parent_rpcs.respond_to? :create_ingress_rule
                    @create_ingress_rule = ::Gapic::Config::Method.new create_ingress_rule_config
                    get_ingress_rule_config = parent_rpcs.get_ingress_rule if parent_rpcs.respond_to? :get_ingress_rule
                    @get_ingress_rule = ::Gapic::Config::Method.new get_ingress_rule_config
                    update_ingress_rule_config = parent_rpcs.update_ingress_rule if parent_rpcs.respond_to? :update_ingress_rule
                    @update_ingress_rule = ::Gapic::Config::Method.new update_ingress_rule_config
                    delete_ingress_rule_config = parent_rpcs.delete_ingress_rule if parent_rpcs.respond_to? :delete_ingress_rule
                    @delete_ingress_rule = ::Gapic::Config::Method.new delete_ingress_rule_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
